/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.target.assembler;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.target.assembler.IPatchTargetAssembler;
import dbmodel.SystemInstance;
import dbmodel.common.AbstractBaseTarget;
import dbmodel.db_crs.CRSCluster;
import dbmodel.db_crs.DataGuard;
import dbmodel.db_crs.HAS;
import java.util.List;
import java.util.logging.Logger;

public class DataGuardAssembler
implements IPatchTargetAssembler {
    Logger logger = Logger.getLogger(DataGuardAssembler.class.getName());
    private List<DataGuard> dataGuards = null;
    private String parentid = null;

    public DataGuardAssembler(List<DataGuard> dataGuards, String parentid) {
        this.dataGuards = dataGuards;
        this.parentid = parentid;
    }

    @Override
    public boolean isShardRequired(AbstractBaseTarget shard, SystemInstance systemInstance, String option) {
        try {
            this.logger.fine(" dataGuardOption " + option);
            if (this.dataGuards == null) {
                this.dataGuards = systemInstance.getTargetsOfType(DataGuard.class);
            }
            for (DataGuard dataGuard : this.dataGuards) {
                if (dataGuard.getPrimary() == null) continue;
                this.logger.fine("Comparing primary name :" + dataGuard.getPrimary().getName() + " and option :" + option);
                if (!dataGuard.getPrimary().getName().equalsIgnoreCase(option)) continue;
                if (shard instanceof CRSCluster || shard instanceof HAS) {
                    this.logger.fine(shard + " an instance of " + (shard instanceof CRSCluster ? "CRSCluster" : "HAS") + " is required");
                    return true;
                }
                this.logger.fine("Comparing primary name :" + dataGuard.getPrimary().getName() + " and shard name :" + shard.getName());
                if (dataGuard.getPrimary().getName().equalsIgnoreCase(shard.getName())) {
                    return true;
                }
                if (StringUtil.isNullOrEmpty((String)this.parentid)) continue;
                List standbys = dataGuard.getStandbyDatabases();
                for (AbstractBaseTarget standby : standbys) {
                    if (!standby.getName().equals(shard.getName())) continue;
                    return true;
                }
            }
        }
        catch (Exception ex) {
            this.logger.warning("Error in collecting Dataguard information :\n" + ex);
        }
        return false;
    }
}

