/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.model.productsupport;

import com.oracle.cie.common.util.ResourceBundleManager;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.common.util.logging.LogFactory;
import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.OPatchAutoCommand;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.OPatchAutoOption;
import com.oracle.glcm.patch.auto.OPatchAutoOptionGroup;
import com.oracle.glcm.patch.auto.OPatchAutoOptions;
import com.oracle.glcm.patch.auto.action.PatchAction;
import com.oracle.glcm.patch.auto.credential.CredentialManager;
import com.oracle.glcm.patch.auto.db.framework.SessionData;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationResult;
import com.oracle.glcm.patch.auto.db.integration.controller.action.PatchActionUtil;
import com.oracle.glcm.patch.auto.db.integration.controller.action.sdb.DGOGGPatchAction;
import com.oracle.glcm.patch.auto.db.integration.controller.action.sdb.SDBGIPatchAction;
import com.oracle.glcm.patch.auto.db.integration.controller.action.sdb.SDBShardEntityPatchAction;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBCommonSupport;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductParameterConstants;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.ProductSupportHelper;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.shard.DatabaseProductType;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.shard.GISDBProductType;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.shard.OGGDatabaseProductType;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.shard.PrimaryProductType;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.shard.SIHASDBProductType;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.shard.StandbyProductType;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.SDBTopologyBuilder;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.sdb.PatchZipCreator;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.sdb.SDBOptionsAuthorizer;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.sdb.SDBSummaryOrganizer;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.constant.DBCommonPatchingConstants;
import com.oracle.glcm.patch.auto.db.product.summary.DBPatchingSummaryCreator;
import com.oracle.glcm.patch.auto.db.product.summary.SummaryID;
import com.oracle.glcm.patch.auto.product.ProductType;
import dbmodel.SystemInstance;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbsysmodel.driver.sdk.productdriver.OUIDriver;

public class SDBProductSupport
extends DBCommonSupport {
    private static final Logger _log = Logger.getLogger(SDBProductSupport.class.getName());
    private Boolean isShardedDatabase = false;
    private String dataGuardNames = null;
    private String shardGroupNames = null;
    private String shardSpaceNames = null;
    private Boolean isOgg = false;
    private ProductSupportHelper produtHelper = new ProductSupportHelper();

    @Override
    protected Set<ProductType> loadProductTypes() {
        LinkedHashSet<ProductType> productTypes = new LinkedHashSet<ProductType>();
        if (this.isShardedDatabase.booleanValue()) {
            productTypes.add(new PrimaryProductType());
            productTypes.add(new GISDBProductType());
            productTypes.add(new SIHASDBProductType());
            productTypes.add(new OGGDatabaseProductType());
        } else if (!StringUtil.isNullOrEmpty((String)this.dataGuardNames)) {
            productTypes.add(new PrimaryProductType());
            productTypes.add(new StandbyProductType());
        } else if (!StringUtil.isNullOrEmpty((String)this.shardGroupNames) || !StringUtil.isNullOrEmpty((String)this.shardSpaceNames)) {
            productTypes.add(new DatabaseProductType());
        }
        if (_log.isLoggable(Level.INFO)) {
            _log.log(Level.INFO, "Product types loaded...");
        }
        return productTypes;
    }

    @Override
    public void loadTopology(OPatchAutoOptions options, CredentialManager credentialManager) throws OPatchAutoException {
        if (this.getTopology() == null) {
            this._topologyBuilder.setDefaultProductTypeRequired(this.isDefaultTopologyDisable(options));
            super.loadTopology(options, credentialManager);
            List<Object> failedValidations = new ArrayList();
            try {
                this._topologyBuilder.buildTopology(credentialManager);
            }
            catch (Exception e) {
                _log.throwing("Detailed Execption in execute steps : ", e.getMessage(), e);
                throw new OPatchAutoException("Unable to Build Topology " + e.getMessage(), new Object[0]);
            }
            failedValidations = new SDBOptionsAuthorizer().validateTopology(options, credentialManager, this.command, this._topologyBuilder.getTopology());
            if (!failedValidations.isEmpty()) {
                for (int i = 1; i < failedValidations.size(); ++i) {
                    int other_failures = ((ValidationResult)failedValidations.get(i)).getFailureReason().getErrorCode();
                    Reporting.report((String)OPatchAutoHelper.getPublishedMessage((String)Integer.toString(other_failures), (Object[])new Object[0]));
                }
                int errorCode = ((ValidationResult)failedValidations.get(0)).getFailureReason().getErrorCode();
                String arguments = "";
                if (null != ((ValidationResult)failedValidations.get(0)).getPayload()) {
                    arguments = (String)((ValidationResult)failedValidations.get(0)).getPayload();
                }
                throw new OPatchAutoException(OPatchAutoHelper.getPublishedMessage((String)Integer.toString(errorCode), (Object[])new Object[]{arguments}), new Object[0]);
            }
            this.setTopology(this._topologyBuilder.getTopology());
            String patchID = options.getOption("id").getValue();
            if (StringUtil.isNullOrEmpty((String)patchID)) {
                OPatchAutoOption patchLocObj;
                String patchLocation;
                if (_log.isLoggable(Level.INFO)) {
                    _log.log(Level.INFO, "Creating zip from patch...");
                }
                if (StringUtil.isNullOrEmpty((String)(patchLocation = (patchLocObj = options.getOption("patch.location")).getValue()), (boolean)true)) {
                    patchLocation = options.getOption("patch.base.directory").getValue();
                }
                new PatchZipCreator().createzipOnLocal(patchLocation, credentialManager);
            }
            if (this.isShardedDatabase.booleanValue()) {
                SDBSummaryOrganizer SDBSummaryOrganizer2 = new SDBSummaryOrganizer();
                SDBSummaryOrganizer2.displayConfigSummary(options, this.command);
                SDBSummaryOrganizer2.storeSDBSummary(options, this.command, this._summaryCreator);
            }
            if (!this.command.isAction()) {
                if (!this.command.isResumed()) {
                    if (this.isShardedDatabase.booleanValue()) {
                        this.produtHelper.prepareSessionInfoFiles(PatchPlanner.getInstance().getSystemInstance(), options);
                    } else {
                        this.produtHelper.handleRootSessionInfoFile(options);
                    }
                }
                this.produtHelper.prepareLocalAndRemoteFiles(options, credentialManager, this._topologyBuilder, this.command);
            }
        }
    }

    public Set<OPatchAutoOption> getOptions() {
        OPatchAutoOption sdb = OPatchAutoOption.getCommandOption((String)DBProductParameterConstants.SDB.getValue(), (String)"-sdb", (String)"opatchauto.option.sdb.description", (boolean)true, (boolean)false, (OPatchAutoCommand[])new OPatchAutoCommand[]{OPatchAutoCommand.apply, OPatchAutoCommand.rollback});
        OPatchAutoOption dg = OPatchAutoOption.getCommandOption((String)DBProductParameterConstants.DG.getValue(), (String)"-dg", (String)"opatchauto.option.dg.description", (boolean)false, (boolean)false, (OPatchAutoCommand[])new OPatchAutoCommand[]{OPatchAutoCommand.apply, OPatchAutoCommand.rollback});
        OPatchAutoOption shardGroup = OPatchAutoOption.getCommandOption((String)DBProductParameterConstants.SHARD_GROUP.getValue(), (String)"-shardgroup", (String)"opatchauto.option.shardgroup.description", (boolean)false, (boolean)false, (OPatchAutoCommand[])new OPatchAutoCommand[]{OPatchAutoCommand.apply, OPatchAutoCommand.rollback});
        OPatchAutoOption shardSpace = OPatchAutoOption.getCommandOption((String)DBProductParameterConstants.SHARD_SPACE.getValue(), (String)"-shardspace", (String)"opatchauto.option.shardspace.description", (boolean)false, (boolean)false, (OPatchAutoCommand[])new OPatchAutoCommand[]{OPatchAutoCommand.apply, OPatchAutoCommand.rollback});
        OPatchAutoOption catalogServiceName = OPatchAutoOption.getCommandOption((String)DBProductParameterConstants.SERVICE.getValue(), (String)"-service", (String)"opatchauto.option.service.description", (boolean)false, (boolean)false, (OPatchAutoCommand[])new OPatchAutoCommand[]{OPatchAutoCommand.apply, OPatchAutoCommand.rollback});
        OPatchAutoOption rolling = OPatchAutoOption.getCommandOption((String)DBProductParameterConstants.ROLLING_MODE_KEY.getValue(), (String)"-rolling", (String)"opatchauto.option.rolling.description", (boolean)true, (boolean)false, (OPatchAutoCommand[])new OPatchAutoCommand[]{OPatchAutoCommand.apply, OPatchAutoCommand.rollback});
        OPatchAutoOption parentid = OPatchAutoOption.getCommandOption((String)DBProductParameterConstants.PARENTID.getValue(), (String)"-parentid", (String)"opatchauto.option.parentid.description", (boolean)false, (boolean)false, (OPatchAutoCommand[])new OPatchAutoCommand[]{OPatchAutoCommand.apply, OPatchAutoCommand.rollback});
        OPatchAutoOption ocmrf = OPatchAutoOption.getCommandOption((String)DBProductParameterConstants.OCMRF_KEY.getValue(), (String)"-ocmrf", (String)"opatchauto.option.ocmrf.description", (boolean)false, (boolean)false, (OPatchAutoCommand[])new OPatchAutoCommand[]{OPatchAutoCommand.apply});
        LinkedHashSet<OPatchAutoOption> options = new LinkedHashSet<OPatchAutoOption>();
        options.add(dg);
        options.add(shardGroup);
        options.add(shardSpace);
        options.add(sdb);
        options.add(rolling);
        options.add(ocmrf);
        options.add(parentid);
        options.add(catalogServiceName);
        return options;
    }

    public Set<OPatchAutoOptionGroup> getOptionGroups(OPatchAutoOptions options) {
        LinkedHashSet<OPatchAutoOptionGroup> optionGroups = new LinkedHashSet<OPatchAutoOptionGroup>();
        try {
            optionGroups.add(OPatchAutoOptionGroup.getOPatchAutoOptionGroup((String)DBProductParameterConstants.DG_SHARDGROUP_SHARDSPACE_GROUP_KEY.getValue(), (OPatchAutoOptionGroup.Relationship)OPatchAutoOptionGroup.Relationship.mutually_exclusive, (boolean)false, (OPatchAutoOption[])new OPatchAutoOption[]{options.getOption(DBProductParameterConstants.DG.getValue()), options.getOption(DBProductParameterConstants.SHARD_GROUP.getValue()), options.getOption(DBProductParameterConstants.SHARD_SPACE.getValue())}));
            optionGroups.add(OPatchAutoOptionGroup.getOPatchAutoOptionGroup((String)DBProductParameterConstants.SID_SERVICE_GROUP_KEY.getValue(), (OPatchAutoOptionGroup.Relationship)OPatchAutoOptionGroup.Relationship.mutually_exclusive, (boolean)false, (OPatchAutoOption[])new OPatchAutoOption[]{options.getOption(DBProductParameterConstants.SID.getValue()), options.getOption(DBProductParameterConstants.SERVICE.getValue())}));
        }
        catch (OPatchAutoException e) {
            Reporting.report((String)e.getMessage());
        }
        return optionGroups;
    }

    @Override
    public Set<Class<? extends PatchAction>> getPatchActions(OPatchAutoCommand command, OPatchAutoOptions options) {
        HashSet<Class<? extends PatchAction>> actions = new HashSet<Class<? extends PatchAction>>();
        actions.add(SDBGIPatchAction.class);
        actions.add(SDBShardEntityPatchAction.class);
        actions.add(DGOGGPatchAction.class);
        if (_log.isLoggable(Level.FINE)) {
            _log.log(Level.FINE, "Actions loaded...");
        }
        return actions;
    }

    @Override
    public void updateOptions(OPatchAutoOptions options) throws OPatchAutoException {
        OPatchAutoOption ocmrf;
        super.updateOptions(options);
        if (this.command.isApply() && (ocmrf = options.getOption(DBProductParameterConstants.OCMRF_KEY.getValue())).getValue() != null) {
            Reporting.report((String)OPatchAutoHelper.getLocalizedString((String)"Ocmrf.warning.message", (Object[])new Object[0]));
        }
        OPatchAutoOption plan = options.getOption("patch.plan");
        if (!DBPatchingHelper.isCustomPlan(options)) {
            if (this.isShardedDatabase.booleanValue()) {
                OPatchAutoOption rolling = options.getOption(DBProductParameterConstants.ROLLING_MODE_KEY.getValue());
                boolean isRolling = Boolean.parseBoolean(rolling.getValue());
                if (this.isOgg.booleanValue()) {
                    if (isRolling) {
                        plan.setValue(SDBPatchPlan.PATCH_PLAN_SDB_OGG_ROLLING.getValue());
                    } else {
                        plan.setValue(SDBPatchPlan.PATCH_PLAN_SDB_OGG_NONROLLING.getValue());
                    }
                } else if (isRolling) {
                    plan.setValue(SDBPatchPlan.PATCH_PLAN_SDB_DG_ROLLING.getValue());
                } else {
                    plan.setValue(SDBPatchPlan.PATCH_PLAN_SDB_DG_NONROLLING.getValue());
                }
            } else if (!StringUtil.isNullOrEmpty((String)this.dataGuardNames)) {
                plan.setValue(SDBPatchPlan.PATCH_PLAN_DG_DEFAULT.getValue());
            } else if (!StringUtil.isNullOrEmpty((String)this.shardGroupNames) || !StringUtil.isNullOrEmpty((String)this.shardSpaceNames)) {
                plan.setValue(SDBPatchPlan.PATCH_PLAN_SHARDOPTION_DEFAULT.getValue());
            }
        }
    }

    @Override
    public void initialize(OPatchAutoCommand command, OPatchAutoOptions options) throws OPatchAutoException {
        boolean isDescriptionCommand;
        super.initialize(command, options);
        boolean bl = isDescriptionCommand = command.isLsPhases() || command.isLsPlans();
        if (!isDescriptionCommand) {
            String configDir = options.getOption(DBProductParameterConstants.CUSTOM_CONFIG_DIR.getValue()).getValue();
            SessionData.setConfigDir(configDir);
            this._topologyBuilder = new SDBTopologyBuilder(command, options);
            if (!command.isAction()) {
                System.setProperty("ORACLE_HOME", OPatchAutoHelper.getOPatchAutoHome());
                String invPtrLocStr = options.getOption("inventory.pointer.location").getValue();
                DBPatchingHelper.setupEnvironment(System.getProperty("ORACLE_HOME"), invPtrLocStr);
                this.isShardedDatabase = Boolean.parseBoolean(options.getOption(DBProductParameterConstants.SDB.getValue()).getValue());
                if (options.getOption(DBProductParameterConstants.DG.getValue()) != null) {
                    this.dataGuardNames = options.getOption(DBProductParameterConstants.DG.getValue()).getValue();
                }
                if (options.getOption(DBProductParameterConstants.SHARD_GROUP.getValue()) != null) {
                    this.shardGroupNames = options.getOption(DBProductParameterConstants.SHARD_GROUP.getValue()).getValue();
                }
                if (options.getOption(DBProductParameterConstants.SHARD_SPACE.getValue()) != null) {
                    this.shardSpaceNames = options.getOption(DBProductParameterConstants.SHARD_SPACE.getValue()).getValue();
                }
                boolean isInPlace = false;
                if (Boolean.parseBoolean(options.getOption(DBProductParameterConstants.IN_PLACE_KEY.getValue()).getValue())) {
                    isInPlace = true;
                }
                if (this.isShardedDatabase.booleanValue() && !isInPlace) {
                    throw new OPatchAutoException("Provide '-inplace' option along with '-sdb' to support sdb patching", new Object[0]);
                }
                this.prepareConfigDir(configDir);
                String sessionID = options.getOption("session").getValue();
                if (this._summaryCreator == null) {
                    this._summaryCreator = new DBPatchingSummaryCreator();
                    if (this.isShardedDatabase.booleanValue()) {
                        this._summaryCreator.initializePatchingSummary(command, sessionID, SummaryID.sdb_patching);
                    } else if (!(StringUtil.isNullOrEmpty((String)this.dataGuardNames) && StringUtil.isNullOrEmpty((String)this.shardGroupNames) && StringUtil.isNullOrEmpty((String)this.shardSpaceNames))) {
                        this._summaryCreator.initializePatchingSummary(command, sessionID, SummaryID.shard_patching);
                    } else {
                        this._summaryCreator.initializePatchingSummary(command, sessionID, SummaryID.initialize);
                    }
                }
                int status = 0;
                if (!command.isResumed()) {
                    status = new SDBOptionsAuthorizer().validate(options);
                }
                if (status != 0) {
                    throw new OPatchAutoException(OPatchAutoHelper.getPublishedMessage((String)Integer.toString(status), (Object[])new Object[0]), new Object[0]);
                }
                this._topologyBuilder.createSystemInstance();
                SystemInstance sysInst = PatchPlanner.getInstance().getSystemInstance();
                this.isOgg = PatchActionUtil.isOgg(sysInst);
                _log.finer(" OGG set as : " + this.isOgg);
                this.storeSessionFile(sessionID, options);
            }
        }
    }

    private void prepareConfigDir(String configDir) throws OPatchAutoException {
        String ohOwner = OUIDriver.checkFileOwner((File)new File(OPatchAutoHelper.getOPatchAutoHome(), "oraInst.loc"));
        String path = new File(configDir, "dbtmp").toString();
        DBPatchingUtil.mkdirs(path, ohOwner, null);
        path = new File(configDir, "sessioninfo").toString();
        DBPatchingUtil.mkdirs(path, ohOwner, null);
    }

    public Set<String> getPatchPlans() {
        LinkedHashSet<String> patchPlans = new LinkedHashSet<String>();
        if (this.isShardedDatabase.booleanValue()) {
            if (this.isOgg.booleanValue()) {
                patchPlans.add(SDBPatchPlan.PATCH_PLAN_SDB_OGG_NONROLLING.getValue());
                patchPlans.add(SDBPatchPlan.PATCH_PLAN_SDB_OGG_ROLLING.getValue());
            } else {
                patchPlans.add(SDBPatchPlan.PATCH_PLAN_SDB_DG_NONROLLING.getValue());
                patchPlans.add(SDBPatchPlan.PATCH_PLAN_SDB_DG_ROLLING.getValue());
            }
        } else if (!StringUtil.isNullOrEmpty((String)this.dataGuardNames)) {
            patchPlans.add(SDBPatchPlan.PATCH_PLAN_DG_DEFAULT.getValue());
        } else if (!StringUtil.isNullOrEmpty((String)this.shardGroupNames) || !StringUtil.isNullOrEmpty((String)this.shardSpaceNames)) {
            patchPlans.add(SDBPatchPlan.PATCH_PLAN_SHARDOPTION_DEFAULT.getValue());
        }
        return patchPlans;
    }

    public String getPatchPlanDescription(String patchPlan) {
        if (SDBPatchPlan.PATCH_PLAN_SDB_DG_NONROLLING.getValue().equals(patchPlan)) {
            return ResourceBundleManager.getString((String)"opatchauto", (String)SDBPatchPlan.PATCH_PLAN_SDB_DG_NONROLLING.getDescription());
        }
        if (SDBPatchPlan.PATCH_PLAN_SDB_DG_ROLLING.getValue().equals(patchPlan)) {
            return ResourceBundleManager.getString((String)"opatchauto", (String)SDBPatchPlan.PATCH_PLAN_SDB_DG_ROLLING.getDescription());
        }
        if (SDBPatchPlan.PATCH_PLAN_DG_DEFAULT.getValue().equals(patchPlan)) {
            return ResourceBundleManager.getString((String)"opatchauto", (String)SDBPatchPlan.PATCH_PLAN_DG_DEFAULT.getDescription());
        }
        if (SDBPatchPlan.PATCH_PLAN_SDB_OGG_NONROLLING.getValue().equals(patchPlan)) {
            return ResourceBundleManager.getString((String)"opatchauto", (String)SDBPatchPlan.PATCH_PLAN_SDB_OGG_NONROLLING.getDescription());
        }
        if (SDBPatchPlan.PATCH_PLAN_SDB_OGG_ROLLING.getValue().equals(patchPlan)) {
            return ResourceBundleManager.getString((String)"opatchauto", (String)SDBPatchPlan.PATCH_PLAN_SDB_OGG_ROLLING.getDescription());
        }
        if (SDBPatchPlan.PATCH_PLAN_SHARDOPTION_DEFAULT.getValue().equals(patchPlan)) {
            return ResourceBundleManager.getString((String)"opatchauto", (String)SDBPatchPlan.PATCH_PLAN_SHARDOPTION_DEFAULT.getDescription());
        }
        return super.getPatchPlanDescription(patchPlan);
    }

    @Override
    public void closeSession(OPatchAutoCommand command, boolean isSuccessful) {
        super.closeSession(command, isSuccessful);
        if (this.getDBPatchingSummaryCreator(command) != null) {
            this._summaryCreator.generateSummary(command);
        }
        if (!command.isAction() && !isSuccessful) {
            if (this.isShardedDatabase.booleanValue()) {
                ProductSupportHelper.verifyPatching(this._topologyBuilder, this._summaryCreator, true, this.isOgg);
            } else {
                ProductSupportHelper.verifyPatching(this._topologyBuilder, this._summaryCreator, false, this.isOgg);
            }
        }
        if (isSuccessful) {
            this.produtHelper.deleteRemoteFiles();
        }
        if (this.isShardedDatabase.booleanValue()) {
            LogFactory logFactory = LogFactory.getFactory();
            Reporting.report((String)OPatchAutoHelper.getLocalizedString((String)"Sharded.db.session.log.file", (Object[])new Object[]{logFactory.getRootDestination().getDestName()}));
            if (isSuccessful) {
                Reporting.report((String)OPatchAutoHelper.getLocalizedString((String)"PatchAction.opatchauto.successful.message", (Object[])new Object[0]));
            }
        }
        if (!(StringUtil.isNullOrEmpty((String)this.dataGuardNames) && StringUtil.isNullOrEmpty((String)this.shardGroupNames) && StringUtil.isNullOrEmpty((String)this.shardSpaceNames) || command.isAction())) {
            ProductSupportHelper.changeSummaryFileDest();
        }
        ProductSupportHelper.changeLogFolderPermission();
        PatchPlanner.getInstance().cleanup();
        this._topologyBuilder = null;
        this.command = null;
    }

    @Override
    public String getId() {
        return "";
    }

    public List<String> loadUnSupportedOptions() {
        return UNSUPPORTED_OPTIONS;
    }

    public List<String> loadUnVisibleOptions() {
        UNVISIBLE_OPTIONS.add(DBProductParameterConstants.SERVICE.getValue());
        UNVISIBLE_OPTIONS.add(DBProductParameterConstants.PARENTID.getValue());
        UNVISIBLE_OPTIONS.add(DBProductParameterConstants.DG.getValue());
        UNVISIBLE_OPTIONS.add(DBProductParameterConstants.SHARD_GROUP.getValue());
        UNVISIBLE_OPTIONS.add(DBProductParameterConstants.SHARD_SPACE.getValue());
        return UNVISIBLE_OPTIONS;
    }

    @Override
    protected void setProperties() {
        super.setProperties();
        if (this.isShardedDatabase.booleanValue()) {
            System.setProperty("remote.temp.dir.name", DBCommonPatchingConstants.OATCHAUTOCFG_DB_DIR + DBCommonPatchingConstants.CONFIG_SESSIONINFO_DIR + "opatchauto-sdb-tmp");
        } else {
            System.setProperty("remote.temp.dir.name", DBCommonPatchingConstants.OATCHAUTOCFG_DB_DIR + DBCommonPatchingConstants.CONFIG_SESSIONINFO_DIR + "opatchauto-dg-tmp");
        }
    }

    static enum SDBPatchPlan {
        PATCH_PLAN_SDB_DG_NONROLLING("sdb-dg-nonrolling", "opatchauto.plan.sdb-nonrolling.desc"),
        PATCH_PLAN_SDB_DG_ROLLING("sdb-dg-rolling", "opatchauto.plan.sdb-rolling.desc"),
        PATCH_PLAN_DG_DEFAULT("dg", "opatchauto.plan.dg.desc"),
        PATCH_PLAN_SDB_OGG_NONROLLING("sdb-ogg-nonrolling", "opatchauto.plan.sdb-ogg-nonrolling.desc"),
        PATCH_PLAN_SDB_OGG_ROLLING("sdb-ogg-rolling", "opatchauto.plan.sdb-ogg-rolling.desc"),
        PATCH_PLAN_SHARDOPTION_DEFAULT("shardoption", "opatchauto.plan.shardoption.desc");

        private String patchPlan;
        private String desc;

        private SDBPatchPlan(String type, String desc) {
            this.patchPlan = type;
            this.desc = desc;
        }

        public String getValue() {
            return this.patchPlan;
        }

        public String getDescription() {
            return this.desc;
        }
    }
}

