/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.model.productsupport;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.glcm.patch.auto.OPatchAutoCommand;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.OPatchAutoOption;
import com.oracle.glcm.patch.auto.OPatchAutoOptions;
import com.oracle.glcm.patch.auto.action.PatchAction;
import com.oracle.glcm.patch.auto.action.PatchActionExecutorContainer;
import com.oracle.glcm.patch.auto.credential.Credential;
import com.oracle.glcm.patch.auto.credential.CredentialManager;
import com.oracle.glcm.patch.auto.db.framework.SessionData;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.framework.sdk.readme.ReadmeFactory;
import com.oracle.glcm.patch.auto.db.integration.model.plan.DBPatchPlanIncrementSetCreatorImpl;
import com.oracle.glcm.patch.auto.db.integration.model.plan.PatchingProcessInitializer;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductParameterConstants;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.TopologyBuilder;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.DBVersionInfo;
import com.oracle.glcm.patch.auto.db.product.constant.DBCommonPatchingConstants;
import com.oracle.glcm.patch.auto.db.product.summary.DBPatchingSummaryCreator;
import com.oracle.glcm.patch.auto.db.product.summary.SummaryID;
import com.oracle.glcm.patch.auto.plan.PatchPlanIncrementType;
import com.oracle.glcm.patch.auto.product.CommonProductSupport;
import com.oracle.glcm.patch.auto.product.ProductType;
import com.oracle.glcm.patch.auto.session.PatchInfo;
import com.oracle.glcm.patch.auto.session.PatchInfoImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbsysmodel.driver.sdk.productdriver.OUIDriver;

public class DBCommonSupport
extends CommonProductSupport {
    private static final Logger _log = Logger.getLogger(DBCommonSupport.class.getName());
    protected DBPatchingSummaryCreator _summaryCreator = null;
    protected static final List<String> UNSUPPORTED_OPTIONS = new ArrayList<String>();
    protected static final List<String> UNVISIBLE_OPTIONS = new ArrayList<String>();
    protected TopologyBuilder _topologyBuilder;
    protected OPatchAutoCommand command;
    protected Map<String, String> libPathMap = new HashMap<String, String>();
    protected boolean isAnalyzeSession;
    protected boolean isGenerateStepSession;
    protected boolean isRemoteSession;
    protected boolean isNonrollingMode;

    public boolean isSupportedTopology(File topologyFile, OPatchAutoOptions options, CredentialManager credentialManager) throws OPatchAutoException {
        return true;
    }

    public Set<String> getResourceBundles() {
        return DBPatchingHelper.getDBResourceBundles();
    }

    protected void initializePatchData(OPatchAutoOptions options, CredentialManager credentialMgr) throws OPatchAutoException {
        OPatchAutoCommand command = options.getCommand();
        PatchingProcessInitializer patchingProcessInitializer = new PatchingProcessInitializer();
        String oracleHome = OPatchAutoHelper.getOPatchAutoHome();
        if (!command.isAction()) {
            boolean isNonRolling = DBPatchingHelper.isNonRollingMode(options);
            PatchInfo patchInfo = this.getPatchInfo(options);
            if (patchInfo != null) {
                String patchStorageDirectoryPath = DBPatchingUtil.getPatchStorageDirectoryPath(oracleHome);
                Credential credential = credentialMgr.getCredential(DBPatchingHelper.getHostNameWithoutDomain(OPatchAutoHelper.getOPatchAutoHost()));
                DBPatchingHelper.createPatchDirectory(oracleHome, patchStorageDirectoryPath, credential, "700");
            }
            patchingProcessInitializer.processInit(patchInfo, command, isNonRolling, options);
            this.setProperties();
            _log.log(Level.INFO, "Collect Patch Data: Completed.");
        }
        patchingProcessInitializer.setCommonProperty(options, oracleHome);
    }

    protected PatchInfo getPatchInfo(OPatchAutoOptions options) throws OPatchAutoException {
        PatchInfoImpl patchInfo = null;
        String patchID = options.getOption("id").getValue();
        if (StringUtil.isNullOrEmpty((String)patchID)) {
            String patchLocation = options.getOption("patch.base.directory").getValue();
            if (StringUtil.isNullOrEmpty((String)patchLocation, (boolean)true)) {
                patchLocation = options.getOption("patch.location").getValue();
                if (!StringUtil.isNullOrEmpty((String)patchLocation, (boolean)true)) {
                    patchInfo = new PatchInfoImpl(patchLocation, null, null);
                }
            } else {
                patchInfo = new PatchInfoImpl(null, patchLocation, null);
            }
        } else {
            patchInfo = new PatchInfoImpl(null, null, patchID);
        }
        return patchInfo;
    }

    public void loadTopology(OPatchAutoOptions options, CredentialManager credentialManager) throws OPatchAutoException {
        if (this.getTopology() == null) {
            this.initializePatchData(options, credentialManager);
        }
    }

    public void updateOptions(OPatchAutoOptions options) throws OPatchAutoException {
        super.updateOptions(options);
        if (!StringUtil.isNullOrEmpty((String)options.getOption(DBProductParameterConstants.DATABASE_KEY.getValue()).getValue(), (boolean)true)) {
            OPatchAutoOption oh = options.getOption("home");
            oh.setDefaultValueResolver(null);
        }
    }

    public void initialize(OPatchAutoCommand command, OPatchAutoOptions options) throws OPatchAutoException {
        this.command = command;
        this.isAnalyzeSession = options.getOption("analyze").isSwitchEnabled();
        this.isNonrollingMode = options.getOption(DBProductParameterConstants.NONROLLING_MODE_KEY.getValue()).isSwitchEnabled();
        this.isGenerateStepSession = DBPatchingHelper.isGenerateStepCommand(options);
        OPatchAutoOption remoteOption = options.getOption(DBProductParameterConstants.REMOTE_KEY.getValue());
        this.isRemoteSession = Boolean.valueOf(remoteOption.getValue());
        super.initialize(command, options);
        String patchID = options.getOption("id").getValue();
        if (DBPatchingHelper.isOOPSwitchPatchingSession(options)) {
            return;
        }
        if (command.isApply() || command.isRollback() && StringUtil.isNullOrEmpty((String)patchID)) {
            this.checkForDefaultPatchlocation(options);
        }
    }

    private void checkForDefaultPatchlocation(OPatchAutoOptions options) throws OPatchAutoException {
        OPatchAutoOption patchLocObj = options.getOption("patch.location");
        OPatchAutoOption patchDirObj = options.getOption("patch.base.directory");
        String patchLocation = patchLocObj.getValue();
        if (StringUtil.isNullOrEmpty((String)patchLocation, (boolean)true)) {
            patchLocation = patchDirObj.getValue();
        }
        if (StringUtil.isNullOrEmpty((String)patchLocation, (boolean)true)) {
            String patchHomeProp = System.getenv("PATCH_HOME");
            if (StringUtil.isNullOrEmpty((String)patchHomeProp)) {
                File directory = new File(".");
                try {
                    patchLocation = directory.getCanonicalPath();
                }
                catch (IOException e1) {
                    patchLocation = directory.getAbsolutePath();
                }
                patchLocObj.setValue(patchLocation);
                _log.info("Setting current location as patch location ::" + patchLocation);
            } else if (new File(patchHomeProp).exists()) {
                patchDirObj.setValue(patchHomeProp);
                _log.info("Setting PATCH_HOME value as patch directory ::" + patchHomeProp);
            } else {
                throw new OPatchAutoException(Integer.toString(72084), new Object[0]);
            }
        }
    }

    protected void setProperties() {
        System.setProperty("remote.temp.dir.name", DBCommonPatchingConstants.OPATCH_AUTO_DBSESSIONINFO + "opatchauto-tmp");
        System.setProperty("append.host.name", "true");
    }

    public void closeSession(OPatchAutoCommand command, boolean isSuccessful) {
        try {
            ReadmeFactory.getInstance().close();
        }
        catch (Exception e) {
            _log.warning(e.getMessage());
        }
        this.storeMissingHomeSummary();
    }

    private void storeMissingHomeSummary() {
        Map<String, String> homeDetails = PatchPlanner.getInstance().getOPlanEnv().getPatchingStatusOfOracleHome();
        if (homeDetails != null && !homeDetails.isEmpty()) {
            Set<String> homeList = homeDetails.keySet();
            ArrayList<String> missingHomeSummary = new ArrayList<String>();
            for (String home : homeList) {
                if (!homeDetails.get(home).equals("skipped")) continue;
                missingHomeSummary.add(home);
            }
            this._summaryCreator.storePatchingSummary(0, SummaryID.skipped_home_summary, missingHomeSummary);
        }
    }

    public PatchPlanIncrementType getPatchPlanIncrementType(String incrementType) {
        if (_log.isLoggable(Level.FINEST)) {
            _log.log(Level.FINEST, "Patch plan increment type=" + incrementType);
        }
        if (incrementType.equals(DBPatchPlanIncrementSetCreatorImpl.DBPatchPlanIncrementType.host_nonrolling.toString().toLowerCase().trim())) {
            return DBPatchPlanIncrementSetCreatorImpl.DBPatchPlanIncrementType.host_nonrolling;
        }
        return super.getPatchPlanIncrementType(incrementType);
    }

    public boolean isDefaultTopologyDisable(OPatchAutoOptions options) throws OPatchAutoException {
        boolean isDefaultTopologyDisabled = false;
        isDefaultTopologyDisabled = DBPatchingHelper.isOHOrDatabaseOptionSpecified(options) ? true : super.isDefaultTopologyDisable(options);
        return isDefaultTopologyDisabled;
    }

    public Map<String, String> getPluginVersions() {
        DBVersionInfo dbversionInfo = new DBVersionInfo();
        ArrayList<DBVersionInfo.VersionKey> versionKeyList = new ArrayList<DBVersionInfo.VersionKey>();
        versionKeyList.add(DBVersionInfo.VersionKey.OPATCHAUTODB);
        return dbversionInfo.getPluginVersions(versionKeyList);
    }

    public String getProductDisplayName() {
        return "OPatchAuto DB";
    }

    public DBPatchingSummaryCreator getDBPatchingSummaryCreator(OPatchAutoCommand command) {
        return this._summaryCreator;
    }

    protected void storeSessionFile(String sessionId, OPatchAutoOptions options) throws OPatchAutoException {
        if (!DBPatchingHelper.isStaticConfiguration(options)) {
            String currentHostName = System.getProperty("OPatchauto.HOSTNAME");
            String localFilePath = SessionData.getConfigDir() + DBCommonPatchingConstants.CONFIG_SESSIONINFO_DIR + "localSessionInfoFile_" + currentHostName + ".txt";
            String crsOwner = OUIDriver.checkFileOwner((File)new File(OPatchAutoHelper.getOPatchAutoHome(), "oraInst.loc"));
            try {
                boolean sessionIDPersist = DBPatchingUtil.writeContentToFile(localFilePath, crsOwner, null, sessionId);
                if (!sessionIDPersist) {
                    _log.severe("Failed to save session information");
                    throw new OPatchAutoException(Integer.toString(72052), new Object[0]);
                }
            }
            catch (IOException e) {
                _log.severe("Failed to save session information due to " + e.getMessage());
                throw new OPatchAutoException(Integer.toString(72052), new Object[0]);
            }
        }
    }

    protected Set<ProductType> loadProductTypes() {
        return null;
    }

    public String getId() {
        return null;
    }

    public Set<Class<? extends PatchAction>> getPatchActions(OPatchAutoCommand command, OPatchAutoOptions options) {
        return null;
    }

    public Map<String, String> getLibPathMap() {
        return this.libPathMap;
    }

    protected static PatchActionExecutorContainer deserializePath(String containerPath) throws OPatchAutoException {
        File containerFile = new File(containerPath);
        if (!containerFile.exists() || !containerFile.isFile()) {
            throw new OPatchAutoException("The container path provided did not exist or was not a file.", 231);
        }
        PatchActionExecutorContainer container = new PatchActionExecutorContainer();
        try {
            FileInputStream fis = new FileInputStream(containerFile);
            ObjectInputStream ois = new ObjectInputStream(fis);
            container = (PatchActionExecutorContainer)ois.readObject();
            ois.close();
        }
        catch (IOException | ClassNotFoundException e) {
            throw new OPatchAutoException("Failed to de-serialize patch action executor container " + containerFile, 233, (Throwable)e);
        }
        return container;
    }
}

