/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.model.plan;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.glcm.patch.auto.OPatchAutoCommand;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.OPatchAutoOptions;
import com.oracle.glcm.patch.auto.db.framework.sdk.ExecutionMode;
import com.oracle.glcm.patch.auto.db.framework.sdk.PatchPlanAccessOptParamKeys;
import com.oracle.glcm.patch.auto.db.framework.sdk.patch.PatchPackagesBag;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanEnv;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.patch.PatchCollectionException;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.patch.PatchInformationInitializer;
import com.oracle.glcm.patch.auto.db.product.GILogger;
import com.oracle.glcm.patch.auto.db.product.intg.DBPatchPlanIntgFactory;
import com.oracle.glcm.patch.auto.session.PatchInfo;
import dbmodel.common.Host;
import java.util.Comparator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbsysmodel.driver.sdk.productdriver.HostComparatorCreator;
import oracle.opatch.system.db.automation.jaxb.DeploymentSubType;

public class PatchingProcessInitializer {
    private static final Logger _log = Logger.getLogger(PatchingProcessInitializer.class.getName());

    public void processInit(PatchInfo patchInfo, OPatchAutoCommand command, boolean isNonRolling, OPatchAutoOptions options) throws OPatchAutoException {
        if (_log.isLoggable(Level.FINEST)) {
            _log.log(Level.FINEST, "Operation type:" + command.name());
        }
        PatchPlanner oplan = PatchPlanner.getInstance();
        oplan.setRunningStandalone(false);
        DBPatchPlanIntgFactory oplanIntgFactory = new DBPatchPlanIntgFactory();
        oplan.setDBPlanInstgFactory(oplanIntgFactory);
        Properties baseProps = this.getBaseProperties(command, isNonRolling, options);
        PatchPlanner.getInstance().getOPlanEnv().getOptionalParam().put(PatchPlanAccessOptParamKeys.rootCrsPlTempLoc, System.getProperty("OPatchauto.ROOTCRS_PL_FILE_TEMP_LOC"));
        PatchPlanner.getInstance().getOPlanEnv().getOptionalParam().put(PatchPlanAccessOptParamKeys.xagFileTempLoc, System.getProperty("OPatchauto.XAG_FILE_TEMP_LOC"));
        PatchPlanEnv env = oplan.getOPlanEnv();
        env.setProperties(baseProps);
        if (patchInfo != null) {
            this.initializePatchPackageBag(patchInfo, env);
        }
        this.setHostComparator(oplanIntgFactory);
    }

    private void initializePatchPackageBag(PatchInfo patchInfo, PatchPlanEnv env) throws OPatchAutoException {
        String patchLocation = null;
        patchLocation = StringUtil.isNullOrEmpty((String)patchInfo.getPatchBaseDirectory()) ? patchInfo.getPatchLocation() : patchInfo.getPatchBaseDirectory();
        try {
            PatchPackagesBag patchPackagesBag = PatchInformationInitializer.getInstance().createPatch(patchInfo);
            if (patchPackagesBag != null) {
                env.setPatchesBag(patchPackagesBag);
            }
            _log.log(Level.FINER, StringUtil.isNullOrEmpty((String)patchLocation) ? "Collected patch for ID =" + patchInfo.getPatchId() : "Collected patch from location =" + patchLocation);
        }
        catch (PatchCollectionException e) {
            _log.log(Level.WARNING, "Patch Collection failed: " + e.getMessage());
            GILogger.printStackTrace(e);
            throw new OPatchAutoException(OPatchAutoHelper.getPublishedMessage((String)Integer.toString(72043), (Object[])new Object[0]), (Throwable)e, new Object[0]);
        }
        if (patchLocation != null) {
            env.getProperties().setProperty("BundlePatchLocation", patchLocation);
        }
    }

    public void setCommonProperty(OPatchAutoOptions options, String oracleHome) {
        String invPtrLocation = null;
        try {
            invPtrLocation = options.getOption("inventory.pointer.location").getValue();
        }
        catch (OPatchAutoException e) {
            invPtrLocation = null;
        }
        Properties properties = PatchPlanner.getInstance().getOPlanEnv().getProperties();
        if (properties == null) {
            properties = new Properties();
        }
        if (invPtrLocation != null) {
            properties.put("invPtrLoc", invPtrLocation);
        }
        PatchPlanner.getInstance().getOPlanEnv().setProperties(properties);
    }

    private void setHostComparator(DBPatchPlanIntgFactory oplanIntgFactory) {
        Comparator<Host> hostComparator = oplanIntgFactory.getHostComparator();
        HostComparatorCreator.getInstance().setHostComparator(hostComparator);
    }

    private Properties getBaseProperties(OPatchAutoCommand command, boolean isNonRolling, OPatchAutoOptions options) throws OPatchAutoException {
        Properties baseProps = new Properties();
        baseProps.setProperty("ExecutionMode", ExecutionMode.OPATCH.toString());
        baseProps.setProperty("Operation", command.name());
        if (isNonRolling) {
            baseProps.setProperty("autoDeploymentSubType".toString(), DeploymentSubType.NON_ROLLING_UPGRADE.toString());
        } else {
            baseProps.setProperty("autoDeploymentSubType".toString(), DeploymentSubType.ROLLING_UPGRADE.toString());
        }
        return baseProps;
    }
}

