/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.controller.action.siha;

import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.Command;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandActionType;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.integration.controller.action.CRSShutDownStartupAction;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductTypes;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.CommandDetailsGenerator;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandActionType;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandParameters;
import com.oracle.glcm.patch.auto.lifecycle.Goal;
import com.oracle.glcm.patch.auto.lifecycle.OfflinePhase;
import com.oracle.glcm.patch.auto.lifecycle.ShutdownPhase;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.opatch.system.db.automation.jaxb.ActionType;
import oracle.opatch.system.db.automation.jaxb.PatchingPhase;
import oracle.opatch.system.db.automation.jaxb.ServiceStatus;
import oracle.opatch.system.db.automation.jaxb.Strategy;

public class SIHAShutDownAction
extends CRSShutDownStartupAction {
    public SIHAShutDownAction() {
        super(new Goal[]{ShutdownPhase.Goal.shutdown, OfflinePhase.Goal.prepare, OfflinePhase.Goal.finalize_binary_patching});
    }

    @Override
    public List<ExecutionStep> generateCRSSteps(PatchTarget patchTarget) throws OPatchAutoException {
        boolean isRollback = this.getPatchSession().isRollback();
        List<ExecutionStep> generatedSteps = super.generateCRSSteps(patchTarget);
        String primarypatchVersion = PatchPlanner.getInstance().getPrimaryPatchVersion();
        boolean isTwelveVersion = DBPatchingUtil.isDBVersionTweleveOrLater(primarypatchVersion);
        List<ExecutionStep> steps = null;
        if (!isRollback && isTwelveVersion) {
            steps = this.getStopHasCommandExecutionSteps(this.configGraph, patchTarget);
            generatedSteps.addAll(steps);
        }
        boolean actsOnClone = false;
        ServiceStatus serviceStatus = ServiceStatus.DOWN;
        if (patchTarget.getHomeClone() != null) {
            actsOnClone = true;
            serviceStatus = ServiceStatus.UP;
            if (this.getPatchSession().isRollback()) {
                String targetHome = DBPatchingHelper.getTargetHomeFromProductType(patchTarget);
                generatedSteps.addAll(this.getUpdateBootStrappingInClone(patchTarget, targetHome));
            }
        }
        ArrayList<String> readMeMsg = new ArrayList<String>();
        if (isTwelveVersion) {
            readMeMsg.add("Rootcrs-Prepatch-Title");
            readMeMsg.add("Rootcrs-Prepatch-Message");
            steps = this.getrootCRSCommandExecutionSteps(this.configGraph, patchTarget, "siha", serviceStatus, readMeMsg, DBCommandActionType.rootcrs.toString(), actsOnClone, DBCommandParameters.PREPATCH.getValue());
            generatedSteps.addAll(steps);
        } else {
            readMeMsg.add("Rootcrs-Unlock-Title");
            readMeMsg.add("Rootcrs-Unlock-Message");
            steps = this.getrootCRSCommandExecutionSteps(this.configGraph, patchTarget, "siha", serviceStatus, readMeMsg, CommandActionType.shell.toString(), actsOnClone, DBCommandParameters.UNLOCK.getValue());
            generatedSteps.addAll(steps);
        }
        return generatedSteps;
    }

    private List<ExecutionStep> getStopHasCommandExecutionSteps(ConfigGraph configGraph, PatchTarget patchTarget) throws OPatchAutoException {
        HashMap<CommandDetailsGenerator.ActionTypeParams, Object> argList = new HashMap<CommandDetailsGenerator.ActionTypeParams, Object>();
        argList.put(CommandDetailsGenerator.ActionTypeParams.TYPE, DBCommandActionType.StopHAS.toString());
        argList.put(CommandDetailsGenerator.ActionTypeParams.RUN_AS, DBCommandParameters.GLOBAL_ROOT_USER.getValue());
        argList.put(CommandDetailsGenerator.ActionTypeParams.SERVICE_STATUS, ServiceStatus.DOWN);
        argList.put(CommandDetailsGenerator.ActionTypeParams.STRIPE_NAME, "oracle.siha");
        argList.put(CommandDetailsGenerator.ActionTypeParams.STRIPE_TARGETHOME, "siha");
        argList.put(CommandDetailsGenerator.ActionTypeParams.README_TITLE_KEY, "Stop-CRS-Title");
        argList.put(CommandDetailsGenerator.ActionTypeParams.README_MSG_KEY, "Stop-CRS-Message");
        ActionType actionType = CommandDetailsGenerator.generateActionType(CommandDetailsGenerator.ActionTypes.COMMAND_ACTION, argList);
        PatchingPhase phase = this.getpatchingPhase();
        Command stopHasCommand = PatchPlanner.getInstance().getCommandFactory().getCommand(actionType, Strategy.MANUAL, phase);
        List<ExecutionStep> steps = this.getsteps(configGraph, patchTarget, actionType, stopHasCommand);
        return steps;
    }

    public Set<String> getSupportedProductTypes() {
        HashSet<String> targetList = new HashSet<String>();
        targetList.add(DBProductTypes.PRODUCT_TYPE_SIHA.getValue());
        return targetList;
    }
}

