/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.controller.action.siha;

import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.action.PatchActionException;
import com.oracle.glcm.patch.auto.db.framework.SessionData;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandUtils;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.integration.controller.action.DBShutDownStartupAction;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductParameterConstants;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductTypes;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.CommandFailureException;
import com.oracle.glcm.patch.auto.db.product.executor.ExecutionResult;
import com.oracle.glcm.patch.auto.db.product.executor.GISystemCall;
import com.oracle.glcm.patch.auto.lifecycle.Goal;
import com.oracle.glcm.patch.auto.lifecycle.OfflinePhase;
import com.oracle.glcm.patch.auto.lifecycle.ShutdownPhase;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import dbmodel.SystemInstance;
import dbmodel.db_crs.SIDatabase;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import oracle.dbsysmodel.driver.sdk.productdriver.ClusterInformationLoader;

public class SIDBShutDownAction
extends DBShutDownStartupAction {
    Logger logger = Logger.getLogger(SIDBShutDownAction.class.getName());
    private String strSID = "";

    public SIDBShutDownAction() {
        super(new Goal[]{ShutdownPhase.Goal.shutdown, OfflinePhase.Goal.finalize_binary_patching});
    }

    public int getOrderingWeight(Goal goal) {
        if (goal.equals(OfflinePhase.Goal.finalize_binary_patching)) {
            return 40;
        }
        return super.getOrderingWeight(goal);
    }

    @Override
    public boolean isActionRequired(PatchTarget patchTarget) throws PatchActionException {
        boolean isRequired = super.isActionRequired(patchTarget);
        if (!isRequired) {
            return isRequired;
        }
        boolean oopPatchingSession = DBPatchingHelper.isOOPPatchingSession(this.getPatchSession().getOptions());
        try {
            Boolean isSidbOnly = Boolean.parseBoolean(this.getPatchSession().getOptions().getOption(DBProductParameterConstants.SIDB_ONLY.getValue()).getValue());
            if (isSidbOnly.booleanValue()) {
                SystemInstance systemInstance = PatchPlanner.getInstance().getSystemInstance();
                SIDatabase siDatabase = (SIDatabase)systemInstance.getTargetsOfType(SIDatabase.class).get(0);
                String sidbDbUp = siDatabase.getShardProperty().getIsDatabaseUp();
                isRequired = "Y".equalsIgnoreCase(sidbDbUp);
                return isRequired;
            }
            this.strSID = this.getPatchSession().getOptions().getOption(DBProductParameterConstants.SID.getValue()).getValue();
            Boolean isSidb = Boolean.parseBoolean(this.getPatchSession().getOptions().getOption(DBProductParameterConstants.SIDB.getValue()).getValue());
            SessionData.getInstance().setSID(this.strSID);
            String home = patchTarget.getHome().getLocation();
            if (!oopPatchingSession && isSidb.booleanValue() && !CommandUtils.isInstanceShutdownPatch(home)) {
                isRequired = false;
            }
            if (!isSidb.booleanValue()) {
                isRequired = ClusterInformationLoader.getInstance().isStackRunning();
            }
        }
        catch (Exception e) {
            throw new PatchActionException("Exception : " + e.getMessage(), new Object[0]);
        }
        return isRequired;
    }

    @Override
    public List<ExecutionStep> generateSteps(PatchTarget patchTarget) throws OPatchAutoException {
        List<ExecutionStep> generatedSteps = super.generateSteps(patchTarget);
        if (this.checkListenerStatus(patchTarget)) {
            SessionData.getInstance().setListenerDown(true);
            String cmd = this.getListenerCmd(patchTarget, patchTarget.getHome().getLocation(), this.strSID, false);
            String loc = patchTarget.getHome(true).getLocation();
            byte[] pwd = null;
            GISystemCall.ExecReturn ret = GISystemCall.process(cmd, "root", pwd);
            if (!ret.isOK()) {
                this._logger.info("Listener stop completed with errors ....");
            }
        }
        List<ExecutionStep> sqlSteps = this.getStopOracleHomeCommandExecutionSteps(this.configGraph, patchTarget, "sidb", "OracleHome");
        generatedSteps.addAll(sqlSteps);
        return generatedSteps;
    }

    @Override
    protected ExecutionResult runCommand(PatchTarget patchTarget, ExecutionStep executionStep) throws CommandFailureException {
        ExecutionResult status = super.runCommand(patchTarget, executionStep);
        if (status != null && status.isSuccessful()) {
            for (ExecutionStep.Command command : executionStep.getCommand()) {
                if (command.getValue().indexOf("srvctl") == -1) continue;
                String listOfDBStopped = this.listOfDatabasesStopped(command.getValue());
                if (listOfDBStopped == null || listOfDBStopped.length() <= 0) break;
                Reporting.report((String)this.getLocalizedString("ShutdownAction.sidb.down.message", listOfDBStopped));
                break;
            }
        }
        return status;
    }

    public Set<String> getSupportedProductTypes() {
        HashSet<String> targetList = new HashSet<String>();
        targetList.add(DBProductTypes.PRODUCT_TYPE_SIDB.getValue());
        return targetList;
    }
}

