/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.controller.action.crs;

import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.integration.controller.action.PrePostScriptAction;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductTypes;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandActionType;
import com.oracle.glcm.patch.auto.lifecycle.Goal;
import com.oracle.glcm.patch.auto.lifecycle.OfflinePhase;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class RACPatchingAction
extends PrePostScriptAction {
    public RACPatchingAction() {
        super(new Goal[]{OfflinePhase.Goal.prepare, OfflinePhase.Goal.finalize});
    }

    @Override
    public List<ExecutionStep> generateSteps(PatchTarget patchTarget) throws OPatchAutoException {
        boolean isRequired;
        ArrayList<ExecutionStep> generatedSteps = new ArrayList();
        if (patchTarget.getHome().isSharedHome() && (this.getCurrentGoal().equals(OfflinePhase.Goal.prepare) || this.getCurrentGoal().equals(OfflinePhase.Goal.finalize)) && !(isRequired = this.isStepExecutionRequiredForSharedHome(patchTarget))) {
            Reporting.report((String)this.getLocalizedString("BinaryAction.script.execution.skipped", this.getScriptName()));
            return generatedSteps;
        }
        generatedSteps = this.getPrePostScriptSteps(patchTarget, "oracle.server", "rac");
        return generatedSteps;
    }

    @Override
    protected String getCommandActionType() {
        String primarypatchVersion = PatchPlanner.getInstance().getPrimaryPatchVersion();
        if (DBPatchingUtil.isDBVersionTweleveOrLater(primarypatchVersion)) {
            return DBCommandActionType.PatchRACDBHome.toString();
        }
        return super.getCommandActionType();
    }

    public Set<String> getSupportedProductTypes() {
        HashSet<String> targetList = new HashSet<String>();
        targetList.add(DBProductTypes.PRODUCT_TYPE_RAC.getValue());
        return targetList;
    }
}

