/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.controller.action;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.glcm.patch.auto.OPatchAutoCommand;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.OPatchAutoOption;
import com.oracle.glcm.patch.auto.OPatchAutoOptions;
import com.oracle.glcm.patch.auto.action.PatchAction;
import com.oracle.glcm.patch.auto.action.PatchActionResult;
import com.oracle.glcm.patch.auto.action.PatchActionStatus;
import com.oracle.glcm.patch.auto.db.framework.SessionData;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.framework.sdk.patch.PatchPackagesBag;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.framework.validation.IValidator;
import com.oracle.glcm.patch.auto.db.framework.validation.MultipleValidationResult;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationParam;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationResult;
import com.oracle.glcm.patch.auto.db.integration.controller.action.DBCommonPatchAction;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductParameterConstants;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductTypes;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.constant.DBCommonPatchingConstants;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPSessionInfoHandler;
import com.oracle.glcm.patch.auto.db.product.validation.ValidationParamKey;
import com.oracle.glcm.patch.auto.db.product.validation.ValidationPhase;
import com.oracle.glcm.patch.auto.db.product.validation.validators.CluvfyValidator;
import com.oracle.glcm.patch.auto.db.product.validation.validators.ConsistentPatchingModeValidator;
import com.oracle.glcm.patch.auto.db.product.validation.validators.PatchApplicableValidator;
import com.oracle.glcm.patch.auto.db.product.validation.validators.PatchingExecutionModeValidator;
import com.oracle.glcm.patch.auto.db.product.validation.validators.RACNonRollingValidator;
import com.oracle.glcm.patch.auto.db.product.validation.validators.TwoStageAutoRollbackValidator;
import com.oracle.glcm.patch.auto.db.product.validation.validators.TwoStageRollbackValidator;
import com.oracle.glcm.patch.auto.lifecycle.Goal;
import com.oracle.glcm.patch.auto.lifecycle.InitPhase;
import com.oracle.glcm.patch.auto.session.PatchSession;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import dbmodel.SystemInstance;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;

public class ValidationPatchAction
extends DBCommonPatchAction {
    Logger logger = Logger.getLogger(ValidationPatchAction.class.getName());

    public ValidationPatchAction() {
        super(new Goal[]{InitPhase.Goal.init});
    }

    @Override
    public final PatchActionResult execute(PatchTarget patchTarget) {
        PatchActionResult patchActionResult = new PatchActionResult();
        OPatchAutoOptions options = this.getPatchSession().getOptions();
        ValidationParam params = new ValidationParam();
        params.set(ValidationParamKey.CONFIG_GRAPH.ordinal(), PatchPlanner.getInstance().getConfigGraph());
        params.set(ValidationParamKey.PATCH_TARGET.ordinal(), patchTarget);
        params.set(ValidationParamKey.VALIDATION_PHASE.ordinal(), (Object)ValidationPhase.POST_TOPOLOGY);
        try {
            OPatchAutoOption option = options.getOption(DBProductParameterConstants.REMOTE_KEY.getValue());
            boolean isRemote = Boolean.valueOf(option.getValue());
            params.set(ValidationParamKey.REMOTE_PATCHING.ordinal(), isRemote);
            boolean isAnalyzeSession = options.getOption("analyze").isSwitchEnabled();
            params.set(ValidationParamKey.ANALYZE_OPTION.ordinal(), isAnalyzeSession);
            params.set(ValidationParamKey.OOP_ENABLED.ordinal(), DBPatchingHelper.isOOPPatchingSession(options));
            params.set(ValidationParamKey.HOME_KEY_OPTION.ordinal(), DBPatchingHelper.isOHOrDatabaseOptionSpecified(options));
            params.set(ValidationParamKey.NONROLLING_OPTION.ordinal(), this.getPatchSession().getProductSupportManager().getOptions().getOption(DBProductParameterConstants.NONROLLING_MODE_KEY.getValue()).isSwitchEnabled());
            params.set(ValidationParamKey.ANALYZED_PATCHINFO_LIST.ordinal(), SessionData.getInstance().getAnalyzedPatchList(patchTarget.getHome(true).getLocation()));
            params.set(ValidationParamKey.OOP_OPERATION_TYPE.ordinal(), (Object)DBPatchingHelper.getOperationType(options));
            params.set(ValidationParamKey.WALLET_LOC.ordinal(), DBPatchingHelper.getWalletLocation(options));
            params.set(ValidationParamKey.GENERATE_STEP_OPTION.ordinal(), DBPatchingHelper.isGenerateStepCommand(options));
            SystemInstance systemInstance = PatchPlanner.getInstance().getSystemInstance();
            params.set(ValidationParamKey.SYSTEM_INST.ordinal(), systemInstance);
            PatchSession patchSession = this.getPatchSession();
            if (this.getPatchSession().isRollback()) {
                params.set(ValidationParamKey.OPERATION.ordinal(), OPatchAutoCommand.rollback);
            } else {
                params.set(ValidationParamKey.OPERATION.ordinal(), OPatchAutoCommand.apply);
                if (!(this.getPatchSession().isRollback() && !StringUtil.isNullOrEmpty((String)options.getOption("id").getValue()) || DBPatchingHelper.isOOPSwitchPatchingSession(options))) {
                    PatchPlanner patchPlanner = PatchPlanner.getInstance();
                    PatchPackagesBag patchPackagesBag = patchPlanner.getOPlanEnv().getPatchesBag();
                    params.set(ValidationParamKey.PATCHPACKAGESBAG.ordinal(), patchPackagesBag);
                }
            }
            boolean sidbOnlyOption = Boolean.valueOf(options.getOption(DBProductParameterConstants.SIDB_ONLY.getValue()).getValue()) != false || options.getOption(DBProductParameterConstants.SIDB.getValue()).isSwitchEnabled();
        }
        catch (OPatchAutoException e) {
            e.printStackTrace();
        }
        List<ValidationResult> failedValidations = this.invokeInitPhase(params);
        for (ValidationResult result : failedValidations) {
            if (result.getStatus() != ValidationResult.ValidationStatus.FAILED) continue;
            patchActionResult = new PatchActionResult(PatchActionStatus.failure);
            SessionData.getInstance().setDeleteSessionXML(true);
            this._logger.info("Session failed in ValidationPatchAction : true");
            patchActionResult.addDetail(OPatchAutoHelper.getPublishedMessage((String)Integer.toString(result.getFailureReason().getErrorCode()), (Object[])new Object[]{result.getPayload()}));
            return patchActionResult;
        }
        try {
            if (DBPatchingHelper.isOOPPatchingSession(options) && !this.getPatchSession().isAnalyze() && !DBPatchingHelper.isGenerateStepCommand(options)) {
                this.logger.info("Updating cookie files after validations.");
                String sessionInfoFile = DBCommonPatchingConstants.OOP_SESSION_INFO_FILE;
                sessionInfoFile = sessionInfoFile.replace("$HOST_NAME", DBPatchingHelper.getHostNameWithoutDomain(OPatchAutoHelper.getOPatchAutoHost()));
                String oopSessionFilePath = OPatchAutoHelper.getOPatchAutoHome() + sessionInfoFile;
                if (options.getOption(DBProductParameterConstants.NONROLLING_MODE_KEY.getValue()).isSwitchEnabled()) {
                    OOPSessionInfoHandler.getInstance().setNonRolling();
                }
                OOPSessionInfoHandler.getInstance().saveOOPSessionCookie(oopSessionFilePath);
                if (this.getPatchSession().isRollback()) {
                    String sbSessionInfoFile = DBCommonPatchingConstants.OOP_SESSION_INFO_FILE_SWITCHBACK;
                    sbSessionInfoFile = sbSessionInfoFile.replace("$HOST_NAME", DBPatchingHelper.getHostNameWithoutDomain(OPatchAutoHelper.getOPatchAutoHost()));
                    new File(OPatchAutoHelper.getOPatchAutoHome() + sbSessionInfoFile).delete();
                }
            }
        }
        catch (OPatchAutoException e) {
            SessionData.getInstance().setDeleteSessionXML(true);
            this._logger.info("Session failed exception in ValidationPatchAction : true");
            patchActionResult = new PatchActionResult((Throwable)e);
            return patchActionResult;
        }
        SessionData.getInstance().setValidationCompleted(true);
        return patchActionResult;
    }

    public List<ValidationResult> invokeInitPhase(ValidationParam params) {
        HashSet<String> RACTypes = new HashSet<String>();
        RACTypes.add(DBProductTypes.PRODUCT_TYPE_RAC.getValue());
        RACTypes.add(DBProductTypes.PRODUCT_TYPE_RAC_SHARED.getValue());
        RACTypes.add(DBProductTypes.PRODUCT_TYPE_RAC_NONSHARED.getValue());
        PatchTarget patchTarget = (PatchTarget)params.get(ValidationParamKey.PATCH_TARGET.ordinal());
        boolean racType = RACTypes.contains(patchTarget.getProductType().getType());
        boolean sidbOnlyOption = DBPatchingHelper.isSidbOnlyMode(this.getPatchSession().getOptions());
        ValidationPhase validationPhase = (ValidationPhase)((Object)params.get(ValidationParamKey.VALIDATION_PHASE.ordinal()));
        boolean isAnalyzeMode = (Boolean)params.get(ValidationParamKey.ANALYZE_OPTION.ordinal());
        ArrayList<IValidator> validationList = new ArrayList<IValidator>();
        validationList.add(new PatchingExecutionModeValidator());
        validationList.add(new PatchApplicableValidator());
        String primaryVersion = PatchPlanner.getInstance().getPrimaryPatchVersion();
        if (DBPatchingUtil.isVersionEqalOrlater(primaryVersion, "23.0.0.0.0")) {
            if (this.getPatchSession().isRollback()) {
                if (!DBPatchingHelper.isNonRollingMode(this.getPatchSession().getOptions()) && !sidbOnlyOption && racType) {
                    validationList.add(new TwoStageRollbackValidator());
                }
            } else if (!DBPatchingHelper.isNonRollingMode(this.getPatchSession().getOptions()) && !sidbOnlyOption && racType) {
                validationList.add(new TwoStageAutoRollbackValidator());
            }
        }
        if (!DBPatchingHelper.isOOPPatchingSession(this.getPatchSession().getOptions())) {
            if (!sidbOnlyOption) {
                validationList.add(new ConsistentPatchingModeValidator());
            }
            if (DBPatchingHelper.isNonRollingMode(this.getPatchSession().getOptions()) && !isAnalyzeMode && racType) {
                validationList.add(new RACNonRollingValidator());
            }
        }
        if (!DBPatchingHelper.isOOPPatchingSession(this.getPatchSession().getOptions()) && patchTarget.getType().equals(DBProductTypes.PRODUCT_TYPE_CRS.getValue())) {
            validationList.add(new CluvfyValidator());
        }
        ArrayList<ValidationResult> failedValidations = new ArrayList<ValidationResult>();
        MultipleValidationResult multipleValidationResult = null;
        for (IValidator validator : validationList) {
            multipleValidationResult = validator.validate(params);
            for (ValidationResult validationResult : multipleValidationResult.getValidationResultList()) {
                this.logger.info("Validation status :: " + (Object)((Object)validationResult.getStatus()));
                if (!validationResult.getStatus().equals((Object)ValidationResult.ValidationStatus.FAILED)) continue;
                this.logger.info("Validation failed with reason  :: " + validationResult.getFailureReason());
                this.logger.info("Validation failed due to :" + OPatchAutoHelper.getPublishedMessage((String)Integer.toString(validationResult.getFailureReason().getErrorCode()), (Object[])new Object[]{validationResult.getPayload()}));
                failedValidations.add(validationResult);
            }
        }
        return failedValidations;
    }

    @Override
    public String getStatusMessage(PatchTarget patchTarget, PatchActionStatus status) {
        String statusMsg = null;
        switch (status) {
            case incomplete: {
                statusMsg = this.getLocalizedString("ValidationPatchAction.start.message", patchTarget.toReportingString());
                break;
            }
            case success: {
                statusMsg = this.getLocalizedString("ValidationPatchAction.success.message", patchTarget.toReportingString());
                break;
            }
            case warning: {
                statusMsg = this.getLocalizedString("ValidationPatchAction.warning.message", patchTarget.toReportingString());
                break;
            }
            case failure: {
                statusMsg = this.getLocalizedString("ValidationPatchAction.failure.message", patchTarget.toReportingString());
                break;
            }
            default: {
                statusMsg = super.getStatusMessage(patchTarget, status);
            }
        }
        return statusMsg;
    }

    public Set<String> getSupportedProductTypes() {
        HashSet<String> targetList = new HashSet<String>();
        targetList.add(DBProductTypes.PRODUCT_TYPE_SIHA.getValue());
        targetList.add(DBProductTypes.PRODUCT_TYPE_SIDB.getValue());
        targetList.add(DBProductTypes.PRODUCT_TYPE_RAC.getValue());
        targetList.add(DBProductTypes.PRODUCT_TYPE_CRS.getValue());
        return targetList;
    }

    @Override
    protected List<ExecutionStep> generateSteps(PatchTarget patchTarget) throws OPatchAutoException {
        return null;
    }

    public boolean isRollbackSupported() {
        return true;
    }

    public int getOrderingWeight(Goal goal) {
        return 30;
    }

    public boolean isAnalyzeSupported() {
        boolean isAnalyzeSupported = false;
        if (this.getCurrentGoal().equals(InitPhase.Goal.init)) {
            isAnalyzeSupported = true;
        }
        return isAnalyzeSupported;
    }

    @Override
    public PatchAction clone() throws CloneNotSupportedException {
        PatchAction patchAction = super.clone();
        return patchAction;
    }
}

