/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.controller.action;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.remote.RemoteConnectionException;
import com.oracle.cie.remote.RemoteConnectionHandler;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoOptions;
import com.oracle.glcm.patch.auto.action.PatchAction;
import com.oracle.glcm.patch.auto.action.PatchActionException;
import com.oracle.glcm.patch.auto.action.PatchActionExecutorContainer;
import com.oracle.glcm.patch.auto.action.PatchActionStatus;
import com.oracle.glcm.patch.auto.db.framework.SessionData;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.User;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.integration.controller.action.DBCommonPatchAction;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductTypes;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.lifecycle.Goal;
import com.oracle.glcm.patch.auto.lifecycle.ShutdownPhase;
import com.oracle.glcm.patch.auto.session.MutablePatchSession;
import com.oracle.glcm.patch.auto.session.PatchSession;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import dbmodel.common.Host;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import oracle.dbsysmodel.driver.sdk.productdriver.OUIDriver;
import oracle.opatch.system.db.automation.jaxb.ActionType;

public class RHPPrePatchAction
extends DBCommonPatchAction {
    private static final String ROOT_RHP_COMMAND = "%OracleHome.path%/rhp/patch/rootrhp.pl";
    Logger logger = Logger.getLogger(RHPPrePatchAction.class.getName());

    public RHPPrePatchAction() {
        super(new Goal[]{ShutdownPhase.Goal.shutdown});
    }

    public Set<String> getSupportedProductTypes() {
        HashSet<String> targetList = new HashSet<String>();
        targetList.add(DBProductTypes.PRODUCT_TYPE_CRS.getValue());
        return targetList;
    }

    @Override
    protected List<ExecutionStep> generateSteps(PatchTarget patchTarget) throws OPatchAutoException {
        ArrayList<ExecutionStep> executionList = new ArrayList<ExecutionStep>();
        String sourceHome = patchTarget.getHome(true).getLocation();
        sourceHome = sourceHome.replaceAll("/+$", "");
        StringBuilder prePatchRHPcmd = new StringBuilder();
        PatchSession patchSession = this.getPatchSession();
        String patchPath = DBPatchingHelper.getPatchPath(patchSession.getPatchLocation(), patchSession.getPatchBaseDirectory());
        prePatchRHPcmd.append(sourceHome + "/perl/bin/perl " + sourceHome + "/rhp/patch/rootrhp.pl");
        prePatchRHPcmd.append(" home=" + sourceHome);
        if (!StringUtil.isNullOrEmpty((String)patchPath)) {
            prePatchRHPcmd.append(" patchHome=" + patchPath);
        }
        prePatchRHPcmd.append(" -pre -stop_rhp ");
        String cmd = prePatchRHPcmd.toString();
        if (!StringUtil.isNullOrEmpty((String)cmd, (boolean)true)) {
            this.logger.info("Command generated ::" + cmd);
            ActionType actionType = new ActionType();
            ExecutionStep executionStep = new ExecutionStep(actionType);
            executionStep.getCommand().add(new ExecutionStep.Command(cmd));
            String ohOwner = null;
            ohOwner = !DBPatchingHelper.isStaticConfiguration(this.getPatchSession().getOptions()) ? OUIDriver.checkFileOwner((File)new File(patchTarget.getHome(true).getLocation(), "oraInst.loc")) : System.getProperty("user.name");
            User user = new User();
            user.setValue("root");
            executionStep.setUser(user);
            Host host = new Host();
            host.setDisplayName(patchTarget.getHost().getHost());
            host.setName(patchTarget.getHost().getHost());
            executionStep.setHost(host);
            executionList.add(executionStep);
            return executionList;
        }
        this.logger.info("Skipping action to run RHP Prepatch command since no step got generated");
        return null;
    }

    @Override
    public boolean isActionRequired(PatchTarget patchTarget) throws PatchActionException {
        boolean isActionRequired = super.isActionRequired(patchTarget);
        if (!isActionRequired) {
            return isActionRequired;
        }
        String primarypatchVersion = PatchPlanner.getInstance().getPrimaryPatchVersion();
        if (!DBPatchingUtil.isVersionEqalOrlater(primarypatchVersion, "21.0.0.0.0")) {
            return false;
        }
        OPatchAutoOptions options = this.getPatchSession().getOptions();
        String home_loc = patchTarget.getHome().getLocation();
        if (DBPatchingHelper.isOOPPatchingSession(options) || this.getPatchSession().isAnalyze()) {
            isActionRequired = false;
        } else if (SessionData.getInstance().getAnalyzedPatchList(home_loc) != null && !SessionData.getInstance().getAnalyzedPatchList(home_loc).isEmpty()) {
            isActionRequired = DBPatchingHelper.isRHPPatchingSession(patchTarget.getHome().getLocation(), this.getPatchSession(), SessionData.getInstance().getAnalyzedPatchList(home_loc));
            this.logger.info("RHP Patching session RHP Pre : " + isActionRequired);
        } else {
            isActionRequired = false;
        }
        if (patchTarget.getHome().isSharedHome()) {
            isActionRequired = isActionRequired && DBPatchingHelper.isFirstNodeGIPatching();
        }
        return isActionRequired;
    }

    public boolean isAnalyzeSupported() {
        boolean isAnalyzeSupported = false;
        return isAnalyzeSupported;
    }

    public int getOrderingWeight(Goal goal) {
        if (goal.equals(ShutdownPhase.Goal.shutdown)) {
            return 55;
        }
        return super.getOrderingWeight(goal);
    }

    @Override
    public String getStatusMessage(PatchTarget patchTarget, PatchActionStatus status) {
        String statusMsg = null;
        switch (status) {
            case incomplete: {
                statusMsg = this.getLocalizedString("RHPPrePatchAction.start.message", patchTarget.toReportingString());
                break;
            }
            case success: {
                statusMsg = this.getLocalizedString("RHPPrePatchAction.success.message", patchTarget.toReportingString());
                break;
            }
            case warning: {
                statusMsg = this.getLocalizedString("RHPPrePatchAction.warning.message", patchTarget.toReportingString());
                break;
            }
            case failure: {
                statusMsg = this.getLocalizedString("RHPPrePatchAction.failure.message", patchTarget.toReportingString());
                break;
            }
            default: {
                statusMsg = super.getStatusMessage(patchTarget, status);
            }
        }
        return statusMsg;
    }

    public boolean isRollbackSupported() {
        return true;
    }

    public boolean isLocalParallelExecutionSupported() {
        return true;
    }

    @Override
    public void prepareRemoteActionExecutionHost(RemoteConnectionHandler handler, PatchActionExecutorContainer container) throws RemoteConnectionException, PatchActionException {
        super.prepareRemoteActionExecutionHost(handler, container);
    }

    @Override
    public void setupRemoteActionExecutionEnvironment(MutablePatchSession patchSession, PatchActionExecutorContainer container) throws PatchActionException {
        super.setupRemoteActionExecutionEnvironment(patchSession, container);
    }

    @Override
    public PatchAction clone() throws CloneNotSupportedException {
        PatchAction patchAction = super.clone();
        return patchAction;
    }
}

