/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.controller.action;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.cie.remote.RemoteConnectionException;
import com.oracle.cie.remote.RemoteConnectionHandler;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.action.CommonPatchAction;
import com.oracle.glcm.patch.auto.action.PatchAction;
import com.oracle.glcm.patch.auto.action.PatchActionException;
import com.oracle.glcm.patch.auto.action.PatchActionExecutorContainer;
import com.oracle.glcm.patch.auto.action.PatchActionResult;
import com.oracle.glcm.patch.auto.action.PatchActionStatus;
import com.oracle.glcm.patch.auto.credential.Credential;
import com.oracle.glcm.patch.auto.credential.CredentialManager;
import com.oracle.glcm.patch.auto.credential.ValueHolder;
import com.oracle.glcm.patch.auto.db.framework.SessionData;
import com.oracle.glcm.patch.auto.db.framework.TrackOOPSessions;
import com.oracle.glcm.patch.auto.db.framework.patchinfostore.PatchingSessionInfoStore;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.Command;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.SystemModelUtils;
import com.oracle.glcm.patch.auto.db.framework.sdk.readme.ReadmeFactory;
import com.oracle.glcm.patch.auto.db.integration.controller.RemoteContentTransferHandler;
import com.oracle.glcm.patch.auto.db.integration.controller.action.ExecutionThread;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBFamily;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductParameterConstants;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductSupport;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.CommandFailureException;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBBaseTargetModel;
import com.oracle.glcm.patch.auto.db.product.constant.DBCommonPatchingConstants;
import com.oracle.glcm.patch.auto.db.product.executor.ExecutionResult;
import com.oracle.glcm.patch.auto.db.product.executor.PatchingStepExecutor;
import com.oracle.glcm.patch.auto.db.product.summary.DBPatchingSummaryCreator;
import com.oracle.glcm.patch.auto.db.product.summary.SummaryID;
import com.oracle.glcm.patch.auto.lifecycle.Goal;
import com.oracle.glcm.patch.auto.plan.PatchPlanManager;
import com.oracle.glcm.patch.auto.session.MutablePatchSession;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import com.oracle.helper.util.HelperUtility;
import dbmodel.common.AbstractBaseTarget;
import dbmodel.common.Host;
import dbmodel.common.OracleHome;
import dbmodel.db_crs.DBInstance;
import dbmodel.db_crs.RACDBInstance;
import dbmodel.db_crs.RACDatabase;
import dbmodel.db_crs.SIDatabase;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import oracle.dbsysmodel.driver.sdk.productdriver.ClusterInformationLoader;
import oracle.dbsysmodel.driver.sdk.util.FileUtility;
import oracle.opatch.system.db.automation.jaxb.ActionType;

public abstract class DBCommonPatchAction
extends CommonPatchAction {
    private Map<PatchTarget, List<ExecutionStep>> generatedStepsMap;

    public DBCommonPatchAction(Goal ... goals) {
        super(goals);
    }

    public boolean isActionRequired(PatchTarget patchTarget) throws PatchActionException {
        if (this.getPatchSession().getCommand().isReport()) {
            return false;
        }
        return !this.isPatchApplicabilityCheckRequired(patchTarget) || !PatchingSessionInfoStore.getInstance().skipPatchTarget(patchTarget);
    }

    protected boolean isPatchApplicabilityCheckRequired(PatchTarget patchTarget) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public PatchActionResult execute(PatchTarget patchTarget) {
        PatchActionResult patchActionResult;
        block14: {
            block15: {
                patchActionResult = new PatchActionResult();
                List<ExecutionStep> generatedSteps = null;
                if (this.generatedStepsMap != null && this.generatedStepsMap.get(patchTarget) != null) {
                    generatedSteps = this.generatedStepsMap.get(patchTarget);
                } else {
                    try {
                        generatedSteps = this.generateSteps(patchTarget);
                    }
                    catch (OPatchAutoException e) {
                        this._logger.info(e.getMessage());
                        patchActionResult = new PatchActionResult((Throwable)e);
                    }
                }
                if (generatedSteps == null || generatedSteps.isEmpty()) break block15;
                this.preOperation(patchTarget);
                TrackOOPSessions.startPatchAction(patchTarget.getHome().getLocation(), ((Object)((Object)this)).getClass().getName());
                patchActionResult = this.executeSteps(generatedSteps, patchTarget);
                try {
                    this.postOperation(patchTarget);
                }
                catch (OPatchAutoException e) {
                    this._logger.info(e.getMessage());
                    patchActionResult = new PatchActionResult((Throwable)e);
                }
                TrackOOPSessions.endPatchAction(patchTarget.getHome().getLocation(), ((Object)((Object)this)).getClass().getName(), !patchActionResult.isFailure());
                break block14;
                catch (OPatchAutoException e) {
                    try {
                        this._logger.info(e.getMessage());
                        patchActionResult = new PatchActionResult((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        try {
                            this.postOperation(patchTarget);
                        }
                        catch (OPatchAutoException e2) {
                            this._logger.info(e2.getMessage());
                            patchActionResult = new PatchActionResult((Throwable)e2);
                        }
                        TrackOOPSessions.endPatchAction(patchTarget.getHome().getLocation(), ((Object)((Object)this)).getClass().getName(), !patchActionResult.isFailure());
                        throw throwable;
                    }
                    try {
                        this.postOperation(patchTarget);
                    }
                    catch (OPatchAutoException e3) {
                        this._logger.info(e3.getMessage());
                        patchActionResult = new PatchActionResult((Throwable)e3);
                    }
                    TrackOOPSessions.endPatchAction(patchTarget.getHome().getLocation(), ((Object)((Object)this)).getClass().getName(), !patchActionResult.isFailure());
                    break block14;
                }
            }
            patchActionResult = new PatchActionResult(PatchActionStatus.skipped);
            this.displayNoStepMessage(patchTarget);
        }
        return patchActionResult;
    }

    public PatchActionResult executeStepsInParallel(List<ExecutionStep> generatedSteps, PatchTarget patchTarget) {
        PatchActionResult patchActionResult = new PatchActionResult();
        if (generatedSteps != null && !generatedSteps.isEmpty()) {
            try {
                ArrayList<ExecutionThread> stepThreads = new ArrayList<ExecutionThread>();
                for (ExecutionStep step : generatedSteps) {
                    ExecutionThread threadForStep = new ExecutionThread(step, null, this._logger);
                    stepThreads.add(threadForStep);
                }
                this._logger.info("\nStarting parallel execution of the steps\n");
                for (ExecutionThread et : stepThreads) {
                    et.start();
                }
                for (ExecutionThread et : stepThreads) {
                    try {
                        et.join();
                    }
                    catch (InterruptedException e) {}
                }
                boolean failed = false;
                ArrayList<String> details = new ArrayList<String>();
                for (ExecutionThread et : stepThreads) {
                    if (et.successfull || this.getPatchSession().isAnalyze()) continue;
                    failed = true;
                    this._logger.info(et.errorMsg);
                    details.add(et.getCommand());
                }
                if (failed) {
                    patchActionResult = new PatchActionResult(PatchActionStatus.failure);
                    patchActionResult.setDetails(details);
                    return patchActionResult;
                }
            }
            catch (Exception e) {
                this._logger.info(e.getMessage());
                patchActionResult = new PatchActionResult((Throwable)e);
            }
        } else {
            patchActionResult = new PatchActionResult(PatchActionStatus.skipped);
            this._logger.info("No Steps generated for this action on the selected target.");
            this.displayNoStepMessage(patchTarget);
        }
        return patchActionResult;
    }

    protected void displayNoStepMessage(PatchTarget target) {
        Reporting.report((String)OPatchAutoHelper.getLocalizedString((String)"PatchAction.no.step.execution", (Object[])new Object[0]));
    }

    protected abstract List<ExecutionStep> generateSteps(PatchTarget var1) throws OPatchAutoException;

    protected PatchActionResult executeSteps(List<ExecutionStep> executionSteps, PatchTarget patchTarget) throws OPatchAutoException {
        PatchActionResult patchActionResult = new PatchActionResult();
        if (DBPatchingHelper.isGenerateStepCommand(this.getPatchSession().getOptions())) {
            ReadmeFactory.getInstance().logExecutionStep(executionSteps);
            DBPatchingSummaryCreator summaryCreator = this.getProductSupport().getDBPatchingSummaryCreator(this.getPatchSession().getCommand());
            StringBuilder summary = new StringBuilder();
            summary.append(this.getLocalizedString("Generate.step.message", new Object[0]));
            summary.append(this.getLocalizedString("Generate.step.file.loc", PatchPlanner.getInstance().getLogInfo().getReadmeTxt().getAbsolutePath()));
            summaryCreator.storePatchingSummary(0, SummaryID.generate_step, patchTarget, summary.toString());
        } else {
            block2: for (ExecutionStep executionStep : executionSteps) {
                try {
                    ExecutionResult result = this.runCommand(patchTarget, executionStep);
                    if (result == null) continue;
                    for (ExecutionResult.CommandExecutionResult commandStatus : result.getResultList()) {
                        ExecutionResult.ExecutionStatus status = commandStatus.getStatus();
                        if (!this.getPatchSession().isAnalyze() && status == ExecutionResult.ExecutionStatus.FAILURE) {
                            patchActionResult = new PatchActionResult(PatchActionStatus.failure);
                            continue block2;
                        }
                        String reportAnalyzeFailOption = this.getPatchSession().getProductSupportManager().getOptions().getOption(DBProductParameterConstants.REPORT_ANALYZE_FAILURE.getValue()).getValue();
                        if (!StringUtil.isNullOrEmpty((String)reportAnalyzeFailOption) && this.getPatchSession().isAnalyze() && status == ExecutionResult.ExecutionStatus.FAILURE) {
                            PatchPlanner.getInstance().setAnalyzeFailed(true);
                        }
                        patchActionResult = new PatchActionResult(PatchActionStatus.success);
                    }
                }
                catch (CommandFailureException e) {
                    this._logger.info(e.getLocalizedMessage());
                    StringBuilder builder = this.generateErrorSummary(patchTarget, executionStep, e.getCommand(), e.getCommandOutput(), e.getLocalizedMessage());
                    ArrayList<String> details = new ArrayList<String>();
                    details.add(builder.toString());
                    patchActionResult = new PatchActionResult(PatchActionStatus.failure);
                    patchActionResult.setDetails(details);
                    return patchActionResult;
                }
            }
        }
        return patchActionResult;
    }

    protected StringBuilder generateErrorSummary(PatchTarget target, ExecutionStep step, String command, String commandOutPut, String errorMessage) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getLocalizedString("PatchAction.command.failure.header", new Object[0]));
        builder.append(this.getLocalizedString("PatchAction.command.failure.body", target.getHome().getLocation(), target.getHost().getHost()));
        builder.append(this.getLocalizedString("PatchAction.command.failure.commanddetails", command));
        if (StringUtil.isNullOrEmpty((String)commandOutPut.trim())) {
            commandOutPut = errorMessage;
        }
        builder.append(this.getLocalizedString("PatchAction.command.failure.commandoutput", commandOutPut.trim()));
        return builder;
    }

    protected ExecutionResult runCommand(PatchTarget patchTarget, ExecutionStep executionStep) throws CommandFailureException {
        long startTime = System.currentTimeMillis();
        CredentialManager credentialMgr = this.getPatchSession().getCredentialManager();
        Credential cred = null;
        try {
            String currentUser = System.getProperty("user.name");
            if (!"root".equals(currentUser)) {
                String owner;
                boolean echoCmd = false;
                for (ExecutionStep.Command cmd : (ArrayList)executionStep.getCommand()) {
                    String command = cmd.getValue();
                    if (command.indexOf("echo") == -1) continue;
                    echoCmd = true;
                    break;
                }
                if (!echoCmd && null != (owner = DBPatchingHelper.getStepOwner(executionStep)) && !"root".equals(owner)) {
                    cred = credentialMgr.getCredential(patchTarget.getHost().getHost(), null, owner);
                }
                if (cred == null) {
                    cred = credentialMgr.getCredential(patchTarget.getHost().getHost(), null, currentUser);
                }
            }
        }
        catch (OPatchAutoException e) {
            this._logger.severe("No credential available for host " + patchTarget.getHost().getHost());
        }
        ExecutionResult result = PatchingStepExecutor.getInstance().processSteps(executionStep, this.getPatchSession(), cred, patchTarget);
        long endTime = System.currentTimeMillis();
        if (this._logger.isLoggable(Level.INFO)) {
            long duration = endTime - startTime;
            this._logger.info("Time taken for execution of steps " + executionStep.getAutomationAction().getType() + " :: " + TimeUnit.MILLISECONDS.toSeconds(duration) + " seconds");
        }
        return result;
    }

    protected byte[] getPassword(PatchTarget target) {
        byte[] pass = target.getHost().getPassword();
        if (pass == null) {
            CredentialManager credentialMgr = this.getPatchSession().getCredentialManager();
            try {
                Credential credential = credentialMgr.getCredential(target.getHost().getHost());
                if (credential != null) {
                    pass = new String(credential.getPassword()).getBytes();
                }
            }
            catch (OPatchAutoException e) {
                this._logger.severe("No credential available for host " + target.getHost().getHost());
            }
        }
        return pass;
    }

    protected byte[] getPassword(PatchTarget target, String username) {
        byte[] pass = null;
        CredentialManager credentialMgr = this.getPatchSession().getCredentialManager();
        try {
            Credential credential = credentialMgr.getCredential(target.getHost().getHost(), null, username);
            if (credential != null) {
                pass = new String(credential.getPassword()).getBytes();
            }
        }
        catch (OPatchAutoException e) {
            this._logger.severe("No credential available for host " + username + "@" + target.getHost().getHost());
        }
        return pass;
    }

    protected DBProductSupport getProductSupport() {
        return (DBProductSupport)this.getPatchSession().getProductSupportManager().getProductSupport("db");
    }

    public boolean isRemoteExecutionHandled(PatchTarget patchTarget) throws OPatchAutoException {
        boolean isRemoteExcutionHandled = false;
        isRemoteExcutionHandled = DBPatchingHelper.isGenerateStepCommand(this.getPatchSession().getOptions()) ? true : super.isRemoteExecutionHandled(patchTarget);
        return isRemoteExcutionHandled;
    }

    protected boolean isStepExecutionRequiredForSharedHome(PatchTarget currentTarget) {
        boolean isRequired = true;
        PatchPlanManager patchPlanManager = this.getPatchSession().getPatchPlanManager();
        Set patchTargetList = patchPlanManager.getPatchTargets(currentTarget.getType());
        if (patchTargetList != null && !patchTargetList.isEmpty()) {
            for (PatchTarget target : patchTargetList) {
                PatchActionStatus status;
                if (currentTarget.equals(target) || !target.getHome().isSharedHome() || !target.getHome().getLocation().equals(currentTarget.getHome().getLocation()) || (status = this.getPatchSession().getPatchTracking().getPreviousActionExecutionStatus((PatchAction)this, target, this.getCurrentGoal())) != PatchActionStatus.success) continue;
                isRequired = false;
                break;
            }
        }
        return isRequired;
    }

    protected List<ExecutionStep> getsteps(ConfigGraph configGraph, PatchTarget patchTarget, ActionType actionType, Command command) throws OPatchAutoException {
        List<Object> steps = null;
        DBBaseTargetModel targetModel = this.findBaseTargetAndHost(configGraph, actionType, patchTarget);
        if (targetModel.isValid()) {
            steps = command.getExecutionSteps(targetModel.getAbstractBaseTargetList(), configGraph, targetModel.getTargetHost());
        }
        if (steps == null) {
            steps = new ArrayList();
        }
        return steps;
    }

    protected boolean isUpdatedPatchLocationRequired(List<ExecutionStep> executionSteps) {
        String ohOwner;
        boolean isRequired = false;
        String currentUser = System.getProperty("user.name");
        if ("root".equals(currentUser)) {
            isRequired = false;
        } else if (executionSteps != null && executionSteps.size() > 0 && !currentUser.equals(ohOwner = executionSteps.get(0).getUser().getValue())) {
            isRequired = true;
            this._logger.info("Patch location update required");
        }
        return isRequired;
    }

    protected String findUpdatedPatchLocation(List<ExecutionStep> executionSteps, PatchTarget patchTarget) throws OPatchAutoException {
        String patchLocation = null;
        String ohOwner = executionSteps.get(0).getUser().getValue();
        CredentialManager credentialMgr = this.getPatchSession().getCredentialManager();
        Credential credential = DBPatchingHelper.getOwnerOrCurrentUserCred(patchTarget, credentialMgr);
        patchLocation = DBPatchingUtil.getUpdatePatchLocation(ohOwner, patchTarget.getHome(true).getLocation(), credential);
        return patchLocation;
    }

    protected Class<? extends AbstractBaseTarget> getApplicableTargetHome(ActionType actionType) {
        Class<? extends AbstractBaseTarget> type = SystemModelUtils.getClassForType(actionType.getActsOn());
        return type;
    }

    protected DBBaseTargetModel findBaseTargetAndHost(ConfigGraph graph, ActionType actionType, PatchTarget patchTarget) throws OPatchAutoException {
        DBBaseTargetModel targetModel = new DBBaseTargetModel();
        Class<? extends AbstractBaseTarget> type = this.getApplicableTargetHome(actionType);
        List<? extends AbstractBaseTarget> targets = graph.getTargets(type, actionType.getStripe());
        Host targetHost = null;
        OracleHome oh = null;
        for (AbstractBaseTarget abstractBaseTarget : targets) {
            targetHost = null;
            oh = null;
            if (abstractBaseTarget instanceof OracleHome) {
                oh = (OracleHome)abstractBaseTarget;
                if (oh.getPath().equals(patchTarget.getHome(true).getLocation())) {
                    targetHost = this.findHostFromHome(patchTarget, oh);
                }
            } else if (abstractBaseTarget instanceof DBInstance) {
                this._logger.info("target instanceof DBInstance");
                oh = ((DBInstance)abstractBaseTarget).getRuns_from();
                if (oh.getPath().equals(patchTarget.getHome(true).getLocation()) && ((DBInstance)abstractBaseTarget).getHost().getHostName().equals(patchTarget.getHost().getHost())) {
                    targetHost = ((DBInstance)abstractBaseTarget).getHost();
                }
            } else if (abstractBaseTarget instanceof RACDatabase) {
                this._logger.info("target instanceof RACDatabase");
                List dbInstances = ((RACDatabase)abstractBaseTarget).getDbInstances();
                for (RACDBInstance racdbInstance : dbInstances) {
                    oh = racdbInstance.getRuns_from();
                    if (racdbInstance.getHost().getHostName().equalsIgnoreCase(patchTarget.getHost().getHost()) && oh.getPath().equals(patchTarget.getHome(true).getLocation())) {
                        targetHost = racdbInstance.getHost();
                    }
                    if (oh == null || targetHost == null) continue;
                    break;
                }
            } else if (abstractBaseTarget instanceof SIDatabase) {
                this._logger.info("target instanceof SIDatabase");
            }
            if (oh == null || targetHost == null) continue;
            this._logger.info("Target type=" + abstractBaseTarget.getType());
            this._logger.info("Target display name=" + abstractBaseTarget.getDisplayName());
            this._logger.info("Target host=" + targetHost.getHostName());
            targetModel.addAbstractBaseTarget(abstractBaseTarget);
            targetModel.setTargetHost(targetHost);
        }
        return targetModel;
    }

    private Host findHostFromHome(PatchTarget patchTarget, OracleHome oh) {
        Host targetHost = null;
        for (Host host : oh.getHosts()) {
            if (!host.getHostName().equals(patchTarget.getHost().getHost())) continue;
            targetHost = host;
            break;
        }
        return targetHost;
    }

    private void setGeneratedStepsMap(Map<PatchTarget, List<ExecutionStep>> generatedStepsMap) {
        this.generatedStepsMap = generatedStepsMap;
    }

    protected String getLocalizedString(String name, Object ... messageFormatting) {
        return OPatchAutoHelper.getLocalizedString((String)name, (Object[])messageFormatting);
    }

    public void prepareRemoteActionExecutionHost(RemoteConnectionHandler handler, PatchActionExecutorContainer container) throws RemoteConnectionException, PatchActionException {
        super.prepareRemoteActionExecutionHost(handler, container);
        for (PatchTarget patchTarget : container.getPatchTargets()) {
            String oraBaseConfig;
            String home = patchTarget.getHome().getLocation();
            this._logger.info("Preparing remote home for target :" + patchTarget);
            try {
                oraBaseConfig = HelperUtility.detectOraBaseConfig((String)home, (RemoteConnectionHandler)handler);
            }
            catch (OPatchAutoException e) {
                throw new RemoteConnectionException((Throwable)e);
            }
            String opatchautoCfg = oraBaseConfig + File.separator + "opatchautocfg";
            if (ClusterInformationLoader.isGridHome((String)home)) {
                Credential credential;
                this._logger.info("Working on grid home :" + home);
                String host = DBPatchingHelper.getHostNameWithoutDomain(handler.getHost().getHost());
                String homeOwner = FileUtility.checkFileOwner((File)new File(home, "oraInst.loc"));
                try {
                    credential = this.getPatchSession().getCredentialManager().getCredential(host, null, homeOwner);
                }
                catch (OPatchAutoException e) {
                    throw new PatchActionException((Throwable)e);
                }
                RemoteContentTransferHandler.getInstance().mkDirOnRemoteHost(opatchautoCfg, handler, RemoteContentTransferHandler.DeleteStatus.NONE, "root", credential);
                RemoteContentTransferHandler.getInstance().chown(opatchautoCfg, home, handler, "root", credential);
                RemoteContentTransferHandler.getInstance().chmod(opatchautoCfg, 775, handler);
            } else {
                this._logger.info("Working on a database home :" + home);
                RemoteContentTransferHandler.getInstance().mkDirOnRemoteHost(opatchautoCfg, handler, RemoteContentTransferHandler.DeleteStatus.NONE);
            }
            String opatchautoCfgDB = oraBaseConfig + DBCommonPatchingConstants.OATCHAUTOCFG_DB_DIR;
            RemoteContentTransferHandler.getInstance().mkDirOnRemoteHost(opatchautoCfgDB, handler, RemoteContentTransferHandler.DeleteStatus.NONE);
            String opatchautoCfgSession = oraBaseConfig + DBCommonPatchingConstants.OATCHAUTOCFG_DB_DIR + DBCommonPatchingConstants.CONFIG_SESSIONINFO_DIR;
            RemoteContentTransferHandler.getInstance().mkDirOnRemoteHost(opatchautoCfgSession, handler, RemoteContentTransferHandler.DeleteStatus.NONE);
            String opatchautoCfgdbTmpLocation = oraBaseConfig + DBCommonPatchingConstants.OATCHAUTOCFG_DB_DIR + DBCommonPatchingConstants.CONFIG_DBTMP_DIR;
            RemoteContentTransferHandler.getInstance().mkDirOnRemoteHost(opatchautoCfgdbTmpLocation, handler, RemoteContentTransferHandler.DeleteStatus.NONE);
        }
        this.copyPerlLibPathFile(handler, container);
        this.persistStepsInRemote(container);
        if (this.getPatchSession().isRollback() && DBPatchingHelper.isRollbackUsingPatchId(this.getPatchSession())) {
            container.addPatchActionParameter("id", (Object)this.getPatchSession().getPatchId());
        } else if (!DBPatchingHelper.isOOPSwitchPatchingSession(this.getPatchSession().getOptions())) {
            this.copyPatchToRemote(handler, container);
        }
        Boolean isOOPApplySwitch = null;
        Boolean hasCRSPatching = false;
        boolean isOOPPatchingSession = DBPatchingHelper.isOOPPatchingSession(this.getPatchSession().getOptions());
        container.addPatchActionParameter(DBProductParameterConstants.OOP_PATCHING_SESSION.getValue(), (Object)new Boolean(isOOPPatchingSession));
        if (isOOPPatchingSession) {
            isOOPApplySwitch = Boolean.FALSE;
            if (this.getPatchSession().getCommand().isApply() && DBPatchingHelper.isOOPSwitchPatchingSession(this.getPatchSession().getOptions())) {
                isOOPApplySwitch = Boolean.TRUE;
            }
        }
        PatchPlanManager patchPlanManager = this.getPatchSession().getPatchPlanManager();
        Set patchTargetList = patchPlanManager.getPatchTargets();
        hasCRSPatching = DBPatchingHelper.hasCRSPatching(patchTargetList);
        container.addPatchActionParameter(DBProductParameterConstants.OOP_SWITCH_SESSION.getValue(), (Object)isOOPApplySwitch);
        container.addPatchActionParameter(DBProductParameterConstants.HAS_CRS_PATCHING.getValue(), (Object)hasCRSPatching);
        this.persistSessionIDOnRemote(handler, container);
        String patchWithFiles = System.getProperty("OPatchauto.PATCH_WITH_FILES_FROM_LOC");
        container.addPatchActionParameter(DBProductParameterConstants.PATCH_WITH_FILES_FROM_LOC.getValue(), (Object)patchWithFiles);
        String giHomePath = System.getProperty("OPatchauto.GI_HOME_PATH");
        if (!StringUtil.isNullOrEmpty((String)giHomePath, (boolean)true)) {
            container.addPatchActionParameter(DBProductParameterConstants.GRID_HOME.getValue(), (Object)giHomePath);
        }
        String homePath = this.getProductSupport().getLibPathFromHost(handler.getHost().getHost());
        String dbTmpLocation = this.getDBTmpLocation(homePath, handler);
        this.writeWalletToContainer(handler, container, dbTmpLocation);
        try {
            String family = this.getPatchSession().getProductSupportManager().getOptions().getOption(DBProductParameterConstants.FAMILY.getValue()).getValue();
            if (!StringUtil.isNullOrEmpty((String)family)) {
                container.addPatchActionParameter(DBProductParameterConstants.FAMILY.getValue(), (Object)this.getPatchSession().getProductSupportManager().getOptions().getOption(DBProductParameterConstants.FAMILY.getValue()).getValue());
            }
        }
        catch (OPatchAutoException e) {
            throw new PatchActionException((Throwable)e);
        }
    }

    private void copyPerlLibPathFile(RemoteConnectionHandler handler, PatchActionExecutorContainer container) throws RemoteConnectionException, PatchActionException {
        String homePath = this.getProductSupport().getLibPathFromHost(handler.getHost().getHost());
        try {
            String oracleHomePath = ((PatchTarget)container.getPatchTargets().iterator().next()).getHome().getLocation();
            String sessionTemp = oracleHomePath + DBCommonPatchingConstants.OPATCH_AUTO_DBSESSIONINFO;
            String filePath = OPatchAutoHelper.getOPatchAutoHome() + DBCommonPatchingConstants.OPATCH_AUTO_DBSESSIONINFO + "perllibpath_" + handler.getHost().getHost() + ".txt";
            if (homePath == null) {
                homePath = oracleHomePath;
            }
            File f = new File(filePath);
            f.createNewFile();
            DBPatchingUtil.writeContent(f, homePath, false, false);
            String remoteSessionInfoLocation = sessionTemp + "perllibpath.txt";
            RemoteContentTransferHandler.getInstance().transferFileToRemoteHost(remoteSessionInfoLocation, new File(filePath), handler, RemoteContentTransferHandler.DeleteStatus.DELETE_ON_EXIT);
            f.deleteOnExit();
        }
        catch (IOException e) {
            throw new PatchActionException((Throwable)e);
        }
        catch (OPatchAutoException e) {
            throw new PatchActionException((Throwable)e);
        }
    }

    private String getDBTmpLocation(String home, RemoteConnectionHandler handler) throws RemoteConnectionException {
        String dbTmpLocation = null;
        if (this.getPatchSession().isRollback() && DBPatchingHelper.isRollbackUsingPatchId(this.getPatchSession()) || DBPatchingHelper.isOOPSwitchPatchingSession(this.getPatchSession().getOptions())) {
            String oraBaseConfig;
            try {
                oraBaseConfig = HelperUtility.detectOraBaseConfig((String)home, (RemoteConnectionHandler)handler);
            }
            catch (OPatchAutoException e) {
                throw new RemoteConnectionException((Throwable)e);
            }
            dbTmpLocation = oraBaseConfig + DBCommonPatchingConstants.OATCHAUTOCFG_DB_DIR + DBCommonPatchingConstants.CONFIG_DBTMP_DIR;
        } else {
            String remotePatchLocation = System.getProperty("patch.zip.location");
            File remotePatchLocationFile = new File(remotePatchLocation);
            dbTmpLocation = remotePatchLocationFile.getParentFile().getParent() + DBCommonPatchingConstants.OPATCH_AUTO_DBTMP_DIR;
        }
        return dbTmpLocation;
    }

    private void writeWalletToContainer(RemoteConnectionHandler handler, PatchActionExecutorContainer container, String dbTmpLocation) throws RemoteConnectionException, PatchActionException {
        RemoteContentTransferHandler contentTransferHandler = RemoteContentTransferHandler.getInstance();
        File wallet = this.getPatchSession().getCredentialManager().getWalletLocation();
        if (wallet != null) {
            String remoteWalletDir = dbTmpLocation + "wallet";
            String remoteWalletLocation = remoteWalletDir + File.separator + wallet.getName();
            container.addPatchActionParameter("wallet", (Object)remoteWalletLocation);
            contentTransferHandler.mkDirOnRemoteHost(remoteWalletDir, handler, RemoteContentTransferHandler.DeleteStatus.DELETE_ON_EXIT);
            contentTransferHandler.transferFileToRemoteHost(remoteWalletLocation, wallet, handler, RemoteContentTransferHandler.DeleteStatus.NONE);
            try {
                container.addPatchActionParameter("value.holder", (Object)this.getPatchSession().getCredentialManager().getValueHolder());
            }
            catch (OPatchAutoException e) {
                throw new PatchActionException((Throwable)e);
            }
        }
    }

    public void setupRemoteActionExecutionEnvironment(MutablePatchSession patchSession, PatchActionExecutorContainer container) throws PatchActionException {
        Boolean isOOPSwitch;
        super.setupRemoteActionExecutionEnvironment(patchSession, container);
        this.generatedStepsMap = (Map)container.getPatchActionParameterValue(DBProductParameterConstants.STEPS_GENERATED_KEY.getValue());
        String patchId = null;
        if (patchSession.isRollback()) {
            patchId = (String)container.getPatchActionParameterValue("id");
        }
        if ((isOOPSwitch = (Boolean)container.getPatchActionParameterValue(DBProductParameterConstants.OOP_SWITCH_SESSION.getValue())) == null || !isOOPSwitch.booleanValue() && !patchSession.isRollback()) {
            try {
                if (!StringUtil.isNullOrEmpty((String)patchId, (boolean)true)) {
                    patchSession.setPatchInfo(null, null, patchId);
                } else {
                    String zipLocation = (String)container.getPatchActionParameterValue(DBProductParameterConstants.PATCH_ZIP_FILE_LOC.getValue());
                    System.setProperty(DBProductParameterConstants.PATCH_ZIP_FILE_LOC.getValue(), zipLocation);
                    patchSession.setPatchInfo((String)container.getPatchActionParameterValue("patch.location"), (String)container.getPatchActionParameterValue("patch.base.directory"), null);
                }
                String family = (String)container.getPatchActionParameterValue(DBProductParameterConstants.FAMILY.getValue());
                if (!StringUtil.isNullOrEmpty((String)family)) {
                    this.getPatchSession().getProductSupportManager().getOptions().getOption(DBProductParameterConstants.FAMILY.getValue()).setValue(family);
                }
            }
            catch (OPatchAutoException e) {
                throw new PatchActionException((Throwable)e);
            }
        }
        this.readWalletFromContainer(patchSession, container);
    }

    private void readWalletFromContainer(MutablePatchSession patchSession, PatchActionExecutorContainer container) throws PatchActionException {
        CredentialManager credentialManager = new CredentialManager();
        String wallet = (String)container.getPatchActionParameterValue("wallet");
        if (!StringUtil.isNullOrEmpty((String)wallet, (boolean)true)) {
            try {
                ValueHolder valueHolder = (ValueHolder)container.getPatchActionParameterValue("value.holder");
                credentialManager.setWallet(new File(wallet), valueHolder != null ? valueHolder.getValue() : null);
            }
            catch (OPatchAutoException e) {
                throw new PatchActionException("Unable to configure wallet in credential manager.", (Throwable)e, new Object[0]);
            }
        }
        patchSession.setCredentialManager(credentialManager);
    }

    public PatchAction clone() throws CloneNotSupportedException {
        PatchAction patchAction = super.clone();
        ((DBCommonPatchAction)patchAction).setGeneratedStepsMap(this.generatedStepsMap);
        return patchAction;
    }

    private void persistStepsInRemote(PatchActionExecutorContainer container) throws PatchActionException {
        HashMap<PatchTarget, List<ExecutionStep>> generatedStepsMap = new HashMap<PatchTarget, List<ExecutionStep>>();
        for (PatchTarget patchTarget : container.getPatchTargets()) {
            try {
                List<ExecutionStep> generatedSteps = this.generateSteps(patchTarget);
                generatedStepsMap.put(patchTarget, generatedSteps);
            }
            catch (OPatchAutoException e) {
                throw new PatchActionException((Throwable)e);
            }
        }
        container.addPatchActionParameter(DBProductParameterConstants.STEPS_GENERATED_KEY.getValue(), generatedStepsMap);
    }

    private void copyPatchToRemote(RemoteConnectionHandler handler, PatchActionExecutorContainer container) throws PatchActionException, RemoteConnectionException {
        String patchLocation = this.getPatchSession().getPatchLocation();
        String parameterKey = "patch.location";
        if (StringUtil.isNullOrEmpty((String)patchLocation, (boolean)true)) {
            patchLocation = this.getPatchSession().getPatchBaseDirectory();
            parameterKey = "patch.base.directory";
        }
        if (StringUtil.isNullOrEmpty((String)patchLocation, (boolean)true)) {
            throw new PatchActionException("The patch location or patch base location were not set.", new Object[0]);
        }
        String patchZipLocation = System.getProperty("patch.zip.location");
        File remotePatchZipLocationFile = new File(patchZipLocation);
        RemoteContentTransferHandler.getInstance().transferFileToRemoteHost(remotePatchZipLocationFile.getParent(), remotePatchZipLocationFile, handler, RemoteContentTransferHandler.DeleteStatus.DELETE_ON_EXIT);
        String patchName = remotePatchZipLocationFile.getName().split("\\.")[0];
        String remotePatchLocation = remotePatchZipLocationFile.getParentFile().getParent() + DBCommonPatchingConstants.OPATCH_AUTO_DBTMP_DIR + patchName;
        handler.deleteOnClose(remotePatchLocation);
        container.addPatchActionParameter(DBProductParameterConstants.PATCH_ZIP_FILE_LOC.getValue(), (Object)patchZipLocation);
        container.addPatchActionParameter(parameterKey, (Object)remotePatchLocation);
        String perlLibPath = this.getProductSupport().getLibPathFromHost(handler.getHost().getHost());
        String oracleHomePath = ((PatchTarget)container.getPatchTargets().iterator().next()).getHome().getLocation();
        RemoteContentTransferHandler.getInstance().unzipPatchOnRemote(handler, oracleHomePath, patchZipLocation, remotePatchLocation, perlLibPath);
    }

    private void persistSessionIDOnRemote(RemoteConnectionHandler handler, PatchActionExecutorContainer container) throws PatchActionException, RemoteConnectionException {
        String currentHostName = System.getProperty("OPatchauto.HOSTNAME");
        String localFilePath = SessionData.getConfigDir() + DBCommonPatchingConstants.CONFIG_SESSIONINFO_DIR + "localSessionInfoFile_" + currentHostName + ".txt";
        File localSessionInfoFile = new File(localFilePath);
        Set targets = container.getPatchTargets();
        for (PatchTarget target : targets) {
            String oracleHome = target.getHome(true).getLocation();
            String sessionTemp = HelperUtility.detectOraBaseConfig((String)oracleHome) + DBCommonPatchingConstants.OATCHAUTOCFG_DB_DIR + DBCommonPatchingConstants.CONFIG_SESSIONINFO_DIR;
            String remoteSessionInfoLocation = sessionTemp + "sessioninfo.txt";
            RemoteContentTransferHandler.getInstance().transferFileToRemoteHost(remoteSessionInfoLocation, localSessionInfoFile, handler, RemoteContentTransferHandler.DeleteStatus.DELETE_ON_EXIT);
        }
    }

    public void postExecute(PatchTarget patchTarget, PatchActionResult patchActionResult) throws OPatchAutoException {
        String opatchSpaceAuto = System.getenv("OPATCH_SPACE_AUTO");
        if (patchActionResult.isFailure() && patchActionResult.getDetailsList() != null && !patchActionResult.getDetailsList().isEmpty() && this.getPatchSession().getPatchTracking() != null) {
            StringBuilder builder = new StringBuilder();
            List detailsList = patchActionResult.getDetailsList();
            for (String detail : detailsList) {
                builder.append(detail);
            }
            if (SessionData.getInstance().isValidationCompleted()) {
                if (!Boolean.parseBoolean(opatchSpaceAuto)) {
                    builder.append(this.getLocalizedString("PatchAction.command.failure.sessionid", this.getPatchSession().getPatchTracking().getSessionId()));
                }
            } else {
                builder.append(this.getLocalizedString("PatchAction.command.failure.validation", this.getPatchSession().getPatchTracking().getSessionId()));
            }
            detailsList.removeAll(detailsList);
            ArrayList<String> modifedList = new ArrayList<String>();
            modifedList.add(builder.toString());
            patchActionResult.setDetails(modifedList);
        }
    }

    protected String addTag(String statusMsg) {
        String updatedMsg = statusMsg;
        try {
            String dbproduct;
            if (!StringUtil.isNullOrEmpty((String)statusMsg) && this.getPatchSession().getProductSupportManager().getOptions().getOption(DBProductParameterConstants.FAMILY.getValue()) != null && !StringUtil.isNullOrEmpty((String)(dbproduct = this.getPatchSession().getProductSupportManager().getOptions().getOption(DBProductParameterConstants.FAMILY.getValue()).getValue())) && dbproduct.equalsIgnoreCase(DBFamily.SHARDING.getValue())) {
                updatedMsg = "<sharding>" + statusMsg + "</sharding>";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return updatedMsg;
    }

    protected void preOperation(PatchTarget patchTarget) throws OPatchAutoException {
    }

    protected void postOperation(PatchTarget patchTarget) throws OPatchAutoException {
    }

    public String getStatusMessage(PatchTarget patchTarget, PatchActionStatus status) {
        String statusMsg = null;
        switch (status) {
            case skipped: {
                statusMsg = " ";
                break;
            }
            default: {
                statusMsg = super.getStatusMessage(patchTarget, status);
            }
        }
        return statusMsg;
    }
}

