/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.controller.action;

import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.action.PatchActionException;
import com.oracle.glcm.patch.auto.action.PatchActionStatus;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.Command;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandActionType;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.integration.controller.action.DBCommonPatchAction;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductTypes;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.CommandDetailsGenerator;
import com.oracle.glcm.patch.auto.db.product.executor.GISystemCall;
import com.oracle.glcm.patch.auto.lifecycle.Goal;
import com.oracle.glcm.patch.auto.lifecycle.OfflinePhase;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.opatch.system.db.automation.jaxb.ActionType;
import oracle.opatch.system.db.automation.jaxb.PatchingPhase;
import oracle.opatch.system.db.automation.jaxb.PhaseType;
import oracle.opatch.system.db.automation.jaxb.ServiceStatus;
import oracle.opatch.system.db.automation.jaxb.Strategy;

public class CloneOracleHomeAction
extends DBCommonPatchAction {
    private static final String PERL_PATH = "%OracleHome.path%/perl/bin/perl";
    private static final String CLONE_PL_COMMAND = "%OracleHome.path%/clone/bin/clone.pl";
    private static final String RUN_INSTALLER = "%OracleHome.path%/runInstaller";
    private static final String GRID_SETUP = "%OracleHome.path%/gridSetup.sh";
    private static final String INSTALL_DB_SWONLY = "oracle.install.option=INSTALL_DB_SWONLY";
    private static final String INSTALL_CRS_SWONLY = "oracle.install.option=CRS_SWONLY";
    private static final String DEFAULT_HOME_NAME = "-defaultHomeName";
    private static final String SHARED_HOME_FLAG = "-cfs";
    private static final String CRS_FALSE = "CRS=false";
    private static final String CLUSTER_NODES_PARAM = "\"CLUSTER_NODES={%@Host.hostName%}\"";
    private static final String CLUSTER_NODES_PARA_DB19 = "'CLUSTER_NODES={%@Host.hostName%}'";
    private static final String LOCAL_NODE_PARAM = "\"LOCAL_NODE=%Host.hostName%\"";
    private static final String ROOT_SH_CONFIRMATION = "SHOW_ROOTSH_CONFIRMATION=false";
    private static final String SKIP_ROOT_PRE = "oracle.install.skipRootPre=true";
    private static final String SILENT_MODE = "-silent";
    private ConfigGraph configGraph = null;

    public CloneOracleHomeAction() {
        super(new Goal[]{OfflinePhase.Goal.prepare});
    }

    @Override
    public boolean isActionRequired(PatchTarget patchTarget) throws PatchActionException {
        boolean isActionRequired = super.isActionRequired(patchTarget);
        if (!isActionRequired) {
            return isActionRequired;
        }
        return DBPatchingHelper.isOOPPreparePatchingSession(this.getPatchSession().getOptions()) || DBPatchingHelper.isSingleOOPPatchingSession(this.getPatchSession().getOptions());
    }

    public boolean isActionRequiredLocalOnly() {
        return true;
    }

    public Set<String> getSupportedProductTypes() {
        HashSet<String> targetList = new HashSet<String>();
        targetList.add(DBProductTypes.PRODUCT_TYPE_SIHA.getValue());
        targetList.add(DBProductTypes.PRODUCT_TYPE_SIDB.getValue());
        targetList.add(DBProductTypes.PRODUCT_TYPE_CRS.getValue());
        targetList.add(DBProductTypes.PRODUCT_TYPE_RAC.getValue());
        return targetList;
    }

    public int getOrderingWeight(Goal goal) {
        return 40;
    }

    public boolean isLocalParallelExecutionSupported() {
        return false;
    }

    public boolean isRemoteParallelExecutionSupported() {
        return false;
    }

    @Override
    protected List<ExecutionStep> generateSteps(PatchTarget patchTarget) throws OPatchAutoException {
        this.configGraph = PatchPlanner.getInstance().getConfigGraph();
        ArrayList<ExecutionStep> generatedSteps = new ArrayList<ExecutionStep>();
        List<ExecutionStep> steps = null;
        String targetHome = DBPatchingHelper.getTargetHomeFromProductType(patchTarget);
        steps = this.getClonePlExecutionStep(patchTarget, targetHome);
        generatedSteps.addAll(steps);
        return generatedSteps;
    }

    private List<ExecutionStep> getClonePlExecutionStep(PatchTarget patchTarget, String targetHome) throws OPatchAutoException {
        HashMap<CommandDetailsGenerator.ActionTypeParams, Object> argList = new HashMap<CommandDetailsGenerator.ActionTypeParams, Object>();
        String clonePlCommand = "";
        argList.put(CommandDetailsGenerator.ActionTypeParams.TYPE, CommandActionType.shell.toString());
        argList.put(CommandDetailsGenerator.ActionTypeParams.ACTS_ON_CLONE, Boolean.TRUE);
        if (DBPatchingUtil.isVersionEqalOrlater(patchTarget.getHome().getVersion(), "20.0.0.0.0")) {
            if (targetHome.equals("siha") || targetHome.equals("crs")) {
                argList.put(CommandDetailsGenerator.ActionTypeParams.README_TITLE_KEY, "GridSetup-Oh-Title");
                argList.put(CommandDetailsGenerator.ActionTypeParams.README_MSG_KEY, "GridSetup-Oh-Message");
            } else if (targetHome.equals("sidb") || targetHome.equals("rac")) {
                argList.put(CommandDetailsGenerator.ActionTypeParams.README_TITLE_KEY, "RunInstaller-Oh-Title");
                argList.put(CommandDetailsGenerator.ActionTypeParams.README_MSG_KEY, "RunInstaller-Oh-Message");
            }
        } else {
            argList.put(CommandDetailsGenerator.ActionTypeParams.README_TITLE_KEY, "Clone-Oh-Title");
            argList.put(CommandDetailsGenerator.ActionTypeParams.README_MSG_KEY, "Clone-Oh-Message");
        }
        argList.put(CommandDetailsGenerator.ActionTypeParams.STRIPE_TARGETHOME, targetHome);
        String stripeName = DBPatchingHelper.getStripeName(patchTarget);
        argList.put(CommandDetailsGenerator.ActionTypeParams.STRIPE_NAME, stripeName);
        ArrayList<String> params = new ArrayList<String>();
        this.updateClonePLParams(targetHome, argList, params, patchTarget);
        if (!DBPatchingUtil.isVersionEqalOrlater(patchTarget.getHome().getVersion(), "20.0.0.0.0")) {
            clonePlCommand = PERL_PATH;
        }
        HashMap commandDetails = new HashMap();
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.addAll(params);
        commandDetails.put(clonePlCommand, paramList);
        argList.put(CommandDetailsGenerator.ActionTypeParams.COMMAND_DETAILS, commandDetails);
        ActionType actionType = CommandDetailsGenerator.generateActionType(CommandDetailsGenerator.ActionTypes.COMMAND_ACTION, argList);
        PatchingPhase phase = this.getpatchingPhase();
        Command clonePLCommand = PatchPlanner.getInstance().getCommandFactory().getCommand(actionType, Strategy.MANUAL, phase);
        List<ExecutionStep> steps = this.getsteps(this.configGraph, patchTarget, actionType, clonePLCommand);
        return steps;
    }

    private void updateClonePLParams(String targetHome, HashMap<CommandDetailsGenerator.ActionTypeParams, Object> argList, List<String> params, PatchTarget patchTarget) {
        boolean isSharedHome = patchTarget.getHome().isSharedHome();
        if (DBPatchingUtil.isVersionEqalOrlater(patchTarget.getHome().getVersion(), "20.0.0.0.0")) {
            if (targetHome.equals("siha") || targetHome.equals("crs")) {
                params.add(GRID_SETUP);
                params.add(INSTALL_CRS_SWONLY);
                params.add("oracle.install.asm.OSDBA=" + this.getGroupName(patchTarget, "OSDBA"));
                params.add("oracle.install.asm.OSOPER=" + this.getGroupName(patchTarget, "OSOPER"));
                params.add("oracle.install.asm.OSASM=" + this.getGroupName(patchTarget, "OSASM"));
            } else if (targetHome.equals("sidb") || targetHome.equals("rac")) {
                params.add(RUN_INSTALLER);
                params.add(INSTALL_DB_SWONLY);
                params.add("oracle.install.db.OSDBA_GROUP=" + this.getGroupName(patchTarget, "OSDBA"));
                params.add("oracle.install.db.OSBACKUPDBA_GROUP=" + this.getGroupName(patchTarget, "OSBACKUPDBA"));
                params.add("oracle.install.db.OSDGDBA_GROUP=" + this.getGroupName(patchTarget, "OSDGDBA"));
                params.add("oracle.install.db.OSKMDBA_GROUP=" + this.getGroupName(patchTarget, "OSKMDBA"));
                params.add("oracle.install.db.OSRACDBA_GROUP=" + this.getGroupName(patchTarget, "OSRACDBA"));
                params.add("oracle.install.db.OSOPER_GROUP=" + this.getGroupName(patchTarget, "OSOPER"));
            }
        } else {
            params.add(CLONE_PL_COMMAND);
        }
        params.add("ORACLE_BASE=%OracleHome.oracleBaseLocation%");
        params.add("ORACLE_HOME=%OracleHome.path%");
        if (targetHome.equals("siha") || targetHome.equals("crs")) {
            params.add("INVENTORY_LOCATION=%OracleHome.centralInvPtr%");
            params.add(DEFAULT_HOME_NAME);
            if (targetHome.equals("crs")) {
                if (DBPatchingUtil.isVersionEqalOrlater(patchTarget.getHome().getVersion(), "19.0.0.0.0")) {
                    params.add(CLUSTER_NODES_PARA_DB19);
                } else {
                    params.add(CLUSTER_NODES_PARAM);
                }
                params.add(LOCAL_NODE_PARAM);
            }
            params.add(CRS_FALSE);
            params.add(ROOT_SH_CONFIRMATION);
            if (DBPatchingUtil.isAIXPlatform()) {
                params.add(SKIP_ROOT_PRE);
            }
            params.add(SILENT_MODE);
        } else if (targetHome.equals("sidb") || targetHome.equals("rac")) {
            params.add(DEFAULT_HOME_NAME);
            if (DBPatchingUtil.isAIXPlatform()) {
                params.add(SKIP_ROOT_PRE);
            }
            params.add(SILENT_MODE);
        }
    }

    private String getGroupName(PatchTarget patchTarget, String group) {
        String groupName = "";
        byte[] pass = this.getPassword(patchTarget);
        String srcHome = patchTarget.getHome().getLocation();
        if (!srcHome.endsWith(File.separator)) {
            srcHome = srcHome + File.separator;
        }
        String cmd = srcHome + "bin/osdbagrp ";
        switch (group) {
            case "OSDBA": {
                cmd = cmd + "-d";
                break;
            }
            case "OSOPER": {
                cmd = cmd + "-o";
                break;
            }
            case "OSBACKUPDBA": {
                cmd = cmd + "-b";
                break;
            }
            case "OSDGDBA": {
                cmd = cmd + "-g";
                break;
            }
            case "OSKMDBA": {
                cmd = cmd + "-k";
                break;
            }
            case "OSRACDBA": {
                cmd = cmd + "-r";
                break;
            }
            case "OSASM": {
                cmd = cmd + "-a";
                break;
            }
        }
        this._logger.info("Retrieving group name through command " + cmd);
        GISystemCall.ExecReturn ret = GISystemCall.process(cmd, null, pass);
        this._logger.info("Status : " + ret.getReturnCode());
        if (ret.getReturnCode() != 0) {
            this._logger.info("Error message: " + ret.getErrorMessage());
            groupName = "";
        } else {
            groupName = ret.getNormalMessage();
            this._logger.info("Group name: " + groupName);
        }
        return groupName;
    }

    private PatchingPhase getpatchingPhase() {
        PatchingPhase phase = CommandDetailsGenerator.generatePatchingPhase(PhaseType.APPLY, ServiceStatus.UP);
        return phase;
    }

    @Override
    public String getStatusMessage(PatchTarget patchTarget, PatchActionStatus status) {
        String statusMsg = null;
        switch (status) {
            case incomplete: {
                statusMsg = this.getLocalizedString("CloneOracleHomeAction.start.message", patchTarget.toReportingString());
                break;
            }
            case success: {
                statusMsg = this.getLocalizedString("CloneOracleHomeAction.success.message", patchTarget.toReportingString());
                break;
            }
            case failure: {
                statusMsg = this.getLocalizedString("CloneOracleHomeAction.failure.message", patchTarget.toReportingString());
                break;
            }
            default: {
                statusMsg = super.getStatusMessage(patchTarget, status);
            }
        }
        return statusMsg;
    }
}

