/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.controller;

import com.oracle.glcm.patch.auto.credential.Credential;
import com.oracle.glcm.patch.auto.db.product.executor.GISystemCall;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CommandExecutionThread
extends Thread {
    protected final Logger _logger = Logger.getLogger(this.getClass().getName());
    public GISystemCall.ExecReturn er;
    Credential cred = null;
    public String normalMsg = "";
    public String errorMsg = "";
    public String command = "";
    public boolean successfull = true;
    public String host = "";
    public String owner = "";

    CommandExecutionThread(String command, String owner, String host) {
        this.command = command;
        this.owner = owner;
        this.host = host;
    }

    @Override
    public void run() {
        this._logger.log(Level.INFO, "Starting command execution...\n" + this.command + "\n");
        this.er = GISystemCall.process(this.command, this.owner, this.cred);
        this._logger.log(Level.INFO, "status: " + this.er.getReturnCode());
        if (!this.er.isOK()) {
            this.successfull = false;
            this.normalMsg = this.er.getNormalMessage();
            this.errorMsg = this.er.getErrorMessage();
            this._logger.info("Failed in executing the command:\n" + this.command + "\n");
            this._logger.log(Level.INFO, "\nCOMMAND EXECUTION FAILURE :\n" + this.normalMsg + "\nERROR:\n" + this.errorMsg);
            return;
        }
        this._logger.info("Successfully executed the command:\n" + this.command + "\n");
        this._logger.log(Level.INFO, "Output from the command:" + this.command + "\n");
        this._logger.log(Level.INFO, this.er.getNormalMessage());
    }
}

