/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.framework.sdk.exec.api;

import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandContext;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionPlan;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.User;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanInternalException;
import dbmodel.common.AbstractBaseTarget;
import dbmodel.common.Host;
import dbmodel.common.OracleHome;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import oracle.opatch.system.db.automation.jaxb.ActionType;
import oracle.opatch.system.db.automation.jaxb.Readme;
import oracle.opatch.system.db.automation.jaxb.SqlCommand;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="execution-step", namespace="http://oracle.com/schema/opatch/ExecutionPlan", propOrder={"command", "readme", "host", "user"})
public class ExecutionStep
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected List<Command> command;
    @XmlElement(required=true)
    @XmlTransient
    private CommandContext stepProperties;
    @XmlTransient
    transient Logger logger = Logger.getLogger(ExecutionStep.class.getName());
    @XmlElement
    Host host;
    @XmlElement
    User user;
    @XmlTransient
    private ExecutionPlan executionPlan;
    @XmlTransient
    private ActionType action;
    @XmlTransient
    private boolean credentialsRequired;
    private String status;

    public boolean isCredentialRequired() {
        return this.credentialsRequired;
    }

    public void setCredentialRequired(boolean crednetialsRequired) {
        this.credentialsRequired = crednetialsRequired;
    }

    public ExecutionStep(ActionType automationAction) {
        this.action = automationAction;
    }

    public ExecutionStep() {
    }

    public ActionType getAutomationAction() {
        return this.action;
    }

    public List<Command> getCommand() {
        if (this.command == null) {
            this.command = new ArrayList<Command>();
        }
        return this.command;
    }

    public Readme getReadme() {
        return this.action.getReadme();
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public CommandContext getStepProperties() {
        return this.stepProperties;
    }

    public void setStepProperties(CommandContext stepProperties) {
        this.stepProperties = stepProperties;
    }

    public Host getHost() {
        return this.host;
    }

    public void setHost(Host host) {
        this.host = host;
    }

    public void setExecutionPlan(ExecutionPlan executionPlan) {
        this.executionPlan = executionPlan;
    }

    public ExecutionPlan getExecutionPlan() {
        return this.executionPlan;
    }

    public OracleHome getRunsOnOracleHome() {
        try {
            for (OracleHome oh : this.stepProperties.getTargets(OracleHome.class)) {
                for (Host host : oh.getHosts()) {
                    if (!host.equals(this.getHost())) continue;
                    return oh;
                }
            }
        }
        catch (PatchPlanInternalException e) {
            this.logger.info("Oracle Home object type not found in the context. Returning null.: " + e);
        }
        return null;
    }

    public AbstractBaseTarget getActsOnTarget() {
        return this.stepProperties.getPrimaryTarget();
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="")
    public static class Command
    implements Serializable {
        private static final long serialVersionUID = 1L;
        @XmlValue
        private String value;
        @XmlAttribute(name="type")
        protected CommandType type = CommandType.SHELL;
        @XmlTransient
        protected SqlCommand.ErrorHandling.FatalError errorMessage;

        public Command() {
        }

        public Command(String value) {
            this.value = value;
        }

        public Command(String value, CommandType type) {
            this.value = value;
            this.type = type;
        }

        public CommandType getType() {
            return this.type;
        }

        public void setType(CommandType value) {
            this.type = value;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public SqlCommand.ErrorHandling.FatalError getErrorMessage() {
            return this.errorMessage;
        }

        public void setErrorMessage(SqlCommand.ErrorHandling.FatalError message) {
            this.errorMessage = message;
        }

        @XmlEnum
        public static final class CommandType
        extends Enum<CommandType> {
            public static final /* enum */ CommandType SHELL = new CommandType("");
            public static final /* enum */ CommandType SQL = new CommandType("SQLPLUS");
            public static final /* enum */ CommandType DGMGRL = new CommandType("DGMGRL");
            public static final /* enum */ CommandType DOS = new CommandType("dos");
            private String prompt;
            private static final /* synthetic */ CommandType[] $VALUES;

            public static CommandType[] values() {
                return (CommandType[])$VALUES.clone();
            }

            public static CommandType valueOf(String name) {
                return Enum.valueOf(CommandType.class, name);
            }

            private CommandType(String prompt) {
                this.prompt = prompt;
            }

            public String getPrompt(ExecutionStep step) {
                assert (step != null);
                String shellPrompt = "root".equals(step.getUser().getValue()) ? "#" : "$";
                switch (this) {
                    case SHELL: {
                        return shellPrompt;
                    }
                    case SQL: {
                        return this.prompt + ">";
                    }
                    case DGMGRL: {
                        return this.prompt + ">";
                    }
                    case DOS: {
                        return "C:\\Users\\" + step.getUser().getValue() + ">";
                    }
                }
                return shellPrompt;
            }

            public boolean isNonShellPrompt() {
                return !SHELL.equals((Object)this);
            }

            static {
                $VALUES = new CommandType[]{SHELL, SQL, DGMGRL, DOS};
            }
        }
    }
}

