/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.framework.sdk.engine;

import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandContext;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanInternalException;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import dbmodel.common.AbstractBaseTarget;
import dbmodel.common.Host;
import dbmodel.common.OracleHome;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

public class ContextPopulator {
    static Logger logger = Logger.getLogger(ContextPopulator.class.getName());

    public void fixCloneContext(CommandContext context) {
        List<OracleHome> origs = context.getTargets(OracleHome.class);
        ArrayList<OracleHome> clones = new ArrayList<OracleHome>();
        for (OracleHome orig : origs) {
            List<OracleHome> clonehomes = PatchPlanner.getInstance().getMakeCloneHome().getHomeClone(orig);
            for (OracleHome clone : clonehomes) {
                clones.add(clone);
            }
        }
        if (context.getPrimaryTarget() instanceof OracleHome) {
            context.setPrimaryTarget((AbstractBaseTarget)PatchPlanner.getInstance().getMakeCloneHome().getHomeClone((OracleHome)context.getPrimaryTarget()).get(0));
        }
        context.putTargets(clones);
    }

    protected OracleHome getRunsFromHome(ConfigGraph g, AbstractBaseTarget v) {
        Iterator<OracleHome> iterator = g.getConnectedTargets(v, OracleHome.class).iterator();
        if (iterator.hasNext()) {
            OracleHome oh = iterator.next();
            return oh;
        }
        logger.info("Could not find connected oracle home target for target " + v.getDisplayName());
        return null;
    }

    protected Host getHost(ConfigGraph g, AbstractBaseTarget v) {
        if (v instanceof Host) {
            return (Host)v;
        }
        Iterator<Host> iterator = g.getConnectedTargets(v, Host.class).iterator();
        if (iterator.hasNext()) {
            Host host = iterator.next();
            return host;
        }
        throw new PatchPlanInternalException("Couldn't find host for " + v);
    }

    protected CommandContext populateContextForOH(ConfigGraph g, OracleHome oh, Host host) {
        ArrayList<Host> hosts = new ArrayList<Host>(oh.getHosts());
        Collections.sort(hosts, g.getComparator());
        CommandContext context = new CommandContext();
        context.setPrimaryTarget((AbstractBaseTarget)oh);
        if (hosts.size() > 1) {
            Host hostToAdd = g.getLocalHost();
            for (Host tempHost : hosts) {
                if (host == null || !host.getName().equals(tempHost.getName())) continue;
                hostToAdd = host;
                break;
            }
            hosts.clear();
            hosts.add(hostToAdd);
        }
        context.putTargets(hosts);
        return context;
    }

    protected CommandContext getGenericContext(ConfigGraph g, AbstractBaseTarget t) {
        CommandContext context = new CommandContext();
        if (this.getRunsFromHome(g, t) != null) {
            context.putTarget((AbstractBaseTarget)this.getRunsFromHome(g, t));
        }
        context.putTarget((AbstractBaseTarget)this.getHost(g, t));
        context.setPrimaryTarget(t);
        return context;
    }

    public CommandContext populateContext(ConfigGraph g, AbstractBaseTarget target, Host host) {
        if (target instanceof OracleHome) {
            return this.populateContextForOH(g, (OracleHome)target, host);
        }
        return this.getGenericContext(g, target);
    }
}

