/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.commands;

import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandActionType;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandBuilder;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandContext;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.commands.SimpleShellCommand;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import dbmodel.common.OracleHome;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.opatch.system.db.automation.jaxb.ActionType;
import oracle.opatch.system.db.automation.jaxb.CommandAction;
import oracle.opatch.system.db.automation.jaxb.Strategy;

public class CopyHome
extends SimpleShellCommand {
    Logger logger = Logger.getLogger(CopyHome.class.getName());

    public CopyHome(ActionType automationAction) {
        super(automationAction);
    }

    @Override
    public List<String> getShellCommands(CommandContext context) {
        ArrayList<String> cmds = new ArrayList<String>();
        OracleHome oh = context.getFirstTarget(OracleHome.class);
        List<OracleHome> clones = PatchPlanner.getInstance().getMakeCloneHome().getHomeClone(oh);
        for (OracleHome clone : clones) {
            String clonePath = clone.getPath();
            while (clonePath.lastIndexOf("/") == clonePath.length() - 1) {
                clonePath = clonePath.substring(0, clonePath.length() - 1);
            }
            cmds.add("mkdir -p " + clonePath.substring(0, clonePath.lastIndexOf("/")));
            cmds.add("cp -pR " + oh.getPath() + " " + clone.getPath());
        }
        return cmds;
    }

    public static class Builder
    implements CommandBuilder<CopyHome> {
        @Override
        public CopyHome getCommand(ActionType a, Strategy s) {
            Logger logger = Logger.getLogger(CopyHome.class.getName());
            logger.log(Level.FINEST, "In construct");
            if (!(a instanceof CommandAction) || !a.getType().equals(CommandActionType.CopyHome.toString())) {
                return null;
            }
            CopyHome ch = new CopyHome(a);
            return ch;
        }
    }
}

