/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator;

import com.oracle.glcm.patch.auto.db.framework.sdk.ExecutionMode;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.Command;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandBuilder;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandUtils;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.commands.ConfigCompare;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.commands.CopyHome;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.commands.CopyPatch;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.commands.GenericDosCommand;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.commands.GenericShellCommand;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.commands.ManualActionCommandBuilder;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.commands.SimpleDCLICommand;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanInternalException;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.SystemModelUtils;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.commands.CopyDBHome;
import dbmodel.common.AbstractBaseTarget;
import dbmodel.common.OracleHome;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.opatch.system.db.automation.jaxb.ActionType;
import oracle.opatch.system.db.automation.jaxb.PatchingPhase;
import oracle.opatch.system.db.automation.jaxb.Strategy;

public class CommandFactory {
    private Logger logger = Logger.getLogger(CommandFactory.class.getName());
    protected List<CommandBuilder> constructables = new ArrayList<CommandBuilder>();

    public CommandFactory() {
        this.constructables.add(new ConfigCompare.Builder());
        this.constructables.add(new CopyPatch.Builder());
        this.constructables.add(new SimpleDCLICommand.Builder(new CopyHome.Builder()));
        this.constructables.add(new SimpleDCLICommand.Builder(new ManualActionCommandBuilder()));
        this.constructables.add(new SimpleDCLICommand.Builder(new GenericShellCommand.Builder()));
        this.constructables.add(new GenericDosCommand.Builder());
        this.constructables.add(new CopyDBHome.Builder());
    }

    public Command getCommand(ActionType action, Strategy s, PatchingPhase automationPhase) {
        this.logger.log(Level.FINEST, "Choosing command for " + action.getClass().getName());
        for (CommandBuilder ac : this.constructables) {
            Object constructed = ac.getCommand(action, s);
            if (constructed == null) continue;
            ((Command)constructed).setPatchingPhase(automationPhase);
            return constructed;
        }
        throw new PatchPlanInternalException("Unsupported Action Type:" + action.getClass().getName() + " subtype:" + action.getType());
    }

    public boolean includeTargetByVersion(ConfigGraph g, AbstractBaseTarget abt, ExecutionMode exeMode) {
        return true;
    }

    protected boolean decideBasedOnWhilePatchingTargetAttribute(Command command, ConfigGraph g, AbstractBaseTarget abt) {
        Class<? extends AbstractBaseTarget> type = SystemModelUtils.getClassForType(command.getAutomationAction().getWhilePatching());
        if (abt instanceof OracleHome) {
            OracleHome oh = (OracleHome)abt;
            this.logger.log(Level.FINER, "SkipTargetCookie is set on OracleHome target :" + abt + " and while-patching condition(" + command.getAutomationAction().getWhilePatching() + ") is set for step: " + command.getAutomationAction() + " . Going to check all the targets running from OracleHome: " + oh.getInstalledSWComponents());
            for (AbstractBaseTarget dep : oh.getInstalledSWComponents()) {
                if (!CommandUtils.shouldIncludeTargetCosDependantsNotSkipped(command, g, abt, g.getConnectedTargets(dep, type))) continue;
                return true;
            }
            this.logger.log(Level.FINER, "All the targets running from this OracleHome is being skipped as well. Hence do not generate execution step for this target. ");
            return false;
        }
        return CommandUtils.shouldIncludeTargetCosDependantsNotSkipped(command, g, abt, g.getConnectedTargets(abt, type));
    }
}

