/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.framework.core.patch;

import com.oracle.glcm.patch.auto.db.framework.core.patch.CompositePatchValidatorAndGenerator;
import com.oracle.glcm.patch.auto.db.framework.core.patch.DefaultPatchValidatorAndGenerator;
import com.oracle.glcm.patch.auto.db.framework.core.patch.ExapatchPatchValidatorAndGenerator;
import com.oracle.glcm.patch.auto.db.framework.core.patch.OPatchBundlePatchValidatorAndGenerator;
import com.oracle.glcm.patch.auto.db.framework.core.patch.OPatchSingletonPatchValidatorAndGenerator;
import dbmodel.patchmodel.PatchingTool;
import java.util.ArrayList;
import java.util.List;
import oracle.dbsysmodel.patchsdk.PatchPackageException;
import oracle.dbsysmodel.patchsdk.PatchValidatorAndGenerator;

public class SupportedPatchTools {
    private static List<PatchingTool> oplanRecognizedPatchingTools = new ArrayList<PatchingTool>();
    private static List<PatchValidatorAndGenerator> supportedPatchValidatorsAndGenerators = new ArrayList<PatchValidatorAndGenerator>();
    private static List<PatchValidatorAndGenerator> supportedBundlePatchGenericPatchValidatorsAndGenerators = new ArrayList<PatchValidatorAndGenerator>();

    public static List<PatchValidatorAndGenerator> getSupportedPatchValidatorsAndGenerators() {
        return supportedPatchValidatorsAndGenerators;
    }

    public static List<PatchValidatorAndGenerator> getSupportedBundlePatchGenericPatchValidatorAndGenerators() {
        return supportedBundlePatchGenericPatchValidatorsAndGenerators;
    }

    public static List<PatchingTool> getOplanRecognizedPatchingTools() throws PatchPackageException {
        if (oplanRecognizedPatchingTools.isEmpty()) {
            for (PatchValidatorAndGenerator vg : SupportedPatchTools.getSupportedPatchValidatorsAndGenerators()) {
                try {
                    PatchingTool pt = (PatchingTool)PatchingTool.valueOf(PatchingTool.class, (String)vg.getPatchTool());
                    oplanRecognizedPatchingTools.add(pt);
                }
                catch (IllegalArgumentException e) {
                    throw new PatchPackageException("The PatchValidatorAndGenerator doesn't have a recognized patch tool", (Throwable)e);
                }
            }
        }
        return oplanRecognizedPatchingTools;
    }

    static {
        supportedBundlePatchGenericPatchValidatorsAndGenerators.add(new OPatchSingletonPatchValidatorAndGenerator());
        supportedBundlePatchGenericPatchValidatorsAndGenerators.add(new CompositePatchValidatorAndGenerator());
        supportedBundlePatchGenericPatchValidatorsAndGenerators.add(new ExapatchPatchValidatorAndGenerator());
        supportedBundlePatchGenericPatchValidatorsAndGenerators.add(new DefaultPatchValidatorAndGenerator());
        supportedPatchValidatorsAndGenerators.add(new OPatchBundlePatchValidatorAndGenerator());
        for (PatchValidatorAndGenerator psvg : supportedBundlePatchGenericPatchValidatorsAndGenerators) {
            supportedPatchValidatorsAndGenerators.add(psvg);
        }
    }
}

