/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.framework.core.patch;

import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.db.framework.core.oplan.IOUtils;
import com.oracle.glcm.patch.auto.db.framework.core.patch.PatchInventory;
import com.oracle.glcm.patch.auto.db.framework.core.patch.PatchMetadaReader;
import com.oracle.glcm.patch.auto.db.framework.core.patch.PatchUtils;
import com.oracle.glcm.patch.auto.db.framework.sdk.intg.PatchPlanIntgFactory;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import dbmodel.patchmodel.OPatchSingleton;
import dbmodel.patchmodel.PatchPackage;
import dbmodel.patchmodel.PatchingTool;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.dbsysmodel.patchsdk.PatchPackageException;
import oracle.dbsysmodel.patchsdk.PatchValidatorAndGenerator;
import oracle.opatch.opatchsdk.SQLPatchStartupMode;
import oracle.opatchauto.core.binary.OPatchPatchInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class OPatchSingletonPatchValidatorAndGenerator
implements PatchValidatorAndGenerator {
    static Logger logger = Logger.getLogger(OPatchSingletonPatchValidatorAndGenerator.class.getName());
    private final String INV_XML = "etc" + File.separator + "config" + File.separator + "inventory.xml";
    private final String PATCHMD_XML = "patchmd.xml";
    private final String AUTOMATIONXML_FOLDER = "automation";
    private final String RESOURCE_BUNDLE = "messages.properties";
    public static final String INV_XML_NAME = "inventory.xml";

    public boolean isPatchValid(String patchLocation) throws PatchPackageException {
        assert (patchLocation != null);
        File patchDir = new File(patchLocation);
        if (!patchDir.exists()) {
            throw new PatchPackageException("Patch Location " + patchLocation + " does not exist.");
        }
        if (!patchDir.isDirectory()) {
            throw new PatchPackageException("Patch Location " + patchLocation + " does not represent a directory");
        }
        StringBuffer inventoryXMLLoc = new StringBuffer(patchLocation);
        inventoryXMLLoc.append(File.separator);
        inventoryXMLLoc.append(this.INV_XML);
        File invxml = new File(inventoryXMLLoc.toString());
        if (invxml.exists()) {
            logger.log(Level.INFO, "inventory.xml found at " + inventoryXMLLoc.toString() + " which implies it is an OPatch Singleton patch");
            return true;
        }
        return false;
    }

    public List<PatchPackage> generate(List<String> patchLocationList) throws PatchPackageException {
        ArrayList<PatchPackage> patchPackageList = new ArrayList<PatchPackage>();
        for (String loc : patchLocationList) {
            File patchDir = new File(loc);
            if (!patchDir.exists()) {
                throw new PatchPackageException("The given patchLocation " + loc + " does not exist");
            }
            if (patchDir.isDirectory()) continue;
            throw new PatchPackageException("The given patchLocation " + loc + " does not represent a directory");
        }
        List<OPatchPatchInfo> opatchPatchList = null;
        try {
            PatchMetadaReader patchMetadataReader = new PatchMetadaReader();
            opatchPatchList = patchMetadataReader.getPatchInformation(patchLocationList);
            if (opatchPatchList == null || opatchPatchList.isEmpty()) {
                throw new PatchPackageException("Failed to retrieve patch information for " + patchLocationList);
            }
        }
        catch (OPatchAutoException e) {
            throw new PatchPackageException(e.getMessage(), (Throwable)e);
        }
        for (OPatchPatchInfo patchInfo : opatchPatchList) {
            OPatchSingleton patch = this.createPatchPackage(patchInfo);
            patchPackageList.add((PatchPackage)patch);
        }
        return patchPackageList;
    }

    public PatchPackage generate(String patchLocation) throws PatchPackageException {
        assert (patchLocation != null);
        File patchDir = new File(patchLocation);
        if (!patchDir.exists()) {
            throw new PatchPackageException("The given patchLocation " + patchLocation + " does not exist");
        }
        if (!patchDir.isDirectory()) {
            throw new PatchPackageException("The given patchLocation " + patchLocation + " does not represent a directory");
        }
        ArrayList<String> patchList = new ArrayList<String>();
        patchList.add(patchLocation);
        List<OPatchPatchInfo> opatchPatchList = null;
        try {
            PatchMetadaReader patchMetadataReader = new PatchMetadaReader();
            opatchPatchList = patchMetadataReader.getPatchInformation(patchList);
            if (opatchPatchList == null || opatchPatchList.isEmpty()) {
                throw new PatchPackageException("Failed to retrieve patch information for " + patchLocation);
            }
        }
        catch (OPatchAutoException e) {
            throw new PatchPackageException(e.getMessage(), (Throwable)e);
        }
        OPatchSingleton patch = this.createPatchPackage(opatchPatchList.get(0));
        return patch;
    }

    private OPatchSingleton createPatchPackage(OPatchPatchInfo opatchPatch) throws PatchPackageException {
        File automationXmlFolderLocation;
        OPatchSingleton patch = new OPatchSingleton();
        String patchLocation = opatchPatch.getPatchLocation();
        File patchDir = new File(patchLocation);
        patch.setPatchLocation(patchLocation);
        patch.setPatchTool(this.getPatchTool());
        patch.setPatchID(opatchPatch.getPatchID());
        if (opatchPatch.getMinOPatchVersion() != null) {
            patch.setMinimumOPatchVersion(opatchPatch.getMinOPatchVersion());
        }
        patch.setRollingPatch(Boolean.valueOf(opatchPatch.isRollingPatch()));
        patch.setInstanceShutdownPatch(Boolean.valueOf(opatchPatch.isInstanceShutDownPatch()));
        patch.setUPI(opatchPatch.getUniquePatchID());
        patch.setSqlPatch(Boolean.valueOf(opatchPatch.isSQLPatch()));
        if (opatchPatch.isSQLPatch()) {
            String mode = opatchPatch.getSqlPatchDatabaseStartupMode();
            if (mode.equals(SQLPatchStartupMode.UPGRADE.toString())) {
                patch.setSqlPatchUpgradeMode(Boolean.valueOf(true));
            } else {
                patch.setSqlPatchUpgradeMode(Boolean.valueOf(false));
            }
        } else {
            patch.setSqlPatchUpgradeMode(Boolean.valueOf(false));
        }
        patch.setSupportedPlatforms(opatchPatch.getSupportedPlatForms());
        File patchmdxml = new File(patchDir, "patchmd.xml");
        if (patchmdxml.isFile()) {
            try {
                patch.setPatchMDxml(IOUtils.getContent(new FileInputStream(patchmdxml)).toString());
            }
            catch (IOException e) {
                throw new PatchPackageException("Exception while reading patchmd.xml", (Throwable)e);
            }
        }
        if ((automationXmlFolderLocation = new File(patchDir, "automation")).exists()) {
            if (!automationXmlFolderLocation.isDirectory()) {
                throw new PatchPackageException(automationXmlFolderLocation.getAbsolutePath() + " exists but is not a folder");
            }
            if (automationXmlFolderLocation.listFiles() == null || automationXmlFolderLocation.listFiles().length == 0) {
                throw new PatchPackageException(automationXmlFolderLocation.getAbsolutePath() + " exists but does not contain any automationXmls.");
            }
            ArrayList<String> automationXmls = new ArrayList<String>();
            patch.setAutomationXmlLocation(automationXmlFolderLocation.getAbsolutePath());
            for (File file : automationXmlFolderLocation.listFiles()) {
                if (!file.isFile()) continue;
                try {
                    if ("messages.properties".equals(file.getName())) {
                        patch.setResourceBundle(IOUtils.getContent(new FileInputStream(file)).toString());
                        continue;
                    }
                    automationXmls.add(IOUtils.getContent(new FileInputStream(file)).toString());
                }
                catch (IOException e) {
                    throw new PatchPackageException("Couldn't read the file from automation folder", (Throwable)e);
                }
            }
            patch.setAutoXmls(automationXmls);
        } else {
            patch.setAutomationXmlLocation(null);
        }
        ArrayList<String> applicableTargets = new ArrayList<String>();
        applicableTargets.addAll(this.getTargetListFromInventory(patchLocation));
        patch.setApplicableTargets(applicableTargets);
        return patch;
    }

    public OPatchSingleton generate(String patchLocation, List<String> applicableTargets) throws PatchPackageException {
        OPatchSingleton patch = (OPatchSingleton)this.generate(patchLocation);
        patch.setApplicableTargets(PatchPlanner.getInstance().getOPlanIntgFactory().getApplicabilityTarget().makeOPlanRecognizedApplicableTargetsList(applicableTargets));
        return patch;
    }

    public OPatchSingleton generate(String patchID, String patchLocation, List<String> applicableTargets) throws PatchPackageException {
        OPatchSingleton patch = new OPatchSingleton();
        patch.setPatchLocation(patchLocation);
        patch.setPatchID(patchID);
        patch.setApplicableTargets(PatchPlanner.getInstance().getOPlanIntgFactory().getApplicabilityTarget().makeOPlanRecognizedApplicableTargetsList(applicableTargets));
        patch.setPatchTool(this.getPatchTool());
        return patch;
    }

    public static OPatchSingleton addApplicabilityTargets(OPatchSingleton patch, List<String> applicableTargets) throws PatchPackageException {
        patch.setApplicableTargets(PatchPlanner.getInstance().getOPlanIntgFactory().getApplicabilityTarget().makeOPlanRecognizedApplicableTargetsList(applicableTargets));
        return patch;
    }

    public String getPatchTool() {
        return PatchingTool.OPATCH.toString();
    }

    public boolean isPatchValid(Map map) {
        HashMap invMap = (HashMap)map.get("INVENTORY_XMLS");
        HashMap actionMap = (HashMap)map.get("ACTION_XMLS");
        int invNum = invMap.size();
        int actionNum = actionMap.size();
        if (invNum == 1 && actionNum == 1) {
            String invPath = (String)invMap.keySet().toArray()[0];
            String actionPath = (String)actionMap.keySet().toArray()[0];
            Pattern invPartern = Pattern.compile("\\d+/etc/config/inventory\\.xml");
            Pattern actionPartern = Pattern.compile("\\d+/etc/config/actions\\.xml");
            Matcher invMatcher = invPartern.matcher(invPath);
            Matcher actionMatcher = actionPartern.matcher(actionPath);
            if (!invMatcher.matches()) {
                return false;
            }
            return actionMatcher.matches();
        }
        return false;
    }

    public PatchPackage generate(Map map) throws PatchPackageException {
        OPatchSingleton patch = new OPatchSingleton();
        patch.setPatchTool(this.getPatchTool());
        PatchInventory[] PatchInventoryList = PatchUtils.getPatchInventoryFromZipMap(map);
        PatchUtils.setSingletonPatchInfoByPatchInventory(patch, PatchInventoryList[0]);
        patch.setPatchLocation((String)map.get("TOP_DIR_NAME"));
        this.setApplicableTargetForSingletonPatch(patch);
        patch.setAutoXmls(PatchUtils.getAutoXmlsFromZipStreamMap(map));
        patch.setResourceBundle(PatchUtils.getMessagePropertyFromZipStreamMap(map));
        patch.setPatchMDxml(PatchUtils.getPatchmdFromZipMap(map));
        return patch;
    }

    private void setApplicableTargetForSingletonPatch(OPatchSingleton patch) throws PatchPackageException {
        ArrayList<String> applicableTarget = new ArrayList<String>(1);
        PatchPlanIntgFactory oplanIntgFactory = PatchPlanner.getInstance().getOPlanIntgFactory();
        applicableTarget.add(oplanIntgFactory.getApplicabilityTarget().getDefaultApplicableTarget());
        patch.setApplicableTargets(oplanIntgFactory.getApplicabilityTarget().makeOPlanRecognizedApplicableTargetsList(applicableTarget));
    }

    private List<String> getTargetListFromInventory(String patchLocation) {
        ArrayList<String> targetList = new ArrayList<String>();
        StringBuffer inventoryXMLLoc = new StringBuffer(patchLocation);
        inventoryXMLLoc.append(File.separator);
        inventoryXMLLoc.append(this.INV_XML);
        File invxml = new File(inventoryXMLLoc.toString());
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(invxml);
            doc.getDocumentElement().normalize();
            NodeList targetNodeList = doc.getElementsByTagName("target");
            if (targetNodeList != null && targetNodeList.getLength() > 0) {
                for (int j = 0; j < targetNodeList.getLength(); ++j) {
                    Element el = (Element)targetNodeList.item(j);
                    if (!el.hasAttribute("type")) continue;
                    targetList.add(el.getAttribute("type"));
                }
            }
        }
        catch (ParserConfigurationException e) {
            logger.warning("ParserConfigurationException::" + e.getMessage());
        }
        catch (SAXException e) {
            logger.warning("SAXException::" + e.getMessage());
        }
        catch (IOException e) {
            logger.warning("IOException::" + e.getMessage());
        }
        return targetList;
    }
}

