/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.framework.core.patch;

import com.oracle.glcm.patch.auto.db.framework.core.oplan.IOUtils;
import com.oracle.glcm.patch.auto.db.framework.core.patch.OPatchSingletonPatchValidatorAndGenerator;
import com.oracle.glcm.patch.auto.db.framework.core.patch.PatchInventory;
import com.oracle.glcm.patch.auto.db.framework.core.patch.PatchUtils;
import com.oracle.glcm.patch.auto.db.framework.core.patch.SupportedPatchTools;
import com.oracle.glcm.patch.auto.db.framework.sdk.patch.PatchBundlexml;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import dbmodel.patchmodel.CompositePatch;
import dbmodel.patchmodel.GenericPatch;
import dbmodel.patchmodel.OPatchSingleton;
import dbmodel.patchmodel.PatchBundle;
import dbmodel.patchmodel.PatchPackage;
import dbmodel.patchmodel.PatchingTool;
import dbmodel.util.BundleValidationException;
import dbmodel.util.BundleXmlException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbsysmodel.patchsdk.PatchPackageException;
import oracle.dbsysmodel.patchsdk.PatchValidatorAndGenerator;

public class OPatchBundlePatchValidatorAndGenerator
implements PatchValidatorAndGenerator {
    static Logger logger = Logger.getLogger(OPatchBundlePatchValidatorAndGenerator.class.getName());
    public static final String BUNDLE_XML = "bundle.xml";
    public static final String AUTOMATION_XML = "automation";
    public static final String RESOURCE_BUNDLE = "messages.properties";

    public boolean isPatchValid(String patchLocation) throws PatchPackageException {
        assert (patchLocation != null);
        File patchDir = new File(patchLocation);
        if (!patchDir.exists()) {
            throw new PatchPackageException("Patch Location " + patchLocation + " does not exist.");
        }
        if (!patchDir.isDirectory()) {
            throw new PatchPackageException("The patch specified by the given location " + patchLocation + " is not a directory");
        }
        StringBuffer bundleXMLLoc = new StringBuffer(patchLocation);
        bundleXMLLoc.append(File.separator);
        bundleXMLLoc.append(BUNDLE_XML);
        File bxml = new File(bundleXMLLoc.toString());
        if (!bxml.exists()) {
            logger.log(Level.INFO, "Bundle.xml does not exist");
            return false;
        }
        if (!bxml.isFile()) {
            throw new PatchPackageException("Bundle.xml exists at location " + bxml.getAbsolutePath() + " but is not a file");
        }
        try {
            PatchBundlexml pbxml = new PatchBundlexml(IOUtils.getContent(new FileInputStream(bxml)).toString());
        }
        catch (IOException e) {
            throw new PatchPackageException("Exception while reading the input stream.");
        }
        catch (BundleXmlException e) {
            throw new PatchPackageException("Exception occured while trying to read the bundle.xml", (Throwable)e);
        }
        catch (BundleValidationException e) {
            logger.log(Level.INFO, "Exception while making the PatchBundlexml object. This might implythat the bundle.xml is of the new format corresponding to the EngineeredSystemPatch");
            return false;
        }
        return true;
    }

    public PatchPackage generate(String patchLocation) throws PatchPackageException {
        String bundlexmlContent;
        assert (patchLocation != null);
        File patchDir = new File(patchLocation);
        if (!patchDir.exists()) {
            throw new PatchPackageException("The given patchLocation " + patchLocation + " does not exist");
        }
        if (!patchDir.isDirectory()) {
            throw new PatchPackageException("The patchLocation " + patchLocation + " specified is not a directory");
        }
        StringBuffer bundleXMLLoc = new StringBuffer(patchLocation);
        bundleXMLLoc.append(File.separator);
        bundleXMLLoc.append(BUNDLE_XML);
        File bundlexml = new File(bundleXMLLoc.toString());
        if (!bundlexml.exists() || !bundlexml.isFile()) {
            throw new PatchPackageException("Location " + patchDir.getAbsolutePath() + "does not contain 'bundle.xml' file.");
        }
        PatchBundle patch = new PatchBundle();
        patch.setPatchLocation(patchLocation);
        patch.setPatchTool(this.getPatchTool());
        patch.setBundleXmlLoc(bundlexml.getAbsolutePath());
        try {
            bundlexmlContent = IOUtils.getContent(new FileInputStream(bundlexml)).toString();
            PatchBundlexml pbxml = new PatchBundlexml(bundlexmlContent);
        }
        catch (IOException e) {
            throw new PatchPackageException("Exception while reading bundle.xml", (Throwable)e);
        }
        catch (BundleXmlException e) {
            throw new PatchPackageException("Exception occured while trying to create bundleXml object");
        }
        catch (BundleValidationException e) {
            throw new PatchPackageException("The bundle.xml in the patch does not correspond to a Bundle Patch. Hence,PatchBundle object cannot be created.");
        }
        patch.setBundleXml(bundlexmlContent);
        File automationXmlFolderLocation = new File(patchDir, AUTOMATION_XML);
        if (automationXmlFolderLocation.exists()) {
            if (!automationXmlFolderLocation.isDirectory()) {
                throw new PatchPackageException(automationXmlFolderLocation.getAbsolutePath() + " exists but is not a folder");
            }
            if (automationXmlFolderLocation.listFiles() == null || automationXmlFolderLocation.listFiles().length == 0) {
                throw new PatchPackageException(automationXmlFolderLocation.getAbsolutePath() + " exists but does not contain any automationXmls.");
            }
            patch.setAutomationXmlLocation(automationXmlFolderLocation.getAbsolutePath());
            ArrayList<String> automationXmls = new ArrayList<String>();
            for (File file : automationXmlFolderLocation.listFiles()) {
                if (!file.isFile()) continue;
                try {
                    if (RESOURCE_BUNDLE.equals(file.getName())) {
                        patch.setResourceBundle(IOUtils.getContent(new FileInputStream(file)).toString());
                        continue;
                    }
                    automationXmls.add(IOUtils.getContent(new FileInputStream(file)).toString());
                }
                catch (IOException e) {
                    throw new PatchPackageException("Couldn't read the file from automation folder", (Throwable)e);
                }
            }
            patch.setAutoXmls(automationXmls);
        } else {
            patch.setAutomationXmlLocation(null);
        }
        patch.setSubPatches(this.instantiatePatches(patchDir, patch.getBundleXml()));
        boolean areAllSubPatchesRolling = true;
        for (GenericPatch subPatch : patch.getSubPatches()) {
            if (subPatch.getRollingPatch() != null && subPatch.getRollingPatch().booleanValue()) continue;
            areAllSubPatchesRolling = false;
        }
        patch.setRollingPatch(new Boolean(areAllSubPatchesRolling));
        patch.setPatchID(this.getPatchID(patch));
        return patch;
    }

    private List<GenericPatch> instantiatePatches(File patchDir, String bundleXmlContent) throws PatchPackageException {
        PatchBundlexml pbxml;
        try {
            pbxml = new PatchBundlexml(bundleXmlContent);
        }
        catch (IOException e) {
            throw new PatchPackageException("Exception while reading bundle.xml", (Throwable)e);
        }
        catch (BundleXmlException e) {
            throw new PatchPackageException("Exception while trying to create the object", (Throwable)e);
        }
        catch (BundleValidationException e) {
            throw new PatchPackageException("Couldn't validate the bundle.xml", (Throwable)e);
        }
        ArrayList<GenericPatch> subPatches = new ArrayList<GenericPatch>();
        for (String patchloc : pbxml.getPatchesOrder()) {
            File subPatchDir = new File(patchDir, patchloc);
            if (!subPatchDir.isDirectory()) {
                throw new PatchPackageException("Sub-patch path " + subPatchDir + " specified in bundle.xml does not exists.");
            }
            logger.info("Found sub-patch " + subPatchDir + " applicable to home types " + pbxml.getPatchToTargetList().get(patchloc) + " in the bundle.");
            PatchPackage subPatch = null;
            for (PatchValidatorAndGenerator pvg : SupportedPatchTools.getSupportedBundlePatchGenericPatchValidatorAndGenerators()) {
                if (!pvg.isPatchValid(subPatchDir.getAbsolutePath())) continue;
                subPatch = pvg.generate(subPatchDir.getAbsolutePath());
                if (subPatch instanceof GenericPatch) break;
                throw new PatchPackageException("The subpatch is not a valid bundle patch subpatch type.");
            }
            if (subPatch == null) {
                throw new PatchPackageException("Couldn't generate the patch object because the patch is not supported andcould not be validated/generated by any of the PatchValidatorAndGenerator for a bundle patch.");
            }
            GenericPatch subpatch = (GenericPatch)subPatch;
            subpatch.setApplicableTargets(pbxml.getPatchToTargetList().get(patchloc));
            subPatches.add(subpatch);
        }
        return subPatches;
    }

    public PatchPackage generate(String bundleXmlContent, String patchLocationWhilePatching, List<String> automationXmls) throws PatchPackageException {
        PatchBundle patch = new PatchBundle();
        patch.setPatchLocation(patchLocationWhilePatching);
        patch.setPatchTool(this.getPatchTool());
        patch.setBundleXml(bundleXmlContent);
        patch.setAutoXmls(automationXmls);
        patch.setSubPatches(this.instantiatePatches(patch.getPatchLocation(), patch.getBundleXml()));
        patch.setPatchID(this.getPatchID(patch));
        return patch;
    }

    private List<GenericPatch> instantiatePatches(String patchLocationWhilePatching, String bundleXmlContent) throws PatchPackageException {
        PatchBundlexml pbxml;
        String FileSeparator = PatchPlanner.getInstance().getOPlanEnv().isTargetOnWindows() ? "\\" : "/";
        ArrayList<GenericPatch> subPatches = new ArrayList<GenericPatch>();
        try {
            pbxml = new PatchBundlexml(bundleXmlContent);
        }
        catch (BundleValidationException e) {
            throw new PatchPackageException("The given bundleXmlContent does not represent a valid ", (Throwable)e);
        }
        catch (IOException e) {
            throw new PatchPackageException("Exception while reading the bundle.xml", (Throwable)e);
        }
        catch (BundleXmlException e) {
            throw new PatchPackageException("Exception occured while trying to get BundleXml object", (Throwable)e);
        }
        for (String patchloc : pbxml.getPatchesOrder()) {
            String subPatchDir = null;
            subPatchDir = patchLocationWhilePatching != null ? patchLocationWhilePatching + FileSeparator + patchloc : patchloc;
            logger.info("Found sub-patch " + subPatchDir + " applicable to home types " + pbxml.getPatchToTargetList().get(patchloc) + " in the bundle.");
            String patchID = new File(patchloc).getName();
            OPatchSingletonPatchValidatorAndGenerator osvg = new OPatchSingletonPatchValidatorAndGenerator();
            subPatches.add((GenericPatch)osvg.generate(patchID, subPatchDir, pbxml.getPatchToTargetList().get(patchloc)));
        }
        return subPatches;
    }

    private List<GenericPatch> instantiatePatches(String patchLocationWhilePatching, String bundleXmlContent, Map map) throws PatchPackageException {
        PatchBundlexml pbxml;
        PatchInventory[] inventoryList = PatchUtils.getPatchInventoryFromZipMap(map);
        String FileSeparator = PatchPlanner.getInstance().getOPlanEnv().isTargetOnWindows() ? "\\" : "/";
        ArrayList<GenericPatch> subPatches = new ArrayList<GenericPatch>();
        try {
            pbxml = new PatchBundlexml(bundleXmlContent);
        }
        catch (BundleValidationException e) {
            throw new PatchPackageException("The given bundleXmlContent does not represent a valid ", (Throwable)e);
        }
        catch (IOException e) {
            throw new PatchPackageException("Exception while reading the bundle.xml", (Throwable)e);
        }
        catch (BundleXmlException e) {
            throw new PatchPackageException("Exception occured while trying to get BundleXml object", (Throwable)e);
        }
        block4: for (String patchLoc : pbxml.getPatchesOrder()) {
            if (PatchUtils.isCompositeSubPatch(patchLoc, map)) {
                CompositePatch compositePatch = PatchUtils.getCompositePatch(map, patchLoc);
                String subPatchDir = null;
                subPatchDir = patchLocationWhilePatching != null ? patchLocationWhilePatching + FileSeparator + patchLoc : patchLoc;
                compositePatch.setPatchLocation(subPatchDir);
                List<String> applicationTargets = pbxml.getPatchToTargetList().get(patchLoc);
                compositePatch.setPatchMDxml(PatchUtils.getPatchmdFromZipMap(subPatchDir, map));
                compositePatch.setApplicableTargets(PatchPlanner.getInstance().getOPlanIntgFactory().getApplicabilityTarget().makeOPlanRecognizedApplicableTargetsList(applicationTargets));
                subPatches.add((GenericPatch)compositePatch);
                continue;
            }
            String subPatchDir = null;
            subPatchDir = patchLocationWhilePatching != null ? patchLocationWhilePatching + FileSeparator + patchLoc : patchLoc;
            logger.info("Found sub-patch " + subPatchDir + " applicable to home types " + pbxml.getPatchToTargetList().get(patchLoc) + " in the bundle.");
            for (int i = 0; i < inventoryList.length; ++i) {
                PatchInventory inventory = inventoryList[i];
                if (!patchLoc.contains(inventory.getPatchID())) continue;
                OPatchSingleton subPatch = new OPatchSingleton();
                PatchUtils.setSingletonPatchInfoByPatchInventory(subPatch, inventory);
                subPatch.setPatchLocation(patchLoc);
                subPatch.setPatchMDxml(PatchUtils.getPatchmdFromZipMap(subPatchDir, map));
                List<String> applicationTargets = pbxml.getPatchToTargetList().get(patchLoc);
                subPatch.setApplicableTargets(PatchPlanner.getInstance().getOPlanIntgFactory().getApplicabilityTarget().makeOPlanRecognizedApplicableTargetsList(applicationTargets));
                subPatches.add((GenericPatch)subPatch);
                continue block4;
            }
        }
        return subPatches;
    }

    public String getPatchID(PatchBundle bundle) {
        if (bundle.getSubPatches().size() > 0) {
            return ((GenericPatch)bundle.getSubPatches().get(0)).getPatchID();
        }
        return null;
    }

    public String getPatchTool() {
        return PatchingTool.OPATCH.toString();
    }

    public boolean isPatchValid(Map map) throws PatchPackageException {
        assert (!map.isEmpty());
        String[] bundleXml = PatchUtils.getBundleXmlFromZipStreamMap(map);
        if (bundleXml == null || bundleXml.length != 2) {
            logger.log(Level.FINE, "Bundle.xml was not found in the given patch zip file");
            return false;
        }
        PatchBundlexml pbxml = null;
        try {
            pbxml = new PatchBundlexml(bundleXml[1]);
        }
        catch (IOException e) {
            throw new PatchPackageException("Exception while reading the input stream.");
        }
        catch (BundleXmlException e) {
            throw new PatchPackageException("Exception occured while trying to read the bundle.xml", (Throwable)e);
        }
        catch (BundleValidationException e) {
            logger.log(Level.INFO, "Exception while making the OPatchGIBundleXML object. This might implythat the bundle.xml is of the new format corresponding to the EngineeredSystemPatch");
            return false;
        }
        if ((pbxml.getPatchesOrder() == null || pbxml.getPatchesOrder().isEmpty()) && (pbxml.getPatchToTargetList() == null || pbxml.getPatchToTargetList().isEmpty())) {
            logger.log(Level.FINE, "Couldn't get the list of patches and order of patches from the bundle.xml");
            return false;
        }
        return true;
    }

    public PatchPackage generate(Map map) throws PatchPackageException {
        assert (!map.isEmpty());
        String[] bundleXml = PatchUtils.getBundleXmlFromZipStreamMap(map);
        if (bundleXml == null || bundleXml.length != 2) {
            logger.log(Level.FINE, "Bundle.xml was not found in the given patch zip file");
            throw new PatchPackageException("Bundle.xml was not found in the given patch zip file");
        }
        PatchBundle patch = new PatchBundle();
        String bundleLoc = bundleXml[0];
        if (!bundleLoc.equals(BUNDLE_XML)) {
            patch.setPatchLocation((String)map.get("TOP_DIR_NAME"));
        }
        patch.setBundleXmlLoc(bundleXml[0]);
        patch.setBundleXml(bundleXml[1]);
        patch.setAutoXmls(PatchUtils.getAutoXmlsFromZipStreamMap(map));
        patch.setResourceBundle(PatchUtils.getMessagePropertyFromZipStreamMap(map));
        patch.setPatchTool(this.getPatchTool());
        patch.setSubPatches(this.instantiatePatches(patch.getPatchLocation(), patch.getBundleXml(), map));
        if (!bundleLoc.equals(BUNDLE_XML)) {
            patch.setPatchID((String)map.get("TOP_DIR_NAME"));
        } else {
            patch.setPatchID(this.getPatchID(patch));
        }
        return patch;
    }
}

