Rem
Rem $Header: rdbms/admin/c18.sql apfwkr_blr_backport_33795989_19.22.0.0.240116dbru/1 2023/12/14 03:04:26 apfwkr Exp $
Rem
Rem c18.sql
Rem
Rem Copyright (c) 2009, 2023, Oracle and/or its affiliates.
Rem All rights reserved.
Rem
Rem    NAME
Rem      c18.sql - Current upgrade actions for basic dictionary objects
Rem
Rem    DESCRIPTION
Rem      Use this script for any dictionary changes that need to
Rem      be run before catalog.sql and catproc.sql are run.
Rem
Rem      If a change affects basic DDL/DML operations, then put the
Rem      upgrade action into the "i" script.
Rem
Rem      If a change requires the use of PL/SQL packages or views,
Rem      put the upgrade action into the "a" script, since catalog.sql and
Rem      catproc.sql will be run before that script is invoked.
Rem
Rem      DO NOT use VIEWS or PACKAGES in this script.
Rem
Rem    NOTES
Rem      * The upgrade is performed in the following stages:
Rem        STAGE 1: upgrade from 18 to the current release
Rem        STAGE 2: invoke script for subsequent release
Rem
Rem BEGIN SQL_FILE_METADATA
Rem SQL_SOURCE_FILE: rdbms/admin/c18.sql
Rem SQL_SHIPPED_FILE: rdbms/admin/c18.sql
Rem SQL_PHASE: UPGRADE
Rem SQL_STARTUP_MODE: UPGRADE
Rem SQL_IGNORABLE_ERRORS: NONE
Rem SQL_CALLING_FILE: rdbms/admin/catupstr.sql
Rem END SQL_FILE_METADATA
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    apfwkr      12/14/23 - BLR# 36106387 of
Rem    apfwkr      12/14/23 - apfwkr_blr_backport_33795989_19.21.0.0.231017dbru
Rem    apfwkr      12/14/23 - from st_rdbms_19.21.0.0.0dbru.
Rem    apfwkr      12/14/23 - BLR# 36106387
Rem                           apfwkr_blr_backport_33795989_19.22.0.0.240116dbru
Rem    apfwkr      10/01/23 - BLR# 35859917 of
Rem    apfwkr      10/01/23 - apfwkr_blr_backport_33795989_19.20.0.0.230718dbru
Rem    apfwkr      10/01/23 - from st_rdbms_19.20.0.0.0dbru.
Rem    apfwkr      10/01/23 - BLR# 35859917
Rem                           apfwkr_blr_backport_33795989_19.21.0.0.231017dbru
Rem    sanagara    07/11/23 - Backport of bug 35271571
Rem    apfwkr      07/03/23 - BLR# 35558705 of
Rem    apfwkr      07/03/23 - apfwkr_blr_backport_33795989_19.19.0.0.230418dbru
Rem    apfwkr      07/03/23 - from st_rdbms_19.19.0.0.0dbru.
Rem    apfwkr      07/03/23 - BLR# 35558705
Rem                           apfwkr_blr_backport_33795989_19.20.0.0.230718dbru
Rem    apfwkr      03/31/23 - BLR# 35236227 of
Rem    apfwkr      03/31/23 - apfwkr_blr_backport_33795989_19.18.0.0.230117dbru
Rem    apfwkr      03/31/23 - from st_rdbms_19.18.0.0.0dbru.
Rem    apfwkr      03/31/23 - BLR# 35236227
Rem    apfwkr      03/31/23 - apfwkr_blr_backport_33795989_19.19.0.0.230418dbru
Rem    sanagara    12/18/22 - CI# 34900058 of sanagara_bug-33523831 from
Rem    sanagara    12/18/22 - st_rdbms_19.
Rem    sanagara    12/18/22 - CI# 34900058
Rem    sanagara    12/18/22 - sanagara_ci_backport_33523831_19.0.0.0.0dbru
Rem    sanagara    11/15/22 - Proj# 91371: obj# reuse
Rem    apfwkr      12/01/22 - CI# 34852983 of
Rem    apfwkr      12/01/22 - pgahukar_blr_backport_34575784_19.16.0.0.220719dbru
Rem    apfwkr      12/01/22 - from st_rdbms_19.16.0.0.0dbru.
Rem    apfwkr      12/01/22 - CI# 34852983
Rem    apfwkr      12/01/22 - apfwkr_ci_backport_34575784_19.0.0.0.0dbru
Rem    pgahukar    09/28/22 - Backport pgahukar_bug-34575784 from main
Rem    apfwkr      12/27/22 - BLR# 34932558 of
Rem    apfwkr      12/27/22 - apfwkr_blr_backport_33795989_19.17.0.0.221018dbru
Rem    apfwkr      12/27/22 - from st_rdbms_19.17.0.0.0dbru.
Rem    apfwkr      12/27/22 - BLR# 34932558
Rem    apfwkr      12/27/22 - apfwkr_blr_backport_33795989_19.18.0.0.230117dbru
Rem    apfwkr      09/28/22 - BLR# 34649149 of
Rem    apfwkr      09/28/22 - apfwkr_blr_backport_33795989_19.16.0.0.220719dbru
Rem    apfwkr      09/28/22 - from st_rdbms_19.16.0.0.0dbru.
Rem    apfwkr      09/28/22 - BLR# 34649149
Rem    apfwkr      09/28/22 - apfwkr_blr_backport_33795989_19.17.0.0.221018dbru
Rem    apfwkr      07/21/22 - BLR# 34409935 of
Rem    apfwkr      07/21/22 - apfwkr_blr_backport_33795989_19.14.0.0.220118dbru
Rem    apfwkr      07/21/22 - from st_rdbms_19.14.0.0.0dbru.
Rem    apfwkr      07/21/22 - BLR# 34409935
Rem    apfwkr      07/21/22 - apfwkr_blr_backport_33795989_19.16.0.0.220719dbru
Rem    apfwkr      03/10/22 - Backport
Rem                           apfwkr_blr_backport_31562484_19.10.0.0.210119dbru
Rem                           from st_rdbms_19.10.0.0.0dbru
Rem    apfwkr      12/16/21 - Backport
Rem                           apfwkr_blr_backport_32012400_19.7.0.0.200414dbru
Rem                           from st_rdbms_19.7.0.0.0dbru
Rem    apfwkr      12/11/21 - Backport shnandan_bug-33651003 from
Rem                           st_rdbms_19.14.0.0.0dbru
Rem    apfwkr      06/23/22 - Backport shnandan_bug-33795989 from
Rem                           st_rdbms_19.14.0.0.0dbru
Rem    shnandan    12/09/21 - Backout Bug 32610271.
Rem    ankuljai    10/07/21 - bug-29356306 : Add logmnrc_user cache to better
Rem                           support LOGMNR$USER_GG_TABF_PUBLIC table function
Rem    cmlim       10/01/21 - backout apfwkr_ci_backport_30387640_19.0.0.0.0dbru
Rem    ramekuma    09/13/21 - Backport
Rem                           apfwkr_ci_backport_33027539_19.11.2.0.211019dbrur
Rem                           from st_rdbms_19.11.0.0.0dbrur
Rem    aquinto     08/04/21 - CI 32338029: Adding Planned Failover begin
Rem                           request rule
Rem    sinsiash    07/29/21 - Backport of 32811069
Rem    apfwkr      07/27/21 - Backport
Rem                           apfwkr_blr_backport_32610271_19.8.0.0.200714dbru
Rem                           from st_rdbms_19.8.0.0.0dbru
Rem    apfwkr      06/14/21 - Backport
Rem                           cmlim_blr_backport_30387640_19.10.0.0.210119dbru
Rem                           from st_rdbms_19.10.0.0.0dbru
Rem    archgoya    04/22/21 - Blr#32438777 Proj#84235 Gradual Password Rollover
Rem    sdball      01/26/21 - XbranchMerge sdball_labfix20 from
Rem                           st_rdbms_19.10.0.0.0dbru
Rem    cmlim       05/22/21 - Backport cmlim_bug-30387640 from main
Rem    ramekuma    01/06/21 - Backport bug-31942136 from main
Rem    apfwkr      12/18/20 - Backport shismath_bug-30249738 from main
Rem    pacornej    12/08/20 - Bug 32240850: Backport proj-83087
Rem    cmlim       05/22/21 - Backport cmlim_bug-30387640 from main
Rem    apfwkr      09/27/21 - Backport
Rem                           apfwkr_blr_backport_31562484_19.12.0.0.210720dbru
Rem                           from st_rdbms_19.12.0.0.0dbru
Rem    apfwkr      08/24/21 - Backport subkanch_bug-31562484 from main
Rem    smangala    10/05/20 - Backport proj-77243: per-pdb capture support
Rem    sshastry    08/21/20 - Backport sshastry_bug-31145804 from st_rdbms_19
Rem    jdozal      06/05/20 - Bug #31312388: add 2 columns to
Rem                           wri$_adv_sqlt_plan_stats.
Rem    apfwkr      07/03/20 - Backport
Rem                           apfwkr_blr_backport_30973698_19.5.0.0.191015dbru
Rem                           from st_rdbms_19.5.0.0.0dbru
Rem    apfwkr      04/22/20 - Backport
Rem                           apfwkr_blr_backport_30973698_19.7.0.0.200414dbru
Rem                           from st_rdbms_19.7.0.0.0dbru
Rem    shnandan    06/03/21 - Backport shnandan_bug-32610271 from main.
Rem    apfwkr      04/15/20 - Backport subkanch_bug-30973698 from main
Rem    shnandan    06/03/21 - Backport shnandan_bug-32610271 from main.
Rem    apfwkr      11/09/20 - Backport prakumar_bug-32012400 from main
Rem    mthiyaga    07/23/19 - Backport apfwkr_blr_backport_29549071_19.0.0.0.0
Rem    aelbaum     12/18/18 - Backport aelbaum_bug-28487688 from main
Rem    apfwkr      12/17/18 - Backport bsprunt_bug-28951397 from main
Rem    yuyzhang    12/17/18 - #(29018307): add SPM evolve task parameters
Rem    pgahukar    09/21/22 - Bug 34575784: truncate sys.aq$_message_types
Rem    subkanch    05/12/21 - Bug 31562484: Update SYSACTN byte vectors of
Rem                           existing audit policies
Rem    subkanch    04/06/20 - Bug 30973698 : Reset KQDOBUAT flag in obj$.flags 
Rem                           for AUDSYS.AUD$UNIFIED table
Rem    shismath    11/26/19 - bug_30249738:Resolving ORA-01749 after OFS DBFS
Rem                           conversion tests.
Rem    prakumar    10/27/20 - Bug 32012400: Add RETAIN_UNIQUE_INDEX access
Rem                           advisor parameter
Rem    bsprunt     12/10/18 - Bug 28951397: max running sessions per AWR
Rem                           snapshot
Rem    schakkap    12/07/18 - Bug 29023878: sql_id_vc for wri$_adv_objects
Rem    aelbaum     11/27/18 - Bug 28487688: add sess_cnt_history$
Rem    schakkap    11/18/18 - Bug 28785774: property to wri$_sqlset_definitions
Rem    amelidis    11/02/18 - 28134320: minimize OUTLN privileges
Rem    quotran     10/24/18 - Schema change in atsk$_schedule_control
Rem    apfwkr      10/23/18 - Backport wbattist_bug-28741851 from main
Rem    wbattist    10/16/18 - bug 28741851: remove code PL/SQL added in bug
Rem                           28527106 - default for 19.2 and above is INSTANCE
Rem    svechala    10/01/18 - bug28521977: backout txn svechala_bug25985914
Rem    sajaureg    09/10/18 - Bug 28619571: avoid ORA-01440
Rem    schakkap    09/06/18 - Rti 21446231: remove changes to
Rem                           wri$_adv_sqlaccess_adv
Rem    hvieyra     09/06/18 - Bug 28606076 - DROP VIEW X_$KGLOB AND SYNONYM X$KGLOB
Rem    shvmalik    09/03/18 - #28557503: drop dbms_optim related ojects
Rem    sumkumar    08/31/18 - XbranchMerge sumkumar_bug-28538268 from main
Rem    svechala    08/29/18 - XbranchMerge svechala_lrg-21541715 from main
Rem    cunnitha    08/29/18 - XbranchMerge cunnitha_bug-28551362 from main
Rem    cunnitha    08/27/18 - #28551362: add column reset_state to service$
Rem    wxli        08/27/18 - XbranchMerge wxli_bug-564110 from main
Rem    sumkumar    08/30/18 - Bug 28538268: set KZDPF_ORCL bit
Rem    wxli        08/27/18 - bug 564110: revoke pstubtbl to public
Rem    wxli        08/27/18 - bug 564110: revoke pstubtbl from public
Rem    svechala    08/20/18 - RTI 21541715: drop view _INT$_ALL_SYNONYMS_FOR_AO
Rem    wbattist    08/20/18 - bug 28527106: change INSTANCE to NODE in
Rem                           HANG_MANAGER_PARAMETERS
Rem    kmorfoni    08/17/18 - Bug 25382878: fix im_seg_stat membytes
Rem    sumkumar    08/08/18 - Bug 28469827: Revoke SET CONTAINER from PDB_DBA
Rem    welin       08/01/18 - Bug 28433703: drop public synonym xmlconcat
Rem    osuro       07/30/18 - bug 28322347: extend wrm$_wr_control.src_dbname
Rem    alestrel    07/29/18 - Scheduler fortify changes for 19c part 2.
Rem                           Increase size of global attribute values.
Rem    svechala    07/27/18 - Bug 25985914 : drop views during upgrade
Rem    ralekra     07/26/18 - Bug 28141150: revoke unused ggsys privileges
Rem    rdecker     07/09/18 - 28146626: Add Existing table%rowtypes to type$
Rem    schakkap    07/05/18 - proj 74122: Auto index support
Rem    sumkumar    07/11/18 - Bug 27445727: Revoke grant on CDBView_Internal
Rem    sdball      07/05/18 - Bug 28249859: revoke dbms_sys_sql from
Rem                           gsmadmin_internal
Rem    shbose      07/03/18 - bug 27045057: revoke privileges given by
Rem                           blessUser
Rem    wbattist    06/14/18 - add placement_policy column to service$
Rem    dcolello    06/29/18 - bug 28141063: restrict gsmuser privs
Rem    zhanl       06/22/18 - bug 28042089: add 2 cols to wri$_adv_sqlt_plans
Rem    wbattist    06/14/18 - add placement_policy column to service$
Rem    yingzhen    06/09/18 - Bump swrf_version for 19.1
Rem    sramakri    05/14/18 - bug-27915028: drop package dbms_sumref_util
Rem    makataok    06/06/18 - Bug 26850063: drop public synonyms in
Rem                           prvtstattyp.sql
Rem    jjye        05/04/18 - Bug 27929485 add KQLDTVCP_MVL for mlog$_ tabs
Rem    rayalag     05/01/18 - bug 24495099: lazy deletion
Rem    sajaureg    04/20/18 - Bug 26632926: fine-grained precision for latency
Rem    prshanth    04/20/18 - Bug 27864190: add exuserlist to lockdown_prof$
Rem    amorimur    04/27/18 - Bug 20282756: Modify WRH$_DYN_REMASTER_STATS
Rem    ushaft      04/19/18 - Bug 27877704: add 3 cols to wri$_adv_actions
Rem    rankalik    03/21/18 - Bug 26663687: Add service qualifier support
Rem    sramakri    04/16/18 - bug-27864388: add lastrfreshdate_xp in sum$
Rem    shbose      04/09/18 - bug 27045346:upgrade action for dictionary change
Rem                           in bug 27045090
Rem    youngtak    04/03/18 - Bug 27502161: add DIFMOD to X$KCCDI
Rem    dmelinge    03/09/18 - Bug 22456380: Auditing XDB protocols
Rem    msusaira    02/19/18 - add snapshotfile
Rem    zzeng       02/14/18 - Bug 27476067: add table_family_id to service$
Rem    rthatte     02/14/18 - Bug 27071161: Tag oracle defined audit policies
Rem    teagarwa    02/07/18 - Project 74550: Support snapshot PDBs/gold copies
Rem                           in object store
Rem    lenovak     01/31/18 - upgrade for GSMADMIN_INTERNAL schema
Rem    qinwu       01/31/18 - add database replay upgrade script
Rem    shbose      12/18/17 - bug 27045090: revoke privileges from dbfs_role
Rem    alestrel    01/24/18 - Bug 27303287. Remove indexes of long columns not
Rem                           supported by 2k dbs
Rem    tchorma     01/18/18 - Proj 74459 - new DBMS_LOGMNR objects
Rem    jcarey      01/13/18 - Bug 25687751- AW lockdown
Rem    dcolello    01/10/18 - project 74418: multiple PDB shards allowed in CDB
Rem    zzeng       01/09/18 - Project 74510:shard catalog table upgrades
Rem    thbaby      01/07/18 - Bug 27317860: add i_sensitive_fixed$
Rem    jorgrive    01/03/18 - dessupport Streams
Rem    sgdelgad    12/18/17 - Project 74398: Add columns to heat_map_stat$
Rem                           for DML stats
Rem    ushaft      12/14/17 - add two columns to wri$_adv_addm_tasks
Rem    jingzhen    11/30/17 - add pseudo controlfile meta columns
Rem    welin       11/08/17 - Created
Rem

Rem *************************************************************************
Rem BEGIN c18.sql
Rem *************************************************************************


Rem =========================================================================
Rem BEGIN STAGE 1: upgrade from 18 to the current release
Rem =========================================================================

Rem *************************************************************************
Rem BEGIN BUG 564110
Rem *************************************************************************

revoke select,delete on sys.pstubtbl from public
/

Rem *************************************************************************
Rem END BUG 564110
Rem *************************************************************************
  
Rem =======================================================================
Rem Begin Changes for bug 29356306
Rem =======================================================================
  
-- Recreate, adding spare1, which is added for 20.  Match shape in dlmnr.bsq
DROP TABLE sys.logmnrg_user$ PURGE;
CREATE TABLE sys.logmnrg_user$ (
      user# NUMBER(22),
      spare1 NUMBER,
      name VARCHAR2(128) NOT NULL ) 
   SEGMENT CREATION IMMEDIATE
   TABLESPACE system LOGGING
/

ALTER TABLE system.logmnr_user$ ADD (spare1 NUMBER)
/

-- system.logmnrc_user$, added for v 20.0, happens in catlmnr.sql

Rem =======================================================================
Rem End Changes for bug 29356306
Rem =======================================================================

Rem *************************************************************************
Rem BEGIN Changes for Bug 31942136
Rem *************************************************************************

DECLARE
  ddlstr  varchar2(32767);

  CURSOR  pkey_cons_csr IS
   select u.name user_name, o.name tbl_name, cd.enabled
   from cdef$ cd, ccol$ cc, col$ cl, obj$ o, user$ u
   where cl.obj# = cd.obj#
     and cc.intcol# = cl.intcol#
     and cd.con# = cc.con#
     and cd.type# = 2
     and bitand(cl.property, 1073741824) = 1073741824
     and cd.obj# = o.obj#
     and o.owner# = u.user#
     and not exists (select * from recyclebin$ rb where rb.obj# = cd.obj#)
     order by 1, 2;
   
BEGIN

  FOR pkey_rec in pkey_cons_csr
  LOOP
    IF pkey_rec.enabled is NULL
    THEN
      ddlstr := 'ALTER TABLE ' || 
                DBMS_ASSERT.ENQUOTE_NAME(pkey_rec.user_name, false) || '.' || 
                DBMS_ASSERT.ENQUOTE_NAME(pkey_rec.tbl_name, false) || 
                ' DISABLE PRIMARY KEY';
    ELSE
      ddlstr := 'ALTER TABLE ' || 
                dbms_assert.enquote_name(pkey_rec.user_name, false) || '.' || 
                dbms_assert.enquote_name(pkey_rec.tbl_name, false) || 
                ' ENABLE PRIMARY KEY';
    END IF;

    EXECUTE IMMEDIATE ddlstr;
  END LOOP;
EXCEPTION
  WHEN OTHERS THEN
   NULL;
END;
/

Rem *************************************************************************
Rem END Changes for Bug 31942136
Rem *************************************************************************

Rem *************************************************************************
Rem BEGIN BUG 27099034 and 27358482 changes
Rem *************************************************************************
alter table SYS.RPP$X$KCCPDB add (PDBPCSS                 NUMBER,
                                 PDBCRI_INC_SCN          NUMBER,
                                 PDBCRI_INC_TIM          NUMBER,
                                 PDBCRI_BR_SCN           NUMBER,
                                 PDBCRI_BR_TIM           NUMBER,
                                 PDBCRI_ER_SCN           NUMBER,
                                 PDBCRI_ER_TIM           NUMBER,
                                 PDBRLC                  NUMBER,
                                 PDBRLS                  NUMBER,
                                 PDBKOD_ENA              NUMBER,
                                 PDBKOD_KEY              RAW(48),
                                 PDBKOD_MKEYID           RAW(16),
                                 PDBKOD_MKLOC            NUMBER,
                                 PDBKOD_FLAG             NUMBER,
                                 PDBINT                  NUMBER,
                                 PDB_TDE_CONF            NUMBER);

alter table SYS.ROPP$X$KCCPDB add (PDBPCSS                 NUMBER,
                                 PDBCRI_INC_SCN          NUMBER,
                                 PDBCRI_INC_TIM          NUMBER,
                                 PDBCRI_BR_SCN           NUMBER,
                                 PDBCRI_BR_TIM           NUMBER,
                                 PDBCRI_ER_SCN           NUMBER,
                                 PDBCRI_ER_TIM           NUMBER,
                                 PDBRLC                  NUMBER,
                                 PDBRLS                  NUMBER,
                                 PDBKOD_ENA              NUMBER,
                                 PDBKOD_KEY              RAW(48),
                                 PDBKOD_MKEYID           RAW(16),
                                 PDBKOD_MKLOC            NUMBER,
                                 PDBKOD_FLAG             NUMBER,
                                 PDBINT                  NUMBER,
                                 PDB_TDE_CONF            NUMBER);

alter table SYS.RPP$X$KCCDI2 add (DI2DPC_HEAD                   NUMBER
                                 ,DI2DPC_TAIL                   NUMBER
                                 ,DI2_FB_BLOCK_CNT_HIGH          NUMBER
                                 ,DI2_FB_BLOCK_CNT_LOW           NUMBER
                                 ,DI2_HIGHEST_SEEN_SCN           NUMBER
                                 ,DI2_HALF                       NUMBER
                                 ,DI2_MINSCNINC                  NUMBER
                                 ,DI2_SBYNRTS                    NUMBER
                                 ,DI2_FBWCUR                     NUMBER
                                 ,DI2_FBWPST                     NUMBER
                                 ,DI2_NOCT                       NUMBER
                                 ,DI2_FBL_SWITCH_CNT             NUMBER
                                 ,DI2_LAST_ETB_CHG_SCN           NUMBER
                                 ,DI2_SSBY_APRATE                NUMBER
                                 ,DI2_SBYORTS                    NUMBER
                                 ,DI2_SSBY_RECTIME               NUMBER
                                 ,DI2_FBCS                       NUMBER
                                 ,DI2_SCANFINSCN                 NUMBER
                                 ,DI2_FBPS                       NUMBER);

alter table SYS.ROPP$X$KCCDI2 add (DI2DPC_HEAD                   NUMBER
                                  ,DI2DPC_TAIL                   NUMBER
                                  ,DI2_FB_BLOCK_CNT_HIGH         NUMBER
                                  ,DI2_FB_BLOCK_CNT_LOW          NUMBER
                                  ,DI2_HIGHEST_SEEN_SCN          NUMBER
                                  ,DI2_HALF                      NUMBER
                                  ,DI2_MINSCNINC                 NUMBER
                                  ,DI2_SBYNRTS                   NUMBER
                                  ,DI2_FBWCUR                    NUMBER
                                  ,DI2_FBWPST                    NUMBER
                                  ,DI2_NOCT                      NUMBER
                                  ,DI2_FBL_SWITCH_CNT            NUMBER
                                  ,DI2_LAST_ETB_CHG_SCN          NUMBER
                                  ,DI2_SSBY_APRATE               NUMBER
                                  ,DI2_SBYORTS                   NUMBER
                                  ,DI2_SSBY_RECTIME              NUMBER
                                  ,DI2_FBCS                      NUMBER
                                  ,DI2_SCANFINSCN                NUMBER
                                  ,DI2_FBPS                      NUMBER);
alter table SYS.RPP$X$KCCIC add (ICSTM NUMBER);
alter table SYS.ROPP$X$KCCIC add (ICSTM NUMBER);

alter table SYS.RPP$X$KCCFE add (FERFNO NUMBER);
alter table SYS.ROPP$X$KCCFE add (FERFNO NUMBER);

Rem Add meta-columns to pseudo controlfile
Rem RPP_CDBDBID, RPP_TIMESTAMP, RPP_META_SPARE1, RPP_META_SPARE2
DECLARE
   TYPE names_t IS TABLE OF VARCHAR2(30);
   lnames CONSTANT names_t := names_t (
      'X$KCCDI',
      'X$KCCDI2',
      'X$KCCIC',
      'X$KCCPDB',
      'X$KCPDBINC',
      'X$KCCTS',
      'X$KCCFE',
      'X$KCCFN',
      'X$KCCTF',
      'X$KCCRT',
      'X$KCCLE',
      'X$KCCSL',
      'X$KCCTIR',
      'X$KCCOR',
      'X$KCCLH',
      'X$KCCAL',
      'X$KCCBS',
      'X$KCCBP',
      'X$KCCBF',
      'X$KCCBL',
      'X$KCCBI',
      'X$KCCDC',
      'X$KCCPD',
      'X$KCCPA',
      'X$KCCPIC'
   );
   dup_column_name EXCEPTION;
   table_not_exist EXCEPTION;
   table_exist EXCEPTION;
   column_not_found EXCEPTION;
   pragma exception_init (dup_column_name, -957);
   pragma exception_init (table_not_exist, -942);
   pragma exception_init (table_exist, -955);
   pragma exception_init (column_not_found, -904);
   PROCEDURE addColumns(p_tableName IN varchar2) IS
   BEGIN
      EXECUTE IMMEDIATE 'ALTER TABLE ' || p_tableName
                        || ' ADD (RPP_CDBDBID NUMBER, '
                        || 'RPP_TIMESTAMP NUMBER, '
                        || 'RPP_META_SPARE1 NUMBER, '
                        || 'RPP_META_SPARE2 NUMBER)';
   EXCEPTION
      WHEN dup_column_name THEN
         NULL;
      WHEN table_not_exist THEN
         NULL;
   END addColumns;

BEGIN
   FOR n in 1..lnames.COUNT LOOP
      addColumns('RPP$' || lnames(n));
      addColumns('ROPP$' || lnames(n));
   END LOOP;
END;
/

Rem *************************************************************************
Rem END bug 27099034 and 27358482 changes
Rem *************************************************************************

Rem
Rem BEGIN ADDM tables
Rem
ALTER TABLE sys.wri$_adv_addm_tasks
  ADD (dbtype_flags NUMBER, dbtype_flags_used NUMBER);
Rem
Rem END ADDM Tables
Rem

Rem =========================================================================
Rem BEGIN Bug 27071161: Set a bit in the audit policy dictionary table to
Rem indicate whether it is a pre-define audit policy.
Rem =========================================================================

update sys.aud_policy$ set type= type + 512
where (bitand(type, 512) = 0) and policy# in
(select distinct obj# from sys.obj$ where namespace=93 and type#=115 and
name in (
'ORA_CIS_RECOMMENDATIONS',
'ORA_DATABASE_PARAMETER',
'ORA_ACCOUNT_MGMT',
'ORA_LOGON_FAILURES',
'ORA_SECURECONFIG',
'COMMON_USER_LOGONS',
'SYS_USER_ACTIONS'));
COMMIT;

Rem =========================================================================
Rem END Bug 27071161: Set a bit in the audit policy dictionary table to
Rem indicate whether it is a pre-defined audit policy.
Rem =========================================================================

Rem =========================================================================
Rem Begin of fix for Bug 27317860
Rem 1. drop index on (name) column of sensitive_fixed$
Rem 2. create index on (name,flag) columns of sensitive_fixed$
Rem

drop index i_sensitive_fixed_n$;
create index i_sensitive_fixed$ on sensitive_fixed$(name, flag);

Rem
Rem End of fix for Bug 27317860
Rem =========================================================================

Rem =======================================================================
Rem Begin DBFS section for 18.1
Rem =======================================================================

begin
 execute immediate 'revoke execute on dbms_system from dbfs_role';
exception
  when others then
    if sqlcode in ( -04042, -1927 ) then NULL;
    else raise;
    end if;
end;
/

begin
 execute immediate 'revoke execute on dbms_session from dbfs_role';
exception
  when others then
    if sqlcode in ( -04042, -1927 ) then NULL;
    else raise;
    end if;
end;
/


REM The changes bug 27045090 ensured that storage within DBFS dictionary
REM is without double quotes and when required upper cased.

declare
 lschema    varchar2(128);
 ltable     varchar2(128);
 fschema    varchar2(128);
 ftable     varchar2(128);
 issquoted  boolean;
 istquoted  boolean;
 cursor s_c is select  schema_name, table_name, rowid from sys.dbfs_sfs$_tab;
 function unquote (v in  varchar2, quoted out boolean)
        return  varchar2
        deterministic
 is
 begin
    if ((v is null) or (v = '') or (length(v) < 2)) then
      quoted := false;
      return v;
    end if;

    if ((substr(v,         1, 1) = '"')     and
       (substr(v, length(v), 1) = '"'))    then
       quoted := true;
       return substr(v, 2, length(v)-2);
    end if;

    quoted := false;
    return v;
 end;
begin

 FOR s_c_rec in s_c LOOP
   issquoted := false;
   istquoted := false;
   lschema := unquote(s_c_rec.schema_name, issquoted);
   ltable  := unquote(s_c_rec.table_name, istquoted);

   if issquoted then
     fschema := lschema;
   else
     fschema := upper(s_c_rec.schema_name);
   end if;

   if istquoted then
     ftable := ltable;
   else
     ftable := upper(s_c_rec.table_name);
   end if;

   update sys.dbfs_sfs$_tab
     set schema_name = fschema,
         table_name = ftable
     where ROWID = s_c_rec.rowid;
 END LOOP;
 commit;
end;
/

REM Bug27045057 : revoke privileges granted using blessUser
REM Must be called after upgrade action of bug 27045090 (above)
REM Incase this script tries to revoke execute on SYS user (in the case when
REM sys user creates a DBFS) we have to ignore ORA-01749.

declare
 cursor s_c is select distinct schema_name from sys.dbfs_sfs$_tab;
 lschema    varchar2(128); 
 suid       varchar2(512);
begin
 for s_c_rec in s_c LOOP
  suid := dbms_assert.enquote_name(s_c_rec.schema_name, false); 
  begin
  execute immediate 'revoke execute on dbms_dbfs_content_property_t '
      || ' from ' || suid;
  exception
    when others then
      if sqlcode in ( -04042, -1927, -01749  ) then NULL;
      else raise;
      end if;
  end;

  begin
  execute immediate 'revoke execute on dbms_dbfs_content_properties_t '
      || ' from ' || suid;
  exception
    when others then
      if sqlcode in ( -04042, -1927, -01749  ) then NULL;
      else raise;
      end if;
  end;

  begin
  execute immediate 'revoke execute on dbms_dbfs_content_context_t '
      || ' from ' || suid;
  exception
    when others then
      if sqlcode in ( -04042, -1927, -01749  ) then NULL;
      else raise;
      end if;
  end;

  begin
  execute immediate 'revoke execute on dbms_dbfs_content_raw_t '
      || ' from ' || suid;
  exception
    when others then
      if sqlcode in ( -04042, -1927, -01749  ) then NULL;
      else raise;
      end if;
  end;

  begin
  execute immediate 'revoke execute on dbms_fuse '
      || ' from ' || suid;
  exception
    when others then
      if sqlcode in ( -04042, -1927, -01749  ) then NULL;
      else raise;
      end if;
  end;

  begin
  execute immediate 'revoke execute on dbms_dbfs_sfs '
      || ' from ' || suid;
  exception
    when others then
      if sqlcode in ( -04042, -1927, -01749 ) then NULL;
      else raise;
      end if;
  end;
 end LOOP;
 commit;
end;
/

Rem =======================================================================
Rem End DBFS section for 18.1
Rem =======================================================================

Rem *************************************************************************
Rem BEGIN Changes for Automatic inmemory management (Project 74398)
Rem *************************************************************************

alter table sys.heat_map_stat$ add (
       n_insert    number
      ,n_update    number
      ,n_delete    number
      ,n_rowsins   number
      ,n_rowsupd   number
      ,n_rowsdel   number
);

Rem *************************************************************************
Rem END Changes for Automatic inmemory management (Project 74398)
Rem *************************************************************************

Rem *************************************************************************
Rem BEGIN bug 25687751 -- These actions now handled internally
Rem *************************************************************************
DROP TRIGGER SYS.aw_trunc_trg;
DROP PROCEDURE sys.aw_trunc_proc;
DROP TRIGGER sys.aw_ren_trg;
DROP PROCEDURE sys.aw_ren_proc;
DROP TRIGGER sys.aw_drop_trg;
DROP PROCEDURE sys.aw_drop_proc;
Rem *************************************************************************
Rem END bug 25687751
Rem *************************************************************************


Rem *************************************************************************
Rem BEGIN changes to container$
Rem *************************************************************************

ALTER TABLE container$ ADD (credname VARCHAR2(262));

Rem *************************************************************************
REM END changes to container$
Rem *************************************************************************

Rem =========================================================================
Rem Begin Logminer changes for 19.0
Rem =========================================================================

CREATE TABLE SYSTEM.LOGMNR_PROFILE_TABLE_STATS$ (
      OWNER                   VARCHAR2(384),
      NAME                    VARCHAR2(384),
      OBJID                   NUMBER,
      OPNUM                   NUMBER, /* Total number of DDLs + DMLs */
      TLSBYUNSUPPOPNUM        NUMBER, /* RU unsupported */
      OGGUNSUPPOPNUM          NUMBER, /* OGG NONE support mode */
      OGGFETCHOPNUM           NUMBER, /* OGG Fetch support mode */
      OGGPLSQLOPNUM           NUMBER, /* OGG PL/SQL support mode */
      PARTNUM                 NUMBER, /* # of partitions encountered */
      INSERTNUM               NUMBER, /* # of Inserts processed */
      UPDATENUM               NUMBER, /* # of Updates processed */
      DELETENUM               NUMBER, /* # of Deletes processed */
      DDLNUM                  NUMBER, /* # of DDLs processed */
      PROPERTY1               NUMBER, /* Tab$.property bits */
      PROPERTY2               NUMBER, /* Upper tab$.property bits */
      PARTITIONATTR           NUMBER,
      REDOSIZE                NUMBER, /* Size of redo for this table */
      MAXLOBSIZE              NUMBER,
      REDORATE                NUMBER, /* Redo rate for this table */
      SPARE1                  VARCHAR2(384),
      SPARE2                  VARCHAR2(384),
      SPARE3                  NUMBER,
      SPARE4                  NUMBER,
      SPARE5                  NUMBER,
      SPARE6                  NUMBER,
      constraint LOGMNR_PROFILE_TABLE$_PK primary key (OBJID))
      TABLESPACE SYSAUX LOGGING
/

CREATE TABLE SYSTEM.LOGMNR_PROFILE_PLSQL_STATS$ (
      PKGOWNER                VARCHAR2(384),
      PKGNAME                 VARCHAR2(384),
      NAME                    NUMBER, /* Function or Procedure Name */
      PRAGMAOP                NUMBER, /* PLSQL pragma */
      OPNUM                   NUMBER, /* Total number of invocations */
      TLSBYUNSUPPOPNUM        NUMBER, /* # of calls unsupported by TLSBY */
      OGGUNSUPPOPNUM          NUMBER, /* # of calls unsupported by OGG */
      REDOSIZE                NUMBER,
      REDORATE                NUMBER,
      SPARE1                  VARCHAR2(384),
      SPARE2                  VARCHAR2(384),
      SPARE3                  NUMBER,
      SPARE4                  NUMBER,
      SPARE5                  NUMBER,
      SPARE6                  NUMBER,
      constraint LOGMNR_PROFILE_PLSQL$_PK
        primary key (PKGOWNER, PKGNAME, NAME))
      TABLESPACE SYSAUX LOGGING
/

Rem =========================================================================
Rem End Logminer changes for 19.0
Rem =========================================================================

Rem =========================================================================
Rem  Changes for Database Workload Capture and Replay
@@c18_wrr.sql
Rem =========================================================================

Rem =========================================================================
Rem BEGIN GDS/Sharding  changes for 19
Rem =========================================================================

----------------------------------------------------------------------------
-- Chancges added for patch/RU
---------------------------------------------------------------------------
-- Bug 31628311: Need to make PKE fields wider for FIPS
-- Since we cannot convert from RAW to BLOB and the table has only
-- one row, we just need to drop and re-build the whole table
BEGIN
      -- we just need build the table and move the row
      -- 1) rename table
      execute immediate
         'alter table gsmadmin_internal.cloud rename to cloud_tmp';
      -- 2) create original table with new format
      execute immediate
        'CREATE TABLE gsmadmin_internal.cloud (
           name               VARCHAR2(128) NOT NULL,
           encryption_key     VARCHAR2(30),
           change_seq#        NUMBER,
           next_db_num        NUMBER,
           mastergsm          VARCHAR2(128) DEFAULT NULL,
           autovncr           NUMBER(1)     DEFAULT 1,
           max_instances      NUMBER        DEFAULT NULL ,
           private_key        BLOB          DEFAULT NULL,
           public_key         BLOB          DEFAULT NULL,
           prvk_enc_str       RAW(2000)     DEFAULT NULL,
           data_vers          VARCHAR2(30)  DEFAULT NULL,
           last_ddl_num       NUMBER        DEFAULT 0,
           last_syncddl_num   NUMBER        DEFAULT 0,
           region_num         NUMBER,
           deploy_state       NUMBER        DEFAULT 0,
           objnum_gen         NUMBER        DEFAULT 1000000,
           sharding_type      NUMBER(1)     DEFAULT NULL,
           replication_type   NUMBER(1)     DEFAULT NULL,
           protection_mode    NUMBER(1)     DEFAULT NULL,
           replication_factor NUMBER        DEFAULT NULL,
           chunk_count        NUMBER        DEFAULT NULL,
           database_flags     CHAR(1)       DEFAULT NULL,
           ddl_offset         NUMBER        DEFAULT 0,
           PRIMARY KEY (name)
           )';
      -- 3) insert from temp table to new format table (there is only one row)
      execute immediate 'insert into gsmadmin_internal.cloud (name, 
           encryption_key, change_seq#, next_db_num, mastergsm, autovncr,
           max_instances, private_key, public_key, prvk_enc_str, data_vers,
           last_ddl_num, last_syncddl_num, region_num, deploy_state, objnum_gen,
           sharding_type, replication_type, protection_mode, replication_factor,
           chunk_count, database_flags)
           select name, encryption_key,
           change_seq#, next_db_num, mastergsm, autovncr, max_instances,
           private_key, public_key,
           prvk_enc_str, data_vers, last_ddl_num,
           last_syncddl_num, region_num, deploy_state, objnum_gen, sharding_type,
           replication_type, protection_mode, replication_factor, chunk_count,
           database_flags
           from gsmadmin_internal.cloud_tmp';
      -- 4) remove temp table
      execute immediate 'drop table gsmadmin_internal.cloud_tmp';
EXCEPTION WHEN OTHERS THEN
  IF SQLCODE = -00942 THEN
    NULL;
  ELSE
    RAISE;
  END IF;
END;
/

ALTER TABLE sys.ddl_requests_pwd
    MODIFY (enc_pwd RAW(256))
/

-------------------------------------------------------------------------------
-- changes to table TABLE_FAMILY
-------------------------------------------------------------------------------

ALTER TABLE gsmadmin_internal.table_family ADD
    schema_name              VARCHAR2(128 BYTE)  DEFAULT NULL
/

ALTER TABLE gsmadmin_internal.table_family RENAME COLUMN
    family_name to root_name
/

-- Update the schema_name column based on the corresponding value from
-- global_table matching the root table name
DECLARE
  num_tab_fams      NUMBER;
  num_tab_rows      NUMBER;
  loc_schema_name   VARCHAR2(128);
BEGIN
  EXECUTE IMMEDIATE
    'SELECT COUNT(*) FROM gsmadmin_internal.table_family' INTO num_tab_fams;
  IF num_tab_fams = 1 THEN
    EXECUTE IMMEDIATE
      'SELECT COUNT(*) FROM gsmadmin_internal.global_table gt,
         gsmadmin_internal.table_family tf WHERE gt.table_name = tf.root_name'
      INTO num_tab_rows;
    IF num_tab_rows = 1 THEN
      EXECUTE IMMEDIATE
        'SELECT gt.schema_name FROM gsmadmin_internal.global_table gt,
          gsmadmin_internal.table_family tf WHERE gt.table_name = tf.root_name'
        INTO loc_schema_name;
      EXECUTE IMMEDIATE
        'UPDATE gsmadmin_internal.table_family set schema_name = :1'
           USING loc_schema_name;
      COMMIT;
    END IF;
  END IF;
EXCEPTION
  WHEN NO_DATA_FOUND THEN NULL;
  WHEN OTHERS THEN
    IF (SQLCODE = -942) THEN NULL;
    END IF;
END;
/

ALTER TABLE gsmadmin_internal.cloud ADD
    ddl_offset NUMBER  DEFAULT 0
/

-------------------------------------------------------------------------------
-- changes to table SERVICE$
-------------------------------------------------------------------------------
alter table sys.service$ add (table_family_id number);

-- Update the table_family column for all global services in
-- gsmadmin_internal.service and servic$ tables to have the value of the
-- current single table family ID, if exists
DECLARE
  num_tab_fams      NUMBER;
  loc_tab_fam_id    NUMBER;
BEGIN
  EXECUTE IMMEDIATE
    'SELECT COUNT(*) FROM gsmadmin_internal.table_family' INTO num_tab_fams;
  IF num_tab_fams = 1 THEN
    EXECUTE IMMEDIATE
      'SELECT family_id FROM gsmadmin_internal.table_family'
      INTO loc_tab_fam_id;
    EXECUTE IMMEDIATE
      'UPDATE gsmadmin_internal.service set table_family = :1'
         USING loc_tab_fam_id;
    EXECUTE IMMEDIATE
      'UPDATE sys.service$ set table_family_id = :1
         WHERE bitand(flag, 64) = 64'
         USING loc_tab_fam_id;
    COMMIT;
  END IF;
EXCEPTION
  WHEN NO_DATA_FOUND THEN NULL;
  WHEN OTHERS THEN
    IF (SQLCODE = -942) THEN NULL;
    END IF;
END;
/

-- privilege changes
REVOKE EXECUTE on sys.dbms_sys_sql FROM gsmadmin_internal
/

alter table sys.service$ add (placement_policy number);
alter table sys.service$ add (reset_state number);
alter table sys.service$ add (vcspare1 varchar2(1024));
alter table sys.service$ add (nspare1 number);

-----------------------------------------------------------------------------
-- revoke unnecessary privileges from GSM users
-----------------------------------------------------------------------------
DECLARE
  -- procedure to revoke GSM user privs
  PROCEDURE revoke_priv(priv varchar2, grantee varchar2)
  AS
    stmt varchar2(4000) := 'REVOKE ' || priv || ' FROM ' || grantee;
  BEGIN
    EXECUTE IMMEDIATE stmt;
  EXCEPTION
    WHEN OTHERS THEN
      -- Ignore errors for privileges not granted
      IF SQLCODE NOT IN (-1917,-1918,-1927,-1951,-1952,-65092) THEN
        RAISE;
      END IF;
  END;

BEGIN
  revoke_priv('create library', 'gsmadmin_internal');
  revoke_priv('create sequence', 'gsmadmin_internal');
  revoke_priv('alter user', 'gsmadmin_internal');
  revoke_priv('alter session', 'gsmadmin_role');
  revoke_priv('drop any index', 'gsmadmin_internal');
  revoke_priv('exempt access policy', 'gsmuser');
  revoke_priv('connect', 'gsmcatuser');
  revoke_priv('connect', 'gsmuser_role');
  revoke_priv('unlimited tablespace', 'gsmuser');
  revoke_priv('create tablespace', 'gsmuser');
  revoke_priv('create any table', 'gsmuser');
  revoke_priv('create any index', 'gsmuser');
  revoke_priv('create any materialized view', 'gsmuser');
  revoke_priv('create any procedure', 'gsmuser');
  revoke_priv('create any sequence', 'gsmuser');
  revoke_priv('create any synonym', 'gsmuser');
  revoke_priv('create any view', 'gsmuser');
  revoke_priv('alter any table', 'gsmuser');
  revoke_priv('alter any index', 'gsmuser');
  revoke_priv('alter any materialized view', 'gsmuser');
  revoke_priv('alter any procedure', 'gsmuser');
  revoke_priv('alter any sequence', 'gsmuser');
  revoke_priv('drop any table', 'gsmuser');
  revoke_priv('drop any index', 'gsmuser');
  revoke_priv('drop any materialized view', 'gsmuser');
  revoke_priv('drop any procedure', 'gsmuser');
  revoke_priv('drop any sequence', 'gsmuser');
  revoke_priv('drop any synonym', 'gsmuser');
  revoke_priv('drop any view', 'gsmuser');
  revoke_priv('alter system', 'gsmuser');
  revoke_priv('connect', 'ggsys');
  revoke_priv('resource', 'ggsys');
  END;
/

Rem =========================================================================
Rem END GDS/Sharding  changes for 19
Rem =========================================================================
Rem =======================================================================
Rem Begin Streams changes
Rem =======================================================================
DROP PACKAGE dbms_streams_messaging;
DROP PACKAGE dbms_streams_handler_adm;
DROP PACKAGE dbms_streams_handler_internal;
DROP PACKAGE dbms_streams_adv_adm_utl;
DROP PACKAGE dbms_streams_advisor_adm;
DROP PACKAGE dbms_streams_adv_adm_utl_invok;
DROP PACKAGE dbms_streams_mc_inv;
DROP PACKAGE dbms_streams_mc;
DROP PACKAGE dbms_apply_handler_adm;
DROP PACKAGE dbms_apply_handler_internal;

DROP PUBLIC SYNONYM dbms_streams_messaging;
DROP PUBLIC SYNONYM dbms_streams_handler_adm;
DROP PUBLIC SYNONYM dbms_streams_advisor_adm;


Rem =======================================================================
Rem End Streams changes
Rem =======================================================================

Rem =========================================================================
Rem Beginning of changes for project 74418
Rem
ALTER SESSION SET CURRENT_SCHEMA = gsmadmin_internal;

ALTER TABLE service_preferred_available
   MODIFY database VARCHAR2(159)
/

ALTER TABLE database MODIFY name VARCHAR2(159)
/

ALTER SESSION SET CURRENT_SCHEMA = SYS;

Rem
Rem End of changes for project 74418
Rem =========================================================================

Rem
Rem BEGIN pdb_snapshotfile tables
Rem
create table pdb_snapshotfile$ (
  con_id#       number not null,                             /* container ID */
  snapscn       number not null,                             /* snapshot scn */
  snapfilename  varchar2(513) not null,                /* snapshot file name */
  snapfiletype  varchar2(8) not null,                  /* snapshot file type */
  spare1        number,
  spare2        number,
  spare3        varchar2(1000),
  spare4        varchar2(1000)
)
/
Rem
Rem END pdb_snapshotfile tables
Rem

Rem =========================================================================
Rem Begin Scheduler changes
Rem =========================================================================

Rem ************************************************************************
Rem Begin Bug 27303287. Drop indexes not supported by 2k block size DBs
Rem ************************************************************************

drop index sys.i_scheduler$_listeneraddresse3;
drop index sys.i_scheduler$_listeneraddresse4;

Rem ************************************************************************
Rem End Bug 27303287
Rem ************************************************************************

Rem ************************************************************************
Rem Begin Fortify changes part 2. Increase size of global attribute values.
Rem ************************************************************************

alter table sys.scheduler$_global_attribute modify value varchar2(256);

Rem ************************************************************************
Rem End Fortify changes part 2
Rem ************************************************************************

Rem =========================================================================
Rem End Scheduler changes
Rem =========================================================================

Rem =======================================================================
Rem Begin Changes for Bug 30973698 : If bit KQDOBUAT(i.e.0x8000000/134217728)
Rem set in 'obj$.flags' for AUDSYS.AUD$UNIFIED table ,then reset it
Rem to avoid federation object checks during ALTER TABLE operation.
Rem =======================================================================

DECLARE
  uni_aud_tab_flag   NUMBER;
BEGIN
  EXECUTE IMMEDIATE
    'SELECT flags FROM sys.obj$ WHERE NAME=''AUD$UNIFIED'' and type#=2' INTO uni_aud_tab_flag;
  IF (BITAND(uni_aud_tab_flag, 134217728) = 134217728) THEN
    EXECUTE IMMEDIATE
      'update sys.obj$ set flags= flags - 134217728 where NAME=''AUD$UNIFIED'' and type#=2';
    COMMIT;
    EXECUTE IMMEDIATE 'alter system flush shared_pool';
  END IF;
EXCEPTION
  WHEN NO_DATA_FOUND THEN NULL;
  WHEN OTHERS THEN
    IF (SQLCODE = -942) THEN NULL;
    END IF;
END;
/

Rem =======================================================================
Rem End Changes for Bug 30973698 : Reset KQDOBUAT flag
Rem =======================================================================

Rem**************************************************************************
Rem BEGIN BUG 22456380: Add auditing for XDB protocols
Rem**************************************************************************
-- Add new columns to table audsys.aud$unified
ALTER TABLE audsys.aud$unified ADD PROTOCOL_SESSION_ID NUMBER;
ALTER TABLE audsys.aud$unified ADD PROTOCOL_RETURN_CODE NUMBER;
ALTER TABLE audsys.aud$unified ADD PROTOCOL_ACTION_NAME VARCHAR2(32);
ALTER TABLE audsys.aud$unified ADD PROTOCOL_USERHOST VARCHAR2(128);
ALTER TABLE audsys.aud$unified ADD PROTOCOL_MESSAGE VARCHAR2(4000);

Rem**************************************************************************
Rem END BUG 22456380: Add auditing for XDB protocols
Rem**************************************************************************


Rem *************************************************************************
Rem BEGIN BUG 27502161 changes
Rem *************************************************************************

alter table SYS.RPP$X$KCCDI add DIFMOD NUMBER;
alter table SYS.ROPP$X$KCCDI add  DIFMOD NUMBER;

Rem *************************************************************************
Rem END BUG 27502161 changes
Rem *************************************************************************

Rem *************************************************************************
Rem BEGIN BUG 26632926 changes
Rem *************************************************************************

truncate table resource_io_calibrate$;
alter table resource_io_calibrate$ modify latency number(*,3);

Rem *************************************************************************
Rem END BUG 26632926 changes
Rem *************************************************************************

Rem *************************************************************************
Rem BEGIN BUG 27864388 changes
Rem *************************************************************************

alter table sys.sum$ add lastrefreshdate_xp date;
update sys.sum$ set lastrefreshdate_xp = lastrefreshdate;
commit;

Rem *************************************************************************
Rem END BUG 27864388 changes
Rem *************************************************************************

Rem*************************************************************************
Rem BEGIN Bug 27929485 make sure KQLDTVCP_MVL property for mlog$_ tabs
Rem*************************************************************************

  -- Bug 27929485:
  -- this bug is regression from bug 13863326
  -- if any database version is upgraded from 11.2.0.3 or earlier,
  -- KQLDTVCP_MVL bit of property column in tab$ may not be set for
  -- mlog$_ tables.
  -- we need make sure this bit is set in current version.
  UPDATE sys.tab$ t SET t.property = t.property + 65536
  WHERE  bitand (t.property,65536) = 0 and
         t.obj# IN (SELECT o.obj# FROM sys.obj$ o, sys.mlog$ l
                    WHERE o.name = l.log);
  COMMIT;

Rem*************************************************************************
Rem END Bug 27929485
Rem*************************************************************************

Rem *************************************************************************
Rem BEGIN BUG 27864190 changes
Rem *************************************************************************

ALTER TABLE sys.lockdown_prof$ ADD exuserlist CLOB;

Rem *************************************************************************
Rem END BUG 27864190 changes
Rem *************************************************************************

Rem *************************************************************************
Rem BEGIN BUG 20282756 changes
Rem *************************************************************************

alter table sys.wrh$_dyn_remaster_stats add persistent_objects number;

Rem *************************************************************************
Rem END BUG 20282756 changes
Rem *************************************************************************

Rem ************************************************************************
Rem Begin Bug 26663687. Drop index which does not support services
Rem ************************************************************************

drop index u_sql;
create unique index i_sqlsvc$ on connection_tests$(connection_test_type,
                                  sql_connection_test, service_name);

Rem ************************************************************************
Rem End Bug 26663687
Rem ************************************************************************

Rem *************************************************************************
Rem BEGIN BUG 27877704 changes
Rem *************************************************************************

ALTER TABLE SYS.WRI$_ADV_ACTIONS ADD (
   res_status#        number,
   res_last_modified  timestamp(3),
   res_msg_id         number
);

Rem *************************************************************************
Rem END BUG 27877704 changes
Rem *************************************************************************

Rem =========================================================================
Rem Begin of fix for bug 24495099 lazy deletion
Rem

begin
  execute immediate 'update SYS.SYSDBIMFS_METADATA$ set value = 2 where key = ''SCHEMA_VER''';
  commit;
exception when others then
  if (sqlcode = -942) then null;
  end if;
end;
/

alter table SYS.SYSDBIMFSSEG$ add version number default 0;
alter table SYS.SYSDBIMFS$ add version number default 0;

drop index SYS.SYSDBIMFS_IDX$;

drop index SYS.SYSDBIMFSSEG_IDX$;

Rem
Rem End of fix for bug 24495099 lazy deletion
Rem =========================================================================

Rem *************************************************************************
Rem BEGIN BUG 27915028 changes
Rem *************************************************************************

DROP PACKAGE dbms_sumref_util;

Rem *************************************************************************
Rem END BUG 27915028 changes
Rem *************************************************************************

Rem ====================================================================
Rem Begin Bug 26850063
Rem ====================================================================
drop public synonym COLDICTTAB;
drop public synonym COLDICTREC;
drop public synonym SELTAB;
drop public synonym SELREC;
drop public synonym CTAB;
drop public synonym CREC;
drop public synonym RAWCTAB;
drop public synonym RAWCREC;

drop public synonym COLHISTTAB;
drop public synonym COLHISTREC;

Rem ====================================================================
Rem End Bug 26850063
Rem ====================================================================

Rem *************************************************************************
Rem Begin change for AWR
Rem *************************************************************************

-- bug 25382878
alter table WRH$_SEG_STAT add (im_membytes number default 0);

-- Bug28322347
alter table  WRM$_WR_CONTROL modify src_dbname varchar2(128);

Rem =======================================================
Rem ==  Update the SWRF_VERSION to the latest version.   ==
Rem ==  The range of values for swrf_version are defined ==
Rem ==  in kewr.h: KEWR_DB_RELEASE_* macros.             ==
Rem =======================================================
BEGIN
  EXECUTE IMMEDIATE 'UPDATE wrm$_wr_control SET swrf_version = 30';
  COMMIT;
EXCEPTION
  WHEN OTHERS THEN
    IF (SQLCODE = -942) THEN
      NULL;
    ELSE
      RAISE;
    END IF;
END;
/


Rem *************************************************************************
Rem End change for AWR
Rem *************************************************************************

Rem *************************************************************************
Rem Begin changes for bug 28146626: Insert rowtypes into type$
Rem *************************************************************************
create index i_oid2 on oid$(obj#,oid$)
/
create index i_collection2 on collection$(package_obj#,elem_toid)
/
declare
  type toid_table is table of oid$.oid$%type index by binary_integer;
  toids toid_table;
begin
  select oid.oid$                -- Get all table%rowtype toids from oid$
    bulk collect into toids
    from oid$ oid, obj$ obj
    where
      obj.type# in (2,4) and                     -- only tables and views
      obj.oid$ is null and                       -- no nested type tables
      obj.obj# = oid.obj# and                    -- get the toid
      oid.oid$ not in (select tvoid from type$); -- not already in type$!

  begin                                   -- bulk insert toids into type$
    forall i in toids.first..toids.last save exceptions
      insert into type$ (toid,version#,version,tvoid,typecode,properties)
      values (toids(i), 1, '$8.0', toids(i), 250, 0);
  exception when others then
    null;                                 -- don't worry about exceptions
  end;

  commit;                                           -- commit the changes
end;
/
Rem *************************************************************************
Rem End changes for bug 28146626
Rem *************************************************************************

Rem *************************************************************************
Rem BEGIN BUG 28042089 changes
Rem *************************************************************************

alter table sys.wri$_adv_sqlt_plans add outrows number;
alter table sys.wri$_adv_sqlt_plans add starts number;

Rem *************************************************************************
Rem END BUG 28042089 changes
Rem *************************************************************************

Rem *************************************************************************
Rem Begin Changes for proj 74122
Rem *************************************************************************

Rem Add TASK_PROP_USERSETUP
Rem -----------------------

update wri$_adv_tasks set property = property - bitand(property, 64) + 64
where advisor_name = 'SQL Access Advisor' and name != 'SYS_AUTO_INDEX_TASK';

commit;

Rem New column for opt_sqlstat$
Rem ---------------------------

truncate table opt_sqlstat$;

alter table opt_sqlstat$ add (px_servers_executions number);

Rem *************************************************************************
Rem End Changes for proj 74122
Rem *************************************************************************

Rem *************************************************************************
Rem BEGIN Bug 27445727 changes
Rem *************************************************************************

revoke execute on sys.CDBView_Internal from execute_catalog_role;

Rem *************************************************************************
Rem END Bug 27445727 changes
Rem *************************************************************************

Rem *************************************************************************
Rem BEGIN Bug 28433703: drop public synonym xmlconcat
Rem *************************************************************************

drop public synonym XMLConcat;

Rem *************************************************************************
Rem END Bug 28433703: drop public synonym xmlconcat
Rem *************************************************************************

Rem *************************************************************************
Rem BEGIN Changes for Bug 28469827
Rem *************************************************************************

begin
  -- Revoke SET CONTAINER from PDB_DBA in all the PDBs
  if (sys_context('userenv','con_id') > 1) then
    begin
      execute immediate 'revoke set container from pdb_dba container=current';
    exception when others then
      if (sqlcode not in (-1952, -65092)) then
        raise;
      end if;
    end;
  end if;
end;
/

Rem *************************************************************************
Rem END Changes for Bug 28469827
Rem *************************************************************************

Rem *************************************************************************
Rem Bug 28538268 : Set KZDPF_ORCL bit for Oracle supplied profiles
Rem *************************************************************************

update profname$ set flags = flags + 8 - bitand(flags, 8)
where name in ('DEFAULT', 'ORA_STIG_PROFILE', 'GSM_PROF');

commit;

Rem *************************************************************************
Rem End changes for Bug 28538268
Rem *************************************************************************

Rem *************************************************************************
Rem Bug 28606076 : DROP VIEW X_$KGLOB AND SYNONYM X$KGLOB DURING UPGRADE
Rem *************************************************************************

drop view X_$KGLOB;
drop public SYNONYM X$KGLOB;

Rem *************************************************************************
Rem End changes for Bug 28606076
Rem *************************************************************************

Rem *************************************************************************
Rem BEGIN Changes for Bug 28557503: drop dbms_optim package related objects
Rem *************************************************************************

drop package sys.dbms_optim_bundle;
drop type sys.dbms_optim_fcTabType;
drop type sys.dbms_optim_bugValObType;
drop directory DBMS_OPTIM_ADMINDIR;
drop directory DBMS_OPTIM_LOGDIR;

Rem *************************************************************************
Rem END Changes for Bug 28557503
Rem *************************************************************************

Rem *************************************************************************
Rem BEGIN BUG 28134320 minimize privileges on OUTLN
Rem *************************************************************************

begin
 execute immediate 'revoke create session from outln';
 exception when others then
  if sqlcode in (-1952, -65092) then null; else raise; end if;
end;
/

begin
 execute immediate 'revoke resource from outln';
 exception when others then
  if sqlcode in (-1951) then null; else raise; end if;
end;
/

begin
 execute immediate 'revoke unlimited tablespace from outln';
 exception when others then
  if sqlcode in (-1952, -65092) then null; else raise; end if;
end;
/

begin
 execute immediate 'revoke execute any procedure from outln';
 exception when others then
  if sqlcode in (-1952, -65092) then null; else raise; end if;
end;
/

begin
 execute immediate 'revoke set container from outln';
 exception when others then
  if sqlcode in (-1952, -65092) then null; else raise; end if;
end;
/

begin
 execute immediate 'revoke inherit privileges on user outln from public';
 exception when others then
  if sqlcode in (-1927) then null; else raise; end if;
end;
/

begin
 execute immediate 'alter user outln quota unlimited on system';
end;
/

Rem *************************************************************************
Rem END BUG 28134320 
Rem *************************************************************************

Rem =========================================================================
Rem BEGIN Changes for Bug 28487688
Rem =========================================================================

REM This table stores session usage history
create table sess_cnt_history$
(
  instance_id  varchar2(50) not null,
  epoch_usec   number not null,
  session_cnt  number not null
)
/

Rem =========================================================================
Rem END Changes for Bug 28487688
Rem =========================================================================

Rem *************************************************************************
Rem BEGIN Changes for Bug 28785774
Rem *************************************************************************

alter table wri$_sqlset_definitions add property number default 0;

Rem *************************************************************************
Rem END Changes for Bug 28785774
Rem *************************************************************************

Rem =========================================================================
Rem Begin Bug 29549071: Drop unsupported Hive catalog views
Rem =========================================================================
--
-- We only create Hive catalog views in platform id = 2 and 13. In all other
-- platform, we don't support Hive catalog views. In earlier releases such as
-- 12.0, we unconditionally created Hive catalog views on all the unsupported
-- platforms. Hence upgrading from an unsupported platform (say IBM AIX) of 
-- 12.0 to 19.1 will result in invalid hive catalog views.
--
DECLARE
  pfid     NUMBER := 0;
BEGIN
  SELECT platform_id INTO pfid FROM v$database;

  IF (pfid != 13 AND pfid != 2) THEN
    EXECUTE IMMEDIATE 'DROP VIEW DBA_HIVE_TABLES';
    EXECUTE IMMEDIATE 'DROP VIEW USER_HIVE_TABLES';
    EXECUTE IMMEDIATE 'DROP VIEW ALL_HIVE_TABLES';
    EXECUTE IMMEDIATE 'DROP VIEW DBA_HIVE_COLUMNS';
    EXECUTE IMMEDIATE 'DROP VIEW ALL_HIVE_DATABASES';
    EXECUTE IMMEDIATE 'DROP VIEW ALL_HIVE_COLUMNS';
    EXECUTE IMMEDIATE 'DROP VIEW DBA_HIVE_DATABASES';
    EXECUTE IMMEDIATE 'DROP VIEW USER_HIVE_DATABASES';
    EXECUTE IMMEDIATE 'DROP VIEW USER_HIVE_COLUMNS';
  END IF;
END;
/
Rem =========================================================================
Rem END Bug 29549071: Drop unsupported Hive catalog views
Rem =========================================================================


Rem *************************************************************************
Rem BEGIN Resource Manager Changes
Rem *************************************************************************

alter table WRH$_RSRC_PDB_METRIC add (max_avg_rng_sess number default 0
                                      not null);

Rem *************************************************************************
Rem END Resource Manager Changes
Rem *************************************************************************

Rem *************************************************************************
Rem BEGIN Changes for Bug 29023878
Rem *************************************************************************

alter table wri$_adv_objects 
add sql_id_vc generated always as 
    (decode(type, 7, substr(attr1, 1, 13), null));

Rem *************************************************************************
Rem END Changes for Bug 29023878
Rem *************************************************************************

Rem *************************************************************************
Rem BEGIN Changes for Bug 29018307
Rem *************************************************************************

BEGIN
  -- bug 29018307: add parameters for SPM evolve advisor tasks
  EXECUTE IMMEDIATE 
    q'#INSERT INTO wri$_adv_parameters (task_id, name, value, datatype, flags)
       (SELECT t.id, '_ALTERNATE_PLAN_STS_RATIO', '110', 1,  9 
        FROM wri$_adv_tasks t
        WHERE t.advisor_name = 'SPM Evolve Advisor' AND 
              NOT EXISTS (SELECT 0 
                          FROM wri$_adv_parameters p
                          WHERE p.task_id = t.id and 
                                p.name = '_ALTERNATE_PLAN_STS_RATIO'))#';

  EXECUTE IMMEDIATE 
    q'#INSERT INTO wri$_adv_parameters (task_id, name, value, datatype, flags)
       (SELECT t.id, '_ALTERNATE_PLAN_THRESHOLD', '100', 1,  9 
        FROM wri$_adv_tasks t
        WHERE t.advisor_name = 'SPM Evolve Advisor' AND 
              NOT EXISTS (SELECT 0 
                          FROM wri$_adv_parameters p
                          WHERE p.task_id = t.id and 
                                p.name = '_ALTERNATE_PLAN_THRESHOLD'))#';

  EXECUTE IMMEDIATE 
    q'#INSERT INTO wri$_adv_parameters (task_id, name, value, datatype, flags)
       (SELECT t.id, '_ALTERNATE_PLAN_AI_MODE', 'FALSE', 2,  9 
        FROM wri$_adv_tasks t
        WHERE t.advisor_name = 'SPM Evolve Advisor' AND 
              NOT EXISTS (SELECT 0 
                          FROM wri$_adv_parameters p
                          WHERE p.task_id = t.id and 
                                p.name = '_ALTERNATE_PLAN_AI_MODE'))#';

  EXCEPTION 
    WHEN OTHERS THEN
      IF SQLCODE = -942 
        THEN NULL;
      ELSE
        RAISE;
      END IF;
END;
/

Rem *************************************************************************
Rem END Changes for Bug 29018307
Rem *************************************************************************

Rem =======================================================================
Rem  Begin Changes for Bug 31644775
Rem =======================================================================

alter table scheduler$_credential modify key varchar2(32767);

Rem =======================================================================
Rem  End Changes for Bug 31644775
Rem =======================================================================


Rem =======================================================================
Rem BEGIN per PDB Capture changes
Rem =======================================================================

ALTER TABLE SYS.LOGMNR_BUILDLOG ADD ( DBID NUMBER )
/
ALTER TABLE SYS.LOGMNR_BUILDLOG ADD ( CONTAINER_ID NUMBER )
/
ALTER TABLE SYS.LOGMNR_BUILDLOG ADD ( CONTAINER_UID NUMBER )
/
ALTER TABLE SYS.LOGMNR_BUILDLOG ADD ( CONTAINER_NAME VARCHAR2(384) )
/
ALTER TABLE SYS.LOGMNR_BUILDLOG ADD ( RESETLOGS_CHANGE# NUMBER )
/
ALTER TABLE SYS.LOGMNR_BUILDLOG ADD ( RESETLOGS_TIME DATE )
/
ALTER TABLE SYS.LOGMNR_BUILDLOG ADD ( THREAD_ID NUMBER )
/
ALTER TABLE SYS.LOGMNR_BUILDLOG ADD ( SEQUENCE#_BEGIN NUMBER )
/
ALTER TABLE SYS.LOGMNR_BUILDLOG ADD ( SEQUENCE#_END   NUMBER )
/
ALTER TABLE SYS.LOGMNR_BUILDLOG ADD ( SCN_END_OF_BLD  NUMBER )
/
ALTER TABLE SYS.LOGMNR_BUILDLOG ADD ( BUILD_NAME VARCHAR2(384) )
/
ALTER TABLE SYS.LOGMNR_BUILDLOG ADD ( BUILD_OP NUMBER )
/

Rem =======================================================================
Rem END per PDB Capture changes
Rem =======================================================================

Rem *************************************************************************
Rem Begin bug 28145995 : update indpart$ for local index on ref part tables
Rem *************************************************************************

-- Create temporary tables from partjob$
create table tab32811069_1 as ( 
  select ipo.obj# from partobj$ ipo, ind$ i, partobj$ tpo
    where bitand(ipo.flags, 1) != 0    -- index is local
      and ipo.obj# = i.obj# and i.bo# = tpo.obj#
      and tpo.parttype = 5  -- table is ref partitioned 
  );

-- Create index organised table from tabpartv$ and indpartv$
create table tab32811069_2(phypart#, obj# primary key) organization index as (  
  select tpv.phypart#, ipv.obj# 
  from ind$ i, tabpartv$ tpv, indpartv$ ipv, indpart$ ip 
  where ip.obj# = ipv.obj# and ipv.bo# = i.obj# 
    and i.bo# = tpv.bo# and ipv.part# = tpv.part#); 

-- Update indpart$ using tab32811069_1 and tab32811069_2
update indpart$ ip set part# = ( 
  select t.phypart# from tab32811069_2 t where ip.obj# = t.obj#) 
  where bo# in 
    (select obj# from tab32811069_1 );

commit;

-- Drop temporary tables
drop table tab32811069_1;
drop table tab32811069_2;

commit; 

Rem *************************************************************************
Rem End bug 28145995
Rem *************************************************************************
Rem =======================================================================
Rem  Begin Changes for Bug 32240850
Rem =======================================================================

Rem
Rem  ACCHK_READ role creation 
Rem
BEGIN
  EXECUTE IMMEDIATE 'CREATE ROLE ACCHK_READ';
  EXCEPTION
      WHEN OTHERS THEN
        IF SQLCODE = -1921 THEN NULL;   -- ignore role already created
      ELSE 
        RAISE;
      END IF;
END;
/

Rem
Rem  Grant the new ACCHK_READ role to DBA users with admin option.
Rem

GRANT ACCHK_READ TO DBA WITH ADMIN OPTION;

Rem =======================================================================
Rem  End Changes for Bug 32240850
Rem =======================================================================
Rem *************************************************************************
Rem Project 84235: PASSWORD_ROLLOVER_TIME password profile parameter - BEGIN
Rem *************************************************************************
Rem
Rem Insert a row into the RESOURCE_MAP table for the new password profile
Rem parameter PASSWORD_ROLLOVER_TIME which corresponds to RESOURCE#=8 in
Rem the PROFILE$ table.
Rem
Rem For profiles created prior to release 20.1, since there is no entry in 
Rem the PROFILE$ table corresponding to RESOURCE#=8, attempting to alter
Rem an existing profile's PASSWORD_ROLLOVER_TIME parameter without first
Rem inserting this row would cause an ORA-600 [kzdpfr:pwd] internal error.
Rem
Rem We need to go over all of the existing profiles, including
Rem the DEFAULT profile, and insert a row into PROFILE$ for the
Rem new PASSWORD_ROLLOVER_TIME password profile parameter.
Rem
Rem The PROFILE$ and RESOURCE_MAP tables do not have any constraint defined on
Rem them, so an ORA-00001: "unique constraint violated" error cannot arise.
Rem
Rem To avoid any double-insert into PROFILE$ or into RESOURCE_MAP,
Rem we check whether the entry already exists in the dictionary.
Rem We only go ahead with the insert if the entry does not exist.
Rem
declare
  num_rows number := -1;
  prt_val  number := -1;
begin
  select count(*) into num_rows
    from sys.resource_map
   where name = 'PASSWORD_ROLLOVER_TIME';

  if num_rows = 0 then
    insert into sys.resource_map values (8, 1, 'PASSWORD_ROLLOVER_TIME');
  end if;

  /* For every existing profile, if there's not already an entry in
  ** the PROFILE$ table for the PASSWORD_ROLLOVER_TIME parameter, insert a
  ** row into the PROFILE$ table for it with the following entries:
  **   RESOURCE# = 8 (next number after INACTIVE_ACCOUNT_TIME, which is 7)
  **   TYPE#     = 1 (means that this is a password profile parameter)
  **   LIMIT#    = -1 for the DEFAULT profile, 0 for all other profiles.
  */
  for rec in (select profile# from sys.profname$ order by profile#)
  loop
    num_rows := -1;

    select count(*) into num_rows
      from sys.profile$
     where profile#  = rec.profile#
       and type#     = 1
       and resource# = 8;

    if num_rows = 0 then
      prt_val := (case rec.profile# when 0 then -1 else 0 end);
      insert into sys.profile$ values (rec.profile#, 8, 1, prt_val);
    end if;
  end loop;
end;
/

Rem Bug #32703918: add backport infrastructure for the BLR 32438777 backport
Rem of the project 84235 (Gradual Password Rollover): Avoid duplicate rows
Rem appearing in the sys.user_astatus_map table during upgrade.

 MERGE INTO sys.user_astatus_map uam
 USING SYS.DUAL
    ON (uam.STATUS# = 32)
  WHEN NOT MATCHED THEN
INSERT (STATUS#, STATUS) VALUES (32,
  'OPEN ' || '&' || ' IN ROLLOVER');

 MERGE INTO sys.user_astatus_map uam
 USING SYS.DUAL
    ON (uam.STATUS# = 33)
  WHEN NOT MATCHED THEN
INSERT (STATUS#, STATUS) VALUES (33,
  'EXPIRED ' || '&' || ' IN ROLLOVER');

 MERGE INTO sys.user_astatus_map uam
 USING SYS.DUAL
    ON (uam.STATUS# = 36)
  WHEN NOT MATCHED THEN
INSERT (STATUS#, STATUS) VALUES (36,
  'LOCKED(TIMED) ' || '&' || ' IN ROLLOVER');

 MERGE INTO sys.user_astatus_map uam
 USING SYS.DUAL
    ON (uam.STATUS# = 37)
  WHEN NOT MATCHED THEN
INSERT (STATUS#, STATUS) VALUES (37,
  'EXPIRED ' || '&' || ' LOCKED(TIMED) ' || '&' || ' IN ROL');

 MERGE INTO sys.user_astatus_map uam
 USING SYS.DUAL
    ON (uam.STATUS# = 40)
  WHEN NOT MATCHED THEN
INSERT (STATUS#, STATUS) VALUES (40,
  'LOCKED ' || '&' || ' IN ROLLOVER');

 MERGE INTO sys.user_astatus_map uam
 USING SYS.DUAL
    ON (uam.STATUS# = 41)
  WHEN NOT MATCHED THEN
INSERT (STATUS#, STATUS) VALUES (41,
  'EXPIRED ' || '&' || ' LOCKED ' || '&' || ' IN ROLLOVER');

commit
/

Rem *************************************************************************
Rem Project 84235: PASSWORD_ROLLOVER_TIME password profile parameter - END
Rem *************************************************************************

Rem *************************************************************************
Rem Begin bug 29830374 : insert into connection_tests for draining  on request
Rem boundaries at begin request
Rem *************************************************************************
BEGIN
    INSERT into connection_tests$(predefined, connection_test_type,
      sql_connection_test, enabled) VALUES ( 1, 3, 'NA', 1);
COMMIT;

EXCEPTION
  WHEN OTHERS THEN
    IF (SQLCODE = -1) THEN
      NULL;
    ELSE
      RAISE;
    END IF;
END;
/
Rem *************************************************************************
Rem End bug 29830374
Rem *************************************************************************

Rem *************************************************************************
Rem BEGIN Changes for Bug 32012400
Rem *************************************************************************

BEGIN
  -- bug 32012400: add parameters for SQL Access Advisor tasks
  EXECUTE IMMEDIATE
  q'#INSERT INTO wri$_adv_parameters 
      (task_id, name, value, datatype, flags,description)
       (SELECT t.id, 'RETAIN_UNIQUE_INDEX', 'TRUE', 2, 0, 'QSM-03040'
        FROM wri$_adv_tasks t
        WHERE t.advisor_name = 'SQL Access Advisor' AND
              NOT EXISTS (SELECT 0
                          FROM wri$_adv_parameters p
                          WHERE p.task_id = t.id and
                                p.name = 'RETAIN_UNIQUE_INDEX')) #';
  EXCEPTION
    WHEN OTHERS THEN
      IF SQLCODE = -942
        THEN NULL;
      ELSE
        RAISE;
      END IF;
END;
/

Rem *************************************************************************
Rem END Changes for Bug 32012400
Rem *************************************************************************


Rem *************************************************************************
Rem BEGIN Changes for Bug 31562484 
Rem Update SYSACTN byte vectors of existing unified audit policies
Rem *************************************************************************

DECLARE 
  type actionMaxVal IS VARRAY(6) OF INTEGER; 
  oldMaxActVal actionMaxVal;
  newMaxActVal actionMaxVal;
  
  arraySize integer; 
  vecBitPos integer;
  
  SYSACT_VEC_SIZE CONSTANT NUMBER :=2000;
  SYSACT_VLEN CONSTANT NUMBER :=5;
  
  SYSACT_VER19C CONSTANT NUMBER := 19000;
  cur_sysactVer NUMBER;
  curVerStr varchar2(5);
  
  sysactnBitVec varchar2(2000);
  modSysactnVec varchar2(2000);
  tempBuffer varchar2(2000);
  
  getSysactn_stmt varchar2(512);
BEGIN 
  /* {KZAP_STDACT_ALL, KZAP_XSACT_ALL, KZAP_OLSACT_ALL, KZAP_DPACT_ALL, 
      KZAP_DVEVT_FA, KZAP_DPAPIACT_ALL} of 18C database */
  oldMaxActVal := actionMaxVal(256,50,18,3,13,2);

  /* {KZAP_STDACT_ALL, KZAP_XSACT_ALL, KZAP_OLSACT_ALL, KZAP_DPACT_ALL, 
      KZAP_DVEVT_FA, KZAP_DPAPIACT_ALL} of 19C database */
  newMaxActVal := actionMaxVal(256,50,18,3,13,2);

  arraySize := oldMaxActVal.count;

  -- Loop all existing unified audit policies  
  FOR c_policies in
    (SELECT DISTINCT policy# FROM sys.aud_policy$)
  LOOP   
    vecBitPos :=1;
    cur_sysactVer :=0;

    --Get the Policy Actions into buffer
    SELECT sysactn into sysactnBitVec FROM sys.aud_policy$ 
           WHERE policy#= c_policies.policy#; 

    --Get existing SYSACTN byte vector version and convert to integer
    curVerStr := SUBSTR(sysactnBitVec, SYSACT_VEC_SIZE-SYSACT_VLEN+1, SYSACT_VLEN);
    IF TRIM(TRANSLATE(curVerStr, '0123456789',' ')) IS NULL THEN
      cur_sysactVer := to_number(curVerStr);
    END IF;

    --Update SYSACTN byte vector only if version is less than 19C (i.e. 19000)
    IF (cur_sysactVer < SYSACT_VER19C) THEN
      --Update SYSACTN bytes of all components except PROTOCOL
      FOR i in 1 .. arraySize LOOP 
        tempBuffer := SUBSTR(sysactnBitVec,vecBitPos,oldMaxActVal(i));
        modSysactnVec := concat(concat(modSysactnVec,tempBuffer) , 
                                RPAD('-', newMaxActVal(i)-oldMaxActVal(i) , '-'));
        modSysactnVec := concat(modSysactnVec, 
                             SUBSTR(sysactnBitVec,vecBitPos+oldMaxActVal(i),1));
        vecBitPos := vecBitPos + oldMaxActVal(i) + 1;
        tempBuffer := '';
      END LOOP; 
      
      modSysactnVec := concat(modSysactnVec, 
                        RPAD('-', SYSACT_VEC_SIZE-SYSACT_VLEN-LENGTH(modSysactnVec) , '-'));
      -- Append DB version at the end of SYSACTN byte vector
      modSysactnVec := concat(modSysactnVec, TO_CHAR(SYSACT_VER19C));

      --Overwrite SYSACTN byte vector with modified vector 
      UPDATE sys.aud_policy$ SET sysactn = modSysactnVec 
             WHERE policy# = c_policies.policy#;
      commit;
      modSysactnVec := '';
    END IF;
  END LOOP; --end of looping policies
  EXECUTE IMMEDIATE 'alter system flush shared_pool';
END; 
/

Rem *************************************************************************
Rem END Changes for Bug 31562484 
Rem *************************************************************************

Rem =======================================================================
Rem  34575784: Begin Changes to truncate sys.aq$_message_types
Rem =======================================================================

-- do not carry forward the type verification data associated with message
-- propagation from old release to new release. By clearing the data during
-- upgrade, we force AQ to initiate type verification afresh in the upgraded
-- database.
TRUNCATE TABLE sys.aq$_message_types;

Rem =======================================================================
Rem  34575784: End Changes to truncate sys.aq$_message_types
Rem =======================================================================


Rem *************************************************************************
Rem Changes for Bug 32610271
Rem *************************************************************************

create unique index i_sysauth2 on sysauth$(privilege#, grantee#);

Rem *************************************************************************
Rem END Changes for Bug 32610271
Rem *************************************************************************


---------- ADD UPGRADE ACTIONS ABOVE THIS LINE ---------------

Rem =========================================================================
Rem Changes for Project# 91371 - object number reuse
Rem =========================================================================

create table objnum_reuse (
  obj# number not null,
  ins_date date)
/
create unique index i_objnum_reuse1 on objnum_reuse(obj#)
/
create index i_objnum_reuse2 on objnum_reuse(ins_date, obj#)
/
Rem =========================================================================
Rem END Changes for Project# 91371 - object number reuse
Rem =========================================================================

Rem =========================================================================
Rem Bug 35271571: Change ins_date column to a timestamp. 
Rem =========================================================================

alter table objnum_reuse modify (ins_date timestamp);

Rem =========================================================================
Rem END Changes for Bug 35271571
Rem =========================================================================

---------- ADD UPGRADE ACTIONS ABOVE THIS LINE ---------------

Rem =========================================================================
Rem END STAGE 1: upgrade from 18 to the current release
Rem =========================================================================

Rem =========================================================================
Rem BEGIN STAGE 2: invoke script for subsequent release
Rem =========================================================================

-- @@cxxxxxxxx.sql

Rem =========================================================================
Rem END STAGE 2: invoke script for subsequent release
Rem =========================================================================

Rem *************************************************************************
Rem END   c18.sql
Rem *************************************************************************
