/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbsysmodel.driver.sdk.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.UserPrincipal;
import oracle.dbsysmodel.driver.sdk.productdriver.ProductDriverException;

public class FileUtility {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void persistDataObj(String location, Object data, boolean deleteExistingFile) throws IOException {
        File persistFile = new File(location);
        if (persistFile.exists() && deleteExistingFile) {
            persistFile.delete();
        }
        if (!persistFile.getParentFile().exists()) {
            persistFile.getParentFile().mkdirs();
        }
        FileOutputStream fileOut = null;
        ObjectOutputStream out = null;
        try {
            fileOut = new FileOutputStream(location);
            out = new ObjectOutputStream(fileOut);
            out.writeObject(data);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (fileOut != null) {
                fileOut.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object deserializeDataObj(String objectLoc) throws IOException, ClassNotFoundException {
        Object dataObj = new Object();
        FileInputStream fileIn = null;
        ObjectInputStream in = null;
        try {
            fileIn = new FileInputStream(objectLoc);
            in = new ObjectInputStream(fileIn);
            dataObj = in.readObject();
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (fileIn != null) {
                fileIn.close();
            }
        }
        return dataObj;
    }

    public static String checkFileOwner(File f) {
        return FileUtility.checkFileOwner(f, LinkOption.NOFOLLOW_LINKS);
    }

    public static String checkFileOwner(File f, LinkOption linkOption) {
        Path path = FileSystems.getDefault().getPath(f.getParent(), f.getName());
        String fileOwner = null;
        try {
            UserPrincipal userPrincipal = Files.getOwner(path, linkOption);
            fileOwner = userPrincipal.getName();
        }
        catch (IOException e1) {
            throw new ProductDriverException("Failed to get file owner for : " + f.getAbsolutePath(), e1, ProductDriverException.Type.UnableToCollectKnownInformation);
        }
        return fileOwner;
    }
}

