/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import oracle.security.xmlsec.c14n.CanonicalizationException;
import oracle.security.xmlsec.c14n.Canonicalizer;
import oracle.security.xmlsec.util.DSIGInitializer;
import oracle.security.xmlsec.util.ENCInitializer;
import oracle.security.xmlsec.util.XMLUtils;
import oracle.security.xmlsec.util.XPathException;
import org.jaxen.JaxenException;
import org.jaxen.dom.DOMXPath;
import org.jaxen.dom.NamespaceNode;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLContainer {
    private Node subTree;
    private Set nodeSet;
    private InputStream octetStream;
    private Object userData;
    private String systemId;
    private boolean withComments = true;

    public XMLContainer() {
    }

    public XMLContainer(NodeList nodes) {
        int len = nodes.getLength();
        this.nodeSet = new LinkedHashSet(len);
        for (int i = 0; i < len; ++i) {
            this.nodeSet.add(nodes.item(i));
        }
    }

    public XMLContainer(Collection nodeSet) {
        this.nodeSet = new LinkedHashSet(nodeSet);
    }

    public XMLContainer(Node subTree) {
        this.subTree = subTree;
    }

    public XMLContainer(Node subTree, boolean withComments) {
        this.subTree = subTree;
        this.withComments = withComments;
    }

    public XMLContainer(InputStream octetStream) throws IOException {
        this.setOctetStream(octetStream);
    }

    public XMLContainer(byte[] bytes) throws IOException {
        this.setOctets(bytes);
    }

    public XMLContainer(String systemId) {
        this.setSystemId(systemId);
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void setWithComments(boolean value) {
        if (this.withComments != value && (this.subTreeAvailable() || this.octetsAvailable())) {
            this.nodeSet = null;
        }
        this.withComments = value;
    }

    public boolean getWithComments() {
        return this.withComments;
    }

    public Node getSubTree() throws IOException, SAXException {
        InputStream is;
        if (this.subTree == null && (is = this.getOctetStream()) != null) {
            this.subTree = XMLUtils.createDocBuilder().parse(is);
            this.nodeSet = null;
        }
        return this.subTree;
    }

    public Set getNodeSet() throws IOException, SAXException, XPathException {
        if (this.nodeSet == null && this.getSubTree() != null) {
            this.nodeSet = XMLContainer.subtreeToNodeSet(this.subTree, this.withComments);
        }
        return this.nodeSet;
    }

    private void setOctets(byte[] octets) throws IOException {
        this.setOctetStream(new ByteArrayInputStream(octets));
    }

    private void setOctetStream(InputStream octetStream) throws IOException {
        this.octetStream = octetStream;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InputStream getOctetStream() throws IOException {
        if (this.octetStream != null) return this.octetStream;
        if (this.nodeSet != null || this.subTree != null) {
            try {
                if (this.nodeSet != null) {
                    this.setOctets(Canonicalizer.getInstance(true, false).canonicalize(this.nodeSet));
                    return this.octetStream;
                }
                if (this.subTree == null) return this.octetStream;
                this.setOctets(Canonicalizer.getInstance(true, false).canonicalize(this.subTree));
                return this.octetStream;
            }
            catch (CanonicalizationException ex) {
                throw new IOException(ex.toString());
            }
        } else {
            if (this.systemId == null) return this.octetStream;
            this.setOctetStream(new URL(XMLUtils.fixURL(this.systemId)).openConnection().getInputStream());
        }
        return this.octetStream;
    }

    public byte[] toByteArray() throws IOException {
        byte[] b = null;
        if (this.getOctetStream() != null) {
            b = XMLUtils.readBytes(this.octetStream);
        }
        return b;
    }

    public boolean octetsAvailable() {
        return this.octetStream != null;
    }

    public boolean nodeSetAvailable() {
        return this.nodeSet != null;
    }

    public boolean subTreeAvailable() {
        return this.subTree != null;
    }

    public static Set subtreeToNodeSet(Node node, boolean withComments) throws XPathException {
        String xp;
        boolean C14N_NS_FILTERED_OUT;
        if (node == null) {
            return null;
        }
        boolean bl = C14N_NS_FILTERED_OUT = System.getProperty("osdt.c14nNsFilteredOut") != null;
        if (node.getNodeType() == 9) {
            xp = C14N_NS_FILTERED_OUT ? "(//. | //@* | //namespace::*)" : "(//. | //@*)";
        } else {
            String string = xp = C14N_NS_FILTERED_OUT ? "(.//. | .//@* | .//namespace::*)" : "(.//. | .//@*)";
        }
        if (!withComments) {
            xp = xp + "[not(self::comment())]";
        }
        List nodeList = null;
        try {
            DOMXPath xpath = new DOMXPath(xp);
            nodeList = xpath.selectNodes((Object)node);
        }
        catch (JaxenException ex) {
            throw new XPathException(ex);
        }
        LinkedHashSet nodeSet = new LinkedHashSet(nodeList);
        return nodeSet;
    }

    public static ArrayList subtreeToNodeList(Node node, boolean withComments, boolean sortAttribs) {
        ArrayList output = new ArrayList();
        XMLContainer.subtreeToNodeList(node, output, withComments, sortAttribs);
        return output;
    }

    private static void subtreeToNodeList(Node node, List output, boolean withComments, boolean sortAttribs) {
        if (node == null) {
            return;
        }
        output.add(node);
        NamedNodeMap attrs = node.getAttributes();
        if (attrs != null) {
            ArrayList<NamespaceNode> nsList = new ArrayList<NamespaceNode>();
            ArrayList<Attr> attrList = new ArrayList<Attr>();
            int size = attrs.getLength();
            for (int i = 0; i < size; ++i) {
                Attr attr = (Attr)attrs.item(i);
                if (attr.getNodeName().equals("xmlns") || attr.getNodeName().startsWith("xmlns:")) {
                    String prefix = attr.getNodeName().equals("xmlns") ? "" : attr.getNodeName().substring("xmlns:".length());
                    nsList.add(new NamespaceNode(node, prefix, attr.getNodeValue()));
                    continue;
                }
                attrList.add(attr);
            }
            output.addAll(nsList);
            output.addAll(attrList);
        }
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() == 8 && !withComments) continue;
            XMLContainer.subtreeToNodeList(child, output, withComments, sortAttribs);
        }
    }

    public void setUserData(Object userData) {
        this.userData = userData;
    }

    public Object getUserData() {
        return this.userData;
    }

    static {
        DSIGInitializer.initialize();
        ENCInitializer.initialize();
    }
}

