/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.util;

import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import java.util.HashMap;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.util.OIDManager;
import oracle.security.xmlsec.c14n.ExclusiveC14N;
import oracle.security.xmlsec.c14n.ExclusiveC14NWithComments;
import oracle.security.xmlsec.c14n.StreamingC14NImpl;
import oracle.security.xmlsec.c14n.XMLC14N;
import oracle.security.xmlsec.c14n.XMLC14NWithComments;
import oracle.security.xmlsec.dsig.XSManifest;
import oracle.security.xmlsec.dsig.XSObject;
import oracle.security.xmlsec.dsig.XSSigProperties;
import oracle.security.xmlsec.enc.XEEncryptedKey;
import oracle.security.xmlsec.enc.XEEncryptionProperties;
import oracle.security.xmlsec.keys.DHAgreementMethod;
import oracle.security.xmlsec.keys.DHKeyValue;
import oracle.security.xmlsec.keys.DSAKeyValue;
import oracle.security.xmlsec.keys.DerivedKey;
import oracle.security.xmlsec.keys.ECDSAKeyValue;
import oracle.security.xmlsec.keys.ECKeyValue;
import oracle.security.xmlsec.keys.KeyName;
import oracle.security.xmlsec.keys.MgmtData;
import oracle.security.xmlsec.keys.PGPData;
import oracle.security.xmlsec.keys.RSAKeyValue;
import oracle.security.xmlsec.keys.RawX509Cert;
import oracle.security.xmlsec.keys.RetrievalMethod;
import oracle.security.xmlsec.keys.SPKIData;
import oracle.security.xmlsec.keys.X509Data;
import oracle.security.xmlsec.transform.Base64Decoder;
import oracle.security.xmlsec.transform.C14NTransform;
import oracle.security.xmlsec.transform.C14NWithCommentsTransform;
import oracle.security.xmlsec.transform.DecryptTransform;
import oracle.security.xmlsec.transform.EnvelopedSigTransform;
import oracle.security.xmlsec.transform.ExcC14NTransform;
import oracle.security.xmlsec.transform.ExcC14NWithCommentsTransform;
import oracle.security.xmlsec.transform.XPathFilter;
import oracle.security.xmlsec.transform.XPathFilter2;
import oracle.security.xmlsec.transform.XSLTTransform;

public class URIManager {
    public static final String DIGEST_KEY = "messageDigest";
    public static final String CIPHER_KEY = "cipher";
    public static final String USE_CIPHER_KEY = "useCipher";
    public static final String SIGNATURE_KEY = "signature";
    public static final String USE_SIGNATURE_KEY = "useSignature";
    public static final String CANONICALIZER_KEY = "canonicalizer";
    public static final String TRANSFORMER_KEY = "transformer";
    public static final String KEY_INFO_KEY = "keyInfo";
    public static final String DATA_OBJECT_KEY = "referenceTarget";
    public static final int TRAILER_FIELD_BC = 1;
    private HashMap<String, ASN1ObjectID> oidMap = new HashMap();
    private HashMap<String, String> algNameMap = new HashMap();
    private HashMap<String, Integer> keySizeMap = new HashMap();
    private HashMap<String, HashMap<String, Class>> classMap = new HashMap();
    private HashMap<String, PSSParameterSpec> rsaPssAlgParamMap = new HashMap();
    private static URIManager uriMgr = new URIManager(true);

    private URIManager() {
        this(true);
    }

    private URIManager(boolean defaultMappings) {
        if (defaultMappings) {
            this.mapDefaults();
        }
    }

    public static URIManager getURIManager() {
        return uriMgr;
    }

    public ASN1ObjectID mapOID(String uri, ASN1ObjectID oid) {
        return this.oidMap.put(uri, oid);
    }

    public String mapJCEAlgorithm(String uri, String algorithm) {
        return this.algNameMap.put(uri, algorithm);
    }

    public String mapJCEKeySize(String uri, int keySize) {
        Integer oldKeySize = this.keySizeMap.put(uri, new Integer(keySize));
        return oldKeySize == null ? null : Integer.toString(oldKeySize);
    }

    public ASN1ObjectID getOID(String uri) {
        return this.oidMap.get(uri);
    }

    public String getJCEAlgorithm(String uri) {
        return this.algNameMap.get(uri);
    }

    public int getJCEKeySize(String uri) {
        Integer keySize = this.keySizeMap.get(uri);
        return keySize != null ? keySize : -1;
    }

    public Class mapClass(String uri, String key, Class c) {
        HashMap<String, Class<Object>> h = this.classMap.get(key);
        if (h == null) {
            h = new HashMap();
        }
        Class old = h.put(uri, c);
        this.classMap.put(key, h);
        return old;
    }

    public Class getClassForURI(String uri, String key) throws ClassNotFoundException {
        ASN1ObjectID oid = this.getOID(uri);
        if (oid != null) {
            return OIDManager.getOIDManager().getMapping(oid, key);
        }
        HashMap<String, Class> h = this.classMap.get(key);
        if (h != null) {
            return h.get(uri);
        }
        return null;
    }

    public PSSParameterSpec mapRsaPssParams(String uri, PSSParameterSpec param) {
        return this.rsaPssAlgParamMap.put(uri, param);
    }

    public String getRsaPssAlgorithm(String uri) {
        String alg = null;
        if (this.getRsaPssParams(uri) != null) {
            alg = "RSASSA-PSS";
        }
        return alg;
    }

    public PSSParameterSpec getRsaPssParams(String uri) {
        return this.rsaPssAlgParamMap.get(uri);
    }

    private void mapDefaults() {
        this.mapOID("http://www.w3.org/2000/09/xmldsig#sha1", AlgID.sha1.getOID());
        this.mapOID("http://www.w3.org/2001/04/xmldsig-more#md5", AlgID.md5.getOID());
        this.mapOID("http://www.w3.org/2000/09/xmldsig#dsa-sha1", AlgID.dsaWithSHA1.getOID());
        this.mapOID("http://www.w3.org/2000/09/xmldsig#rsa-sha1", AlgID.sha_1WithRSAEncryption.getOID());
        this.mapOID("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", AlgID.sha256WithRSAEncryption.getOID());
        this.mapOID("http://www.w3.org/2000/09/xmldsig#hmac-sha1", AlgID.hmacSHA.getOID());
        this.mapOID("http://www.w3.org/2001/04/xmldsig-more#hmac-md5", AlgID.hmacMD5.getOID());
        if (System.getProperty("osdt.useOldC14n") != null) {
            this.mapClass("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", CANONICALIZER_KEY, XMLC14N.class);
            this.mapClass("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments", CANONICALIZER_KEY, XMLC14NWithComments.class);
            this.mapClass("http://www.w3.org/2001/10/xml-exc-c14n#", CANONICALIZER_KEY, ExclusiveC14N.class);
            this.mapClass("http://www.w3.org/2001/10/xml-exc-c14n#WithComments", CANONICALIZER_KEY, ExclusiveC14NWithComments.class);
        } else {
            this.mapClass("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", CANONICALIZER_KEY, StreamingC14NImpl.StreamingInclusiveC14NImpl.class);
            this.mapClass("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments", CANONICALIZER_KEY, StreamingC14NImpl.StreamingInclusiveCommentsC14NImpl.class);
            this.mapClass("http://www.w3.org/2001/10/xml-exc-c14n#", CANONICALIZER_KEY, StreamingC14NImpl.StreamingExclusiveC14NImpl.class);
            this.mapClass("http://www.w3.org/2001/10/xml-exc-c14n#WithComments", CANONICALIZER_KEY, StreamingC14NImpl.StreamingExclusiveCommentsC14NImpl.class);
            this.mapClass("http://www.w3.org/2006/12/xml-c14n11", CANONICALIZER_KEY, StreamingC14NImpl.StreamingInclusiveC14N11Impl.class);
            this.mapClass("http://www.w3.org/2006/12/xml-c14n11#WithComments", CANONICALIZER_KEY, StreamingC14NImpl.StreamingInclusiveCommentsC14N11Impl.class);
        }
        this.mapClass("http://www.w3.org/2000/09/xmldsig#base64", TRANSFORMER_KEY, Base64Decoder.class);
        this.mapClass("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", TRANSFORMER_KEY, C14NTransform.class);
        this.mapClass("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments", TRANSFORMER_KEY, C14NWithCommentsTransform.class);
        this.mapClass("http://www.w3.org/2006/12/xml-c14n11", TRANSFORMER_KEY, C14NTransform.C14N11Transform.class);
        this.mapClass("http://www.w3.org/2006/12/xml-c14n11#WithComments", TRANSFORMER_KEY, C14NWithCommentsTransform.C14N11WithCommentsTransform.class);
        this.mapClass("http://www.w3.org/2001/10/xml-exc-c14n#", TRANSFORMER_KEY, ExcC14NTransform.class);
        this.mapClass("http://www.w3.org/2001/10/xml-exc-c14n#WithComments", TRANSFORMER_KEY, ExcC14NWithCommentsTransform.class);
        this.mapClass("http://www.w3.org/TR/1999/REC-xpath-19991116", TRANSFORMER_KEY, XPathFilter.class);
        this.mapClass("http://www.w3.org/2002/06/xmldsig-filter2", TRANSFORMER_KEY, XPathFilter2.class);
        this.mapClass("http://www.w3.org/TR/1999/REC-xslt-19991116", TRANSFORMER_KEY, XSLTTransform.class);
        this.mapClass("http://www.w3.org/2000/09/xmldsig#enveloped-signature", TRANSFORMER_KEY, EnvelopedSigTransform.class);
        this.mapClass("http://www.w3.org/2000/09/xmldsig-more#KeyName", KEY_INFO_KEY, KeyName.class);
        this.mapClass("http://www.w3.org/2000/09/xmldsig#DSAKeyValue", KEY_INFO_KEY, DSAKeyValue.class);
        this.mapClass("http://www.w3.org/2000/09/xmldsig#RSAKeyValue", KEY_INFO_KEY, RSAKeyValue.class);
        this.mapClass("http://www.w3.org/2000/09/xmldsig-more#RetrievalMethod", KEY_INFO_KEY, RetrievalMethod.class);
        this.mapClass("http://www.w3.org/2000/09/xmldsig#X509Data", KEY_INFO_KEY, X509Data.class);
        this.mapClass("http://www.w3.org/2000/09/xmldsig#PGPData", KEY_INFO_KEY, PGPData.class);
        this.mapClass("http://www.w3.org/2000/09/xmldsig#SPKIData", KEY_INFO_KEY, SPKIData.class);
        this.mapClass("http://www.w3.org/2000/09/xmldsig#MgmtData", KEY_INFO_KEY, MgmtData.class);
        this.mapClass("http://www.w3.org/2000/09/xmldsig#rawX509Certificate", KEY_INFO_KEY, RawX509Cert.class);
        this.mapClass("http://www.w3.org/2000/09/xmldsig#Object", DATA_OBJECT_KEY, XSObject.class);
        this.mapClass("http://www.w3.org/2000/09/xmldsig#SignatureProperties", DATA_OBJECT_KEY, XSSigProperties.class);
        this.mapClass("http://www.w3.org/2000/09/xmldsig#Manifest", DATA_OBJECT_KEY, XSManifest.class);
        this.mapOID("http://www.w3.org/2001/04/xmlenc#tripledes-cbc", AlgID.DES_EDE3_CBC.getOID());
        this.mapOID("http://www.w3.org/2001/04/xmlenc#aes128-cbc", AlgID.aes128_CBC.getOID());
        this.mapOID("http://www.w3.org/2001/04/xmlenc#aes192-cbc", AlgID.aes192_CBC.getOID());
        this.mapOID("http://www.w3.org/2001/04/xmlenc#aes256-cbc", AlgID.aes256_CBC.getOID());
        this.mapOID("http://www.w3.org/2001/04/xmlenc#rsa-1_5", AlgID.rsaWithV15Encoding.getOID());
        this.mapOID("http://www.w3.org/2001/04/xmlenc#kw-tripledes", new ASN1ObjectID(ASN1Utils.pkcsID, 9, 16, 3, 6));
        this.mapOID("http://www.w3.org/2001/04/xmlenc#dh", AlgID.dh.getOID());
        this.mapOID("http://www.w3.org/2001/04/xmlenc#sha256", AlgID.sha_256.getOID());
        this.mapOID("http://www.w3.org/2001/04/xmlenc#sha512", AlgID.sha_512.getOID());
        this.mapOID("http://www.w3.org/2001/04/xmldsig-more#sha384", AlgID.sha_384.getOID());
        this.mapClass("http://www.w3.org/2002/07/decrypt#XML", TRANSFORMER_KEY, DecryptTransform.class);
        this.mapClass("http://www.w3.org/2002/07/decrypt#Binary", TRANSFORMER_KEY, DecryptTransform.class);
        this.mapClass("http://www.w3.org/2001/04/xmlenc#EncryptedKey", KEY_INFO_KEY, XEEncryptedKey.class);
        this.mapClass("http://www.w3.org/2001/04/xmlenc#dh", KEY_INFO_KEY, DHAgreementMethod.class);
        this.mapClass("http://www.w3.org/2001/04/xmlenc#DHKeyValue", KEY_INFO_KEY, DHKeyValue.class);
        this.mapClass("http://www.w3.org/2009/xmldsig11#ECKeyValue", KEY_INFO_KEY, ECKeyValue.class);
        this.mapClass("http://www.w3.org/2001/04/xmldsig-more#ECDSAKeyValue", KEY_INFO_KEY, ECDSAKeyValue.class);
        this.mapClass("http://www.w3.org/2009/xmlenc11#DerivedKey", KEY_INFO_KEY, DerivedKey.class);
        this.mapClass("http://www.w3.org/2001/04/xmlenc#EncryptionProperties", DATA_OBJECT_KEY, XEEncryptionProperties.class);
        this.mapJCEAlgorithm("http://www.w3.org/2001/04/xmlenc#tripledes-cbc", "DESede/CBC/NoPadding");
        this.mapJCEAlgorithm("http://www.w3.org/2001/04/xmlenc#aes128-cbc", "AES/CBC/NoPadding");
        this.mapJCEAlgorithm("http://www.w3.org/2001/04/xmlenc#aes192-cbc", "AES/CBC/NoPadding");
        this.mapJCEAlgorithm("http://www.w3.org/2001/04/xmlenc#aes256-cbc", "AES/CBC/NoPadding");
        this.mapJCEAlgorithm("http://www.w3.org/2009/xmlenc11#aes128-gcm", "AES/GCM/NoPadding");
        this.mapJCEAlgorithm("http://www.w3.org/2009/xmlenc11#aes192-gcm", "AES/GCM/NoPadding");
        this.mapJCEAlgorithm("http://www.w3.org/2009/xmlenc11#aes256-gcm", "AES/GCM/NoPadding");
        this.mapJCEKeySize("http://www.w3.org/2001/04/xmlenc#tripledes-cbc", 168);
        this.mapJCEKeySize("http://www.w3.org/2001/04/xmlenc#aes128-cbc", 128);
        this.mapJCEKeySize("http://www.w3.org/2001/04/xmlenc#aes192-cbc", 192);
        this.mapJCEKeySize("http://www.w3.org/2001/04/xmlenc#aes256-cbc", 256);
        this.mapJCEKeySize("http://www.w3.org/2009/xmlenc11#aes128-gcm", 128);
        this.mapJCEKeySize("http://www.w3.org/2009/xmlenc11#aes192-gcm", 192);
        this.mapJCEKeySize("http://www.w3.org/2009/xmlenc11#aes256-gcm", 256);
        this.mapJCEAlgorithm("http://www.w3.org/2001/04/xmlenc#rsa-1_5", "RSA/ECB/PKCS1Padding");
        this.mapJCEAlgorithm("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p", "RSA/ECB/OAEPWithSHA1AndMGF1Padding");
        this.mapJCEAlgorithm("http://www.w3.org/2009/xmlenc11#rsa-oaep", "RSA/ECB/OAEPWithSHA1AndMGF1Padding");
        this.mapJCEAlgorithm("http://www.w3.org/2000/09/xmldsig#sha1", "SHA-1");
        this.mapJCEAlgorithm("http://www.w3.org/2001/04/xmldsig-more#md5", "MD5");
        this.mapJCEAlgorithm("http://www.w3.org/2001/04/xmlenc#sha256", "SHA-256");
        this.mapJCEAlgorithm("http://www.w3.org/2001/04/xmlenc#sha512", "SHA-512");
        this.mapJCEAlgorithm("http://www.w3.org/2001/04/xmldsig-more#sha384", "SHA-384");
        this.mapJCEAlgorithm("http://www.w3.org/2000/09/xmldsig#dsa-sha1", "SHA1withDSA");
        this.mapJCEAlgorithm("http://www.w3.org/2000/09/xmldsig#rsa-sha1", "SHA1withRSA");
        this.mapJCEAlgorithm("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", "SHA256withRSA");
        this.mapJCEAlgorithm("http://www.w3.org/2001/04/xmldsig-more#rsa-sha384", "SHA384withRSA");
        this.mapJCEAlgorithm("http://www.w3.org/2001/04/xmldsig-more#rsa-sha512", "SHA512withRSA");
        this.mapJCEAlgorithm("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1", "SHA1withECDSA");
        this.mapJCEAlgorithm("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha224", "SHA224withECDSA");
        this.mapJCEAlgorithm("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256", "SHA256withECDSA");
        this.mapJCEAlgorithm("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha384", "SHA384withECDSA");
        this.mapJCEAlgorithm("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512", "SHA512withECDSA");
        this.mapJCEAlgorithm("http://www.w3.org/2000/09/xmldsig#hmac-sha1", "HmacSHA1");
        this.mapJCEAlgorithm("http://www.w3.org/2001/04/xmldsig-more#hmac-md5", "HmacMD5");
        this.mapJCEAlgorithm("http://www.w3.org/2001/04/xmldsig-more#hmac-sha256", "HmacSHA256");
        this.mapJCEAlgorithm("http://www.w3.org/2001/04/xmldsig-more#hmac-sha384", "HmacSHA384");
        this.mapJCEAlgorithm("http://www.w3.org/2001/04/xmldsig-more#hmac-sha512", "HmacSHA512");
        this.mapJCEAlgorithm("http://www.w3.org/2001/04/xmlenc#dh", "DiffieHellman");
        this.mapJCEAlgorithm("http://www.w3.org/2001/04/xmlenc#kw-aes128", "AES");
        this.mapJCEAlgorithm("http://www.w3.org/2001/04/xmlenc#kw-aes192", "AES");
        this.mapJCEAlgorithm("http://www.w3.org/2001/04/xmlenc#kw-aes256", "AES");
        this.mapJCEAlgorithm("http://www.w3.org/2001/04/xmlenc#kw-tripledes", "DESede");
        this.mapJCEKeySize("http://www.w3.org/2001/04/xmlenc#kw-aes128", 128);
        this.mapJCEKeySize("http://www.w3.org/2001/04/xmlenc#kw-aes192", 192);
        this.mapJCEKeySize("http://www.w3.org/2001/04/xmlenc#kw-aes256", 256);
        this.mapJCEKeySize("http://www.w3.org/2001/04/xmlenc#kw-tripledes", 168);
        this.mapRsaPssParams("http://www.w3.org/2007/05/xmldsig-more#sha1-rsa-MGF1", new PSSParameterSpec("SHA-1", "MGF1", MGF1ParameterSpec.SHA1, 20, 1));
        this.mapRsaPssParams("http://www.w3.org/2007/05/xmldsig-more#sha256-rsa-MGF1", new PSSParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA256, 32, 1));
        this.mapRsaPssParams("http://www.w3.org/2007/05/xmldsig-more#sha384-rsa-MGF1", new PSSParameterSpec("SHA-384", "MGF1", MGF1ParameterSpec.SHA384, 48, 1));
        this.mapRsaPssParams("http://www.w3.org/2007/05/xmldsig-more#sha512-rsa-MGF1", new PSSParameterSpec("SHA-512", "MGF1", MGF1ParameterSpec.SHA512, 64, 1));
    }
}

