/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.transform;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.spec.AlgorithmParameterSpec;
import javax.xml.crypto.Data;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.OctetStreamData;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.TransformException;
import javax.xml.crypto.dsig.TransformService;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.xmlsec.dsig.JSR105Util;
import oracle.security.xmlsec.dsig.ReferenceException;
import oracle.security.xmlsec.dsig.XSAlgorithmIdentifier;
import oracle.security.xmlsec.transform.TransformationException;
import oracle.security.xmlsec.transform.XSTransformer;
import oracle.security.xmlsec.util.XMLContainer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XSTransformerAdapter
extends TransformService {
    XSTransformer tr;

    @Override
    public void init(TransformParameterSpec params) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("Not supported");
    }

    @Override
    public void init(XMLStructure parent, XMLCryptoContext context) throws InvalidAlgorithmParameterException {
        Element transformElem = (Element)((DOMStructure)parent).getNode();
        try {
            this.tr = XSTransformer.getInstance(new XSAlgorithmIdentifier(transformElem));
        }
        catch (AlgorithmIdentifierException ex) {
            InvalidAlgorithmParameterException ex1 = new InvalidAlgorithmParameterException("Unrecognized algorithm");
            ex1.initCause(ex);
            throw ex1;
        }
    }

    @Override
    public void marshalParams(XMLStructure parent, XMLCryptoContext context) throws MarshalException {
        Element transformElem = (Element)((DOMStructure)parent).getNode();
        Document doc = transformElem.getOwnerDocument();
        Element oldTransformElem = this.tr.transform.getElement();
        if (transformElem.getOwnerDocument() != oldTransformElem.getOwnerDocument()) {
            oldTransformElem = (Element)transformElem.getOwnerDocument().importNode(oldTransformElem, true);
            for (Node nd = oldTransformElem.getFirstChild(); nd != null; nd = nd.getNextSibling()) {
                transformElem.appendChild(nd);
            }
        } else {
            for (Node nd = oldTransformElem.getFirstChild(); nd != null; nd = nd.getNextSibling()) {
                transformElem.appendChild(nd.cloneNode(true));
            }
        }
    }

    @Override
    public AlgorithmParameterSpec getParameterSpec() {
        return null;
    }

    @Override
    public Data transform(Data data, XMLCryptoContext context, OutputStream os) throws TransformException {
        try {
            int n;
            XMLContainer source = data instanceof JSR105Util.OraNodeSetData ? ((JSR105Util.OraNodeSetData)data).getXMLContainer() : (data instanceof OctetStreamData ? new XMLContainer(((OctetStreamData)data).getOctetStream()) : JSR105Util.convertFromJSR105(data));
            XMLContainer result = this.tr.transform(source);
            InputStream is = result.getOctetStream();
            byte[] buf = new byte[1024];
            do {
                if ((n = is.read(buf)) <= 0) continue;
                os.write(buf, 0, n);
            } while (n != -1);
        }
        catch (IOException ex) {
            throw new TransformException(ex);
        }
        catch (TransformationException ex) {
            throw new TransformException(ex);
        }
        return null;
    }

    @Override
    public Data transform(Data data, XMLCryptoContext context) throws TransformException {
        try {
            XMLContainer source = data instanceof JSR105Util.OraNodeSetData ? ((JSR105Util.OraNodeSetData)data).getXMLContainer() : (data instanceof OctetStreamData ? new XMLContainer(((OctetStreamData)data).getOctetStream()) : JSR105Util.convertFromJSR105(data));
            XMLContainer result = this.tr.transform(source);
            return JSR105Util.convertToJSR105(result);
        }
        catch (IOException ex) {
            throw new TransformException(ex);
        }
        catch (ReferenceException ex) {
            throw new TransformException(ex);
        }
        catch (TransformationException ex) {
            throw new TransformException(ex);
        }
    }

    @Override
    public boolean isFeatureSupported(String arg0) {
        return false;
    }
}

