/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.transform;

import java.io.IOException;
import java.util.Set;
import oracle.security.xmlsec.dsig.XSAlgorithmIdentifier;
import oracle.security.xmlsec.transform.NodeFilterTransform;
import oracle.security.xmlsec.transform.TransformationException;
import oracle.security.xmlsec.transform.XPathFilter;
import oracle.security.xmlsec.transform.XSTransformer;
import oracle.security.xmlsec.util.XMLContainer;
import oracle.security.xmlsec.util.XMLUtils;
import oracle.security.xmlsec.util.XPathException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class EnvelopedSigTransform
extends XSTransformer
implements NodeFilterTransform {
    private Element sigElement;
    private static final String XPATH = "count(ancestor-or-self::dsig:Signature | here()/ancestor::dsig:Signature[1]) > count(ancestor-or-self::dsig:Signature)";

    public EnvelopedSigTransform(XSAlgorithmIdentifier trans) {
        super(trans);
        Element parent;
        if (!"http://www.w3.org/2000/09/xmldsig#enveloped-signature".equals(trans.getAlgorithm())) {
            throw new IllegalArgumentException("Enveloped Signature Transform required");
        }
        if (trans.getParameters().getLength() != 0) {
            throw new IllegalArgumentException("Illegal Transform parameter");
        }
        for (parent = (Element)this.getTransform().getNode().getParentNode(); !(parent == null || "http://www.w3.org/2000/09/xmldsig#".equals(parent.getNamespaceURI()) && "Signature".equals(parent.getLocalName())); parent = (Element)parent.getParentNode()) {
        }
        this.sigElement = parent;
    }

    @Override
    public String getAlgorithmURI() {
        return "http://www.w3.org/2000/09/xmldsig#enveloped-signature";
    }

    @Override
    public XMLContainer transform(XMLContainer source) throws TransformationException {
        Set nodeSet = null;
        try {
            nodeSet = source.getNodeSet();
        }
        catch (IOException ex) {
            throw new TransformationException(ex);
        }
        catch (SAXException ex) {
            throw new TransformationException(ex);
        }
        catch (XPathException ex) {
            throw new TransformationException(ex);
        }
        Set result = null;
        if (nodeSet != null && nodeSet.size() != 0) {
            Node firstNode = (Node)nodeSet.iterator().next();
            Document doc = XMLUtils.getOwnerDocument(firstNode);
            if (doc != this.transform.getOwnerDocument()) {
                throw new TransformationException("Transform must be applied to parent document node-set");
            }
            Element nsNode = doc.createElement("_EnvelopedSignatureNamespaceNode_" + XMLUtils.randomName());
            nsNode.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:dsig", "http://www.w3.org/2000/09/xmldsig#");
            Node xpNode = this.transform.getNode().getAttributes().item(0);
            if (xpNode == null) {
                throw new TransformationException("XPath expression node not found");
            }
            try {
                result = XPathFilter.applyXPath(XPATH, nodeSet, nsNode, xpNode);
            }
            catch (XPathException ex) {
                throw new TransformationException(ex);
            }
        }
        if (result != null) {
            return new XMLContainer(result);
        }
        return new XMLContainer();
    }

    @Override
    public int accept(Node node) throws TransformationException {
        if (node == this.sigElement) {
            return 4;
        }
        return 1;
    }
}

