/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.soap.v12;

import java.util.ArrayList;
import java.util.List;
import oracle.security.xmlsec.soap.v12.SOAPFault;
import oracle.security.xmlsec.soap.v12.SOAPFaultCode;
import oracle.security.xmlsec.util.SOAPInitializer;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SOAPEnvelope
extends XMLElement {
    private static final String[] nsURIs = new String[]{"http://www.w3.org/2003/05/soap-envelope", "http://www.w3.org/2003/05/soap-envelope"};
    private static final String[] localNames = new String[]{"Header", "Body"};

    public SOAPEnvelope(Document owner) throws DOMException {
        super(owner, "http://www.w3.org/2003/05/soap-envelope", "Envelope");
        this.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://www.w3.org/2003/05/soap-envelope");
        this.addNSPrefixAttrDefault("http://www.w3.org/2003/05/soap-envelope");
        Element body = owner.createElementNS("http://www.w3.org/2003/05/soap-envelope", "Body");
        XMLUtils.copyNSPrefix((Element)this.node, body);
        XMLUtils.insertChild((Element)this.node, body, nsURIs, localNames);
    }

    public SOAPEnvelope(Element env) throws DOMException {
        super(env);
    }

    public SOAPEnvelope(Element env, String systemId) throws DOMException {
        super(env, systemId);
    }

    public void addHeaderElement(Element headerElement) throws DOMException {
        Document doc = this.getOwnerDocument();
        Element header = null;
        NodeList list = this.getChildElementsByTagNameNS("http://www.w3.org/2003/05/soap-envelope", "Header");
        if (list.getLength() != 0) {
            header = (Element)list.item(0);
        } else {
            header = doc.createElementNS("http://www.w3.org/2003/05/soap-envelope", "Header");
            XMLUtils.copyNSPrefix((Element)this.node, header);
            XMLUtils.insertChild((Element)this.node, header, nsURIs, localNames);
        }
        header.appendChild(headerElement);
    }

    public void addHeaderElement(XMLElement headerElement) throws DOMException {
        this.addHeaderElement((Element)headerElement.getNode());
    }

    public void addBodyElement(Element bodyElement) throws DOMException {
        Document doc = this.getOwnerDocument();
        Element body = null;
        NodeList list = this.getChildElementsByTagNameNS("http://www.w3.org/2003/05/soap-envelope", "Body");
        if (list.getLength() != 0) {
            body = (Element)list.item(0);
        } else {
            body = doc.createElementNS("http://www.w3.org/2003/05/soap-envelope", "Body");
            XMLUtils.copyNSPrefix((Element)this.node, body);
            XMLUtils.insertChild((Element)this.node, body, nsURIs, localNames);
        }
        if (!doc.equals(bodyElement.getOwnerDocument())) {
            bodyElement = (Element)doc.importNode(bodyElement, true);
        }
        body.appendChild(bodyElement);
    }

    public void addBodyElement(XMLElement bodyElement) throws DOMException {
        this.addBodyElement((Element)bodyElement.getNode());
    }

    public SOAPFault addSOAPFault(String code, String reasonText, String reasonLang) throws DOMException {
        SOAPFault fault = this.addSOAPFault();
        SOAPFaultCode fc = new SOAPFaultCode(this.getOwnerDocument());
        fc.setValue(code, this.getPrefix());
        fault.setCode(fc);
        fault.addReasonText(reasonText, reasonLang);
        return fault;
    }

    public SOAPFault addSOAPFault() throws DOMException {
        XMLUtils.removeChildren((Element)this.node, "http://www.w3.org/2003/05/soap-envelope", "Value");
        SOAPFault fault = new SOAPFault(this.getOwnerDocument());
        XMLUtils.copyNSPrefix((Element)this.node, (Element)fault.getNode());
        fault.setSystemId(this.getSystemId());
        this.addBodyElement(fault);
        return fault;
    }

    public Element getHeader() {
        NodeList list = this.getChildElementsByTagNameNS("http://www.w3.org/2003/05/soap-envelope", "Header");
        if (list.getLength() > 0) {
            return (Element)list.item(0);
        }
        return null;
    }

    public List getHeaderElements() {
        return this.getHeaderElements(null);
    }

    public List getHeaderElements(String role) {
        ArrayList<Element> hList = new ArrayList<Element>();
        Element header = this.getHeader();
        if (header != null) {
            NodeList nList = XMLElement.getChildElementsByTagName(header, "*");
            int len = nList.getLength();
            for (int i = 0; i < len; ++i) {
                Element h = (Element)nList.item(i);
                String roleAttr = h.getAttributeNS("http://www.w3.org/2003/05/soap-envelope", "role");
                if (role == null || role.equals(roleAttr)) {
                    hList.add(h);
                    continue;
                }
                if (!"http://www.w3.org/2003/05/soap-envelope/role/ultimateReceiver".equals(role) || roleAttr != null && roleAttr.length() != 0) continue;
                hList.add(h);
            }
        }
        return hList;
    }

    public List getHeaderElements(boolean mustUnderstand) {
        ArrayList<Element> hList = new ArrayList<Element>();
        Element header = this.getHeader();
        if (header != null) {
            NodeList nList = XMLElement.getChildElementsByTagName(header, "*");
            int len = nList.getLength();
            for (int i = 0; i < len; ++i) {
                Element h = (Element)nList.item(i);
                String muAttr = h.getAttributeNS("http://www.w3.org/2003/05/soap-envelope", "mustUnderstand");
                String string = muAttr = "1".equals(muAttr) || "true".equals(muAttr) ? "true" : "false";
                if (!muAttr.equals(Boolean.toString(mustUnderstand))) continue;
                hList.add(h);
            }
        }
        return hList;
    }

    public Element getBody() {
        NodeList list = this.getChildElementsByTagNameNS("http://www.w3.org/2003/05/soap-envelope", "Body");
        if (list.getLength() > 0) {
            return (Element)list.item(0);
        }
        return null;
    }

    public List getBodyElements() {
        ArrayList<Node> bList = new ArrayList<Node>();
        Element body = this.getBody();
        if (body != null) {
            NodeList nList = XMLElement.getChildElementsByTagName(body, "*");
            int len = nList.getLength();
            for (int i = 0; i < len; ++i) {
                bList.add(nList.item(i));
            }
        }
        return bList;
    }

    public List getBodyElementsByTagNameNS(String nsURI, String localName) {
        ArrayList<Node> bList = new ArrayList<Node>();
        Element body = this.getBody();
        if (body != null) {
            NodeList nList = XMLElement.getChildElementsByTagNameNS(body, nsURI, localName);
            int len = nList.getLength();
            for (int i = 0; i < len; ++i) {
                bList.add(nList.item(i));
            }
        }
        return bList;
    }

    public SOAPFault getSOAPFault() {
        NodeList sfs;
        Element body = this.getBody();
        if (body != null && (sfs = XMLElement.getChildElementsByTagNameNS(body, "http://www.w3.org/2003/05/soap-envelope", "Fault")).getLength() != 0) {
            return new SOAPFault((Element)sfs.item(0), this.systemId);
        }
        return null;
    }

    static {
        SOAPInitializer.initialize();
    }
}

