/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.keys.retrieval;

import java.io.IOException;
import java.io.InputStream;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1String;
import oracle.security.crypto.cert.GeneralName;
import oracle.security.crypto.cert.IssuerAndSerialNo;
import oracle.security.crypto.cert.PKCS12;
import oracle.security.crypto.cert.PKCS12Bag;
import oracle.security.crypto.cert.PKCS12CertBag;
import oracle.security.crypto.cert.PKCS12KeyBag;
import oracle.security.crypto.cert.PKCS12Safe;
import oracle.security.crypto.cert.PKCS12ShroudedKeyBag;
import oracle.security.crypto.cert.PKIX;
import oracle.security.crypto.cert.X500Name;
import oracle.security.crypto.cert.X509;
import oracle.security.crypto.cert.ext.SubjectAltNameExtension;
import oracle.security.crypto.cert.ext.SubjectKeyIDExtension;
import oracle.security.crypto.core.PrivateKey;
import oracle.security.crypto.util.CryptoUtils;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;
import oracle.security.xmlsec.keys.KeyInfoData;
import oracle.security.xmlsec.keys.KeyName;
import oracle.security.xmlsec.keys.X509Data;
import oracle.security.xmlsec.keys.retrieval.KeyRetrievalException;
import oracle.security.xmlsec.keys.retrieval.KeyRetriever;
import oracle.security.xmlsec.keys.retrieval.StorageAuthenticationException;
import oracle.security.xmlsec.keys.retrieval.StorageAuthenticator;

public class PKCS12KeyRetriever
extends KeyRetriever {
    private static final boolean debug = System.getProperty("xml.debug.p12") != null;
    private InputStream p12Stream;
    private PKCS12 pkcs12;

    public PKCS12KeyRetriever(InputStream p12Stream) throws IOException {
        this.p12Stream = p12Stream;
    }

    public PKCS12KeyRetriever(PKCS12 pkcs12) throws IOException {
        this.pkcs12 = pkcs12;
    }

    @Override
    public PublicKey retrievePublicKey(KeyInfoData keyInfo) throws KeyRetrievalException {
        this.doPasswordAuth();
        X509Certificate cert = this.retrieveCertificate(keyInfo);
        return cert != null ? cert.getPublicKey() : null;
    }

    @Override
    public X509Certificate retrieveCertificate(KeyInfoData keyInfo) throws KeyRetrievalException {
        this.doPasswordAuth();
        X509Certificate cert = null;
        String type = keyInfo.getType();
        if ("http://www.w3.org/2000/09/xmldsig-more#KeyName".equals(type)) {
            String name = ((KeyName)keyInfo).getName();
            if (name != null) {
                cert = this.getCertByName(name);
            }
        } else if ("http://www.w3.org/2000/09/xmldsig#X509Data".equals(type)) {
            cert = this.getCertByX509Data((X509Data)keyInfo);
        }
        return cert;
    }

    @Override
    public java.security.PrivateKey retrievePrivateKey(KeyInfoData keyInfo) throws KeyRetrievalException {
        PKCS12CertBag certBag;
        if (debug) {
            System.err.println("\n+++ PKCS12KeyRetriever.retrievePrivateKey():");
        }
        this.doPasswordAuth();
        PKCS12Bag bag = null;
        String name = null;
        byte[] kid = null;
        String type = keyInfo.getType();
        if ("http://www.w3.org/2000/09/xmldsig-more#KeyName".equals(type)) {
            kid = (name = ((KeyName)keyInfo).getName()) != null ? name.getBytes() : null;
            bag = this.getPKCS12Bag(name, kid);
            if (bag == null && (certBag = this.getCertBagByName(name)) != null) {
                name = certBag.getFriendlyName();
                kid = certBag.getLocalKeyID();
            }
        } else if ("http://www.w3.org/2000/09/xmldsig#X509Data".equals(type) && (certBag = this.getCertBagByX509Data((X509Data)keyInfo)) != null) {
            name = certBag.getFriendlyName();
            kid = certBag.getLocalKeyID();
        }
        if (debug) {
            System.err.println("KeyInfo.Type=" + type);
            System.err.println("name=" + name);
            System.err.println("kid=" + Utils.toHexString((byte[])kid));
        }
        if (bag == null) {
            bag = this.getPKCS12Bag(name, kid);
        }
        if (bag != null) {
            if (bag instanceof PKCS12ShroudedKeyBag) {
                PKCS12ShroudedKeyBag shroudedBag = (PKCS12ShroudedKeyBag)bag;
                return CryptoUtils.toJCEPrivateKey((PrivateKey)shroudedBag.getPrivateKey());
            }
            if (bag instanceof PKCS12KeyBag) {
                PKCS12KeyBag keyBag = (PKCS12KeyBag)bag;
                return CryptoUtils.toJCEPrivateKey((PrivateKey)keyBag.getPrivateKey());
            }
        }
        return null;
    }

    private void doPasswordAuth() throws StorageAuthenticationException {
        if (this.pkcs12 == null) {
            StorageAuthenticator auth = this.getAuthenticator();
            if (auth == null) {
                throw new StorageAuthenticationException("No authenticator set");
            }
            auth.getCredential();
            try {
                this.pkcs12 = new PKCS12(auth.getPassword(), this.p12Stream);
            }
            catch (IOException ex) {
                throw new StorageAuthenticationException(ex);
            }
        } else if (this.pkcs12.getPassword() == null) {
            StorageAuthenticator auth = this.getAuthenticator();
            if (auth == null) {
                throw new StorageAuthenticationException("No authenticator set");
            }
            auth.getCredential();
            this.pkcs12.setPassword(auth.getPassword());
        }
    }

    private PKCS12Bag getPKCS12Bag(String name, byte[] kid) {
        if (debug) {
            System.err.println("\n+++ PKCS12KeyRetriever.getPKCS12Bag():");
        }
        Vector safes = this.pkcs12.getAuthSafes();
        int x = safes.size();
        for (int i = 0; i < x; ++i) {
            PKCS12Safe safe = (PKCS12Safe)safes.elementAt(i);
            Vector bags = safe.getBags();
            int y = bags.size();
            for (int j = 0; j < y; ++j) {
                PKCS12Bag bag = (PKCS12Bag)bags.elementAt(j);
                if (debug) {
                    System.err.println("\nBagType=" + bag.getClass().getName());
                    System.err.println("FriendlyName=" + bag.getFriendlyName());
                    System.err.println("LocalKeyId=" + Utils.toHexString((byte[])bag.getLocalKeyID()));
                }
                if (name != null && name.equals(bag.getFriendlyName())) {
                    return bag;
                }
                if (kid == null || !Utils.areEqual((byte[])kid, (byte[])bag.getLocalKeyID())) continue;
                return bag;
            }
        }
        return null;
    }

    private X509Certificate getCertByX509Data(X509Data data) throws KeyRetrievalException {
        PKCS12CertBag certBag = this.getCertBagByX509Data(data);
        if (certBag != null) {
            X509 cert = certBag.getCert();
            try {
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                return (X509Certificate)cf.generateCertificate((InputStream)new UnsyncByteArrayInputStream(cert.getEncoded()));
            }
            catch (CertificateException ex) {
                throw new KeyRetrievalException(ex);
            }
        }
        return null;
    }

    private PKCS12CertBag getCertBagByX509Data(X509Data data) throws KeyRetrievalException {
        Vector names = data.getSubjectNames();
        Vector isnos = data.getIssuerSerials();
        Vector skids = data.getSubjectKeyIDs();
        Vector certs = null;
        try {
            certs = data.getCertificates();
        }
        catch (IOException ex) {
            throw new KeyRetrievalException(ex);
        }
        if (debug) {
            System.err.println("\n+++ PKCS12KeyRetriever.getCertBagByX509Data():");
            System.err.println("X509Data.certs:");
            int z = certs.size();
            for (int k = 0; k < z; ++k) {
                X509Certificate c = (X509Certificate)certs.elementAt(k);
                System.err.println("\n" + c);
            }
        }
        Vector safes = this.pkcs12.getAuthSafes();
        int x = safes.size();
        for (int i = 0; i < x; ++i) {
            PKCS12Safe safe = (PKCS12Safe)safes.elementAt(i);
            Vector bags = safe.getBags();
            int y = bags.size();
            for (int j = 0; j < y; ++j) {
                int k;
                int z;
                byte[] certSkid;
                PKCS12Bag bag = (PKCS12Bag)bags.elementAt(j);
                if (!(bag instanceof PKCS12CertBag)) continue;
                PKCS12CertBag certBag = (PKCS12CertBag)bag;
                X509 cert = null;
                try {
                    cert = new X509(certBag.getCert().getEncoded());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (debug) {
                    System.err.println("\nBagType=" + bag.getClass().getName());
                    System.err.println("FriendlyName=" + bag.getFriendlyName());
                    System.err.println("LocalKeyId=" + Utils.toHexString((byte[])bag.getLocalKeyID()));
                    System.err.println("subject=" + cert.getSubject());
                    System.err.println("issuer=" + cert.getIssuer());
                    System.err.println("serialNo=" + cert.getSerialNo());
                }
                IssuerAndSerialNo certIsno = new IssuerAndSerialNo(cert.getIssuer(), cert.getSerialNo());
                if (isnos.size() > 0) {
                    int z2 = isnos.size();
                    for (int k2 = 0; k2 < z2; ++k2) {
                        IssuerAndSerialNo isno = (IssuerAndSerialNo)isnos.elementAt(k2);
                        if (!isno.equals((Object)certIsno)) continue;
                        return certBag;
                    }
                    continue;
                }
                SubjectKeyIDExtension skidExt = (SubjectKeyIDExtension)cert.getExtension(PKIX.id_ce_subjectKeyIdentifier);
                byte[] byArray = certSkid = skidExt != null ? skidExt.getSubjectKeyID() : null;
                if (certSkid != null && skids.size() > 0) {
                    int z3 = skids.size();
                    for (int k3 = 0; k3 < z3; ++k3) {
                        byte[] skid = (byte[])skids.elementAt(k3);
                        if (!Utils.areEqual((byte[])certSkid, (byte[])skid)) continue;
                        return certBag;
                    }
                    continue;
                }
                X500Name subject = cert.getSubject();
                if (names.size() > 0) {
                    z = names.size();
                    for (k = 0; k < z; ++k) {
                        X500Name name = (X500Name)names.elementAt(k);
                        if (!name.equals((Object)subject)) continue;
                        return certBag;
                    }
                    continue;
                }
                z = certs.size();
                for (k = 0; k < z; ++k) {
                    boolean match;
                    X509Certificate jceCert = (X509Certificate)certs.elementAt(k);
                    X509 c = null;
                    try {
                        c = new X509(jceCert.getEncoded());
                    }
                    catch (IOException iOException) {
                    }
                    catch (CertificateEncodingException certificateEncodingException) {
                        // empty catch block
                    }
                    boolean bl = match = subject.equals((Object)c.getSubject()) && certIsno.equals((Object)new IssuerAndSerialNo(c.getIssuer(), c.getSerialNo()));
                    if (match) {
                        byte[] cSkid;
                        SubjectKeyIDExtension cSkidExt = (SubjectKeyIDExtension)c.getExtension(PKIX.id_ce_subjectKeyIdentifier);
                        byte[] byArray2 = cSkid = cSkidExt != null ? cSkidExt.getSubjectKeyID() : null;
                        if (certSkid != null) {
                            match = Utils.areEqual((byte[])certSkid, (byte[])cSkid);
                        }
                    }
                    if (!match) continue;
                    return certBag;
                }
            }
        }
        return null;
    }

    private PKCS12CertBag getCertBagByName(String name) throws KeyRetrievalException {
        Vector safes = this.pkcs12.getAuthSafes();
        int x = safes.size();
        for (int i = 0; i < x; ++i) {
            PKCS12Safe safe = (PKCS12Safe)safes.elementAt(i);
            Vector bags = safe.getBags();
            int y = bags.size();
            for (int j = 0; j < y; ++j) {
                PKCS12Bag bag = (PKCS12Bag)bags.elementAt(j);
                if (!(bag instanceof PKCS12CertBag)) continue;
                PKCS12CertBag certBag = (PKCS12CertBag)bag;
                X509 cert = certBag.getCert();
                X500Name subject = cert.getSubject();
                if (name.equals(subject.toString())) {
                    return certBag;
                }
                ASN1Object cn = subject.getAttributeValue(PKIX.id_at_commonName);
                if (cn != null && cn instanceof ASN1String && name.equals(((ASN1String)cn).getValue())) {
                    return certBag;
                }
                ASN1Object email = subject.getAttributeValue(PKIX.emailAddress);
                if (email != null && email instanceof ASN1String && name.equals(((ASN1String)email).getValue())) {
                    return certBag;
                }
                SubjectAltNameExtension subjAlt = (SubjectAltNameExtension)cert.getExtension(PKIX.id_ce_subjectAltName);
                if (subjAlt != null) {
                    Enumeration e = subjAlt.subjectAltName();
                    while (e.hasMoreElements()) {
                        ASN1Object em;
                        GeneralName gn = (GeneralName)e.nextElement();
                        if (!GeneralName.Type.RFC822_NAME.equals(gn.getType()) || (em = gn.getValue()) == null || !(em instanceof ASN1String) || !name.equals(((ASN1String)em).getValue())) continue;
                        return certBag;
                    }
                }
                if (name.equals(certBag.getFriendlyName())) {
                    return certBag;
                }
                if (!Utils.areEqual((byte[])name.getBytes(), (byte[])certBag.getLocalKeyID())) continue;
                return certBag;
            }
        }
        return null;
    }

    private X509Certificate getCertByName(String name) throws KeyRetrievalException {
        PKCS12CertBag certBag = this.getCertBagByName(name);
        if (certBag != null) {
            X509 cert = certBag.getCert();
            try {
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                return (X509Certificate)cf.generateCertificate((InputStream)new UnsyncByteArrayInputStream(cert.getEncoded()));
            }
            catch (CertificateException ex) {
                throw new KeyRetrievalException(ex);
            }
        }
        return null;
    }
}

