/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.keys;

import oracle.security.xmlsec.keys.ConcatKDFParams;
import oracle.security.xmlsec.keys.KeyDerivationParams;
import oracle.security.xmlsec.keys.PBKDF2params;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class KeyDerivationMethod
extends XMLElement {
    public KeyDerivationMethod(Document owner, String systemId) throws DOMException {
        super(owner, "http://www.w3.org/2009/xmlenc11#", "KeyDerivationMethod", systemId);
        this.addNSPrefixAttrDefault("http://www.w3.org/2009/xmlenc11#");
    }

    public KeyDerivationMethod(Document owner) throws DOMException {
        super(owner, "http://www.w3.org/2009/xmlenc11#", "KeyDerivationMethod");
        this.addNSPrefixAttrDefault("http://www.w3.org/2009/xmlenc11#");
    }

    public KeyDerivationMethod(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public KeyDerivationMethod(Element element) throws DOMException {
        super(element);
    }

    public String getAlgorithm() {
        return this.getAttribute("Algorithm");
    }

    public void setAlgorithm(String algorithm) {
        this.setAttribute("Algorithm", algorithm);
    }

    public KeyDerivationParams getKeyDerivationParams() {
        NodeList nList = this.getChildElementsByTagNameNS("http://www.w3.org/2009/xmlenc11#", "ConcatKDFParams");
        if (nList.getLength() > 0) {
            return new ConcatKDFParams((Element)nList.item(0));
        }
        nList = this.getChildElementsByTagNameNS("http://www.w3.org/2009/xmlenc11#", "PBKDF2-params");
        if (nList.getLength() > 0) {
            return new PBKDF2params((Element)nList.item(0));
        }
        return null;
    }

    public void setKeyDerivationParams(KeyDerivationParams params) {
        XMLUtils.removeAllChildren(this.getNode());
        this.getElement().appendChild(params.getElement());
        this.setAlgorithm(params.getType());
    }
}

