/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.keys;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import java.security.spec.InvalidKeySpecException;
import oracle.security.xmlsec.keys.ECDSAKeyValue;
import oracle.security.xmlsec.keys.KeyValueData;
import oracle.security.xmlsec.util.Base64;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ECKeyValue
extends XMLElement
implements KeyValueData {
    public ECKeyValue(Document owner, String systemId) throws DOMException {
        super(owner, "http://www.w3.org/2009/xmldsig11#", "ECKeyValue", systemId);
        this.addNSPrefixAttrDefault("http://www.w3.org/2009/xmldsig11#");
    }

    public ECKeyValue(Document owner) throws DOMException {
        super(owner, "http://www.w3.org/2009/xmldsig11#", "ECKeyValue");
        this.addNSPrefixAttrDefault("http://www.w3.org/2009/xmldsig11#");
    }

    public ECKeyValue(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public ECKeyValue(Element element) throws DOMException {
        super(element);
    }

    @Override
    public PublicKey getPublicKey() {
        ECParameterSpec ecSpec = this.getCurve();
        Element publicKeyElem = (Element)this.getChildElementsByTagNameNS("http://www.w3.org/2009/xmldsig11#", "PublicKey").item(0);
        byte[] keyBytes = Base64.fromBase64(XMLUtils.collectText(publicKeyElem));
        ECPoint w = ECKeyValue.octetStringToECPoint(keyBytes, ecSpec.getCurve());
        ECPublicKeySpec keySpec = new ECPublicKeySpec(w, this.getCurve());
        try {
            KeyFactory kf = KeyFactory.getInstance("ECDSA");
            return kf.generatePublic(keySpec);
        }
        catch (InvalidKeySpecException ex) {
            throw new IllegalArgumentException(ex);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public ECKeyValue(Document owner, ECPublicKey ecKey) {
        this(owner);
        Node nextChild = null;
        Node n = this.getFirstChild();
        while (n != null) {
            nextChild = n.getNextSibling();
            this.removeChild(n);
            n = nextChild;
        }
        EllipticCurve eCurve = ecKey.getParams().getCurve();
        for (String urn : ECDSAKeyValue.namedCurves.keySet()) {
            ECParameterSpec nc = ECDSAKeyValue.namedCurves.get(urn);
            if (eCurve.getField().getFieldSize() != nc.getCurve().getField().getFieldSize() || !eCurve.getField().equals(nc.getCurve().getField())) continue;
            Element namedCurve = this.getOwnerDocument().createElementNS("http://www.w3.org/2009/xmldsig11#", "NamedCurve");
            XMLUtils.copyNSPrefix((Element)this.node, namedCurve);
            this.appendChild(namedCurve);
            namedCurve.setAttribute("URI", urn);
            break;
        }
        Element publicKey = this.getOwnerDocument().createElementNS("http://www.w3.org/2009/xmldsig11#", "PublicKey");
        XMLUtils.copyNSPrefix((Element)this.node, publicKey);
        this.appendChild(publicKey);
        byte[] keyBytes = ECKeyValue.ecPointToOctetString(ecKey.getW(), ecKey.getParams().getCurve());
        publicKey.appendChild(this.getOwnerDocument().createTextNode(Base64.toBase64WithLFSeparator(keyBytes)));
    }

    @Override
    public String getType() {
        return "http://www.w3.org/2001/04/xmldsig-more#ECDSAKeyValue";
    }

    public ECParameterSpec getCurve() {
        Element namedCurve = (Element)this.getChildElementsByTagNameNS("http://www.w3.org/2009/xmldsig11#", "NamedCurve").item(0);
        String urn = namedCurve.getAttribute("URI");
        return ECDSAKeyValue.namedCurves.get(urn);
    }

    public static byte[] ecPointToOctetString(ECPoint p, EllipticCurve c) {
        int n = (c.getField().getFieldSize() + 7) / 8;
        byte[] encoded = new byte[1 + n * 2];
        encoded[0] = 4;
        System.arraycopy(ECKeyValue.bigintToBytes(p.getAffineX(), n), 0, encoded, 1, n);
        System.arraycopy(ECKeyValue.bigintToBytes(p.getAffineY(), n), 0, encoded, 1 + n, n);
        return encoded;
    }

    public static ECPoint octetStringToECPoint(byte[] encoded, EllipticCurve c) {
        byte[] xEnc = new byte[(encoded.length - 1) / 2];
        byte[] yEnc = new byte[(encoded.length - 1) / 2];
        System.arraycopy(encoded, 1, xEnc, 0, xEnc.length);
        System.arraycopy(encoded, xEnc.length + 1, yEnc, 0, yEnc.length);
        return new ECPoint(new BigInteger(1, xEnc), new BigInteger(1, yEnc));
    }

    private static byte[] bigintToBytes(BigInteger s, int qLength) {
        byte[] bytes = s.toByteArray();
        if (qLength < bytes.length) {
            byte[] tmp = new byte[qLength];
            System.arraycopy(bytes, bytes.length - tmp.length, tmp, 0, tmp.length);
            return tmp;
        }
        if (qLength > bytes.length) {
            byte[] tmp = new byte[qLength];
            System.arraycopy(bytes, 0, tmp, tmp.length - bytes.length, bytes.length);
            return tmp;
        }
        return bytes;
    }
}

