/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.keys;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;
import oracle.security.crypto.util.Utils;
import oracle.security.xmlsec.keys.KeyValueData;
import oracle.security.xmlsec.util.Base64;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DHKeyValue
extends XMLElement
implements KeyValueData {
    public DHKeyValue(Element element) throws DOMException {
        super(element);
    }

    public DHKeyValue(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    DHKeyValue(Document owner) throws DOMException {
        super(owner, "http://www.w3.org/2001/04/xmlenc#", "DHKeyValue");
    }

    DHKeyValue(Document owner, DHPublicKey dhKey) throws DOMException {
        this(owner);
        DHParameterSpec params = dhKey.getParams();
        BigInteger p = params.getP();
        BigInteger g = params.getG();
        if (p == null || g == null) {
            throw new IllegalArgumentException("DH params P, Q and Generator must all be either present or missing");
        }
        BigInteger q = params.getP().subtract(BigInteger.ONE).divide(BigInteger.valueOf(2L));
        this.setDHParams(p, q, g);
        if (dhKey.getY() == null) {
            throw new IllegalArgumentException("DH public key value is missing");
        }
        this.setPublic(dhKey.getY());
    }

    public void setDHParams(BigInteger p, BigInteger q, BigInteger g) throws DOMException {
        Document owner = this.getOwnerDocument();
        Element pNode = owner.createElementNS("http://www.w3.org/2001/04/xmlenc#", "P");
        XMLUtils.copyNSPrefix((Element)this.node, pNode);
        pNode.appendChild(owner.createTextNode(Base64.toBase64WithLFSeparator(Utils.toByteArray((BigInteger)p))));
        Element qNode = owner.createElementNS("http://www.w3.org/2001/04/xmlenc#", "Q");
        XMLUtils.copyNSPrefix((Element)this.node, qNode);
        qNode.appendChild(owner.createTextNode(Base64.toBase64WithLFSeparator(Utils.toByteArray((BigInteger)q))));
        Element gNode = owner.createElementNS("http://www.w3.org/2001/04/xmlenc#", "Generator");
        XMLUtils.copyNSPrefix((Element)this.node, gNode);
        gNode.appendChild(owner.createTextNode(Base64.toBase64WithLFSeparator(Utils.toByteArray((BigInteger)g))));
        NodeList nodes = this.getChildElementsByTagName("*");
        boolean appended = false;
        int len = nodes.getLength();
        for (int i = 0; i < len; ++i) {
            Node node = nodes.item(i);
            String name = node.getLocalName();
            if (name == null) {
                String tn = ((Element)node).getTagName();
                int j = tn.indexOf(":");
                String string = name = j == -1 ? tn : tn.substring(j + 1);
            }
            if ("P".equals(name) || "Q".equals(name) || "Generator".equals(name)) {
                this.removeChild(node);
                continue;
            }
            if (appended || !"Public".equals(name) && !"seed".equals(name) && !"pgenCounter".equals(name)) continue;
            this.insertBefore(pNode, node);
            this.insertBefore(qNode, node);
            this.insertBefore(gNode, node);
            appended = true;
        }
        if (!appended) {
            this.appendChild(pNode);
            this.appendChild(qNode);
            this.appendChild(gNode);
        }
    }

    public BigInteger getP() {
        String pString;
        BigInteger p = null;
        NodeList pList = this.getChildElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "P");
        if (pList.getLength() != 0 && (pString = XMLUtils.collectText(pList.item(0))).length() != 0) {
            p = new BigInteger(1, Base64.fromBase64(pString));
        }
        return p;
    }

    public BigInteger getQ() {
        String qString;
        BigInteger q = null;
        NodeList qList = this.getChildElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "Q");
        if (qList.getLength() != 0 && (qString = XMLUtils.collectText(qList.item(0))).length() != 0) {
            q = new BigInteger(1, Base64.fromBase64(qString));
        }
        return q;
    }

    public BigInteger getGenerator() {
        String gString;
        BigInteger g = null;
        NodeList gList = this.getChildElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "Generator");
        if (gList.getLength() != 0 && (gString = XMLUtils.collectText(gList.item(0))).length() != 0) {
            g = new BigInteger(1, Base64.fromBase64(gString));
        }
        return g;
    }

    public void setPublic(BigInteger y) throws DOMException {
        Document owner = this.getOwnerDocument();
        Element pb = owner.createElementNS("http://www.w3.org/2001/04/xmlenc#", "Public");
        XMLUtils.copyNSPrefix((Element)this.node, pb);
        pb.appendChild(owner.createTextNode(Base64.toBase64WithLFSeparator(Utils.toByteArray((BigInteger)y))));
        NodeList nodes = this.getChildElementsByTagName("*");
        boolean appended = false;
        int len = nodes.getLength();
        for (int i = 0; i < len; ++i) {
            Node node = nodes.item(i);
            String name = node.getLocalName();
            if (name == null) {
                String tn = ((Element)node).getTagName();
                int j = tn.indexOf(":");
                String string = name = j == -1 ? tn : tn.substring(j + 1);
            }
            if ("Public".equals(name)) {
                this.removeChild(node);
                continue;
            }
            if (appended || !"seed".equals(name) && !"pgenCounter".equals(name)) continue;
            this.insertBefore(pb, node);
            appended = true;
        }
        if (!appended) {
            this.appendChild(pb);
        }
    }

    public BigInteger getPublic() {
        String string;
        BigInteger y = null;
        NodeList list = this.getChildElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "Public");
        if (list.getLength() != 0 && (string = XMLUtils.collectText(list.item(0))).length() != 0) {
            y = new BigInteger(1, Base64.fromBase64(string));
        }
        return y;
    }

    public void setValidationParams(byte[] seed, BigInteger counter) throws DOMException {
        Document owner = this.getOwnerDocument();
        Element s = owner.createElementNS("http://www.w3.org/2001/04/xmlenc#", "seed");
        XMLUtils.copyNSPrefix((Element)this.node, s);
        s.appendChild(owner.createTextNode(Base64.toBase64WithLFSeparator(seed)));
        Element pc = owner.createElementNS("http://www.w3.org/2001/04/xmlenc#", "pgenCounter");
        XMLUtils.copyNSPrefix((Element)this.node, pc);
        pc.appendChild(owner.createTextNode(Base64.toBase64WithLFSeparator(Utils.toByteArray((BigInteger)counter))));
        NodeList nodes = this.getChildElementsByTagName("*");
        boolean appended = false;
        int len = nodes.getLength();
        for (int i = 0; i < len; ++i) {
            Node node = nodes.item(i);
            String name = node.getLocalName();
            if (name == null) {
                String tn = ((Element)node).getTagName();
                int j = tn.indexOf(":");
                String string = name = j == -1 ? tn : tn.substring(j + 1);
            }
            if (!"seed".equals(name) && !"pgenCounter".equals(name)) continue;
            this.removeChild(node);
        }
        this.appendChild(s);
        this.appendChild(pc);
    }

    public byte[] getSeed() throws DOMException {
        String sString;
        byte[] seed = null;
        NodeList sList = this.getChildElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "seed");
        if (sList.getLength() != 0 && (sString = XMLUtils.collectText(sList.item(0))).length() != 0) {
            seed = Base64.fromBase64(sString);
        }
        return seed;
    }

    public BigInteger getPGenCounter() {
        String cString;
        BigInteger counter = null;
        NodeList cList = this.getChildElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "pgenCounter");
        if (cList.getLength() != 0 && (cString = XMLUtils.collectText(cList.item(0))).length() != 0) {
            counter = new BigInteger(1, Base64.fromBase64(cString));
        }
        return counter;
    }

    @Override
    public PublicKey getPublicKey() {
        try {
            KeyFactory dhkf = KeyFactory.getInstance("DiffieHellman");
            return dhkf.generatePublic(new DHPublicKeySpec(this.getPublic(), this.getP(), this.getGenerator()));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public String getType() {
        return "http://www.w3.org/2001/04/xmlenc#DHKeyValue";
    }
}

