/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.enc;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import oracle.security.crypto.util.CryptoUtils;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.UnsyncByteArrayOutputStream;
import oracle.security.xmlsec.c14n.CanonicalizationException;
import oracle.security.xmlsec.c14n.StreamingC14NImpl;
import oracle.security.xmlsec.dsig.ReferenceException;
import oracle.security.xmlsec.enc.DecryptInputStream;
import oracle.security.xmlsec.enc.EncryptOutputStream;
import oracle.security.xmlsec.enc.XECipherData;
import oracle.security.xmlsec.enc.XECipherException;
import oracle.security.xmlsec.enc.XECipherReference;
import oracle.security.xmlsec.enc.XEEncryptedObject;
import oracle.security.xmlsec.enc.XEEncryptionMethod;
import oracle.security.xmlsec.enc.XEException;
import oracle.security.xmlsec.enc.XESchemaException;
import oracle.security.xmlsec.util.DocTypeUtil;
import oracle.security.xmlsec.util.IDCache;
import oracle.security.xmlsec.util.NodeListImpl;
import oracle.security.xmlsec.util.SOAPMessageUtils;
import oracle.security.xmlsec.util.XMLUtils;
import org.jaxen.dom.DocumentNavigator;
import org.jaxen.dom.NamespaceNode;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XEEncryptedData
extends XEEncryptedObject {
    private static final boolean debugEncryption;
    private static final boolean debugDecryption;
    private StringBuilder decryptedDataInformation = new StringBuilder();
    private StringBuilder encryptedDataInformation = new StringBuilder();
    private byte[] nonce;
    private static final DocumentNavigator docNavigator;
    public static final int GCM_IV_LENGTH = 12;
    public static final int GCM_TAG_LENGTH = 16;
    private static Method jsr106encrypt;
    private static Method jsr106decrypt;

    public XEEncryptedData(Element encData) throws DOMException {
        super(encData);
    }

    public XEEncryptedData(Element encData, String systemId) throws DOMException {
        super(encData, systemId);
    }

    XEEncryptedData(Document doc) throws DOMException {
        super(doc, "EncryptedData");
    }

    XEEncryptedData(Document doc, String dataType) throws DOMException {
        this(doc);
        if (dataType != null) {
            this.setDataType(dataType);
        }
    }

    XEEncryptedData(Document doc, String id, String dataType) throws DOMException {
        this(doc, dataType);
        if (id != null) {
            this.setId(id);
        }
    }

    public static XEEncryptedData newInstance(String id) throws DOMException {
        Document doc = XMLUtils.createDocument();
        XEEncryptedData enData = new XEEncryptedData(doc);
        if (id != null) {
            enData.setId(id);
        }
        enData.appendTo(doc);
        return enData;
    }

    public static XEEncryptedData newInstance(String id, String dataType) throws DOMException {
        Document doc = XMLUtils.createDocument();
        XEEncryptedData enData = new XEEncryptedData(doc, id, dataType);
        enData.appendTo(doc);
        return enData;
    }

    public static XEEncryptedData newInstance(Document doc, String id) throws DOMException {
        return new XEEncryptedData(doc, id, null);
    }

    public static XEEncryptedData newInstance(Document doc, String id, String dataType) throws DOMException {
        return new XEEncryptedData(doc, id, dataType);
    }

    public void setNonce(byte[] nonce) {
        this.nonce = nonce;
    }

    public byte[] getNonce() {
        return this.nonce;
    }

    public int getNonceLength() {
        String nonceLenStr = this.getAttribute("Nonce").trim();
        if (nonceLenStr.length() != 0) {
            return Integer.parseInt(nonceLenStr);
        }
        return 0;
    }

    public void replaceElement(Element element, boolean contentOnly) throws DOMException {
        Document doc = element.getOwnerDocument();
        Element el = null;
        if (this.getOwnerDocument() != doc) {
            try {
                SOAPMessageUtils.importSoapElementNode(doc, this.node);
            }
            catch (XEException xe) {
                DOMException de = new DOMException(0, "XEException");
                de.initCause(xe);
                throw de;
            }
        }
        if (contentOnly) {
            Node node = element.getFirstChild();
            while (node != null) {
                element.removeChild(node);
                node = element.getFirstChild();
            }
            el = (Element)element.appendChild(this.node);
            this.node = el;
        } else {
            element.getParentNode().replaceChild(this.node, element);
        }
    }

    public byte[] encrypt(byte[] bytes, SecretKey key, byte[] iv) throws XESchemaException, XECipherException {
        boolean USE_JSR106;
        boolean bl = USE_JSR106 = System.getProperty("osdt.useJSR106") != null;
        if (USE_JSR106) {
            ByteArrayHolder bh = new ByteArrayHolder();
            this.encryptUsingJSR106(null, bytes, key, iv, bh);
            return bh.value;
        }
        try {
            UnsyncByteArrayOutputStream bos = new UnsyncByteArrayOutputStream();
            EncryptOutputStream os = this.createEncryptOutputStream(key, iv, (OutputStream)bos);
            ((OutputStream)os).write(bytes);
            ((OutputStream)os).close();
            return bos.toByteArray();
        }
        catch (IOException ex) {
            throw new XECipherException(ex);
        }
    }

    public EncryptOutputStream createEncryptOutputStream(SecretKey key, byte[] iv, OutputStream os) throws XESchemaException, XECipherException, IOException {
        XEEncryptionMethod encMethod = this.getEncryptionMethod();
        if (encMethod == null || encMethod.getAlgorithm() == null) {
            throw new XESchemaException("Missing encryption algorithm identifier URI.");
        }
        EncryptOutputStream encOs = null;
        try {
            String alg = encMethod.getJCEAlgorithm();
            if (encMethod.keySize() / 8 != key.getEncoded().length) {
                throw new InvalidKeyException("Key size mismatch");
            }
            Cipher cipher = CryptoUtils.getCipherInstance((Key)key, (String)alg);
            boolean isSunJCEProv = "SunJCE".equals(cipher.getProvider().getName());
            if (cipher.getAlgorithm().contains("GCM") && isSunJCEProv) {
                if (debugEncryption) {
                    this.encryptedDataInformation.append("\nEncryption Algorithm: " + cipher.getAlgorithm() + ", provider: " + cipher.getProvider().getName());
                }
                if (iv == null) {
                    SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
                    iv = new byte[12];
                    random.nextBytes(iv);
                } else if (debugEncryption) {
                    this.encryptedDataInformation.append("\niv is not null, iv length: " + iv.length);
                }
                GCMParameterSpec ivspec = new GCMParameterSpec(128, iv);
                cipher.init(1, (Key)key, ivspec);
            } else if (iv != null) {
                IvParameterSpec ivspec = new IvParameterSpec(iv);
                cipher.init(1, (Key)key, ivspec);
            } else {
                cipher.init(1, key);
            }
            encOs = new EncryptOutputStream(os, cipher);
        }
        catch (NoSuchProviderException ex) {
            throw new XECipherException(ex);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new XECipherException(ex);
        }
        catch (NoSuchPaddingException ex) {
            throw new XECipherException(ex);
        }
        catch (InvalidKeyException ex) {
            throw new XECipherException(ex);
        }
        catch (InvalidAlgorithmParameterException ex) {
            throw new XECipherException(ex);
        }
        catch (IllegalStateException ex) {
            throw new XECipherException(ex);
        }
        if (this.nonce != null && this.nonce.length > 0) {
            this.setAttribute("Nonce", Integer.toString(this.nonce.length));
            encOs.write(this.nonce);
        }
        return encOs;
    }

    public byte[] encrypt(byte[] bytes, byte[] iv) throws XEException {
        return this.encrypt(bytes, (SecretKey)this.getEncryptionKey(), iv);
    }

    public byte[] encrypt(byte[] bytes, SecretKey key) throws XESchemaException, XECipherException {
        return this.encrypt(bytes, key, null);
    }

    public byte[] encrypt(byte[] bytes) throws XEException {
        return this.encrypt(bytes, (SecretKey)this.getEncryptionKey());
    }

    public byte[] encrypt(Element element, SecretKey key, byte[] iv) throws XESchemaException, XECipherException {
        boolean USE_JSR106;
        boolean bl = USE_JSR106 = System.getProperty("osdt.useJSR106") != null;
        if (USE_JSR106) {
            ByteArrayHolder bh = new ByteArrayHolder();
            this.encryptUsingJSR106(element, null, key, iv, bh);
            return bh.value;
        }
        UnsyncByteArrayOutputStream bos = new UnsyncByteArrayOutputStream();
        this.encryptTo(element, key, iv, (OutputStream)bos);
        return bos.toByteArray();
    }

    public void encryptTo(Element element, SecretKey key, byte[] iv, OutputStream os) throws XESchemaException, XECipherException {
        String dataType = this.getDataType();
        if (dataType == null) {
            throw new XESchemaException("Missing data type attribute");
        }
        XEEncryptionMethod encMethod = this.getEncryptionMethod();
        if (encMethod == null || encMethod.getAlgorithm() == null) {
            throw new XESchemaException("Missing encryption algorithm identifier URI.");
        }
        try {
            EncryptOutputStream encOs = this.createEncryptOutputStream(key, iv, os);
            if (dataType.equals("http://www.w3.org/2001/04/xmlenc#Content")) {
                for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
                    if (node.getNodeType() == 3) {
                        byte[] textNodeValue = XMLUtils.escapeTextNode(node.getNodeValue()).getBytes("UTF-8");
                        if (debugEncryption) {
                            this.encryptedDataInformation.append("\n" + new String(textNodeValue, "UTF-8"));
                        }
                        encOs.write(textNodeValue);
                        continue;
                    }
                    StreamingC14NImpl.StreamingInclusiveC14N11Impl c14n = new StreamingC14NImpl.StreamingInclusiveC14N11Impl();
                    InputStream is = c14n.canonicalizeToStream(node);
                    byte[] buf = new byte[2048];
                    int n = is.read(buf);
                    if (debugEncryption) {
                        this.encryptedDataInformation.append("\n");
                    }
                    while (n != -1) {
                        encOs.write(buf, 0, n);
                        if (debugEncryption) {
                            this.encryptedDataInformation.append(new String(buf, 0, n, "UTF-8"));
                        }
                        n = is.read(buf);
                    }
                }
            } else if (dataType.equals("http://www.w3.org/2001/04/xmlenc#Element")) {
                StreamingC14NImpl.StreamingInclusiveC14N11Impl c14n = new StreamingC14NImpl.StreamingInclusiveC14N11Impl();
                InputStream is = c14n.canonicalizeToStream(element);
                byte[] buf = new byte[2048];
                int n = is.read(buf);
                if (debugEncryption) {
                    this.encryptedDataInformation.append("\n");
                }
                while (n != -1) {
                    encOs.write(buf, 0, n);
                    if (debugEncryption) {
                        this.encryptedDataInformation.append(new String(buf, 0, n, "UTF-8"));
                    }
                    n = is.read(buf);
                }
            } else {
                throw new XESchemaException("Unexpected data type: " + dataType);
            }
            encOs.close();
        }
        catch (CanonicalizationException iex) {
            throw new XESchemaException(iex);
        }
        catch (IOException iex) {
            throw new XESchemaException(iex);
        }
    }

    public byte[] encrypt(Element element, byte[] iv) throws XEException {
        return this.encrypt(element, (SecretKey)this.getEncryptionKey(), iv);
    }

    public byte[] encrypt(Element element, SecretKey key) throws XESchemaException, XECipherException {
        return this.encrypt(element, key, null);
    }

    public byte[] encrypt(Element element) throws XEException {
        return this.encrypt(element, (SecretKey)this.getEncryptionKey());
    }

    public static XEEncryptedData encryptAndReplace(Element element, SecretKey key, byte[] iv, XEEncryptedData encData) throws XESchemaException, XECipherException {
        boolean USE_JSR106;
        boolean bl = USE_JSR106 = System.getProperty("osdt.useJSR106") != null;
        if (USE_JSR106) {
            return encData.encryptUsingJSR106(element, null, key, iv, null);
        }
        XECipherData cipherData = encData.createCipherData();
        encData.setCipherData(cipherData);
        OutputStream os = cipherData.setCipherValueAsStream();
        encData.encryptTo(element, key, iv, os);
        boolean contentOnly = "http://www.w3.org/2001/04/xmlenc#Content".equals(encData.getDataType());
        encData.replaceElement(element, contentOnly);
        return encData;
    }

    public static XEEncryptedData encryptAndReplace(Element element, byte[] iv, XEEncryptedData encData) throws XEException {
        return XEEncryptedData.encryptAndReplace(element, (SecretKey)encData.getEncryptionKey(), iv, encData);
    }

    public static XEEncryptedData encryptAndReplace(Element element, SecretKey key, XEEncryptedData encData) throws XESchemaException, XECipherException {
        return XEEncryptedData.encryptAndReplace(element, key, null, encData);
    }

    public static XEEncryptedData encryptAndReplace(Element element, XEEncryptedData encData) throws XEException {
        return XEEncryptedData.encryptAndReplace(element, (SecretKey)encData.getEncryptionKey(), encData);
    }

    public byte[] decrypt(SecretKey key) throws XESchemaException, XECipherException {
        InputStream is = this.decryptToStream(key);
        try {
            return XMLUtils.readBytes(is);
        }
        catch (IOException ex) {
            throw new XECipherException(ex);
        }
    }

    public InputStream decryptToStream(SecretKey key) throws XESchemaException, XECipherException {
        boolean USE_JSR106;
        boolean bl = USE_JSR106 = System.getProperty("osdt.useJSR106") != null;
        if (USE_JSR106) {
            ByteArrayHolder plaintextBytes = new ByteArrayHolder();
            this.decryptUsingJSR106(key, plaintextBytes);
            return new UnsyncByteArrayInputStream(plaintextBytes.value);
        }
        XECipherData cipherData = this.getCipherData();
        if (cipherData == null) {
            throw new XESchemaException("CipherData not found");
        }
        InputStream cipherIs = cipherData.getCipherValueAsStream();
        if (cipherIs == null) {
            XECipherReference ref = cipherData.getCipherReference();
            if (ref == null) {
                throw new XESchemaException("CipherValue/CipherReference not found");
            }
            try {
                cipherIs = ref.getCipherValueAsStream();
            }
            catch (ReferenceException rex) {
                throw new XECipherException(rex);
            }
        }
        return this.createDecryptInputStream(key, cipherIs);
    }

    public DecryptInputStream createDecryptInputStream(SecretKey key, InputStream cipherIs) throws XESchemaException, XECipherException {
        XEEncryptionMethod encMethod = this.getEncryptionMethod();
        if (encMethod == null || encMethod.getAlgorithm() == null) {
            throw new XESchemaException("EncryptionMethod algorithm URI not found");
        }
        try {
            int n;
            int ivLength;
            byte[] iv;
            int nonceLen = this.getNonceLength();
            String alg = encMethod.getJCEAlgorithm();
            if (encMethod.keySize() / 8 != key.getEncoded().length) {
                throw new InvalidKeyException("Key size mismatch");
            }
            Cipher cipher = Cipher.getInstance(alg);
            int blockSize = cipher.getBlockSize();
            boolean isSunJCEProvForGCM = false;
            if (cipher.getAlgorithm().contains("GCM")) {
                iv = new byte[21];
                iv[0] = 16;
                for (int i = 0; i < 8; ++i) {
                    iv[1 + i] = 0;
                }
                ivLength = 12;
                n = cipherIs.read(iv, 9, ivLength);
                isSunJCEProvForGCM = "SunJCE".equals(cipher.getProvider().getName());
                if (debugDecryption) {
                    this.decryptedDataInformation.append("\nDecryption Algorithm: " + cipher.getAlgorithm() + ", provider: " + cipher.getProvider().getName());
                }
            } else {
                ivLength = blockSize;
                iv = new byte[ivLength];
                n = cipherIs.read(iv);
            }
            if (n < ivLength) {
                throw new XECipherException("Cannot read IV from encrpypted bytes. Read returned only " + n + " bytes, which is less than the block size " + ivLength);
            }
            AlgorithmParameterSpec ivSpec = isSunJCEProvForGCM ? new GCMParameterSpec(iv[0] * 8, iv, 9, 12) : new IvParameterSpec(iv);
            cipher.init(2, (Key)key, ivSpec);
            return new DecryptInputStream(cipherIs, cipher, nonceLen);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new XECipherException(ex);
        }
        catch (NoSuchPaddingException ex) {
            throw new XECipherException(ex);
        }
        catch (InvalidKeyException ex) {
            throw new XECipherException(ex);
        }
        catch (InvalidAlgorithmParameterException ex) {
            throw new XECipherException(ex);
        }
        catch (IllegalStateException ex) {
            throw new XECipherException(ex);
        }
        catch (IOException ex) {
            throw new XECipherException(ex);
        }
    }

    public byte[] decrypt() throws XEException {
        return this.decrypt((SecretKey)this.getDecryptionKey());
    }

    public NodeList decryptAndParse(SecretKey key, boolean parentInNodeSet) throws XEException {
        String type = this.getDataType();
        if (type == null) {
            throw new XESchemaException("Missing EncryptedData Type attribute URI");
        }
        if (!"http://www.w3.org/2001/04/xmlenc#Element".equals(type) && !"http://www.w3.org/2001/04/xmlenc#Content".equals(type)) {
            throw new XESchemaException("Unsupported EncryptedData Type attribute URI \"" + type + "\"");
        }
        Node parent = this.getParentNode();
        InputStream plainIs = this.decryptToStream(key);
        WrappedInputStream wrappedIs = new WrappedInputStream(plainIs, (Element)parent);
        StringBuilder decryptedData = new StringBuilder();
        if (debugDecryption) {
            try {
                byte[] wrapped = XMLUtils.readBytes(wrappedIs);
                wrappedIs = new UnsyncByteArrayInputStream(wrapped);
                decryptedData.append("\n+++ XEEncryptedData.decryptAndParse():");
                decryptedData.append("\n+++ wrapped:");
                decryptedData.append("\n" + new String(wrapped, "UTF-8"));
                this.decryptedDataInformation.append((CharSequence)decryptedData);
                System.err.println(decryptedData);
            }
            catch (IOException ex) {
                throw new XEException(ex);
            }
        }
        NodeList apexNodes = null;
        try {
            apexNodes = XEEncryptedData.unwrapXML(wrappedIs);
        }
        catch (XEException ex) {
            throw new XEException("Error in parsing XML (property xml.debug.decrypt should be enabled for more details):- \n" + decryptedData.toString(), ex);
        }
        if (debugDecryption) {
            decryptedData.append("\n+++ unwrapped:");
            decryptedData.append("\n" + XMLUtils.toStringNodes(new NodeListImpl(apexNodes)).replace(',', '\n'));
            this.decryptedDataInformation.append((CharSequence)decryptedData);
            System.err.println(decryptedData);
        }
        XEEncryptedData.augmentApexNodes(apexNodes, !parentInNodeSet ? parent : null);
        return apexNodes;
    }

    public NodeList decryptAndParse(SecretKey key) throws XEException {
        return this.decryptAndParse(key, true);
    }

    public NodeList decryptAndParse(boolean parentInNodeSet) throws XEException {
        return this.decryptAndParse((SecretKey)this.getDecryptionKey(), parentInNodeSet);
    }

    public NodeList decryptAndParse() throws XEException {
        return this.decryptAndParse((SecretKey)this.getDecryptionKey());
    }

    private static void augmentApexNodes(NodeList nodeList, Node parent) {
        SortedMap xmlAttrMap = null;
        if (parent != null) {
            xmlAttrMap = XEEncryptedData.getAncestorXMLAttrs(parent);
        }
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            XEEncryptedData.augmentDefaultNS(element);
            if (parent == null) continue;
            XEEncryptedData.augmentXMLAttrs(element, xmlAttrMap);
        }
    }

    private static void augmentDefaultNS(Element element) {
        boolean hasDefaultNS = false;
        Iterator nsIter = docNavigator.getNamespaceAxisIterator((Object)element);
        while (nsIter.hasNext()) {
            NamespaceNode ns = (NamespaceNode)nsIter.next();
            if (!"".equals(ns.getNodeName())) continue;
            hasDefaultNS = true;
            break;
        }
        if (!hasDefaultNS) {
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "");
        }
    }

    private static SortedMap getAncestorXMLAttrs(Node node) {
        TreeMap<String, String> xmlAttrMap = new TreeMap<String, String>();
        for (Node ancestor = node; ancestor != null; ancestor = ancestor.getParentNode()) {
            Iterator ancestorAttrAxis = docNavigator.getAttributeAxisIterator((Object)ancestor);
            while (ancestorAttrAxis.hasNext()) {
                Attr attr = (Attr)ancestorAttrAxis.next();
                String attrName = attr.getName();
                if (!attrName.startsWith("xml:") || xmlAttrMap.containsKey(attrName)) continue;
                xmlAttrMap.put(attrName, attr.getValue());
            }
        }
        return xmlAttrMap;
    }

    private static void augmentXMLAttrs(Element element, SortedMap xmlAttrMap) {
        for (String attrName : xmlAttrMap.keySet()) {
            element.setAttribute(attrName, (String)xmlAttrMap.get(attrName));
        }
    }

    private static NodeList unwrapXML(InputStream xmlIs) throws XEException {
        try {
            Document doc = XMLUtils.createDocBuilder().parse(xmlIs);
            if (doc != null) {
                Element dummy = doc.getDocumentElement();
                if (!"dummy".equals(dummy.getNodeName())) {
                    throw new XESchemaException("Document root element <dummy> not found");
                }
                return dummy.getChildNodes();
            }
        }
        catch (IOException ex) {
            throw new XEException(ex);
        }
        catch (SAXException ex) {
            throw new XEException(ex);
        }
        return new NodeListImpl();
    }

    public static Element decryptAndReplace(SecretKey key, Element encDataElement, boolean parentInNodeSet) throws DOMException, XEException {
        boolean USE_JSR106;
        boolean bl = USE_JSR106 = System.getProperty("osdt.useJSR106") != null;
        if (USE_JSR106) {
            XEEncryptedData encData = new XEEncryptedData(encDataElement);
            return encData.decryptUsingJSR106(key, null);
        }
        XEEncryptedData encData = new XEEncryptedData(encDataElement);
        NodeList apexNodes = encData.decryptAndParse(key, parentInNodeSet);
        Document doc = encDataElement.getOwnerDocument();
        Node parent = encDataElement.getParentNode();
        String dataType = encData.getDataType();
        if (dataType.equals("http://www.w3.org/2001/04/xmlenc#Element")) {
            if (apexNodes.getLength() != 1) {
                throw new XESchemaException("Expected single element for encrypted data Type=" + dataType);
            }
            Node node = SOAPMessageUtils.importSoapElementNode(doc, apexNodes.item(0));
            parent.replaceChild(node, encDataElement);
            IDCache.addToIDCache((Element)node);
            return (Element)node;
        }
        if (dataType.equals("http://www.w3.org/2001/04/xmlenc#Content")) {
            int n = apexNodes.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = SOAPMessageUtils.importSoapElementNode(doc, apexNodes.item(i));
                parent.insertBefore(node, encDataElement);
                if (!(node instanceof Element)) continue;
                IDCache.addToIDCache((Element)node);
            }
            parent.removeChild(encDataElement);
            return (Element)parent;
        }
        throw new XESchemaException("Unexpected encrypted data Type=" + dataType);
    }

    public static Element decryptAndReplace(SecretKey key, Element encDataElement) throws DOMException, XEException {
        return XEEncryptedData.decryptAndReplace(key, encDataElement, true);
    }

    public static Element decryptAndReplace(Element encDataElement) throws DOMException, XEException {
        XEEncryptedData ed = new XEEncryptedData(encDataElement);
        return XEEncryptedData.decryptAndReplace((SecretKey)ed.getDecryptionKey(), encDataElement);
    }

    public static Element decryptAndReplace(Element encDataElement, boolean parentInNodeSet) throws DOMException, XEException {
        XEEncryptedData ed = new XEEncryptedData(encDataElement);
        return XEEncryptedData.decryptAndReplace((SecretKey)ed.getDecryptionKey(), encDataElement, parentInNodeSet);
    }

    static byte[] pad(int blockSize, byte[] message, int offset, int length) throws XECipherException {
        if (blockSize < 0 || blockSize > 255) {
            throw new XECipherException("Block size has to be between 0 and 255");
        }
        byte paddingLength = (byte)(blockSize - length % blockSize);
        int paddedMessageLength = length + paddingLength;
        byte[] paddedMessage = new byte[paddedMessageLength];
        System.arraycopy(message, offset, paddedMessage, 0, length);
        for (int i = length; i < paddedMessageLength; ++i) {
            paddedMessage[i] = paddingLength;
        }
        return paddedMessage;
    }

    private XEEncryptedData encryptUsingJSR106(Element element, byte[] bytes, SecretKey key, byte[] iv, ByteArrayHolder cipherBytes) throws XESchemaException, XECipherException {
        try {
            return (XEEncryptedData)jsr106encrypt.invoke(null, this, element, bytes, key, iv, cipherBytes);
        }
        catch (InvocationTargetException ex) {
            throw new XECipherException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new XECipherException(ex);
        }
    }

    private Element decryptUsingJSR106(SecretKey key, ByteArrayHolder plaintextBytes) throws XECipherException, XESchemaException {
        try {
            return (Element)jsr106decrypt.invoke(null, this, key, plaintextBytes);
        }
        catch (InvocationTargetException ex) {
            throw new XECipherException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new XECipherException(ex);
        }
    }

    public String getDecryptedDataInformation() {
        return this.decryptedDataInformation.toString();
    }

    public String getEncryptedDataInformation() {
        return this.encryptedDataInformation.toString();
    }

    static {
        boolean USE_JSR106;
        debugEncryption = System.getProperty("xml.debug.enc") != null;
        debugDecryption = System.getProperty("xml.debug.decrypt") != null;
        docNavigator = XMLUtils.getDocumentNavigator();
        boolean bl = USE_JSR106 = System.getProperty("osdt.useJSR106") != null;
        if (USE_JSR106) {
            try {
                Class<?> jsr105Util = Class.forName("oracle.security.xmlsec.enc.JSR106Util");
                jsr106encrypt = jsr105Util.getMethod("encryptUsingJSR106", XEEncryptedData.class, Element.class, byte[].class, SecretKey.class, byte[].class, ByteArrayHolder.class);
                jsr106decrypt = jsr105Util.getMethod("decryptUsingJSR106", XEEncryptedData.class, SecretKey.class, ByteArrayHolder.class);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
    }

    static class ByteArrayHolder {
        byte[] value;

        ByteArrayHolder() {
        }
    }

    private static class WrappedInputStream
    extends FilterInputStream {
        byte[] dummyHeader;
        byte[] dummyFooter;
        int pos = 0;
        State state = State.IN_HEADER;

        public WrappedInputStream(InputStream in, Element context) {
            super(in);
            StringBuilder dummy = new StringBuilder();
            dummy.append("<?xml version=\"1.0\"?>");
            DocumentType docType = XMLUtils.getOwnerDocument(context).getDoctype();
            if (docType != null && docType.getInternalSubset() != null) {
                DocTypeUtil dtu = new DocTypeUtil();
                dtu.setName("dummy");
                dtu.setPublicId(docType.getPublicId());
                dtu.setSystemId(docType.getSystemId());
                dtu.setInternalSubset(docType.getInternalSubset());
                dummy.append(dtu.toString());
            }
            dummy.append("<dummy");
            Map<String, String> nsMap = XMLUtils.getAncestorNamespaces(context);
            for (String prefix : nsMap.keySet()) {
                String value = nsMap.get(prefix);
                if ("xml".equals(prefix) && "http://www.w3.org/XML/1998/namespace".equals(value) || "".equals(prefix) && "".equals(value)) continue;
                dummy.append(' ');
                dummy.append("xmlns");
                if (prefix.length() > 0) {
                    dummy.append(':');
                    dummy.append(prefix);
                }
                dummy.append("=\"");
                dummy.append(value);
                dummy.append('\"');
            }
            dummy.append('>');
            try {
                this.dummyHeader = dummy.toString().getBytes("UTF8");
                this.dummyFooter = "</dummy>".getBytes("UTF8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }

        @Override
        public int read() throws IOException {
            if (this.state == State.IN_HEADER) {
                if (this.pos < this.dummyHeader.length) {
                    return this.dummyHeader[this.pos++];
                }
                this.state = State.IN_BODY;
                this.pos = 0;
            }
            if (this.state == State.IN_BODY) {
                int b = this.in.read();
                if (b != -1) {
                    return b;
                }
                this.state = State.IN_FOOTER;
            }
            if (this.state == State.IN_FOOTER) {
                if (this.pos < this.dummyFooter.length) {
                    return this.dummyFooter[this.pos++];
                }
                this.state = State.EOF;
                this.pos = 0;
            }
            return -1;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int n1;
            int n = 0;
            if (this.state == State.IN_HEADER) {
                n1 = Math.min(this.dummyHeader.length - this.pos, len);
                System.arraycopy(this.dummyHeader, this.pos, b, off, n1);
                this.pos += n1;
                off += n1;
                len -= n1;
                n += n1;
                if (this.pos == this.dummyHeader.length) {
                    this.state = State.IN_BODY;
                    this.pos = 0;
                }
                if (len == 0) {
                    return n;
                }
            }
            if (this.state == State.IN_BODY) {
                while (len > 0) {
                    n1 = this.in.read(b, off, len);
                    if (n1 == -1) {
                        this.state = State.IN_FOOTER;
                        break;
                    }
                    off += n1;
                    len -= n1;
                    n += n1;
                }
                if (len == 0) {
                    return n;
                }
            }
            if (this.state == State.IN_FOOTER) {
                n1 = Math.min(this.dummyFooter.length - this.pos, len);
                System.arraycopy(this.dummyFooter, this.pos, b, off, n1);
                this.pos += n1;
                off += n1;
                len -= n1;
                n += n1;
                if (this.pos == this.dummyFooter.length) {
                    this.state = State.EOF;
                    this.pos = 0;
                }
                return n;
            }
            return -1;
        }

        @Override
        public synchronized void reset() throws IOException {
            this.state = State.IN_HEADER;
            this.pos = 0;
            super.reset();
        }

        static enum State {
            IN_HEADER,
            IN_BODY,
            IN_FOOTER,
            EOF;

        }
    }
}

