/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.dsig;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.util.Utils;
import oracle.security.xmlsec.c14n.CanonicalizationException;
import oracle.security.xmlsec.c14n.Canonicalizer;
import oracle.security.xmlsec.c14n.StreamingC14NImpl;
import oracle.security.xmlsec.dsig.ObjectReference;
import oracle.security.xmlsec.dsig.ReferenceException;
import oracle.security.xmlsec.dsig.XSAlgorithmIdentifier;
import oracle.security.xmlsec.dsig.XSManifest;
import oracle.security.xmlsec.transform.TransformationException;
import oracle.security.xmlsec.transform.XSTransformer;
import oracle.security.xmlsec.util.Base64;
import oracle.security.xmlsec.util.NodeListImpl;
import oracle.security.xmlsec.util.URIManager;
import oracle.security.xmlsec.util.XMLContainer;
import oracle.security.xmlsec.util.XMLUtils;
import oracle.security.xmlsec.util.XPathException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XSReference
extends ObjectReference {
    private StringBuilder validationErrorMessage = new StringBuilder();
    private StringBuilder signatureDetails = new StringBuilder();
    private byte[] digestedData;
    private XSManifest manifest;

    public XSReference(Element element) throws DOMException {
        super(element);
    }

    public XSReference(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public XSReference(Document owner) throws DOMException {
        super(owner, "Reference");
    }

    public XSReference(Document owner, String id) throws DOMException {
        super(owner, "Reference");
        if (id != null) {
            this.setId(id);
        }
    }

    public XSReference(Document owner, String id, String uri, String type) throws DOMException {
        super(owner, "Reference", uri);
        if (id != null) {
            this.setId(id);
        }
        if (type != null) {
            this.setObjectType(type);
        }
    }

    public void setId(String id) throws DOMException {
        this.setAttribute("Id", id);
    }

    public String getId() {
        if (this.hasAttribute("Id")) {
            return this.getAttribute("Id");
        }
        return null;
    }

    public void setObjectType(String type) throws DOMException {
        this.setAttribute("Type", type);
    }

    public String getObjectType() {
        if (this.hasAttribute("Type")) {
            return this.getAttribute("Type");
        }
        return null;
    }

    @Override
    public void addTransform(XSAlgorithmIdentifier trans) throws DOMException {
        super.addTransform(trans);
        NodeList dvList = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "DigestValue");
        for (int i = dvList.getLength(); i > 0; --i) {
            this.removeChild(dvList.item(i - 1));
        }
    }

    public void setDigestMethod(String digestMethod) throws DOMException {
        this.setDigestMethod(new XSAlgorithmIdentifier(this.getOwnerDocument(), "DigestMethod", digestMethod));
    }

    public void setDigestMethod(XSAlgorithmIdentifier digestMethod) throws DOMException {
        NodeList nList = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "DigestMethod");
        for (int i = nList.getLength(); i > 0; --i) {
            this.removeChild(nList.item(i - 1));
        }
        NodeList dv = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "DigestValue");
        if (dv.getLength() != 0) {
            this.insertBefore(digestMethod, dv.item(0));
        } else {
            this.appendChild(digestMethod);
        }
    }

    public XSAlgorithmIdentifier getDigestMethod() {
        NodeList nList = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "DigestMethod");
        if (nList.getLength() != 0) {
            return new XSAlgorithmIdentifier((Element)nList.item(0), this.systemId);
        }
        return null;
    }

    public void setDigestValue(byte[] digestValue) throws DOMException {
        NodeList nList = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "DigestValue");
        for (int i = nList.getLength(); i > 0; --i) {
            this.removeChild(nList.item(i - 1));
        }
        Element dv = this.getOwnerDocument().createElementNS("http://www.w3.org/2000/09/xmldsig#", "DigestValue");
        XMLUtils.copyNSPrefix((Element)this.node, dv);
        dv.appendChild(this.getOwnerDocument().createTextNode(Base64.toBase64WithLFSeparator(digestValue)));
        this.appendChild(dv);
    }

    public byte[] getDigestValue() throws DOMException {
        String dvString;
        byte[] digestValue = null;
        NodeList dvList = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "DigestValue");
        if (dvList.getLength() != 0 && (dvString = XMLUtils.collectText(dvList.item(0))).length() != 0) {
            digestValue = Base64.fromBase64(dvString);
        }
        return digestValue;
    }

    public void computeDigest() throws ReferenceException, AlgorithmIdentifierException, DOMException {
        this.computeDigest((byte[])null);
    }

    public void computeDigest(byte[] dataObject) throws ReferenceException, AlgorithmIdentifierException, DOMException {
        XMLContainer tbdData = this.getTBDData(dataObject);
        this.doComputeDigest(tbdData);
    }

    public void computeDigest(InputStream dataObject) throws ReferenceException, AlgorithmIdentifierException, DOMException {
        XMLContainer tbdData = this.getTBDData(dataObject);
        this.doComputeDigest(tbdData);
    }

    public void computeDigest(NodeList dataObject) throws ReferenceException, AlgorithmIdentifierException, DOMException {
        this.computeDigest(new HashSet(new NodeListImpl(dataObject)));
    }

    public void computeDigest(Set dataObject) throws ReferenceException, AlgorithmIdentifierException, DOMException {
        XMLContainer tbdData = this.getTBDData(dataObject);
        this.doComputeDigest(tbdData);
    }

    public void computeDigest(Element dataObject) throws ReferenceException, AlgorithmIdentifierException, DOMException {
        XMLContainer tbdData = this.getTBDData(dataObject);
        this.doComputeDigest(tbdData);
    }

    private void doComputeDigest(XMLContainer tbdData) throws ReferenceException, AlgorithmIdentifierException, DOMException {
        byte[] digestValue;
        InputStream is = XSReference.toOctets(tbdData);
        if (is == null) {
            throw new ReferenceException("No data to be digested");
        }
        try {
            digestValue = this.computeDigestValue(is);
        }
        catch (IOException ex) {
            throw new ReferenceException(ex);
        }
        catch (NoSuchAlgorithmException ex) {
            AlgorithmIdentifierException ex1 = new AlgorithmIdentifierException(ex.getMessage());
            ex1.initCause((Throwable)ex);
            throw ex1;
        }
        NodeList dvList = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "DigestValue");
        Element dv = null;
        if (dvList.getLength() != 0) {
            dv = (Element)dvList.item(0);
            NodeList vList = dv.getChildNodes();
            for (int i = vList.getLength(); i > 0; --i) {
                dv.removeChild(vList.item(i - 1));
            }
        } else {
            dv = this.getOwnerDocument().createElementNS("http://www.w3.org/2000/09/xmldsig#", "DigestValue");
            XMLUtils.copyNSPrefix((Element)this.node, dv);
            this.appendChild(dv);
        }
        dv.appendChild(this.getOwnerDocument().createTextNode(Base64.toBase64WithLFSeparator(digestValue)));
    }

    public boolean validate(boolean validateManifests) throws ReferenceException {
        return this.validate(validateManifests, (byte[])null);
    }

    public boolean validate(boolean validateManifests, byte[] dataObject) throws ReferenceException {
        XMLContainer tbdData = this.getTBDData(dataObject);
        return this.doValidate(validateManifests, tbdData);
    }

    public boolean validate(boolean validateManifests, InputStream dataObject) throws ReferenceException {
        XMLContainer tbdData = this.getTBDData(dataObject);
        return this.doValidate(validateManifests, tbdData);
    }

    public boolean validate(boolean validateManifests, NodeList dataObject) throws ReferenceException {
        return this.validate(validateManifests, new HashSet(new NodeListImpl(dataObject)));
    }

    public boolean validate(boolean validateManifests, Set dataObject) throws ReferenceException {
        XMLContainer tbdData = this.getTBDData(dataObject);
        return this.doValidate(validateManifests, tbdData);
    }

    public boolean validate(boolean validateManifests, Element dataObject) throws ReferenceException {
        XMLContainer tbdData = this.getTBDData(dataObject);
        return this.doValidate(validateManifests, tbdData);
    }

    private boolean doValidate(boolean validateManifests, XMLContainer tbdData) throws ReferenceException {
        byte[] digestNew;
        boolean xmlDebugDigest = System.getProperty("xml.debug.digest") != null;
        boolean xmlDebugVerify = System.getProperty("xml.debug.verify") != null;
        try {
            InputStream is = XSReference.toOctets(tbdData);
            if (is == null) {
                throw new ReferenceException("No data to be digested");
            }
            digestNew = this.computeDigestValue(is);
        }
        catch (IOException ex) {
            throw new ReferenceException(ex);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new ReferenceException(ex);
        }
        byte[] digestOld = this.getDigestValue();
        if (!Utils.areEqual((byte[])digestOld, (byte[])digestNew)) {
            if (xmlDebugVerify) {
                StringBuilder validationError = new StringBuilder();
                validationError.append("\n osdt_xmlsec: Reference validation failed. URI=" + this.getURI());
                validationError.append("\n osdt_xmlsec: Canonicalized Reference: length=" + this.digestedData.length + " bytes. Data:");
                if (XSReference.isAscii(this.digestedData)) {
                    validationError.append("\n" + new String(this.digestedData));
                } else {
                    validationError.append("\n" + Base64.toBase64(this.digestedData, true));
                }
                validationError.append("\n osdt_xmlsec: Computed digest = " + (digestNew == null ? null : Base64.toBase64(digestNew, false)));
                validationError.append("\n osdt_xmlsec: Digest in the signature = " + (digestOld == null ? null : Base64.toBase64(digestOld, false)));
                this.validationErrorMessage.append((CharSequence)validationError);
                System.err.println(validationError);
            }
            return false;
        }
        if ("http://www.w3.org/2000/09/xmldsig#Manifest".equals(this.getObjectType())) {
            XSManifest man;
            this.manifest = man = this.toManifest(tbdData);
            if (validateManifests) {
                if (man != null) {
                    return man.validateRefDigests(true);
                }
                throw new ReferenceException("Reference-to-Manifest did not dereference to a dsig:Manifest");
            }
        }
        return true;
    }

    public byte[] getDigestedData() {
        return this.digestedData;
    }

    public XSManifest getManifest() {
        return this.manifest;
    }

    private String getDigestAlg() throws ReferenceException, NoSuchAlgorithmException {
        XSAlgorithmIdentifier digestMethod = this.getDigestMethod();
        if (digestMethod == null) {
            throw new ReferenceException("Missing DigestMethod in Reference");
        }
        String dmAlg = digestMethod.getAlgorithm();
        if (dmAlg == null) {
            throw new ReferenceException("Missing DigestMethod algorithm URI");
        }
        String alg = URIManager.getURIManager().getJCEAlgorithm(dmAlg);
        if (alg == null) {
            throw new NoSuchAlgorithmException("Unknown signature algorithm " + dmAlg);
        }
        return alg;
    }

    private byte[] computeDigestValue(InputStream is) throws NoSuchAlgorithmException, ReferenceException, IOException {
        byte[] digestValue;
        boolean xmlDebugVerify;
        String digestAlg = this.getDigestAlg();
        MessageDigest md = MessageDigest.getInstance(digestAlg);
        boolean xmlDebugDigest = System.getProperty("xml.debug.digest") != null;
        boolean bl = xmlDebugVerify = System.getProperty("xml.debug.verify") != null;
        if (xmlDebugDigest || xmlDebugVerify) {
            byte[] data = XMLUtils.readBytes(is);
            this.digestedData = data;
            digestValue = md.digest(data);
            if (xmlDebugDigest) {
                StringBuilder sigDetails = new StringBuilder();
                sigDetails.append("\n osdt_xmlsec: Computing digest. URI=" + this.getURI());
                sigDetails.append("\n osdt_xmlsec: Canonicalized Reference: length=" + this.digestedData.length + " bytes. Data:");
                if (XSReference.isAscii(this.digestedData)) {
                    sigDetails.append("\n" + new String(this.digestedData));
                } else {
                    sigDetails.append("\n" + Base64.toBase64(this.digestedData, true));
                }
                sigDetails.append("\n osdt_xmlsec: Computed digest = " + (digestValue == null ? null : Base64.toBase64(digestValue, false)));
                this.signatureDetails.append((CharSequence)sigDetails);
                System.err.println(sigDetails);
            }
        } else {
            this.digestedData = null;
            byte[] buf = new byte[1024];
            int n = is.read(buf);
            while (n != -1) {
                md.update(buf, 0, n);
                n = is.read(buf);
            }
            digestValue = md.digest();
        }
        return digestValue;
    }

    private XMLContainer getTBDData(byte[] dataObject) throws ReferenceException {
        XMLContainer result = null;
        if (dataObject == null) {
            result = (XMLContainer)this.dereference();
            if (result == null) {
                result = new XMLContainer();
            }
        } else {
            try {
                result = this.applyTransforms(new XMLContainer(dataObject));
            }
            catch (IOException ex) {
                throw new ReferenceException(ex);
            }
        }
        return result;
    }

    private XMLContainer getTBDData(Set dataObject) throws ReferenceException {
        XMLContainer result = null;
        if (dataObject == null) {
            result = (XMLContainer)this.dereference();
            if (result == null) {
                result = new XMLContainer();
            }
        } else {
            result = this.applyTransforms(new XMLContainer(dataObject));
        }
        return result;
    }

    private XMLContainer getTBDData(Element dataObject) throws ReferenceException {
        XMLContainer result = null;
        if (dataObject == null) {
            result = (XMLContainer)this.dereference();
            if (result == null) {
                result = new XMLContainer();
            }
        } else {
            result = this.applyTransforms(new XMLContainer(dataObject));
        }
        return result;
    }

    private XMLContainer getTBDData(InputStream dataObject) throws ReferenceException {
        XMLContainer result = null;
        if (dataObject == null) {
            result = (XMLContainer)this.dereference();
            if (result == null) {
                result = new XMLContainer();
            }
        } else {
            try {
                result = this.applyTransforms(new XMLContainer(dataObject));
            }
            catch (IOException ex) {
                throw new ReferenceException(ex);
            }
        }
        return result;
    }

    private XMLContainer applyTransforms(XMLContainer source) throws ReferenceException {
        if (this.getTransforms().size() > 0) {
            try {
                return XSTransformer.applyTransforms(source, this.getTransforms());
            }
            catch (TransformationException ex) {
                throw new ReferenceException(ex);
            }
        }
        return source;
    }

    private static InputStream toOctets(XMLContainer source) throws ReferenceException {
        try {
            if (source.subTreeAvailable()) {
                StreamingC14NImpl c14n = (StreamingC14NImpl)Canonicalizer.getInstance(true, false);
                return c14n.canonicalizeToStream(source.getSubTree());
            }
            if (source.nodeSetAvailable()) {
                StreamingC14NImpl c14n = (StreamingC14NImpl)Canonicalizer.getInstance(true, false);
                return c14n.canonicalizeToStream(source.getNodeSet());
            }
            return source.getOctetStream();
        }
        catch (CanonicalizationException ex) {
            throw new ReferenceException(ex);
        }
        catch (SAXException ex) {
            throw new ReferenceException(ex);
        }
        catch (XPathException ex) {
            throw new ReferenceException(ex);
        }
        catch (IOException ex) {
            throw new ReferenceException(ex);
        }
    }

    private XSManifest toManifest(XMLContainer source) throws ReferenceException {
        XSManifest man = null;
        if (source != null && (source.nodeSetAvailable() || source.subTreeAvailable())) {
            try {
                Set nodeSet = source.getNodeSet();
                if (nodeSet != null) {
                    List list = XMLUtils.toDocumentOrderList(nodeSet);
                    man = (XSManifest)XMLUtils.getInstance(list, "Manifest", "http://www.w3.org/2000/09/xmldsig#");
                    man.setSystemId(this.systemId);
                }
            }
            catch (IOException ex) {
                throw new ReferenceException(ex);
            }
            catch (SAXException ex) {
                throw new ReferenceException(ex);
            }
            catch (XPathException ex) {
                throw new ReferenceException(ex);
            }
        }
        return man;
    }

    public static boolean isAscii(byte[] data) {
        for (int i = 0; i < data.length; ++i) {
            if (data[i] == 10 || data[i] == 13 || data[i] == 9 || data[i] >= 32 && data[i] <= 127) continue;
            return false;
        }
        return true;
    }

    public StringBuilder getValidationErrorMessage() {
        return this.validationErrorMessage;
    }

    public StringBuilder getSignatureDetails() {
        return this.signatureDetails;
    }
}

