/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.dsig;

import oracle.security.xmlsec.util.XMLElement;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XSAlgorithmIdentifier
extends XMLElement {
    public XSAlgorithmIdentifier(Element element) throws DOMException {
        super(element);
    }

    public XSAlgorithmIdentifier(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public XSAlgorithmIdentifier(Document owner, String tagName) throws DOMException {
        super(owner, "http://www.w3.org/2000/09/xmldsig#", tagName);
    }

    public XSAlgorithmIdentifier(Document owner, String tagName, String algorithm) throws DOMException {
        this(owner, tagName);
        this.setAlgorithm(algorithm);
    }

    public XSAlgorithmIdentifier(Document owner, String nsURI, String tagName, String algorithm) throws DOMException {
        super(owner, nsURI, tagName);
        this.setAlgorithm(algorithm);
    }

    public void setAlgorithm(String algorithm) throws DOMException {
        this.setAttribute("Algorithm", algorithm);
    }

    public String getAlgorithm() {
        if (this.hasAttribute("Algorithm")) {
            return this.getAttribute("Algorithm");
        }
        return null;
    }

    public void addParameter(Node param) throws DOMException {
        this.appendChild(param);
    }

    public void addParameter(String nsURI, String name, String value) throws DOMException {
        Element p = this.getOwnerDocument().createElementNS(nsURI, name);
        p.appendChild(this.getOwnerDocument().createTextNode(value));
        this.addParameter(p);
    }

    public NodeList getParameters() {
        return this.getChildElementsByTagName("*");
    }
}

