/*
 * Decompiled with CFR 0.152.
 */
package oracle.osysmodel.driver.sdk.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.osysmodel.driver.sdk.productdriver.OUIDriver;
import oracle.osysmodel.driver.sdk.productdriver.ProductDriverException;
import oracle.sysman.oii.oiix.OiixEnvironmentOps;

public class OsysUtility {
    private static Logger logger = Logger.getLogger(OsysUtility.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isSharedPath(String string, String string2, String[] stringArray, boolean bl) {
        boolean bl2;
        block20: {
            if (stringArray.length < 2) {
                return false;
            }
            String string3 = string2;
            if (new File(string).equals(new File(string2))) {
                string3 = string2 + File.separator + "crs" + File.separator + "install";
            }
            if (bl && !OsysUtility.isRootAccess()) {
                try {
                    return Cluster.isSharedPath((String)string3, (String[])stringArray);
                }
                catch (Exception exception) {
                    logger.log(Level.WARNING, "Can not determine if " + string2 + " is a shared oracle home with srvm API.");
                }
            }
            bl2 = false;
            String string4 = "";
            for (int i = 0; i < stringArray.length; ++i) {
                string4 = string4 + stringArray[i] + (i == stringArray.length - 1 ? "" : ",");
            }
            StringBuilder stringBuilder = new StringBuilder(string);
            stringBuilder.append(File.separator).append("bin");
            stringBuilder.append(File.separator).append("cluvfy");
            if (!new File(stringBuilder.toString()).exists()) {
                throw new ProductDriverException("Invalid Oracle Home \"" + string + "\". Command \"" + stringBuilder.toString() + "\" does not exist.", ProductDriverException.Type.InvalidConfiguration);
            }
            String[] stringArray2 = new String[]{"comp", "ssa", "-t", "software", "-s", string3, "-n", string4, "-display_status"};
            ArrayList<String> arrayList = new ArrayList<String>();
            if (OsysUtility.isRootAccess()) {
                arrayList.add(OsysUtility.getSuCommand());
                arrayList.add(OUIDriver.checkFileOwner(new File(string2, "oraInst.loc")));
                String string5 = System.getProperty("os.name").toLowerCase();
                if (!string5.startsWith("sunos")) {
                    arrayList.add("-m");
                }
                arrayList.add("-c");
                for (String object : stringArray2) {
                    stringBuilder.append(" ").append(object);
                }
                arrayList.add(stringBuilder.toString());
            } else {
                arrayList.add(stringBuilder.toString());
                arrayList.addAll(Arrays.asList(stringArray2));
            }
            boolean bl3 = false;
            boolean bl4 = false;
            StringBuffer stringBuffer = new StringBuffer("Failed: ");
            try {
                ProcessBuilder processBuilder = new ProcessBuilder(arrayList);
                processBuilder = processBuilder.redirectErrorStream(true);
                Process process = processBuilder.start();
                process.waitFor();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                try {
                    String string5;
                    while ((string5 = bufferedReader.readLine()) != null) {
                        stringBuffer.append(string5);
                        stringBuffer.append("\n");
                        if (string5.contains("EFAIL")) {
                            OsysUtility.updateErrorString(stringBuffer, bufferedReader2);
                            throw new Exception("The result of cluvfy command contain EFAIL " + string5);
                        }
                        if (string5.contains("OVERALL_STATUS")) {
                            bl4 = true;
                            continue;
                        }
                        if (!string5.contains("VFAIL")) continue;
                        bl3 = true;
                    }
                    if (bl4) {
                        bl2 = !bl3;
                        break block20;
                    }
                    OsysUtility.updateErrorString(stringBuffer, bufferedReader2);
                    throw new Exception("The result of cluvfy command does not contain OVERALL_STATUS String.");
                }
                finally {
                    bufferedReader.close();
                    bufferedReader2.close();
                }
            }
            catch (Exception exception) {
                stringBuffer.append(exception.getMessage());
                logger.warning(stringBuffer.toString());
                System.out.println(stringBuffer.toString());
                throw new ProductDriverException("Unable to determine if \"" + string2 + "\" is a shared oracle home. " + "\n" + stringBuffer.toString(), exception, ProductDriverException.Type.UnableToCollectKnownInformation);
            }
        }
        return bl2;
    }

    private static void updateErrorString(StringBuffer stringBuffer, BufferedReader bufferedReader) throws IOException {
        String string;
        while ((string = bufferedReader.readLine()) != null) {
            stringBuffer.append(string);
            stringBuffer.append("\n");
        }
    }

    public static String execute(ArrayList arrayList) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            String string;
            ProcessBuilder processBuilder = new ProcessBuilder(arrayList);
            processBuilder = processBuilder.redirectErrorStream(true);
            Process process = processBuilder.start();
            int n = process.waitFor();
            if (n != 0) {
                throw new Exception();
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((string = bufferedReader.readLine()) != null) {
                stringBuffer.append(string + "\n");
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            throw new ProductDriverException("Failed to execute system command", exception);
        }
        return stringBuffer.toString().trim();
    }

    public static String which(String string) {
        String string2 = "";
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("which");
        arrayList.add(string);
        try {
            string2 = OsysUtility.execute(arrayList);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    public static String getSuCommand() {
        String string = OsysUtility.which("su");
        if (string != null && !string.equals("")) {
            return string;
        }
        String string2 = System.getProperty("os.name").toLowerCase();
        string = string2.startsWith("hp") || string2.startsWith("aix") || string2.startsWith("sunos") ? "/usr/bin/su" : "/bin/su";
        if (!new File(string).exists()) {
            string = "su";
        }
        return string;
    }

    public static String getHostname() {
        String string;
        String string2 = OsysUtility.which("hostname");
        ArrayList<String> arrayList = new ArrayList<String>();
        if ((string2 == null || string2.equals("")) && !new File(string2 = (string = System.getProperty("os.name").toLowerCase()).startsWith("hp") || string.startsWith("aix") || string.startsWith("sunos") ? "/usr/bin/hostname" : "/bin/hostname").exists()) {
            string2 = "hostname";
        }
        arrayList.add(string2);
        string = "";
        try {
            string = OsysUtility.execute(arrayList);
        }
        catch (Exception exception) {
            throw new ProductDriverException("Failed to fetch host name", exception, ProductDriverException.Type.UnableToCollectKnownInformation);
        }
        return string;
    }

    public static boolean isRootAccess() {
        try {
            int n = OiixEnvironmentOps.ssgetUidux();
            return n == 0;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
    }

    public static void main(String[] stringArray) {
        System.out.println(OsysUtility.which("hostname"));
        System.out.println(OsysUtility.which("su"));
        System.out.println(OsysUtility.getHostname());
    }
}

