/*
 * Decompiled with CFR 0.152.
 */
package oracle.osysmodel.driver.sdk.emrepo;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import model.AssociationType;
import model.BaseClass;
import model.SystemInstance;
import model.common.AbstractBaseTarget;
import model.common.BasePatch;
import model.common.BaseSWComponent;
import model.common.Host;
import model.common.OracleHome;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMRepoDriver {
    private static Logger logger = Logger.getLogger(EMRepoDriver.class.getName());
    public List all = new ArrayList();
    static final String topPackage = "model";
    static Class baseClass;
    static final String baseClassName = "model.common.AbstractBaseTarget";
    static final String annotationClass = "model.AssociationType";
    static final String baseSWComponent = "BaseSWComponent";
    static final String SIDBclassName = "SIDatabase";
    static final String RACinstClassName = "RACDBInstance";
    static final String DBInstanceTypeID = "oracle_database";
    static final String WLSclassName = "WLServer";
    static final String adminWLSclassName = "WLAdminServer";
    static final String WLStypeID = "weblogic_j2eeserver";
    static final Integer direct;
    static final Integer inverse;
    static final Integer allDirect;
    static final Integer allInverse;
    static final String oracle_home = "oracle_home";
    static final String host = "host";
    protected Connection con = null;
    protected final String schema = "SYSMAN.";
    protected final String viewTargets = "MGMT_TARGETS";
    protected final String viewAvailability = "MGMT_CURRENT_AVAILABILITY";
    protected final String viewProperties = "MGMT$TARGET_PROPERTIES";
    protected final String viewAssociations = "GC_ASSOC_INSTANCES";
    protected final String viewHomeInfo = "MGMT$OH_HOME_INFO";
    protected final String viewEcmOS = "cm$mgmt_ecm_os";
    protected final String viewMOS = "mgmt$os_summary";
    protected final String viewEntities = "gc_manageable_entities";
    protected final String viewHomePatches = "MGMT$OH_PATCH";
    protected final String sqlTargetByType = "SELECT /*sqlTargetByType*/ t.TARGET_NAME, t.TARGET_GUID, t.DISPLAY_NAME, t.OWNER, t.TYPE_DISPLAY_NAME, t.DISCOVERED_NAME, t.ORACLE_HOME, t.ORACLE_CONFIG_HOME,  a.CURRENT_STATUS, mos.platform_id , HOST_NAME  FROM SYSMAN.MGMT_TARGETS T, SYSMAN.MGMT_CURRENT_AVAILABILITY A, SYSMAN.mgmt$os_summary mos  WHERE  t.TARGET_TYPE = ? AND t.TARGET_GUID=a.TARGET_GUID(+) and  t.host_name = mos.target_name (+) and mos.target_type = 'host'";
    protected PreparedStatement stTargetByType = null;
    protected final String sqlTargetByGUID = "SELECT /*sqlTargetByGUID*/ t.TARGET_NAME, t.TARGET_GUID, t.DISPLAY_NAME, t.OWNER, t.TYPE_DISPLAY_NAME, t.DISCOVERED_NAME, t.ORACLE_HOME, t.ORACLE_CONFIG_HOME,  a.CURRENT_STATUS, mos.platform_id , HOST_NAME  FROM SYSMAN.MGMT_TARGETS t ,SYSMAN.MGMT_CURRENT_AVAILABILITY a,  SYSMAN.mgmt$os_summary mos  WHERE  t.TARGET_GUID = ? AND t.TARGET_GUID=a.TARGET_GUID(+) and  t.host_name = mos.target_name (+) and mos.target_type = 'host'";
    protected PreparedStatement stTargetByGUID = null;
    protected final String sqlTargetByName = "SELECT /*sqlTargetByName*/ t.TARGET_NAME, t.TARGET_GUID, t.DISPLAY_NAME, t.OWNER, t.TYPE_DISPLAY_NAME, t.DISCOVERED_NAME, t.ORACLE_HOME, t.ORACLE_CONFIG_HOME,  a.CURRENT_STATUS, mos.platform_id , HOST_NAME  FROM SYSMAN.MGMT_TARGETS t ,SYSMAN.MGMT_CURRENT_AVAILABILITY a,  SYSMAN.mgmt$os_summary mos  WHERE  t.TARGET_NAME = ? AND t.TARGET_TYPE = ? AND t.TARGET_GUID=a.TARGET_GUID(+) and  t.host_name = mos.target_name (+) and mos.target_type = 'host'";
    protected PreparedStatement stTargetByName = null;
    protected final String sqlProperties = "select /*sqlProperties*/ UPPER(property_name), property_value from SYSMAN.MGMT$TARGET_PROPERTIES p where P.TARGET_GUID = ?";
    protected PreparedStatement stProperties = null;
    protected final String sqlTargetType = "(SELECT TARGET_GUID FROM SYSMAN.MGMT_TARGETS WHERE  TARGET_TYPE = ?)";
    protected final String sqlAssocFrom = " FROM SYSMAN.GC_ASSOC_INSTANCES";
    protected final String sqlAssocType = " and UPPER(ASSOC_TYPE) = ?";
    protected String sqlAssociatedTargets = "SELECT /*sqlAssociatedTargets*/ DEST_ME_GUID  FROM SYSMAN.GC_ASSOC_INSTANCES WHERE SOURCE_ME_GUID = ? and DEST_ME_GUID in (SELECT TARGET_GUID FROM SYSMAN.MGMT_TARGETS WHERE  TARGET_TYPE = ?) and UPPER(ASSOC_TYPE) = ?";
    protected PreparedStatement stAssociatedTargets = null;
    protected String sqlInverseAssociatedTargets = "SELECT /*sqlInverseAssociatedTargets*/ SOURCE_ME_GUID  FROM SYSMAN.GC_ASSOC_INSTANCES WHERE DEST_ME_GUID = ? and SOURCE_ME_GUID in (SELECT TARGET_GUID FROM SYSMAN.MGMT_TARGETS WHERE  TARGET_TYPE = ?) and UPPER(ASSOC_TYPE) = ?";
    protected PreparedStatement stInverseAssociatedTargets = null;
    protected String sqlAllAssociatedTargets = "SELECT /*sqlAllAssociatedTargets*/ distinct DEST_ME_GUID  FROM SYSMAN.GC_ASSOC_INSTANCES WHERE SOURCE_ME_GUID = ? and DEST_ME_GUID in (SELECT TARGET_GUID FROM SYSMAN.MGMT_TARGETS WHERE  TARGET_TYPE = ?)";
    protected PreparedStatement stAllAssociatedTargets = null;
    protected String sqlInverseAllAssociatedTargets = "SELECT /*sqlInverseAllAssociatedTargets*/ distinct SOURCE_ME_GUID  FROM SYSMAN.GC_ASSOC_INSTANCES WHERE DEST_ME_GUID = ? and SOURCE_ME_GUID in (SELECT TARGET_GUID FROM SYSMAN.MGMT_TARGETS WHERE  TARGET_TYPE = ?)";
    protected PreparedStatement stInverseAllAssociatedTargets = null;
    protected final String sqlRACinstances = " (SELECT DEST_ME_GUID FROM SYSMAN.GC_ASSOC_INSTANCES WHERE SOURCE_ME_GUID IN (SELECT TARGET_GUID FROM SYSMAN.MGMT_TARGETS WHERE  TARGET_TYPE = 'rac_database' ) UNION SELECT SOURCE_ME_GUID FROM SYSMAN.MGMT_TARGETS WHERE DEST_ME_GUID IN (SELECT TARGET_GUID FROM SYSMAN.MGMT_TARGETS WHERE  TARGET_TYPE = 'rac_database' ))";
    protected String sqlAssociatedSIDB = "SELECT /*sqlAssociatedSIDB*/ distinct DEST_ME_GUID  FROM SYSMAN.GC_ASSOC_INSTANCES WHERE SOURCE_ME_GUID = ? and DEST_ME_GUID IN (SELECT TARGET_GUID FROM SYSMAN.MGMT_TARGETS WHERE  TARGET_TYPE = ?) and UPPER(ASSOC_TYPE) = ?AND DEST_ME_GUID NOT IN (SELECT DEST_ME_GUID FROM SYSMAN.GC_ASSOC_INSTANCES WHERE SOURCE_ME_GUID IN (SELECT TARGET_GUID FROM SYSMAN.MGMT_TARGETS WHERE  TARGET_TYPE = 'rac_database' ) UNION SELECT SOURCE_ME_GUID FROM SYSMAN.MGMT_TARGETS WHERE DEST_ME_GUID IN (SELECT TARGET_GUID FROM SYSMAN.MGMT_TARGETS WHERE  TARGET_TYPE = 'rac_database' ))";
    protected PreparedStatement stAssociatedSIDB = null;
    protected String sqlInverseAssociatedSIDB = "SELECT /*sqlInverseAssociatedSIDB*/ distinct SOURCE_ME_GUID  FROM SYSMAN.GC_ASSOC_INSTANCES WHERE DEST_ME_GUID = ? AND SOURCE_ME_GUID IN (SELECT TARGET_GUID FROM SYSMAN.MGMT_TARGETS WHERE  TARGET_TYPE = ?) and UPPER(ASSOC_TYPE) = ?AND SOURCE_ME_GUID NOT IN  (SELECT DEST_ME_GUID FROM SYSMAN.GC_ASSOC_INSTANCES WHERE SOURCE_ME_GUID IN (SELECT TARGET_GUID FROM SYSMAN.MGMT_TARGETS WHERE  TARGET_TYPE = 'rac_database' ) UNION SELECT SOURCE_ME_GUID FROM SYSMAN.MGMT_TARGETS WHERE DEST_ME_GUID IN (SELECT TARGET_GUID FROM SYSMAN.MGMT_TARGETS WHERE  TARGET_TYPE = 'rac_database' ))";
    protected PreparedStatement stInverseAssociatedSIDB = null;
    protected String sqlAllAssociatedSIDB = "SELECT /*sqlAllAssociatedSIDB*/ distinct DEST_ME_GUID  FROM SYSMAN.GC_ASSOC_INSTANCES WHERE SOURCE_ME_GUID = ? and DEST_ME_GUID IN (SELECT TARGET_GUID FROM SYSMAN.MGMT_TARGETS WHERE  TARGET_TYPE = ?) AND DEST_ME_GUID NOT IN  (SELECT DEST_ME_GUID FROM SYSMAN.GC_ASSOC_INSTANCES WHERE SOURCE_ME_GUID IN (SELECT TARGET_GUID FROM SYSMAN.MGMT_TARGETS WHERE  TARGET_TYPE = 'rac_database' ) UNION SELECT SOURCE_ME_GUID FROM SYSMAN.MGMT_TARGETS WHERE DEST_ME_GUID IN (SELECT TARGET_GUID FROM SYSMAN.MGMT_TARGETS WHERE  TARGET_TYPE = 'rac_database' ))";
    protected PreparedStatement stAllAssociatedSIDB = null;
    protected String sqlInverseAllAssociatedSIDB = "SELECT /*sqlInverseAllAssociatedSIDB*/ distinct SOURCE_ME_GUID  FROM SYSMAN.GC_ASSOC_INSTANCES WHERE DEST_ME_GUID = ? and SOURCE_ME_GUID IN (SELECT TARGET_GUID FROM SYSMAN.MGMT_TARGETS WHERE  TARGET_TYPE = ?) AND SOURCE_ME_GUID NOT IN  (SELECT DEST_ME_GUID FROM SYSMAN.GC_ASSOC_INSTANCES WHERE SOURCE_ME_GUID IN (SELECT TARGET_GUID FROM SYSMAN.MGMT_TARGETS WHERE  TARGET_TYPE = 'rac_database' ) UNION SELECT SOURCE_ME_GUID FROM SYSMAN.MGMT_TARGETS WHERE DEST_ME_GUID IN (SELECT TARGET_GUID FROM SYSMAN.MGMT_TARGETS WHERE  TARGET_TYPE = 'rac_database' ))";
    protected PreparedStatement stInverseAllAssociatedSIDB = null;
    protected String sqlAssociatedRACInstances = "SELECT /*sqlAssociatedRACInstances*/ distinct DEST_ME_GUID  FROM SYSMAN.GC_ASSOC_INSTANCES WHERE SOURCE_ME_GUID = ? and DEST_ME_GUID IN (SELECT TARGET_GUID FROM SYSMAN.MGMT_TARGETS WHERE  TARGET_TYPE = ?) and UPPER(ASSOC_TYPE) = ?AND DEST_ME_GUID IN (SELECT DEST_ME_GUID FROM SYSMAN.GC_ASSOC_INSTANCES WHERE SOURCE_ME_GUID IN (SELECT TARGET_GUID FROM SYSMAN.MGMT_TARGETS WHERE  TARGET_TYPE = 'rac_database' ) UNION SELECT SOURCE_ME_GUID FROM SYSMAN.MGMT_TARGETS WHERE DEST_ME_GUID IN (SELECT TARGET_GUID FROM SYSMAN.MGMT_TARGETS WHERE  TARGET_TYPE = 'rac_database' ))";
    protected PreparedStatement stAssociatedRACInstances = null;
    protected String sqlInverseAssociatedRACInstances = "SELECT /*sqlInverseAssociatedRACInstances*/ distinct SOURCE_ME_GUID  FROM SYSMAN.GC_ASSOC_INSTANCES WHERE DEST_ME_GUID = ? AND SOURCE_ME_GUID IN (SELECT TARGET_GUID FROM SYSMAN.MGMT_TARGETS WHERE  TARGET_TYPE = ?) and UPPER(ASSOC_TYPE) = ?AND SOURCE_ME_GUID IN (SELECT DEST_ME_GUID FROM SYSMAN.GC_ASSOC_INSTANCES WHERE SOURCE_ME_GUID IN (SELECT TARGET_GUID FROM SYSMAN.MGMT_TARGETS WHERE  TARGET_TYPE = 'rac_database' ) UNION SELECT SOURCE_ME_GUID FROM SYSMAN.MGMT_TARGETS WHERE DEST_ME_GUID IN (SELECT TARGET_GUID FROM SYSMAN.MGMT_TARGETS WHERE  TARGET_TYPE = 'rac_database' ))";
    protected PreparedStatement stInverseAssociatedRACInstances = null;
    protected String sqlAllAssociatedRACInstances = "SELECT /*sqlAllAssociatedRACInstances*/ distinct DEST_ME_GUID  FROM SYSMAN.GC_ASSOC_INSTANCES WHERE SOURCE_ME_GUID = ? and DEST_ME_GUID IN (SELECT TARGET_GUID FROM SYSMAN.MGMT_TARGETS WHERE  TARGET_TYPE = ?)AND DEST_ME_GUID IN (SELECT DEST_ME_GUID FROM SYSMAN.GC_ASSOC_INSTANCES WHERE SOURCE_ME_GUID IN (SELECT TARGET_GUID FROM SYSMAN.MGMT_TARGETS WHERE  TARGET_TYPE = 'rac_database' ) UNION SELECT SOURCE_ME_GUID FROM SYSMAN.MGMT_TARGETS WHERE DEST_ME_GUID IN (SELECT TARGET_GUID FROM SYSMAN.MGMT_TARGETS WHERE  TARGET_TYPE = 'rac_database' ))";
    protected PreparedStatement stAllAssociatedRACInstances = null;
    protected String sqlInverseAllAssociatedRACInstances = "SELECT /*sqlInverseAllAssociatedRACInstances*/ distinct SOURCE_ME_GUID  FROM SYSMAN.GC_ASSOC_INSTANCES WHERE DEST_ME_GUID = ? AND SOURCE_ME_GUID IN (SELECT TARGET_GUID FROM SYSMAN.MGMT_TARGETS WHERE  TARGET_TYPE = ?)AND SOURCE_ME_GUID IN (SELECT DEST_ME_GUID FROM SYSMAN.GC_ASSOC_INSTANCES WHERE SOURCE_ME_GUID IN (SELECT TARGET_GUID FROM SYSMAN.MGMT_TARGETS WHERE  TARGET_TYPE = 'rac_database' ) UNION SELECT SOURCE_ME_GUID FROM SYSMAN.MGMT_TARGETS WHERE DEST_ME_GUID IN (SELECT TARGET_GUID FROM SYSMAN.MGMT_TARGETS WHERE  TARGET_TYPE = 'rac_database' ))";
    protected PreparedStatement stInverseAllAssociatedRACInstances = null;
    protected final String sqlAdminWLS = "(SELECT TARGET_GUID FROM SYSMAN.MGMT$TARGET_PROPERTIES WHERE TARGET_TYPE = 'weblogic_j2eeserver' AND PROPERTY_NAME = 'isAdminServer' AND PROPERTY_VALUE = 'YES' )";
    protected String sqlAssociatedWLSadmin = "SELECT /*sqlAssociatedWLSadmin*/ distinct DEST_ME_GUID  FROM SYSMAN.GC_ASSOC_INSTANCES WHERE SOURCE_ME_GUID = ? and DEST_ME_GUID IN (SELECT TARGET_GUID FROM SYSMAN.MGMT_TARGETS WHERE  TARGET_TYPE = ?) and UPPER(ASSOC_TYPE) = ?AND DEST_ME_GUID IN(SELECT TARGET_GUID FROM SYSMAN.MGMT$TARGET_PROPERTIES WHERE TARGET_TYPE = 'weblogic_j2eeserver' AND PROPERTY_NAME = 'isAdminServer' AND PROPERTY_VALUE = 'YES' )";
    protected PreparedStatement stAssociatedWLSadmin = null;
    protected String sqlInverseAssociatedWLSadmin = "SELECT /*sqlInverseAssociatedWLSadmin*/ distinct SOURCE_ME_GUID  FROM SYSMAN.GC_ASSOC_INSTANCES WHERE DEST_ME_GUID = ? AND SOURCE_ME_GUID IN (SELECT TARGET_GUID FROM SYSMAN.MGMT_TARGETS WHERE  TARGET_TYPE = ?) and UPPER(ASSOC_TYPE) = ?AND SOURCE_ME_GUID IN(SELECT TARGET_GUID FROM SYSMAN.MGMT$TARGET_PROPERTIES WHERE TARGET_TYPE = 'weblogic_j2eeserver' AND PROPERTY_NAME = 'isAdminServer' AND PROPERTY_VALUE = 'YES' )";
    protected PreparedStatement stInverseAssociatedWLSadmin = null;
    protected String sqlAllAssociatedWLSadmin = "SELECT /*sqlAllAssociatedWLSadmin*/ distinct DEST_ME_GUID  FROM SYSMAN.GC_ASSOC_INSTANCES WHERE SOURCE_ME_GUID = ? and DEST_ME_GUID IN (SELECT TARGET_GUID FROM SYSMAN.MGMT_TARGETS WHERE  TARGET_TYPE = ?) AND DEST_ME_GUID IN(SELECT TARGET_GUID FROM SYSMAN.MGMT$TARGET_PROPERTIES WHERE TARGET_TYPE = 'weblogic_j2eeserver' AND PROPERTY_NAME = 'isAdminServer' AND PROPERTY_VALUE = 'YES' )";
    protected PreparedStatement stAllAssociatedWLSadmin = null;
    protected String sqlInverseAllAssociatedWLSadmin = "SELECT /*sqlInverseAllAssociatedWLSadmin*/ distinct SOURCE_ME_GUID  FROM SYSMAN.GC_ASSOC_INSTANCES WHERE DEST_ME_GUID = ? AND SOURCE_ME_GUID IN (SELECT TARGET_GUID FROM SYSMAN.MGMT_TARGETS WHERE  TARGET_TYPE = ?) AND SOURCE_ME_GUID IN(SELECT TARGET_GUID FROM SYSMAN.MGMT$TARGET_PROPERTIES WHERE TARGET_TYPE = 'weblogic_j2eeserver' AND PROPERTY_NAME = 'isAdminServer' AND PROPERTY_VALUE = 'YES' )";
    protected PreparedStatement stInverseAllAssociatedWLSadmin = null;
    protected String sqlAssociatedWLSmanaged = "SELECT /*sqlAssociatedWLSmanaged*/ distinct DEST_ME_GUID  FROM SYSMAN.GC_ASSOC_INSTANCES WHERE SOURCE_ME_GUID = ? and DEST_ME_GUID IN (SELECT TARGET_GUID FROM SYSMAN.MGMT_TARGETS WHERE  TARGET_TYPE = ?) and UPPER(ASSOC_TYPE) = ?AND DEST_ME_GUID NOT IN(SELECT TARGET_GUID FROM SYSMAN.MGMT$TARGET_PROPERTIES WHERE TARGET_TYPE = 'weblogic_j2eeserver' AND PROPERTY_NAME = 'isAdminServer' AND PROPERTY_VALUE = 'YES' )";
    protected PreparedStatement stAssociatedWLSmanaged = null;
    protected String sqlInverseAssociatedWLSmanaged = "SELECT /*sqlInverseAssociatedWLSmanaged*/ distinct SOURCE_ME_GUID  FROM SYSMAN.GC_ASSOC_INSTANCES WHERE DEST_ME_GUID = ? AND SOURCE_ME_GUID IN (SELECT TARGET_GUID FROM SYSMAN.MGMT_TARGETS WHERE  TARGET_TYPE = ?) and UPPER(ASSOC_TYPE) = ?AND SOURCE_ME_GUID NOT IN(SELECT TARGET_GUID FROM SYSMAN.MGMT$TARGET_PROPERTIES WHERE TARGET_TYPE = 'weblogic_j2eeserver' AND PROPERTY_NAME = 'isAdminServer' AND PROPERTY_VALUE = 'YES' )";
    protected PreparedStatement stInverseAssociatedWLSmanaged = null;
    protected String sqlAllAssociatedWLSmanaged = "SELECT /*sqlAllAssociatedWLSmanaged*/ distinct DEST_ME_GUID  FROM SYSMAN.GC_ASSOC_INSTANCES WHERE SOURCE_ME_GUID = ? and DEST_ME_GUID IN (SELECT TARGET_GUID FROM SYSMAN.MGMT_TARGETS WHERE  TARGET_TYPE = ?) AND DEST_ME_GUID NOT IN(SELECT TARGET_GUID FROM SYSMAN.MGMT$TARGET_PROPERTIES WHERE TARGET_TYPE = 'weblogic_j2eeserver' AND PROPERTY_NAME = 'isAdminServer' AND PROPERTY_VALUE = 'YES' )";
    protected PreparedStatement stAllAssociatedWLSmanaged = null;
    protected String sqlInverseAllAssociatedWLSmanaged = "SELECT /*sqlInverseAllAssociatedWLSmanaged*/ distinct SOURCE_ME_GUID  FROM SYSMAN.GC_ASSOC_INSTANCES WHERE DEST_ME_GUID = ? AND SOURCE_ME_GUID IN (SELECT TARGET_GUID FROM SYSMAN.MGMT_TARGETS WHERE  TARGET_TYPE = ?) AND SOURCE_ME_GUID NOT IN (SELECT TARGET_GUID FROM SYSMAN.MGMT$TARGET_PROPERTIES WHERE TARGET_TYPE = 'weblogic_j2eeserver' AND PROPERTY_NAME = 'isAdminServer' AND PROPERTY_VALUE = 'YES' )";
    protected PreparedStatement stInverseAllAssociatedWLSmanaged = null;
    protected final String sqlOracleHomeAndHost = "select /*sqlOracleHomeAndHost*/ oh.entity_guid, host.target_guid  from SYSMAN.MGMT_TARGETS t, SYSMAN.gc_manageable_entities oh, SYSMAN.MGMT$TARGET_PROPERTIES tp, SYSMAN.MGMT_TARGETS host,SYSMAN.MGMT$TARGET_PROPERTIES ohp  where t.target_guid=? and t.host_name = host.target_name and host.target_type = 'host'  and oh.entity_type='oracle_home' and  oh.host_name = t.host_name and oh.entity_guid =ohp.target_guid and tp.target_guid = t.target_guid  and tp.property_name = 'OracleHome' and ohp.property_name ='INSTALL_LOCATION'  and tp.property_value = ohp.property_value";
    protected PreparedStatement stOracleHomeAndHost = null;
    protected final String sqlPatchesInOracleHome = "select /*sqlPatchesInOracleHome*/ hp.patch_id  from SYSMAN.MGMT$OH_PATCH hp where hp.target_guid=?";
    protected PreparedStatement stPatchesInOracleHome = null;
    protected final String sqlOracleHomeAndHostWLS = "select /*sqlOracleHomeAndHostWLS*/ HOME.SOURCE_ME_GUID, WLS.DEST_ME_GUID  FROM SYSMAN.GC_ASSOC_INSTANCES WLS, SYSMAN.GC_ASSOC_INSTANCES HOME where  WLS.SOURCE_ME_GUID =? and WLS.ASSOC_TYPE = 'hosted_by' and  HOME.DEST_ME_GUID = WLS.DEST_ME_GUID and  HOME.ASSOC_TYPE = 'hosted_by' and HOME.SOURCE_ME_GUID in  (select target_guid from MGMT_TARGETS t where T.TARGET_TYPE = 'oracle_home'  and T.CATEGORY_PROP_1='W' ) ";
    protected PreparedStatement stOracleHomeAndHostWLS = null;
    protected final String sqlOracleHomeInfo = "SELECT /*sqlOracleHomeInfo*/ OH_OWNER, OUI_HOME_NAME, IS_CLONABLE, HOME_RW_STATUS, HOME_POINTER, ARU_ID, ORACLE_BASE FROM SYSMAN.MGMT$OH_HOME_INFO WHERE TARGET_GUID=?";
    protected PreparedStatement stOracleHomeInfo = null;
    protected final String sqlHostExa = "select /*sqlHostExa*/ dbm_member from SYSMAN.cm$mgmt_ecm_os where cm_target_guid = ? and dbm_member ='1'";
    protected PreparedStatement stHostExa = null;
    protected Map<Class, Map<Method, List<BaseClass>>> requestedAssociations = new HashMap<Class, Map<Method, List<BaseClass>>>();
    protected Map<Class, Map<String, Method>> properySetters = new HashMap<Class, Map<String, Method>>();
    protected List<InfoMap> homeInfo = null;
    protected Map<String, PreparedStatement> sqlToSt = new HashMap<String, PreparedStatement>();
    protected Map<String, AbstractBaseTarget> mapOut = new HashMap<String, AbstractBaseTarget>();
    protected Map<Method, BaseClass> invokedMethods = new HashMap<Method, BaseClass>();
    protected Map<String, Map<Integer, String>> sqlByClass = new HashMap<String, Map<Integer, String>>();
    protected Map<Integer, String> sqlAll = new HashMap<Integer, String>();
    protected Map<String, PreparedStatement> executedSQL = new HashMap<String, PreparedStatement>();
    protected List<Result> openResultSets = new ArrayList<Result>();
    private long time = System.currentTimeMillis();
    private long timeInDB = 0L;
    private int numOfQueries;
    private Map<String, Integer> queryStat = new HashMap<String, Integer>();
    private boolean needToCloseConnection = false;

    public EMRepoDriver(String string, String string2, String string3) {
        try {
            if (string == null) {
                throw new IllegalAccessException(" DB connection string is null!");
            }
            String string4 = "jdbc:oracle:thin:@" + string;
            this.setDBAccess(string4, string2, string3);
            this.prepareAllStatements();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public EMRepoDriver(Connection connection) {
        try {
            if (connection == null) {
                throw new IllegalAccessException(" DB connection is null!");
            }
            this.con = connection;
            this.prepareAllStatements();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    protected PreparedStatement prepareStatement(String string) throws SQLException {
        PreparedStatement preparedStatement = this.con.prepareStatement(string);
        this.sqlToSt.put(string, preparedStatement);
        return preparedStatement;
    }

    protected void setDBAccess(String string, String string2, String string3) {
        try {
            Class.forName("oracle.jdbc.driver.OracleDriver");
            logger.finer(string + " " + string2);
            this.con = DriverManager.getConnection(string, string2, string3);
            this.needToCloseConnection = true;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    protected void prepareAllStatements() throws SQLException {
        try {
            this.stTargetByType = this.prepareStatement("SELECT /*sqlTargetByType*/ t.TARGET_NAME, t.TARGET_GUID, t.DISPLAY_NAME, t.OWNER, t.TYPE_DISPLAY_NAME, t.DISCOVERED_NAME, t.ORACLE_HOME, t.ORACLE_CONFIG_HOME,  a.CURRENT_STATUS, mos.platform_id , HOST_NAME  FROM SYSMAN.MGMT_TARGETS T, SYSMAN.MGMT_CURRENT_AVAILABILITY A, SYSMAN.mgmt$os_summary mos  WHERE  t.TARGET_TYPE = ? AND t.TARGET_GUID=a.TARGET_GUID(+) and  t.host_name = mos.target_name (+) and mos.target_type = 'host'");
            this.stTargetByGUID = this.prepareStatement("SELECT /*sqlTargetByGUID*/ t.TARGET_NAME, t.TARGET_GUID, t.DISPLAY_NAME, t.OWNER, t.TYPE_DISPLAY_NAME, t.DISCOVERED_NAME, t.ORACLE_HOME, t.ORACLE_CONFIG_HOME,  a.CURRENT_STATUS, mos.platform_id , HOST_NAME  FROM SYSMAN.MGMT_TARGETS t ,SYSMAN.MGMT_CURRENT_AVAILABILITY a,  SYSMAN.mgmt$os_summary mos  WHERE  t.TARGET_GUID = ? AND t.TARGET_GUID=a.TARGET_GUID(+) and  t.host_name = mos.target_name (+) and mos.target_type = 'host'");
            this.stTargetByName = this.prepareStatement("SELECT /*sqlTargetByName*/ t.TARGET_NAME, t.TARGET_GUID, t.DISPLAY_NAME, t.OWNER, t.TYPE_DISPLAY_NAME, t.DISCOVERED_NAME, t.ORACLE_HOME, t.ORACLE_CONFIG_HOME,  a.CURRENT_STATUS, mos.platform_id , HOST_NAME  FROM SYSMAN.MGMT_TARGETS t ,SYSMAN.MGMT_CURRENT_AVAILABILITY a,  SYSMAN.mgmt$os_summary mos  WHERE  t.TARGET_NAME = ? AND t.TARGET_TYPE = ? AND t.TARGET_GUID=a.TARGET_GUID(+) and  t.host_name = mos.target_name (+) and mos.target_type = 'host'");
            this.stProperties = this.prepareStatement("select /*sqlProperties*/ UPPER(property_name), property_value from SYSMAN.MGMT$TARGET_PROPERTIES p where P.TARGET_GUID = ?");
            this.stOracleHomeAndHost = this.prepareStatement("select /*sqlOracleHomeAndHost*/ oh.entity_guid, host.target_guid  from SYSMAN.MGMT_TARGETS t, SYSMAN.gc_manageable_entities oh, SYSMAN.MGMT$TARGET_PROPERTIES tp, SYSMAN.MGMT_TARGETS host,SYSMAN.MGMT$TARGET_PROPERTIES ohp  where t.target_guid=? and t.host_name = host.target_name and host.target_type = 'host'  and oh.entity_type='oracle_home' and  oh.host_name = t.host_name and oh.entity_guid =ohp.target_guid and tp.target_guid = t.target_guid  and tp.property_name = 'OracleHome' and ohp.property_name ='INSTALL_LOCATION'  and tp.property_value = ohp.property_value");
            this.stOracleHomeAndHost = this.prepareStatement("select /*sqlOracleHomeAndHostWLS*/ HOME.SOURCE_ME_GUID, WLS.DEST_ME_GUID  FROM SYSMAN.GC_ASSOC_INSTANCES WLS, SYSMAN.GC_ASSOC_INSTANCES HOME where  WLS.SOURCE_ME_GUID =? and WLS.ASSOC_TYPE = 'hosted_by' and  HOME.DEST_ME_GUID = WLS.DEST_ME_GUID and  HOME.ASSOC_TYPE = 'hosted_by' and HOME.SOURCE_ME_GUID in  (select target_guid from MGMT_TARGETS t where T.TARGET_TYPE = 'oracle_home'  and T.CATEGORY_PROP_1='W' ) ");
            this.stOracleHomeInfo = this.prepareStatement("SELECT /*sqlOracleHomeInfo*/ OH_OWNER, OUI_HOME_NAME, IS_CLONABLE, HOME_RW_STATUS, HOME_POINTER, ARU_ID, ORACLE_BASE FROM SYSMAN.MGMT$OH_HOME_INFO WHERE TARGET_GUID=?");
            this.stPatchesInOracleHome = this.prepareStatement("select /*sqlPatchesInOracleHome*/ hp.patch_id  from SYSMAN.MGMT$OH_PATCH hp where hp.target_guid=?");
            this.stHostExa = this.prepareStatement("select /*sqlHostExa*/ dbm_member from SYSMAN.cm$mgmt_ecm_os where cm_target_guid = ? and dbm_member ='1'");
            this.stAssociatedTargets = this.prepareStatement(this.sqlAssociatedTargets);
            this.stInverseAssociatedTargets = this.prepareStatement(this.sqlInverseAssociatedTargets);
            this.stAllAssociatedTargets = this.prepareStatement(this.sqlAllAssociatedTargets);
            this.stInverseAllAssociatedTargets = this.prepareStatement(this.sqlInverseAllAssociatedTargets);
            this.sqlAll.put(direct, this.sqlAssociatedTargets);
            this.sqlAll.put(inverse, this.sqlInverseAssociatedTargets);
            this.sqlAll.put(allDirect, this.sqlAllAssociatedTargets);
            this.sqlAll.put(allInverse, this.sqlInverseAllAssociatedTargets);
            this.stAssociatedSIDB = this.prepareStatement(this.sqlAssociatedSIDB);
            this.stInverseAssociatedSIDB = this.prepareStatement(this.sqlInverseAssociatedSIDB);
            this.stAllAssociatedSIDB = this.prepareStatement(this.sqlAllAssociatedSIDB);
            this.stInverseAllAssociatedSIDB = this.prepareStatement(this.sqlInverseAllAssociatedSIDB);
            HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
            hashMap.put(direct, this.sqlAssociatedSIDB);
            hashMap.put(inverse, this.sqlInverseAssociatedSIDB);
            hashMap.put(allDirect, this.sqlAllAssociatedSIDB);
            hashMap.put(allInverse, this.sqlInverseAllAssociatedSIDB);
            this.sqlByClass.put(SIDBclassName, hashMap);
            this.stAssociatedRACInstances = this.prepareStatement(this.sqlAssociatedRACInstances);
            this.stInverseAssociatedRACInstances = this.prepareStatement(this.sqlInverseAssociatedRACInstances);
            this.stAllAssociatedRACInstances = this.prepareStatement(this.sqlAllAssociatedRACInstances);
            this.stInverseAllAssociatedRACInstances = this.prepareStatement(this.sqlInverseAllAssociatedRACInstances);
            hashMap = new HashMap();
            hashMap.put(direct, this.sqlAssociatedRACInstances);
            hashMap.put(inverse, this.sqlInverseAssociatedRACInstances);
            hashMap.put(allDirect, this.sqlAllAssociatedRACInstances);
            hashMap.put(allInverse, this.sqlInverseAllAssociatedRACInstances);
            this.sqlByClass.put(RACinstClassName, hashMap);
            this.stAssociatedWLSmanaged = this.prepareStatement(this.sqlAssociatedWLSmanaged);
            this.stInverseAssociatedWLSmanaged = this.prepareStatement(this.sqlInverseAssociatedWLSmanaged);
            this.stAllAssociatedWLSmanaged = this.prepareStatement(this.sqlAllAssociatedWLSmanaged);
            this.stInverseAllAssociatedWLSmanaged = this.prepareStatement(this.sqlInverseAllAssociatedWLSmanaged);
            hashMap = new HashMap();
            hashMap.put(direct, this.sqlAssociatedWLSmanaged);
            hashMap.put(inverse, this.sqlInverseAssociatedWLSmanaged);
            hashMap.put(allDirect, this.sqlAllAssociatedWLSmanaged);
            hashMap.put(allInverse, this.sqlInverseAllAssociatedWLSmanaged);
            this.sqlByClass.put(WLSclassName, hashMap);
            this.stAssociatedWLSadmin = this.prepareStatement(this.sqlAssociatedWLSadmin);
            this.stInverseAssociatedWLSadmin = this.prepareStatement(this.sqlInverseAssociatedWLSadmin);
            this.stAllAssociatedWLSadmin = this.prepareStatement(this.sqlAllAssociatedWLSadmin);
            this.stInverseAllAssociatedWLSadmin = this.prepareStatement(this.sqlInverseAllAssociatedWLSadmin);
            hashMap = new HashMap();
            hashMap.put(direct, this.sqlAssociatedWLSadmin);
            hashMap.put(inverse, this.sqlInverseAssociatedWLSadmin);
            hashMap.put(allDirect, this.sqlAllAssociatedWLSadmin);
            hashMap.put(allInverse, this.sqlInverseAllAssociatedWLSadmin);
            this.sqlByClass.put(adminWLSclassName, hashMap);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    protected void releaseDBConnection() {
        try {
            for (Result object : this.openResultSets) {
                object.set.close();
            }
            for (Map.Entry entry : this.sqlToSt.entrySet()) {
                ((PreparedStatement)entry.getValue()).close();
                String string = (String)entry.getKey();
                String string2 = string.substring(6, string.indexOf("*/") + 2);
                this.executedSQL.remove(string2);
            }
            for (Map.Entry entry : this.executedSQL.entrySet()) {
                System.out.println(" did not close statement " + (String)entry.getKey());
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected void closeResultSet(ResultSet resultSet) {
        if (resultSet == null) {
            return;
        }
        try {
            resultSet.close();
            Result result = null;
            for (Result result2 : this.openResultSets) {
                if (result2.set != resultSet) continue;
                result = result2;
            }
            this.openResultSets.remove(result);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected Map<Method, List<BaseClass>> getRequestAssocMap(BaseClass baseClass) {
        return this.requestedAssociations.get(baseClass.getClass());
    }

    protected void getSystemInstance(BaseClass baseClass, BaseClass baseClass2) throws SQLException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Map<Method, List<BaseClass>> map = this.getRequestAssocMap(baseClass2);
        if (map == null) {
            return;
        }
        block0: for (Map.Entry<Method, List<BaseClass>> entry : map.entrySet()) {
            if (this.invokedMethods.containsKey(entry.getKey()) && baseClass.getGUID().equals(this.invokedMethods.get(entry.getKey()).getGUID())) continue;
            logger.severe("need to found assoc targets for target " + baseClass.getGUID());
            List<BaseClass> list = this.addAssociated(baseClass, entry);
            BaseClass baseClass3 = null;
            for (BaseClass baseClass4 : list) {
                for (BaseClass baseClass5 : entry.getValue()) {
                    if (!baseClass5.getClass().equals(baseClass4.getClass())) continue;
                    baseClass3 = baseClass5;
                }
                if (baseClass3 == null) {
                    logger.severe("Failed to find request object for added " + baseClass4.toString());
                    continue block0;
                }
                this.getSystemInstance(baseClass4, baseClass3);
            }
        }
    }

    public SystemInstance getSystemInstances(AbstractBaseTarget abstractBaseTarget, Map<Class, Map<Method, List<BaseClass>>> map, Map<Class, Map<String, Method>> map2) {
        ArrayList<Object> arrayList = new ArrayList<BaseClass>();
        AbstractBaseTarget abstractBaseTarget2 = null;
        try {
            if (abstractBaseTarget == null) {
                SystemInstance systemInstance = null;
                return systemInstance;
            }
            this.properySetters = map2;
            this.requestedAssociations = map;
            for (BaseClass object : this.getRoots((BaseClass)abstractBaseTarget)) {
                logger.finer("************************** ");
                this.getSystemInstance(object, (BaseClass)abstractBaseTarget);
            }
            for (Map.Entry entry : this.mapOut.entrySet()) {
                AbstractBaseTarget abstractBaseTarget3 = (AbstractBaseTarget)entry.getValue();
                arrayList.add((BaseClass)abstractBaseTarget3);
                if (!abstractBaseTarget.getClass().equals(abstractBaseTarget3.getClass())) continue;
                abstractBaseTarget2 = abstractBaseTarget3;
            }
            this.setOracleHomesAndHosts(arrayList);
            arrayList = new ArrayList();
            for (Map.Entry entry : this.mapOut.entrySet()) {
                arrayList.add(entry.getValue());
            }
            for (Map.Entry entry : this.queryStat.entrySet()) {
                if ((Integer)entry.getValue() <= 1) continue;
                logger.finer((String)entry.getKey() + " executed " + entry.getValue() + " times");
            }
            this.time = System.currentTimeMillis() - this.time;
            logger.info("\n\n **** time=" + this.time + " time in DB=" + this.timeInDB + " num of queries = " + this.numOfQueries + " number of objects retreived " + this.mapOut.size());
        }
        catch (Exception exception) {
            logger.severe(exception.getMessage());
            exception.printStackTrace();
            throw new IllegalArgumentException(exception);
        }
        finally {
            this.releaseDBConnection();
        }
        return new SystemInstance(arrayList, abstractBaseTarget2);
    }

    protected void setOracleHomesAndHosts(BaseClass baseClass) {
        ResultSet resultSet = null;
        try {
            if (baseClass instanceof OracleHome) {
                this.addHomeInfo((OracleHome)baseClass);
                this.addHomePatches((OracleHome)baseClass);
            }
            if (!(baseClass instanceof BaseSWComponent)) {
                return;
            }
            BaseSWComponent baseSWComponent = (BaseSWComponent)baseClass;
            OracleHome oracleHome = baseSWComponent.getRuns_from();
            Host host = baseSWComponent.getHost();
            if (oracleHome == null || host == null) {
                ArrayList<Object> arrayList;
                String string = null;
                string = baseSWComponent.getClass().getName().contains(WLSclassName) ? "select /*sqlOracleHomeAndHostWLS*/ HOME.SOURCE_ME_GUID, WLS.DEST_ME_GUID  FROM SYSMAN.GC_ASSOC_INSTANCES WLS, SYSMAN.GC_ASSOC_INSTANCES HOME where  WLS.SOURCE_ME_GUID =? and WLS.ASSOC_TYPE = 'hosted_by' and  HOME.DEST_ME_GUID = WLS.DEST_ME_GUID and  HOME.ASSOC_TYPE = 'hosted_by' and HOME.SOURCE_ME_GUID in  (select target_guid from MGMT_TARGETS t where T.TARGET_TYPE = 'oracle_home'  and T.CATEGORY_PROP_1='W' ) " : "select /*sqlOracleHomeAndHost*/ oh.entity_guid, host.target_guid  from SYSMAN.MGMT_TARGETS t, SYSMAN.gc_manageable_entities oh, SYSMAN.MGMT$TARGET_PROPERTIES tp, SYSMAN.MGMT_TARGETS host,SYSMAN.MGMT$TARGET_PROPERTIES ohp  where t.target_guid=? and t.host_name = host.target_name and host.target_type = 'host'  and oh.entity_type='oracle_home' and  oh.host_name = t.host_name and oh.entity_guid =ohp.target_guid and tp.target_guid = t.target_guid  and tp.property_name = 'OracleHome' and ohp.property_name ='INSTALL_LOCATION'  and tp.property_value = ohp.property_value";
                PreparedStatement preparedStatement = this.sqlToSt.get(string);
                preparedStatement.setString(1, baseSWComponent.getGUID());
                resultSet = this.executeQuery(preparedStatement, string, baseSWComponent.getGUID(), null, null);
                if (!resultSet.next()) {
                    logger.severe("Failed to find OracleHome or Host target for " + baseSWComponent.toString());
                    this.closeResultSet(resultSet);
                    return;
                }
                String string2 = resultSet.getString(1);
                String string3 = resultSet.getString(2);
                if (oracleHome == null) {
                    oracleHome = (OracleHome)this.mapOut.get(string2);
                    if (oracleHome == null) {
                        oracleHome = (OracleHome)this.fetchTargetByGUID((AbstractBaseTarget)new OracleHome(), string2);
                    }
                    this.addHomeInfo(oracleHome);
                    this.addHomePatches(oracleHome);
                    baseSWComponent.setRuns_from(oracleHome);
                }
                if (host == null) {
                    logger.severe("host is null need to get host info");
                    host = (Host)this.mapOut.get(string3);
                    if (host == null) {
                        host = (Host)this.fetchTargetByGUID((AbstractBaseTarget)new Host(), string3);
                    }
                    baseSWComponent.setHost(host);
                    this.addHostInfo(host);
                }
                if (oracleHome != null && (oracleHome.getHosts() == null || oracleHome.getHosts().isEmpty())) {
                    arrayList = new ArrayList<Object>();
                    arrayList.add(host);
                    oracleHome.setHosts(arrayList);
                    logger.severe("Add host " + host.getName() + " to oracle home" + oracleHome.getName() + " : " + oracleHome.getPath());
                }
                if (host != null) {
                    if (host.getOracleHomes() == null || host.getOracleHomes().isEmpty()) {
                        logger.severe("host is not null");
                        arrayList = new ArrayList();
                        arrayList.add(oracleHome);
                        host.setOracleHomes(arrayList);
                    } else if (!host.getOracleHomes().contains(oracleHome)) {
                        host.getOracleHomes().add(oracleHome);
                        logger.severe("add home" + oracleHome.getPath() + " to host" + host.getName());
                    }
                    logger.severe("Add oracle home " + oracleHome.getPath() + " to host" + host.getName());
                }
            }
        }
        catch (Exception exception) {
            logger.severe("Failed to set OracleHome or Host " + exception.getMessage());
            throw new RuntimeException("Failed to set OracleHome or Host " + exception.getMessage(), exception);
        }
        finally {
            this.closeResultSet(resultSet);
        }
    }

    protected void setOracleHomesAndHosts(List<BaseClass> list) {
        OracleHome oracleHome;
        HashMap<OracleHome, ArrayList<OracleHome>> hashMap = new HashMap<OracleHome, ArrayList<OracleHome>>();
        HashMap<Host, ArrayList<OracleHome>> hashMap2 = new HashMap<Host, ArrayList<OracleHome>>();
        for (BaseClass object : list) {
            List<Object> list2;
            if (object instanceof OracleHome) {
                this.setOracleHomesAndHosts(object);
                continue;
            }
            if (!(object instanceof BaseSWComponent)) continue;
            this.setOracleHomesAndHosts(object);
            oracleHome = (BaseSWComponent)object;
            if (oracleHome.getRuns_from() != null) {
                list2 = (ArrayList<OracleHome>)hashMap.get(oracleHome.getRuns_from());
                if (list2 == null) {
                    list2 = new ArrayList<OracleHome>();
                    hashMap.put(oracleHome.getRuns_from(), (ArrayList<OracleHome>)list2);
                }
                list2.add(oracleHome);
                logger.severe("add object " + oracleHome.getGUID() + " to home " + oracleHome.getRuns_from().getPath());
            }
            if (oracleHome.getHost() == null) continue;
            list2 = (List)hashMap2.get(host);
            if (list2 == null) {
                list2 = new ArrayList();
            }
            list2.add(oracleHome);
            hashMap2.put(oracleHome.getHost(), (ArrayList<OracleHome>)list2);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            oracleHome = (OracleHome)entry.getKey();
            oracleHome.setInstalledSWComponents((List)entry.getValue());
            logger.severe("add home" + oracleHome.getPath() + ":" + oracleHome.getHosts().get(0) + " to mapOut");
            this.mapOut.put(oracleHome.getGUID(), (AbstractBaseTarget)oracleHome);
        }
        for (Map.Entry entry : hashMap2.entrySet()) {
            oracleHome = (Host)entry.getKey();
            oracleHome.setSWComponents((List)entry.getValue());
            this.mapOut.put(oracleHome.getGUID(), (AbstractBaseTarget)oracleHome);
        }
    }

    protected AbstractBaseTarget fetchTargetByGUID(AbstractBaseTarget abstractBaseTarget, String string) {
        AbstractBaseTarget abstractBaseTarget2 = null;
        ResultSet resultSet = null;
        try {
            this.stTargetByGUID.setString(1, string);
            resultSet = this.executeQuery(this.stTargetByGUID, "SELECT /*sqlTargetByGUID*/ t.TARGET_NAME, t.TARGET_GUID, t.DISPLAY_NAME, t.OWNER, t.TYPE_DISPLAY_NAME, t.DISCOVERED_NAME, t.ORACLE_HOME, t.ORACLE_CONFIG_HOME,  a.CURRENT_STATUS, mos.platform_id , HOST_NAME  FROM SYSMAN.MGMT_TARGETS t ,SYSMAN.MGMT_CURRENT_AVAILABILITY a,  SYSMAN.mgmt$os_summary mos  WHERE  t.TARGET_GUID = ? AND t.TARGET_GUID=a.TARGET_GUID(+) and  t.host_name = mos.target_name (+) and mos.target_type = 'host'", string, null, (BaseClass)abstractBaseTarget);
            if (!resultSet.next()) {
                logger.severe("Failed to find target GUID= " + string);
            } else {
                abstractBaseTarget2 = (AbstractBaseTarget)this.targetInstance((BaseClass)abstractBaseTarget, resultSet);
            }
            if (resultSet.next()) {
                logger.severe("Found more then one target GUID= " + abstractBaseTarget2.toString());
            }
            this.closeResultSet(resultSet);
        }
        catch (Exception exception) {
            try {
                logger.severe("Failed to retriev target GUID= " + string);
                throw new RuntimeException(exception);
            }
            catch (Throwable throwable) {
                this.closeResultSet(resultSet);
                throw throwable;
            }
        }
        return abstractBaseTarget2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addHostInfo(Host host) {
        ResultSet resultSet;
        String string;
        block5: {
            string = host.getGUID();
            resultSet = null;
            PreparedStatement preparedStatement = this.sqlToSt.get("select /*sqlHostExa*/ dbm_member from SYSMAN.cm$mgmt_ecm_os where cm_target_guid = ? and dbm_member ='1'");
            preparedStatement.setString(1, string);
            resultSet = this.executeQuery(preparedStatement, "select /*sqlHostExa*/ dbm_member from SYSMAN.cm$mgmt_ecm_os where cm_target_guid = ? and dbm_member ='1'", string, null, null);
            if (resultSet != null && resultSet.next()) break block5;
            this.closeResultSet(resultSet);
            return;
        }
        try {
            host.setDbmMember(new Boolean(true));
            this.closeResultSet(resultSet);
        }
        catch (SQLException sQLException) {
            try {
                logger.severe(" Failed to fetch Host info " + string + sQLException.getMessage() + " continuing");
                this.closeResultSet(resultSet);
            }
            catch (Throwable throwable) {
                this.closeResultSet(resultSet);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addHomePatches(OracleHome oracleHome) {
        String string = oracleHome.getGUID();
        ResultSet resultSet = null;
        try {
            PreparedStatement preparedStatement = this.sqlToSt.get("select /*sqlPatchesInOracleHome*/ hp.patch_id  from SYSMAN.MGMT$OH_PATCH hp where hp.target_guid=?");
            preparedStatement.setString(1, string);
            logger.info(" fetching patches for Oracle Home  " + string);
            resultSet = this.executeQuery(preparedStatement, "select /*sqlPatchesInOracleHome*/ hp.patch_id  from SYSMAN.MGMT$OH_PATCH hp where hp.target_guid=?", string, null, null);
            if (resultSet == null || !resultSet.next()) {
                logger.severe("no patch in Oracle Home " + oracleHome.getName());
                this.closeResultSet(resultSet);
                return;
            }
            ArrayList<BasePatch> arrayList = new ArrayList<BasePatch>();
            do {
                BasePatch basePatch = new BasePatch();
                basePatch.setPatchID(resultSet.getString(1));
                logger.severe("Found patch " + resultSet.getString(1) + "for Oracle Home " + oracleHome.getName());
                basePatch.setOracleHome(oracleHome);
                arrayList.add(basePatch);
            } while (resultSet.next());
            oracleHome.setPatches(arrayList);
            this.closeResultSet(resultSet);
        }
        catch (SQLException sQLException) {
            logger.severe(" Failed to fetch Oracle Home info " + string + sQLException.getMessage() + " continuing");
        }
        finally {
            this.closeResultSet(resultSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void addHomeInfo(OracleHome oracleHome) {
        ResultSet resultSet;
        String string;
        block19: {
            string = oracleHome.getGUID();
            resultSet = null;
            if (this.homeInfo == null) {
                this.homeInfo = new ArrayList<InfoMap>();
                this.homeInfo.add(new InfoMap("OH_OWNER", "setOwner", (BaseClass)oracleHome, false));
                this.homeInfo.add(new InfoMap("OUI_HOME_NAME", "setHomeName", (BaseClass)oracleHome, false));
                this.homeInfo.add(new InfoMap("IS_CLONABLE", "setIsClonable", (BaseClass)oracleHome, false));
                this.homeInfo.add(new InfoMap("HOME_RW_STATUS", "setRWStatus", (BaseClass)oracleHome, false));
                this.homeInfo.add(new InfoMap("HOME_POINTER", "setInventoryLocation", (BaseClass)oracleHome, false));
                this.homeInfo.add(new InfoMap("ARU_ID", "setARUId", (BaseClass)oracleHome, true));
                this.homeInfo.add(new InfoMap("ORACLE_BASE", "setOracleBaseLocation", (BaseClass)oracleHome, true));
            }
            PreparedStatement preparedStatement = this.sqlToSt.get("SELECT /*sqlOracleHomeInfo*/ OH_OWNER, OUI_HOME_NAME, IS_CLONABLE, HOME_RW_STATUS, HOME_POINTER, ARU_ID, ORACLE_BASE FROM SYSMAN.MGMT$OH_HOME_INFO WHERE TARGET_GUID=?");
            preparedStatement.setString(1, string);
            resultSet = this.executeQuery(preparedStatement, "SELECT /*sqlOracleHomeInfo*/ OH_OWNER, OUI_HOME_NAME, IS_CLONABLE, HOME_RW_STATUS, HOME_POINTER, ARU_ID, ORACLE_BASE FROM SYSMAN.MGMT$OH_HOME_INFO WHERE TARGET_GUID=?", string, null, null);
            if (resultSet != null && resultSet.next()) break block19;
            logger.severe(" failed to find info for Oracle Home, probably it is not monitored " + string);
            this.closeResultSet(resultSet);
            return;
        }
        try {
            ArrayList arrayList = new ArrayList();
            do {
                int n = 1;
                for (InfoMap infoMap : this.homeInfo) {
                    Object object = null;
                    if (infoMap.getter != null) {
                        try {
                            object = infoMap.getter.invoke((Object)oracleHome, null);
                        }
                        catch (Exception exception) {
                            logger.severe(" failed to invoke method " + infoMap.getter.getName());
                        }
                    }
                    if (object == null) {
                        try {
                            if (n == 1) {
                                String string2 = resultSet.getString(n);
                                if (string2 == null || string2.length() == 0) {
                                    string2 = "oh_owner";
                                }
                                infoMap.setter.invoke((Object)oracleHome, string2);
                            } else {
                                infoMap.setter.invoke((Object)oracleHome, resultSet.getString(n));
                            }
                        }
                        catch (Exception exception) {
                            logger.severe(" failed to invoke method " + infoMap.setter.getName());
                        }
                    }
                    ++n;
                }
            } while (resultSet.next());
            this.closeResultSet(resultSet);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            logger.severe(" Failed to set Oracle Home info " + string + noSuchMethodException.getMessage() + " continuing");
            noSuchMethodException.printStackTrace();
            this.closeResultSet(resultSet);
        }
        catch (SQLException sQLException) {
            logger.severe(" Failed to fetch Oracle Home info " + string + sQLException.getMessage() + " continuing");
            sQLException.printStackTrace();
            this.closeResultSet(resultSet);
            {
                catch (Throwable throwable) {
                    this.closeResultSet(resultSet);
                    throw throwable;
                }
            }
        }
    }

    protected List<BaseClass> getRoots(BaseClass baseClass) {
        ResultSet resultSet;
        String string;
        ArrayList<BaseClass> arrayList;
        block11: {
            arrayList = new ArrayList<BaseClass>();
            String string2 = baseClass.getGUID();
            String string3 = baseClass.getTargetTypeId();
            String string4 = ((AbstractBaseTarget)baseClass).getName();
            PreparedStatement preparedStatement = null;
            string = null;
            resultSet = null;
            if (string2 == null) {
                if (string3 == null) {
                    throw new RuntimeException("targetType is null!");
                }
                if (string4 != null) {
                    logger.finest(" name =" + string4 + " guid=" + string2 + " ttid=" + string3);
                    string = "SELECT /*sqlTargetByName*/ t.TARGET_NAME, t.TARGET_GUID, t.DISPLAY_NAME, t.OWNER, t.TYPE_DISPLAY_NAME, t.DISCOVERED_NAME, t.ORACLE_HOME, t.ORACLE_CONFIG_HOME,  a.CURRENT_STATUS, mos.platform_id , HOST_NAME  FROM SYSMAN.MGMT_TARGETS t ,SYSMAN.MGMT_CURRENT_AVAILABILITY a,  SYSMAN.mgmt$os_summary mos  WHERE  t.TARGET_NAME = ? AND t.TARGET_TYPE = ? AND t.TARGET_GUID=a.TARGET_GUID(+) and  t.host_name = mos.target_name (+) and mos.target_type = 'host'";
                    preparedStatement = this.sqlToSt.get(string);
                    preparedStatement.setString(1, string4);
                    preparedStatement.setString(2, string3);
                } else {
                    string = "SELECT /*sqlTargetByType*/ t.TARGET_NAME, t.TARGET_GUID, t.DISPLAY_NAME, t.OWNER, t.TYPE_DISPLAY_NAME, t.DISCOVERED_NAME, t.ORACLE_HOME, t.ORACLE_CONFIG_HOME,  a.CURRENT_STATUS, mos.platform_id , HOST_NAME  FROM SYSMAN.MGMT_TARGETS T, SYSMAN.MGMT_CURRENT_AVAILABILITY A, SYSMAN.mgmt$os_summary mos  WHERE  t.TARGET_TYPE = ? AND t.TARGET_GUID=a.TARGET_GUID(+) and  t.host_name = mos.target_name (+) and mos.target_type = 'host'";
                    preparedStatement = this.sqlToSt.get(string);
                    preparedStatement.setString(1, string3);
                }
            } else {
                string = "SELECT /*sqlTargetByGUID*/ t.TARGET_NAME, t.TARGET_GUID, t.DISPLAY_NAME, t.OWNER, t.TYPE_DISPLAY_NAME, t.DISCOVERED_NAME, t.ORACLE_HOME, t.ORACLE_CONFIG_HOME,  a.CURRENT_STATUS, mos.platform_id , HOST_NAME  FROM SYSMAN.MGMT_TARGETS t ,SYSMAN.MGMT_CURRENT_AVAILABILITY a,  SYSMAN.mgmt$os_summary mos  WHERE  t.TARGET_GUID = ? AND t.TARGET_GUID=a.TARGET_GUID(+) and  t.host_name = mos.target_name (+) and mos.target_type = 'host'";
                preparedStatement = this.sqlToSt.get(string);
                preparedStatement.setString(1, string2);
            }
            resultSet = this.executeQuery(preparedStatement, string, string2 == null ? string4 : string2, string3, baseClass);
            if (resultSet != null && resultSet.next()) break block11;
            logger.severe("No records of " + string3);
            ArrayList<BaseClass> arrayList2 = arrayList;
            this.closeResultSet(resultSet);
            return arrayList2;
        }
        try {
            do {
                arrayList.add(this.targetInstance(baseClass, resultSet));
            } while (resultSet.next());
            this.closeResultSet(resultSet);
        }
        catch (Exception exception) {
            try {
                logger.severe("!!! Failed to fetch new instance of " + baseClass.getClass().getName() + " sql=" + string);
                throw new RuntimeException(exception);
            }
            catch (Throwable throwable) {
                this.closeResultSet(resultSet);
                throw throwable;
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BaseClass targetInstance(BaseClass baseClass, ResultSet resultSet) throws SQLException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Map<String, Method> map;
        ResultSet resultSet2;
        AbstractBaseTarget abstractBaseTarget;
        block8: {
            block7: {
                String string = resultSet.getString(2);
                abstractBaseTarget = this.mapOut.get(string);
                if (abstractBaseTarget == null) {
                    abstractBaseTarget = (AbstractBaseTarget)baseClass.getClass().newInstance();
                    abstractBaseTarget.setGUID(string);
                    this.mapOut.put(string, abstractBaseTarget);
                }
                abstractBaseTarget.setName(resultSet.getString(1));
                abstractBaseTarget.setGUID(string);
                abstractBaseTarget.setDisplayName(resultSet.getString(3));
                abstractBaseTarget.setOwner(resultSet.getString(4));
                abstractBaseTarget.setTypeDisplayName(resultSet.getString(5));
                abstractBaseTarget.setDiscoveredName(resultSet.getString(6));
                if (abstractBaseTarget instanceof BaseSWComponent) {
                    ((BaseSWComponent)abstractBaseTarget).setOracleHome(resultSet.getString(7));
                    ((BaseSWComponent)abstractBaseTarget).setOracleConfigHome(resultSet.getString(8));
                    ((BaseSWComponent)abstractBaseTarget).setAvailability(resultSet.getString(9));
                }
                abstractBaseTarget.setPlatform(resultSet.getString(10));
                abstractBaseTarget.setHostName(resultSet.getString(11));
                logger.info("Get target " + abstractBaseTarget.getName() + " on host " + abstractBaseTarget.getHostName());
                resultSet2 = null;
                map = this.properySetters.get(abstractBaseTarget.getClass());
                if (map != null && !map.isEmpty()) break block7;
                AbstractBaseTarget abstractBaseTarget2 = abstractBaseTarget;
                this.closeResultSet(resultSet2);
                return abstractBaseTarget2;
            }
            this.stProperties.setString(1, abstractBaseTarget.getGUID());
            resultSet2 = this.executeQuery(this.stProperties, "select /*sqlProperties*/ UPPER(property_name), property_value from SYSMAN.MGMT$TARGET_PROPERTIES p where P.TARGET_GUID = ?", abstractBaseTarget.getGUID(), null, baseClass);
            if (resultSet2 != null && resultSet2.next()) break block8;
            AbstractBaseTarget abstractBaseTarget3 = abstractBaseTarget;
            this.closeResultSet(resultSet2);
            return abstractBaseTarget3;
        }
        try {
            Method method = null;
            do {
                if ((method = map.get(resultSet2.getString(1))) == null) continue;
                method.invoke((Object)abstractBaseTarget, resultSet2.getString(2));
            } while (resultSet2.next());
            this.closeResultSet(resultSet2);
        }
        catch (Throwable throwable) {
            this.closeResultSet(resultSet2);
            throw throwable;
        }
        return abstractBaseTarget;
    }

    protected String getAssocType(Method method) {
        for (Annotation annotation : method.getAnnotations()) {
            if (!annotation.annotationType().equals(AssociationType.class)) continue;
            return ((AssociationType)annotation).value().toString().toUpperCase();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> getAssocedTargetGuids(BaseClass baseClass, BaseClass baseClass2, String string) throws SQLException {
        ResultSet resultSet;
        ArrayList<String> arrayList;
        block4: {
            arrayList = new ArrayList<String>();
            resultSet = null;
            boolean bl = false;
            resultSet = this.fetchAssociated(baseClass, baseClass2, string, bl);
            if (resultSet != null && resultSet.next()) break block4;
            bl = true;
            string = BaseClass.getInverseAssociationType((String)string);
            this.closeResultSet(resultSet);
            resultSet = this.fetchAssociated(baseClass, baseClass2, string, bl);
            if (resultSet != null && resultSet.next()) break block4;
            logger.severe("No records of " + baseClass.getTargetTypeId() + " associated to " + baseClass2.getGUID());
            ArrayList<String> arrayList2 = arrayList;
            this.closeResultSet(resultSet);
            return arrayList2;
        }
        try {
            do {
                arrayList.add(resultSet.getString(1));
            } while (resultSet.next());
            this.closeResultSet(resultSet);
        }
        catch (Throwable throwable) {
            this.closeResultSet(resultSet);
            throw throwable;
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<BaseClass> getAssocedTarget(BaseClass baseClass, BaseClass baseClass2, String string, boolean bl) throws SQLException, InstantiationException, IllegalAccessException, InvocationTargetException {
        ArrayList<BaseClass> arrayList = new ArrayList<BaseClass>();
        BaseClass baseClass3 = null;
        ArrayList<BaseClass> arrayList2 = null;
        if (bl) {
            arrayList2 = new ArrayList<BaseClass>();
        }
        List<String> list = this.getAssocedTargetGuids(baseClass, baseClass2, string);
        ResultSet resultSet = null;
        try {
            for (int i = 0; i < list.size(); ++i) {
                String string2 = list.get(i);
                if (!this.mapOut.containsKey(string2)) {
                    this.stTargetByGUID.setString(1, string2);
                    resultSet = this.executeQuery(this.stTargetByGUID, "SELECT /*sqlTargetByGUID*/ t.TARGET_NAME, t.TARGET_GUID, t.DISPLAY_NAME, t.OWNER, t.TYPE_DISPLAY_NAME, t.DISCOVERED_NAME, t.ORACLE_HOME, t.ORACLE_CONFIG_HOME,  a.CURRENT_STATUS, mos.platform_id , HOST_NAME  FROM SYSMAN.MGMT_TARGETS t ,SYSMAN.MGMT_CURRENT_AVAILABILITY a,  SYSMAN.mgmt$os_summary mos  WHERE  t.TARGET_GUID = ? AND t.TARGET_GUID=a.TARGET_GUID(+) and  t.host_name = mos.target_name (+) and mos.target_type = 'host'", string2, null, baseClass2);
                    if (resultSet == null || !resultSet.next()) {
                        throw new RuntimeException("Failed to find target with GUID=" + string2);
                    }
                    baseClass3 = this.targetInstance(baseClass, resultSet);
                    if (resultSet.next()) {
                        throw new RuntimeException("Found more than one target with GUID=" + string2);
                    }
                } else {
                    baseClass3 = (BaseClass)this.mapOut.get(string2);
                }
                if (arrayList2 == null && i > 1) {
                    logger.severe(" Fetched multiple records where should be only one!" + baseClass3.toString() + " in=" + baseClass);
                }
                arrayList.add(baseClass3);
                if (arrayList2 == null) continue;
                arrayList2.add(baseClass3);
            }
        }
        finally {
            this.closeResultSet(resultSet);
        }
        return arrayList;
    }

    protected List<BaseClass> addAssociated(BaseClass baseClass, Map.Entry<Method, List<BaseClass>> entry) throws SQLException, InstantiationException, IllegalAccessException, InvocationTargetException {
        ArrayList<BaseClass> arrayList = new ArrayList<BaseClass>();
        Method method = entry.getKey();
        boolean bl = false;
        if (List.class.equals(method.getParameterTypes()[0])) {
            bl = true;
        }
        for (BaseClass baseClass2 : entry.getValue()) {
            String string;
            String string2 = baseClass2.getTargetTypeId();
            if (this.wantToSkip(baseClass, method, string2, string = this.getAssocType(method))) continue;
            logger.severe("Add assoced target " + baseClass2.getClass() + " with target type " + string2);
            List<BaseClass> list = this.getAssocedTarget(baseClass2, baseClass, string, bl);
            if (list == null || list.size() <= 0) continue;
            arrayList.addAll(list);
        }
        if (arrayList.size() >= 1 && bl) {
            method.invoke((Object)baseClass, arrayList);
        } else if (arrayList.size() == 1 && !bl) {
            method.invoke((Object)baseClass, arrayList.get(0));
        }
        this.invokedMethods.put(method, baseClass);
        return arrayList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean wantToSkip(BaseClass baseClass, Method method, String string, String string2) {
        boolean bl = false;
        Method method2 = baseClass.getGetter(method);
        try {
            Object object = method2.invoke((Object)baseClass, null);
            if (object != null && object instanceof AbstractBaseTarget) {
                return true;
            }
            boolean bl2 = false;
            bl = bl2;
            if (bl) return true;
            if (object != null && object instanceof List && !((List)object).isEmpty()) {
                return true;
            }
            boolean bl3 = false;
            bl = bl3;
            if (bl) return true;
            if (baseClass instanceof BaseSWComponent) {
                if (host.equals(string)) {
                    return true;
                }
            }
            boolean bl4 = false;
            bl = bl4;
            if (bl) return true;
            if (baseClass instanceof BaseSWComponent) {
                if (oracle_home.equals(string)) {
                    return true;
                }
            }
            boolean bl5 = false;
            bl = bl5;
            if (bl) return true;
            if (baseClass instanceof OracleHome) {
                if (host.equals(string)) {
                    return true;
                }
            }
            boolean bl6 = false;
            bl = bl6;
            if (bl) return true;
            if (!(baseClass instanceof Host)) return false;
            if (!oracle_home.equals(string)) return false;
            return true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return bl;
    }

    protected Boolean isSIDB(BaseClass baseClass) {
        if (!DBInstanceTypeID.equals(baseClass.getTargetTypeId())) {
            return null;
        }
        return new Boolean(baseClass.getClass().getName().contains(SIDBclassName));
    }

    protected Boolean isAdminWLS(BaseClass baseClass) {
        if (!WLStypeID.equals(baseClass.getTargetTypeId())) {
            return null;
        }
        return new Boolean(baseClass.getClass().getName().contains(adminWLSclassName));
    }

    protected ResultSet fetchAssociated(BaseClass baseClass, BaseClass baseClass2, String string, boolean bl) throws SQLException {
        string = null;
        String string2 = baseClass.getTargetTypeId();
        String string3 = baseClass2.getGUID();
        Integer n = null;
        if (string != null && !bl) {
            n = direct;
        }
        if (string == null && !bl) {
            n = allDirect;
        }
        if (string != null && bl) {
            n = inverse;
        }
        if (string == null && bl) {
            n = allInverse;
        }
        Boolean bl2 = this.isSIDB(baseClass);
        Boolean bl3 = this.isAdminWLS(baseClass);
        String string4 = null;
        string4 = bl2 != null && bl2 != false ? this.sqlByClass.get(SIDBclassName).get(n) : (bl2 != null && bl2 == false ? this.sqlByClass.get(RACinstClassName).get(n) : (bl3 != null && bl3 != false ? this.sqlByClass.get(adminWLSclassName).get(n) : (bl3 != null && bl3 == false ? this.sqlByClass.get(WLSclassName).get(n) : this.sqlAll.get(n))));
        PreparedStatement preparedStatement = this.sqlToSt.get(string4);
        preparedStatement.setString(1, string3);
        preparedStatement.setString(2, string2);
        if (string != null) {
            preparedStatement.setString(3, string);
        }
        return this.executeQuery(preparedStatement, string4, string3, string2, baseClass2);
    }

    protected ResultSet executeQuery(PreparedStatement preparedStatement, String string, String string2, String string3, BaseClass baseClass) throws SQLException {
        String string4 = "";
        try {
            string4 = string.substring(6, string.indexOf("*/") + 2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!this.executedSQL.containsKey(string4)) {
            this.executedSQL.put(string4, preparedStatement);
        }
        String string5 = string;
        int n = string.indexOf("?");
        if (n > 0) {
            string5 = string.substring(0, n + 1).replace("?", "'" + string2 + "'");
            string5 = string5.concat(string.substring(n + 1, string.length()));
            if (string3 != null) {
                string5 = string5.replace("?", "'" + string3 + "'");
            }
        }
        int n2 = 0;
        if (this.queryStat.containsKey(string5)) {
            n2 = this.queryStat.get(string5);
        }
        this.queryStat.put(string5, new Integer(n2 + 1));
        long l = System.currentTimeMillis();
        ResultSet resultSet = null;
        try {
            resultSet = preparedStatement.executeQuery();
            this.openResultSets.add(new Result(string4, resultSet));
        }
        catch (SQLException sQLException) {
            logger.severe(" Failed in query \n" + string5);
            throw sQLException;
        }
        this.timeInDB += System.currentTimeMillis() - l;
        ++this.numOfQueries;
        return resultSet;
    }

    public Map<Method, BaseClass> getInvokedMethods() {
        return this.invokedMethods;
    }

    public Map<String, AbstractBaseTarget> getMapOut() {
        return this.mapOut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.releaseDBConnection();
        }
        finally {
            super.finalize();
        }
    }

    static {
        direct = new Integer(1);
        inverse = new Integer(2);
        allDirect = new Integer(3);
        allInverse = new Integer(4);
    }

    protected class Result {
        ResultSet set = null;
        String sqlName = null;

        Result(String string, ResultSet resultSet) {
            this.sqlName = string;
            this.set = resultSet;
        }
    }

    protected class InfoMap {
        String column = null;
        Method setter = null;
        Method getter = null;

        InfoMap(String string, String string2, BaseClass baseClass, boolean bl) throws NoSuchMethodException {
            this.column = string;
            Class[] classArray = new Class[]{String.class};
            this.setter = baseClass.getClass().getMethod(string2, classArray);
            if (bl) {
                this.getter = baseClass.getGetter(this.setter);
            }
        }
    }
}

