/*
 * Decompiled with CFR 0.152.
 */
package dbmodel.util;

import dbmodel.common.EMtargetTypes;
import dbmodel.patchmetadata.EsysPatchBundleXML;
import dbmodel.patchmetadata.SubpatchXML;
import dbmodel.patchmetadata.TargetType;
import dbmodel.patchmetadata.automation;
import dbmodel.patchmetadata.fvalue;
import dbmodel.patchmodel.PatchType;
import dbmodel.patchmodel.PatchingTool;
import dbmodel.util.BundleValidationException;
import dbmodel.util.BundleXmlException;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.SAXException;

public class BundleXmlV1Helper {
    protected static Logger logger = null;
    protected String xsdFileName = null;
    protected static String xmlFileName = null;
    protected JAXBContext context = null;
    protected Unmarshaller unmarshaller = null;

    public BundleXmlV1Helper() throws BundleXmlException {
        this("model/xml/bundle.xsd");
        xmlFileName = "model/util/test/bundle.xml";
    }

    public BundleXmlV1Helper(String xsdFileName) throws BundleXmlException {
        this.xsdFileName = xsdFileName;
        logger = Logger.getLogger(this.getClass().getName());
        try {
            SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = sf.newSchema(this.getClass().getResource("/" + xsdFileName));
            this.context = JAXBContext.newInstance((Class[])this.getClasses());
            this.unmarshaller = this.context.createUnmarshaller();
            this.unmarshaller.setSchema(schema);
        }
        catch (JAXBException e) {
            String msg = "Failed to create JAXB context due to: " + e.getMessage();
            logger.log(Level.SEVERE, msg);
            throw new BundleXmlException(msg, e);
        }
        catch (SAXException e) {
            logger.log(Level.SEVERE, "The Bundle schema is invalid. ");
            throw new BundleXmlException("The Bundle schema is invalid", e);
        }
    }

    protected Class[] getClasses() {
        return new Class[]{EsysPatchBundleXML.class, SubpatchXML.class, TargetType.class, automation.class, fvalue.class, PatchingTool.class, PatchType.class, EMtargetTypes.class};
    }

    public EsysPatchBundleXML readBundle(File xmlFile) throws BundleXmlException, BundleValidationException {
        if (xmlFile == null) {
            throw new BundleXmlException("xml file is null!");
        }
        xmlFileName = xmlFile.getAbsolutePath() + xmlFile.getName();
        try {
            Object object = this.unmarshaller.unmarshal(xmlFile);
            return (EsysPatchBundleXML)object;
        }
        catch (UnmarshalException e) {
            String msg = xmlFileName + " is not valid: " + e.getMessage() + " schema is " + this.xsdFileName;
            logger.log(Level.SEVERE, msg);
            throw new BundleValidationException(msg, e);
        }
        catch (JAXBException e) {
            String msg = "Unexpected error " + e.getMessage() + " occures while unmarshalling " + xmlFileName;
            logger.log(Level.SEVERE, msg);
            throw new BundleXmlException(msg);
        }
    }

    public EsysPatchBundleXML readBundle(InputStream xmlFile) throws BundleXmlException, BundleValidationException {
        try {
            Object object = this.unmarshaller.unmarshal(xmlFile);
            return (EsysPatchBundleXML)object;
        }
        catch (UnmarshalException e) {
            String msg = " bundle.xml is not valid: " + e.getMessage() + ". xml is " + xmlFile + " schema is " + this.xsdFileName;
            logger.log(Level.SEVERE, msg);
            throw new BundleValidationException(msg, e);
        }
        catch (JAXBException e) {
            String msg = "Unexpected error " + e.getMessage() + " occures while unmarshalling bundle.xml: " + xmlFile;
            logger.log(Level.SEVERE, msg);
            throw new BundleXmlException("Unexpected errors occur while unmarshalling bundle.xml");
        }
    }

    public EsysPatchBundleXML readBundle(String xmlContent) throws BundleValidationException, BundleXmlException {
        try {
            Object object = this.unmarshaller.unmarshal((Reader)new StringReader(xmlContent));
            return (EsysPatchBundleXML)object;
        }
        catch (UnmarshalException e) {
            String msg = " bundle.xml is not valid:" + e.getMessage() + ". xml is " + xmlContent + " schema is " + this.xsdFileName;
            logger.log(Level.SEVERE, msg);
            throw new BundleValidationException(msg, e);
        }
        catch (JAXBException e) {
            String msg = "Unexpected error " + e.getMessage() + " occures while unmarshalling bundle.xml: " + xmlContent;
            logger.log(Level.SEVERE, msg);
            throw new BundleXmlException(msg);
        }
    }

    public static void main(String[] args) {
        try {
            BundleXmlV1Helper helper = new BundleXmlV1Helper();
            EsysPatchBundleXML obj = helper.readBundle(new File(xmlFileName));
            System.out.println("\n**********  TESTING NEW XSD WITH OLD XML  **************");
            helper.printEsysPatchBundleXMLObj(obj);
            System.out.println("**********************************************************\n");
        }
        catch (Throwable t) {
            System.out.println(" Exception = " + t.getMessage());
            t.printStackTrace();
        }
    }

    public void printEsysPatchBundleXMLObj(EsysPatchBundleXML top) {
        System.out.println(top.toString());
        System.out.println(" UPI=" + top.getUPI() + " PatchID=" + top.getPatchID() + " PatchType=" + (Object)((Object)top.getPatchType()) + " TypeVersion=" + top.getTypeVersion() + " Description=" + top.getDescription());
        automation auto = top.getAutomation();
        System.out.println("   automation: OplanVersion=" + auto.getOplanVersion() + " Hash=" + auto.getHash());
        fvalue f = top.getFvalue();
        System.out.println("   fvalue: Minimum_opatch_version" + f.getMinimum_opatch_version() + " Function=" + f.getFunction() + " Value=" + f.getValue());
        System.out.println("   system:" + this.targetTypetoString(top.getSystem()));
        System.out.println("   subpatches:");
        for (SubpatchXML sub : top.getSubpatches()) {
            System.out.println(this.subpatchtoString(sub));
        }
    }

    public String targetTypetoString(TargetType tt) {
        StringBuffer sb = new StringBuffer("TargetType: type=").append((Object)tt.getType()).append(" version=").append(tt.getVersion()).append(" Product=").append(tt.getProduct()).append(" Release=").append(tt.getRelease());
        return sb.toString();
    }

    public String subpatchtoString(SubpatchXML sub) {
        StringBuffer sb = new StringBuffer("subpatch: Location=").append(sub.getLocation()).append(" patchID=").append(sub.getPatchID()).append(" PatchingTool=").append((Object)sub.getPatchingTool()).append(" PatchType=").append((Object)sub.getPatchType()).append(" Platform=").append(sub.getPlatform());
        for (TargetType tt : sub.getTargetTypes()) {
            sb.append("\n   ").append(this.targetTypetoString(tt));
        }
        return sb.toString();
    }
}

