/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.util.perfmonitor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class MethodTrackerObj
implements Serializable {
    private static final long serialVersionUID = 7100788769588997384L;
    private static Logger logger = Logger.getLogger(MethodTrackerObj.class.getName());
    private boolean initComplete = false;
    private String methodName;
    private String className;
    private int lineNum;
    private long startTime;
    private long timeSpent;
    private long childrenTimeSpent;
    private long maxHeapSize;
    private long cumulativeCount;
    private MethodTrackerObj parent;
    private List<MethodTrackerObj> children;
    private int printTabSpace = 0;
    private StackTraceElement[] stackTrace;
    private String tag;
    private boolean inprogress = false;
    private boolean isTrackingDisabled = false;
    private static List<MethodTrackerObj> openTrackers = new ArrayList<MethodTrackerObj>();
    protected static int trackerUseCount = 0;
    protected static long trackerTimeSpent = 0L;

    protected MethodTrackerObj() {
    }

    protected MethodTrackerObj(boolean isTrackingDisabled) {
        this.isTrackingDisabled = isTrackingDisabled;
    }

    protected boolean isInitComplete() {
        return this.initComplete;
    }

    protected void setInitComplete(boolean initComplete) {
        this.initComplete = initComplete;
    }

    protected String getMethodName() {
        return this.methodName;
    }

    protected void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    protected String getClassName() {
        return this.className;
    }

    protected void setClassName(String className) {
        this.className = className;
    }

    protected int getLineNum() {
        return this.lineNum;
    }

    protected void setLineNum(int lineNum) {
        this.lineNum = lineNum;
    }

    protected Long getStarTime() {
        return this.startTime;
    }

    protected void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    protected void setTimeSpent(Long timeSpent) {
        this.timeSpent = timeSpent;
    }

    protected long getTimeSpent() {
        return this.timeSpent;
    }

    protected long getChildrenTimeSpent() {
        return this.childrenTimeSpent;
    }

    protected void setChildrenTimeSpent(long childrenTimeSpent) {
        this.childrenTimeSpent = childrenTimeSpent;
    }

    protected long getMaxHeapSize() {
        return this.maxHeapSize;
    }

    protected void setMaxHeapSize(long heapSize) {
        this.maxHeapSize = heapSize;
    }

    protected long getCumulativeCount() {
        return this.cumulativeCount;
    }

    protected void setCumulativeCount(long cumulativeCount) {
        this.cumulativeCount = cumulativeCount;
    }

    protected MethodTrackerObj getParent() {
        return this.parent;
    }

    protected void setParent(MethodTrackerObj parent) {
        this.parent = parent;
    }

    protected List<MethodTrackerObj> getChildren() {
        return this.children;
    }

    protected boolean hasChildren() {
        return this.children != null && this.children.size() > 0;
    }

    protected void setChildren(List<MethodTrackerObj> children) {
        this.children = children;
    }

    protected void addChild(MethodTrackerObj child) {
        if (this.children == null) {
            this.children = new ArrayList<MethodTrackerObj>();
        }
        this.children.add(child);
    }

    protected int getPrintTabSpace() {
        return this.printTabSpace;
    }

    protected void setPrintTabSpace(int printTabSpace) {
        this.printTabSpace = printTabSpace;
    }

    protected StackTraceElement[] getStackTrace() {
        return this.stackTrace;
    }

    protected void setStackTrace(StackTraceElement[] stackTrace) {
        this.stackTrace = stackTrace;
    }

    protected String getTag() {
        return this.tag;
    }

    protected void setTag(String tag) {
        this.tag = tag;
    }

    protected boolean isInprogress() {
        return this.inprogress;
    }

    protected void setInprogress(boolean inprogress) {
        this.inprogress = inprogress;
    }

    public void start() {
        try {
            long t1 = System.currentTimeMillis();
            if (!this.isTrackingDisabled && this.initComplete) {
                ++trackerUseCount;
                ++this.cumulativeCount;
                if (this.isInprogress()) {
                    this.end();
                }
                this.setStartTime(System.currentTimeMillis());
                this.setInprogress(true);
                openTrackers.add(this);
            }
            long t2 = System.currentTimeMillis();
            trackerTimeSpent += t2 - t1;
        }
        catch (Exception ex) {
            logger.fine("Error while starting the tracker. Message - " + ex.getMessage());
        }
    }

    public void end() {
        try {
            long t1 = System.currentTimeMillis();
            if (!this.isTrackingDisabled && this.initComplete) {
                long prevMaxHeap = this.getMaxHeapSize();
                long curHeap = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
                if (curHeap > prevMaxHeap) {
                    this.setMaxHeapSize(curHeap);
                }
                this.setInprogress(false);
                long prevTimeSpent = this.getTimeSpent();
                long currTimeSpent = System.currentTimeMillis() - this.getStarTime();
                this.setTimeSpent(prevTimeSpent + currTimeSpent);
                openTrackers.remove(this);
                for (MethodTrackerObj openTracker : openTrackers) {
                    if (!openTracker.equals(this.getParent())) continue;
                    openTracker.setChildrenTimeSpent(openTracker.getChildrenTimeSpent() + currTimeSpent);
                }
            }
            long t2 = System.currentTimeMillis();
            trackerTimeSpent += t2 - t1;
        }
        catch (Exception ex) {
            logger.fine("Error while ending the tracker. Message - " + ex.getMessage());
        }
    }

    public boolean equals(Object obj) {
        boolean isSameObj;
        MethodTrackerObj comparingObj = (MethodTrackerObj)obj;
        boolean bl = isSameObj = this.className.equalsIgnoreCase(comparingObj.getClassName()) && this.methodName.equalsIgnoreCase(comparingObj.getMethodName()) && this.tag.equalsIgnoreCase(comparingObj.getTag());
        if (isSameObj) {
            if (this.getParent() != null && comparingObj.getParent() != null) {
                isSameObj = this.getParent().equals(comparingObj.getParent());
            } else if (this.getParent() != null || comparingObj.getParent() != null) {
                isSameObj = false;
            }
        }
        return isSameObj;
    }
}

