/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.twophase;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import oracle.glcm.opatch.common.api.install.FileState;
import oracle.opatch.DeleteJarAction;
import oracle.opatch.JarAction;
import oracle.opatch.MakeAction;
import oracle.opatch.NotSupportedOPatchCASOperationException;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.OneOffEntry;
import oracle.opatch.PatchObject;
import oracle.opatch.PatchingModel;
import oracle.opatch.SystemCall;
import oracle.opatch.cas.OPatchCASException;
import oracle.opatch.cas.client.CASClientFactory;
import oracle.opatch.cup.CUPFileHandler;
import oracle.opatch.cup.CUPPatchComponent;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.wrappers.WrapperFactory;

public class TwoPhasePatchingHelper {
    public static Map<Path, String> getBaseCopy(String oh) {
        HashMap<Path, String> copy = new HashMap<Path, String>();
        String contents = "inventory" + File.separator + "ContentsXML";
        Path pc = WrapperFactory.getNioServiceWrapper().getPath(contents, new String[0]);
        String oneoffs = "inventory" + File.separator + "oneoffs";
        Path po = WrapperFactory.getNioServiceWrapper().getPath(oneoffs, new String[0]);
        String inv = "inventory";
        Path invPath = WrapperFactory.getNioServiceWrapper().getPath(inv, new String[0]);
        copy.put(pc, contents);
        copy.put(po, oneoffs);
        if (OPatchEnv.isNextGen()) {
            String patches = "inventory" + File.separator + "patches";
            Path pp = WrapperFactory.getNioServiceWrapper().getPath(patches, new String[0]);
            copy.put(pp, patches);
            TwoPhasePatchingHelper.addInvFiles(oh, inv, copy);
        }
        return copy;
    }

    private static void addInvFiles(String oh, String inv, Map<Path, String> copy) {
        Path invDir = WrapperFactory.getNioServiceWrapper().getPath(oh + File.separator + inv, new String[0]);
        if (Files.exists(invDir, new LinkOption[0])) {
            DirectoryStream<Path> files = null;
            try {
                files = Files.newDirectoryStream(invDir);
            }
            catch (IOException e2) {
                OLogger.debug(e2.getMessage());
            }
            if (files != null) {
                for (Path file : files) {
                    Path key;
                    if (Files.isDirectory(file, new LinkOption[0])) {
                        key = WrapperFactory.getNioServiceWrapper().getPath(oh, new String[0]).relativize(file);
                        copy.put(key, key.toString());
                        TwoPhasePatchingHelper.addInvFiles(oh, key.toString(), copy);
                        continue;
                    }
                    key = WrapperFactory.getNioServiceWrapper().getPath(oh, new String[0]).relativize(file);
                    copy.put(key, key.toString());
                }
            }
        } else {
            OLogger.debug("TwoPhasePatchingHelper::addInvFiles : File does not exist. " + invDir.toString());
        }
    }

    public static Map<Path, String> getReferencedFiles(String oh, PatchObject[] patches) {
        if (patches == null || patches.length == 0) {
            return new HashMap<Path, String>();
        }
        HashMap<Path, String> copy = new HashMap<Path, String>();
        for (int i2 = 0; i2 < patches.length; ++i2) {
            if (!OPatchEnv.isCUP2Supported()) continue;
            CUPFileHandler cupFileHandler = new CUPFileHandler();
            List<CUPPatchComponent> comps = cupFileHandler.getCUPPatchComponentListForReferencedFiles(patches[i2]);
            for (CUPPatchComponent comp : comps) {
                Map<FileState, List<String>> fileStateMap = comp.getFileMap();
                for (Map.Entry<FileState, List<String>> entry : fileStateMap.entrySet()) {
                    String fileState = entry.getKey().toString();
                    List<String> fileList = entry.getValue();
                    if (!fileState.equalsIgnoreCase(FileState.REFERENCED.toString())) continue;
                    for (String file : fileList) {
                        Path filePath = WrapperFactory.getNioServiceWrapper().getPath(file, new String[0]);
                        copy.put(filePath, file);
                    }
                }
            }
        }
        OLogger.justlog(OLogger.INFO, "getReferencedFiles(): " + copy);
        return copy;
    }

    public static Map<Path, String> getCopiedFiles(String oh, PatchObject[] patches) {
        MakeAction[] makes;
        OLogger.justlog(OLogger.INFO, "ENTERING METHOD: PhaseOneOperator::getCopiedFiles (String oh, PatchObject[] patches)");
        if (patches == null || patches.length == 0) {
            return new HashMap<Path, String>();
        }
        HashMap<Path, String> copy = new HashMap<Path, String>();
        HashSet<String> patchfiles = new HashSet<String>();
        OneOffEntry[] oneoffs = new OneOffEntry[patches.length];
        for (int i2 = 0; i2 < patches.length; ++i2) {
            oneoffs[i2] = patches[i2].toOneOffEntry(oh);
            String[][] filesTouched = oneoffs[i2].getFilesTouched(oh);
            OLogger.justlog(OLogger.INFO, "Getting list of files touched by patch " + oneoffs[i2].getPatchID());
            for (int x = 0; x < filesTouched.length; ++x) {
                String touchfile = filesTouched[x][1];
                patchfiles.add(touchfile);
                OLogger.justlog(OLogger.FINEST, MessageFormat.format("file \"{0}\" touched by the patch, adding to copy list. \n", touchfile));
            }
            ListIterator iter = patches[i2].getAllIncludedJarActions();
            while (iter.hasNext()) {
                String[] jarfiles;
                JarAction a2 = (JarAction)iter.next();
                for (String jarfile : jarfiles = a2.filesTouched(oh)) {
                    patchfiles.add(jarfile);
                    OLogger.justlog(OLogger.FINEST, MessageFormat.format("multi-layer container file \"{0}\" touched by patch, adding to copy list. \n", jarfile));
                }
            }
            ListIterator djIter = patches[i2].getAllIncludedDeleteJarActions();
            while (djIter.hasNext()) {
                String[] jarfiles;
                DeleteJarAction a3 = (DeleteJarAction)djIter.next();
                for (String jarfile : jarfiles = a3.filesTouched(oh)) {
                    patchfiles.add(jarfile);
                    OLogger.justlog(OLogger.FINEST, MessageFormat.format("multi-layer container file \"{0}\" touched by patch, adding to copy list. \n", jarfile));
                }
            }
            for (String patchfile : patchfiles) {
                Path file = WrapperFactory.getNioServiceWrapper().getPath(patchfile, new String[0]);
                if (!Files.exists(file, new LinkOption[0])) continue;
                patchfile = patchfile.substring(oh.length() + 1, patchfile.length());
                Path p1 = WrapperFactory.getNioServiceWrapper().getPath(patchfile, new String[0]);
                OLogger.justlog(OLogger.FINEST, MessageFormat.format("file \"{0}\" touched by the patch and existed in OH, adding to copy list. \n", patchfile));
                copy.put(p1, patchfile);
            }
        }
        for (MakeAction m2 : makes = OPatchSessionHelper.getIncludedMakeActions(oh, patches)) {
            String makefile = m2.getMakeFile();
            String changedir = m2.getChangeDirectory();
            makefile = changedir + File.separator + makefile;
            Path p2 = WrapperFactory.getNioServiceWrapper().getPath(makefile, new String[0]);
            copy.put(p2, makefile);
            OLogger.justlog(OLogger.INFO, MessageFormat.format("make file \"{0}\" needed for relink, adding to copy list. \n", makefile));
        }
        OLogger.justlog(OLogger.INFO, "EXITING METHOD: PhaseOneOperator::getCopiedFiles (String oh, PatchObject[] patches)");
        return copy;
    }

    public static void addCopiedFilesForPatchStorage(Map<Path, String> copy, String oh, PatchObject[] patches) {
        String patchStorage = OPatchEnv.getPatchStorageName();
        if (PatchingModel.returnModelCode(oh) == 1) {
            for (PatchObject po : patches) {
                String patchInPS = patchStorage + File.separator + po.getCookedPatchID();
                copy.put(WrapperFactory.getNioServiceWrapper().getPath(patchInPS, new String[0]), patchInPS);
            }
            String interimInventory = patchStorage + File.separator + "interim_inventory.txt";
            String latestOPatchSession = patchStorage + File.separator + "LatestOPatchSession.properties";
            String recordInventory = patchStorage + File.separator + "record_inventory.txt";
            String napplyDirectory = patchStorage + File.separator + "NApply";
            String nrollbackDirectory = patchStorage + File.separator + "NRollback";
            String fileToPropogate = patchStorage + File.separator + "prereq_testing.txt";
            String verifyDirectory = patchStorage + File.separator + "verify";
            String newdirsFile = patchStorage + File.separator + "newdirs.txt";
            copy.put(WrapperFactory.getNioServiceWrapper().getPath(interimInventory, new String[0]), interimInventory);
            copy.put(WrapperFactory.getNioServiceWrapper().getPath(latestOPatchSession, new String[0]), latestOPatchSession);
            copy.put(WrapperFactory.getNioServiceWrapper().getPath(recordInventory, new String[0]), recordInventory);
            copy.put(WrapperFactory.getNioServiceWrapper().getPath(napplyDirectory, new String[0]), napplyDirectory);
            copy.put(WrapperFactory.getNioServiceWrapper().getPath(nrollbackDirectory, new String[0]), nrollbackDirectory);
            copy.put(WrapperFactory.getNioServiceWrapper().getPath(fileToPropogate, new String[0]), fileToPropogate);
            copy.put(WrapperFactory.getNioServiceWrapper().getPath(verifyDirectory, new String[0]), verifyDirectory);
            copy.put(WrapperFactory.getNioServiceWrapper().getPath(newdirsFile, new String[0]), newdirsFile);
        }
    }

    public static void addCopiedFilesForSparceCopy(Map<Path, String> copy, String oh, PatchObject[] patches) {
        HashMap<String, String> workingAppDirs = new HashMap<String, String>();
        if (OPatchEnv.isSparseCopy()) {
            for (PatchObject pObject : patches) {
                if (!pObject.isSparseCopy()) continue;
                ArrayList appDirs = pObject.getApplicationDirs();
                for (int i2 = 0; i2 < appDirs.size(); ++i2) {
                    String appDir = (String)appDirs.get(i2);
                    Path latestFile = OPatchEnv.getLatestFileWtihStartString(oh, appDir, "latest-ptr-");
                    if (latestFile != null) {
                        String workingDirName = latestFile.getFileName().toString().substring("latest-ptr-".length());
                        String relativeWorkingDir = appDir + File.separator + workingDirName;
                        workingAppDirs.put(appDir, relativeWorkingDir);
                        copy.put(WrapperFactory.getNioServiceWrapper().getPath(relativeWorkingDir, new String[0]), relativeWorkingDir);
                        String relativeLatestPtrPath = latestFile.toAbsolutePath().toString().substring(oh.length() + 1);
                        copy.put(WrapperFactory.getNioServiceWrapper().getPath(relativeLatestPtrPath, new String[0]), relativeLatestPtrPath);
                    } else {
                        workingAppDirs.put(appDir, "");
                    }
                    Path priorFile = OPatchEnv.getLatestFileWtihStartString(oh, appDir, "prior-ptr-");
                    if (priorFile == null) continue;
                    String relativePriorPtrPath = priorFile.toAbsolutePath().toString().substring(oh.length() + 1);
                    copy.put(WrapperFactory.getNioServiceWrapper().getPath(relativePriorPtrPath, new String[0]), relativePriorPtrPath);
                    if (!pObject.isDeleteOldDirectory()) continue;
                    String oldDirName = priorFile.getFileName().toString().substring("prior-ptr-".length());
                    String relativeOldDir = appDir + File.separator + oldDirName;
                    copy.put(WrapperFactory.getNioServiceWrapper().getPath(relativeOldDir, new String[0]), relativeOldDir);
                }
            }
            OPatchEnv.setApplicationWorkingDirectory(workingAppDirs);
            OLogger.justlog(OLogger.INFO, "casPrepare::the working application directories for each application are " + workingAppDirs);
        }
    }

    public static void validateBlacklistFiles(Collection<String> patchedFiles) throws OPatchCASException {
        List<String> blFiles = CASClientFactory.getCASClient().getBlacklistFiles();
        ArrayList<String> pFiles = new ArrayList<String>(patchedFiles);
        pFiles.retainAll(blFiles);
        if (!pFiles.isEmpty()) {
            NotSupportedOPatchCASOperationException re = new NotSupportedOPatchCASOperationException(OLogger.getString("OUI-68207", new Object[]{pFiles}));
            throw re;
        }
    }

    public static void doTheCopy(Map<Path, String> copy, String oh, String soh) {
        Path ohPath = WrapperFactory.getNioServiceWrapper().getPath(oh, new String[0]);
        Path sohPath = WrapperFactory.getNioServiceWrapper().getPath(soh, new String[0]);
        for (Path path : copy.keySet()) {
            Path src = ohPath.resolve(path);
            Path dest = sohPath.resolve(path);
            if (!Files.exists(src, new LinkOption[0])) continue;
            if (Files.isDirectory(src, new LinkOption[0])) {
                try {
                    TwoPhasePatchingHelper.doCopyDirectory(src, dest);
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                continue;
            }
            SystemCall.copyFile(src, dest);
        }
    }

    private static void doCopyDirectory(Path srcDir, Path destDir) throws IOException {
        DirectoryStream<Path> srcFiles;
        block8: {
            srcFiles = Files.newDirectoryStream(srcDir);
            if (!destDir.toString().equals("") && Files.exists(destDir, new LinkOption[0])) {
                if (!Files.isDirectory(destDir, new LinkOption[0])) {
                    throw new IOException("Destination '" + destDir + "' exists but is not a directory");
                }
            } else {
                try {
                    Files.createDirectories(destDir, new FileAttribute[0]);
                }
                catch (IOException e2) {
                    if (Files.isDirectory(destDir, new LinkOption[0])) break block8;
                    throw new IOException("Destination '" + destDir + "' directory cannot be created");
                }
            }
        }
        if (!Files.isWritable(destDir)) {
            throw new IOException("Destination '" + destDir + "' cannot be written to");
        }
        for (Path srcFile : srcFiles) {
            Path dstFile = WrapperFactory.getNioServiceWrapper().getPath(destDir.toString(), srcFile.getFileName().toString());
            if (Files.isDirectory(srcFile, new LinkOption[0])) {
                TwoPhasePatchingHelper.doCopyDirectory(srcFile, dstFile);
                continue;
            }
            SystemCall.copyFile(srcFile, dstFile);
        }
    }
}

