/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.patchverbs;

import java.util.List;
import oracle.opatch.patchverbs.AutomationElement;

public class CommandActionEl
extends AutomationElement
implements Cloneable {
    private boolean runAsRoot = false;
    private String scriptPath = "";
    private String[] listOfParams = new String[0];

    private CommandActionEl() {
    }

    public CommandActionEl(String runRootStr, String completeScriptPath, List parameters) {
        if (runRootStr.equalsIgnoreCase("root")) {
            this.runAsRoot = true;
        }
        this.scriptPath = completeScriptPath;
        if (parameters != null && parameters.size() != 0) {
            this.listOfParams = new String[parameters.size()];
            parameters.toArray(this.listOfParams);
        }
    }

    public void setRunAsRoot() {
        this.runAsRoot = true;
    }

    public void setRunAsNonRootUser() {
        this.runAsRoot = false;
    }

    public void setScriptPath(String scriptPath) {
        this.scriptPath = scriptPath;
    }

    public void setListOfParams(String[] listOfParams) {
        this.listOfParams = listOfParams;
    }

    public boolean isRunAsRoot() {
        return this.runAsRoot;
    }

    public String getCompleteScriptPath() {
        return this.scriptPath;
    }

    public String[] getListOfParameters() {
        return this.listOfParams;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer("");
        buff.append("[Command Action Element: ");
        buff.append("Run As Root -> " + this.isRunAsRoot() + ",");
        buff.append("Script -> " + this.getCompleteScriptPath() + ",");
        StringBuffer params = new StringBuffer();
        for (int i2 = 0; i2 < this.listOfParams.length; ++i2) {
            params.append(this.listOfParams[i2]);
            if (i2 == this.listOfParams.length - 1) continue;
            params.append(" ");
        }
        buff.append("List of parameters -> \"" + params.toString() + "\"]");
        return buff.toString();
    }

    @Override
    public Object clone() {
        CommandActionEl c1 = (CommandActionEl)super.clone();
        c1.scriptPath = this.scriptPath;
        c1.runAsRoot = this.runAsRoot;
        if (this.listOfParams == null) {
            c1.listOfParams = new String[0];
        } else {
            c1.listOfParams = new String[this.listOfParams.length];
            for (int i2 = 0; i2 < c1.listOfParams.length; ++i2) {
                c1.listOfParams[i2] = this.listOfParams[i2];
            }
        }
        return c1;
    }
}

