/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.patchsdk.util;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.UnmarshalException;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import oracle.opatch.patchsdk.bundle_xml.SystemPatchBundleXML;
import oracle.opatch.patchsdk.util.BundleValidationException;
import oracle.opatch.patchsdk.util.BundleXmlException;
import oracle.opatch.patchsdk.util.BundleXmlUtilBase;
import oracle.opatch.wrappers.WrapperFactory;
import org.xml.sax.SAXException;

public class BundleXmlHelper
extends BundleXmlUtilBase {
    public BundleXmlHelper() throws BundleXmlException {
        logger = Logger.getLogger(this.getClass().getName());
        this.creatUnmarshaller();
    }

    private void creatUnmarshaller() throws BundleXmlException {
        try {
            SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = sf.newSchema(this.getClass().getResource("/" + xsdFileName));
            JAXBContext context = JAXBContext.newInstance((Class[])this.getClasses());
            this.unmarshaller = context.createUnmarshaller();
            this.unmarshaller.setSchema(schema);
        }
        catch (JAXBException e2) {
            String msg = "Failed to create JAXB context due to: " + BundleXmlHelper.digoutMessage(e2);
            logger.log(Level.SEVERE, msg);
            throw new BundleXmlException(msg, e2);
        }
        catch (SAXException e3) {
            String msg = "The Bundle schema is invalid: " + BundleXmlHelper.digoutMessage(e3);
            logger.log(Level.SEVERE, msg);
            throw new BundleXmlException(msg, e3);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SystemPatchBundleXML readBundle(Path xmlFile) throws BundleXmlException, BundleValidationException {
        if (xmlFile == null) {
            throw new BundleXmlException("xml file is null!");
        }
        xmlFileName = xmlFile.toAbsolutePath().toString();
        try (InputStream inputStream = Files.newInputStream(xmlFile, new OpenOption[0]);){
            SystemPatchBundleXML systemPatchBundleXML = (SystemPatchBundleXML)this.unmarshaller.unmarshal(inputStream);
            return systemPatchBundleXML;
        }
        catch (UnmarshalException e2) {
            String msg = xmlFileName + " is not valid: " + BundleXmlHelper.digoutMessage(e2) + " Schema is " + xsdFileName;
            logger.log(Level.SEVERE, msg);
            throw new BundleValidationException(msg, e2);
        }
        catch (JAXBException e3) {
            String msg = "Unexpected error " + BundleXmlHelper.digoutMessage(e3) + " occured while unmarshalling " + xmlFileName;
            logger.log(Level.SEVERE, msg);
            throw new BundleXmlException(msg, e3);
        }
        catch (Exception e4) {
            throw new BundleXmlException(e4);
        }
    }

    public SystemPatchBundleXML readBundle(String xmlContent) throws BundleValidationException, BundleXmlException {
        try {
            return (SystemPatchBundleXML)this.unmarshaller.unmarshal((Reader)new StringReader(xmlContent));
        }
        catch (UnmarshalException e2) {
            String msg = " bundle.xml is not valid:" + BundleXmlHelper.digoutMessage(e2) + ". xml is " + xmlContent + " Schema is " + xsdFileName;
            logger.log(Level.SEVERE, msg);
            throw new BundleValidationException(msg, e2);
        }
        catch (JAXBException e3) {
            String msg = "Unexpected error " + BundleXmlHelper.digoutMessage(e3) + " occured while unmarshalling bundle.xml: " + xmlContent;
            logger.log(Level.SEVERE, msg);
            throw new BundleXmlException(msg, e3);
        }
    }

    public SystemPatchBundleXML readBundle(InputStream xmlContent) throws BundleValidationException, BundleXmlException {
        try {
            return (SystemPatchBundleXML)this.unmarshaller.unmarshal(xmlContent);
        }
        catch (UnmarshalException e2) {
            String msg = " bundle.xml is not valid:" + BundleXmlHelper.digoutMessage(e2) + ". xml is " + xmlContent + " Schema is " + xsdFileName;
            logger.log(Level.SEVERE, msg);
            throw new BundleValidationException(msg, e2);
        }
        catch (JAXBException e3) {
            String msg = "Unexpected error " + BundleXmlHelper.digoutMessage(e3) + " occured while unmarshalling bundle.xml: " + xmlContent;
            logger.log(Level.SEVERE, msg);
            throw new BundleXmlException(msg, e3);
        }
    }

    public static void main(String[] args) {
        try {
            BundleXmlHelper helper = new BundleXmlHelper();
            SystemPatchBundleXML obj = helper.readBundle(WrapperFactory.getNioServiceWrapper().getPath(xmlFileName, new String[0]));
            System.out.println("\n**********  BundleXmlHelper: TESTING System Patch bundle xml: newly generated XSD (model/xml) with old test XML  **************");
            System.out.println("**********************************************************\n");
            System.out.println("\n**********  BundleXmlHelper: TESTING System Patch bundle V3 xml: newly generated XSD (model/xml) with old test v3 XML  **************");
            SystemPatchBundleXML bundleV3 = helper.readBundle(WrapperFactory.getNioServiceWrapper().getPath(xmlV3FileName, new String[0]));
            System.out.println("**********************************************************\n");
        }
        catch (Throwable t) {
            System.out.println(" Exception = " + t.getMessage());
            t.printStackTrace();
        }
    }

    static String digoutMessage(Throwable t) {
        if (t.getMessage() != null && t.getMessage().trim().length() != 0) {
            return t.getMessage();
        }
        Throwable cause = t.getCause();
        if (cause == null) {
            return null;
        }
        return BundleXmlHelper.digoutMessage(cause);
    }
}

