/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.patchsdk.engineeredsystem;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.patchsdk.PatchPackageException;
import oracle.opatch.patchsdk.bundle_xml.Subpatch;
import oracle.opatch.patchsdk.bundle_xml.SystemPatchBundleXML;
import oracle.opatch.patchsdk.engineeredsystem.EngineeredSystemPatchValidatorAndGenerator;
import oracle.opatch.patchsdk.engineeredsystem.HashComputeFunction;
import oracle.opatch.patchsdk.patchmodel.PatchingTool;
import oracle.opatch.wrappers.WrapperFactory;

public class InventoryAndActionOnly
extends HashComputeFunction {
    private static String fileSeparator = File.separator;

    @Override
    protected List<String> fileList(String patchLocation, SystemPatchBundleXML bundleXml) {
        ArrayList<String> metaList = new ArrayList<String>();
        for (Subpatch subPatch : bundleXml.getSubpatches()) {
            if (subPatch.getPatchingTool() != PatchingTool.OPATCH) continue;
            String subPatchLoc = subPatch.getLocation();
            String subPatchAbsLoc = patchLocation + fileSeparator + subPatchLoc;
            if (EngineeredSystemPatchValidatorAndGenerator.IsSubPatchCompositePatch(subPatchAbsLoc)) {
                Path compositePatchDir = WrapperFactory.getNioServiceWrapper().getPath(subPatchAbsLoc, new String[0]);
                if (!Files.exists(compositePatchDir, new LinkOption[0])) continue;
                try {
                    for (Path sp : Files.newDirectoryStream(compositePatchDir)) {
                        if (!Files.isDirectory(sp, new LinkOption[0])) continue;
                        metaList.add(WrapperFactory.getNioServiceWrapper().getPath(sp.toAbsolutePath().toString() + fileSeparator + EngineeredSystemPatchValidatorAndGenerator.ACTIONS_XML, new String[0]).toAbsolutePath().toString());
                        metaList.add(WrapperFactory.getNioServiceWrapper().getPath(sp.toAbsolutePath().toString() + fileSeparator + EngineeredSystemPatchValidatorAndGenerator.INVENTORY_XML, new String[0]).toAbsolutePath().toString());
                    }
                    continue;
                }
                catch (IOException e2) {
                    OLogger.debug(e2.getMessage());
                    continue;
                }
            }
            metaList.add(WrapperFactory.getNioServiceWrapper().getPath(patchLocation, subPatchLoc + fileSeparator + EngineeredSystemPatchValidatorAndGenerator.ACTIONS_XML).toAbsolutePath().toString());
            metaList.add(WrapperFactory.getNioServiceWrapper().getPath(patchLocation, subPatchLoc + fileSeparator + EngineeredSystemPatchValidatorAndGenerator.INVENTORY_XML).toAbsolutePath().toString());
        }
        return metaList;
    }

    @Override
    protected String getHashFunction() {
        return "sha1";
    }

    @Override
    protected String computeHash(List<String> metaList) throws PatchPackageException {
        try {
            MessageDigest md = MessageDigest.getInstance(this.getHashFunction());
            Collections.sort(metaList);
            for (int j2 = 0; j2 < metaList.size(); ++j2) {
                String tempContents = this.getContent(Files.newInputStream(WrapperFactory.getNioServiceWrapper().getPath(metaList.get(j2), new String[0]), new OpenOption[0])).toString();
                boolean newLine = tempContents.endsWith("\n");
                String metaContents = this.getContentWithFilter(Files.newInputStream(WrapperFactory.getNioServiceWrapper().getPath(metaList.get(j2), new String[0]), new OpenOption[0]), "unique_patch_id", newLine).toString();
                byte[] buffHash = metaContents.getBytes();
                md.update(buffHash);
            }
            byte[] b2 = md.digest();
            String HEXES = "0123456789ABCDEF";
            StringBuilder hex = new StringBuilder(2 * b2.length);
            for (int j3 = 0; j3 < b2.length; ++j3) {
                byte bit = b2[j3];
                hex.append(HEXES.charAt((bit & 0xF0) >> 4)).append(HEXES.charAt(bit & 0xF));
            }
            String valueComp = hex.toString();
            return valueComp.toLowerCase();
        }
        catch (NumberFormatException e2) {
            throw new PatchPackageException("The function value \"" + this.getHashFunction() + "\" of tag <fvalue> is invalid.", e2);
        }
        catch (NoSuchAlgorithmException e3) {
            PatchPackageException ppe = new PatchPackageException(e3.getMessage());
            ppe.setStackTrace(e3.getStackTrace());
            throw ppe;
        }
        catch (Exception e4) {
            PatchPackageException ppe = new PatchPackageException(e4.getMessage());
            ppe.setStackTrace(e4.getStackTrace());
            throw ppe;
        }
    }

    @Override
    protected String computeHash(HashMap<String, byte[]> metaMap) throws PatchPackageException {
        try {
            MessageDigest md = MessageDigest.getInstance(this.getHashFunction());
            ArrayList<String> keyList = new ArrayList<String>();
            Set<String> keySet = metaMap.keySet();
            Iterator<String> iterator = keySet.iterator();
            while (iterator.hasNext()) {
                keyList.add(iterator.next());
            }
            Collections.sort(keyList);
            for (String key : keyList) {
                String tempContents = this.getContent(new ByteArrayInputStream(metaMap.get(key))).toString();
                boolean newLine = tempContents.endsWith("\n");
                String metaContents = this.getContentWithFilter(new ByteArrayInputStream(metaMap.get(key)), "unique_patch_id", newLine).toString();
                byte[] buffHash = metaContents.getBytes();
                md.update(buffHash);
            }
            byte[] b2 = md.digest();
            String HEXES = "0123456789ABCDEF";
            StringBuilder hex = new StringBuilder(2 * b2.length);
            for (int j2 = 0; j2 < b2.length; ++j2) {
                byte bit = b2[j2];
                hex.append(HEXES.charAt((bit & 0xF0) >> 4)).append(HEXES.charAt(bit & 0xF));
            }
            String valueComp = hex.toString();
            return valueComp.toLowerCase();
        }
        catch (NumberFormatException e2) {
            throw new PatchPackageException("The function value \"" + this.getHashFunction() + "\" of tag <fvalue> is invalid.");
        }
        catch (NoSuchAlgorithmException e3) {
            PatchPackageException ppe = new PatchPackageException(e3.getMessage());
            ppe.setStackTrace(e3.getStackTrace());
            throw ppe;
        }
        catch (Exception e4) {
            PatchPackageException ppe = new PatchPackageException(e4.getMessage());
            ppe.setStackTrace(e4.getStackTrace());
            throw ppe;
        }
    }

    public StringBuffer getContentWithFilter(InputStream is, String filterWord, boolean newLine) throws IOException {
        Scanner sc = new Scanner(is);
        sc.useDelimiter("\n");
        StringWriter sw = new StringWriter();
        String line = null;
        String tempLine = null;
        while (sc.hasNext()) {
            if (tempLine != null) {
                sw.write(line);
                sw.write(10);
            }
            if (!(line = sc.next()).contains(filterWord)) {
                tempLine = line;
                continue;
            }
            tempLine = null;
        }
        if (tempLine != null) {
            sw.write(tempLine);
            if (newLine) {
                sw.write(10);
            }
        }
        sw.close();
        return sw.getBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuffer getContent(InputStream is) throws IOException {
        InputStreamReader isr = new InputStreamReader(is);
        StringWriter sw = new StringWriter();
        char[] buff = new char[1024];
        int len = 0;
        try {
            while ((len = isr.read(buff, 0, buff.length)) != -1) {
                sw.write(buff, 0, len);
            }
        }
        finally {
            sw.close();
            isr.close();
        }
        return sw.getBuffer();
    }
}

