/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchutil.cleanuphome;

import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import oracle.glcm.opatch.common.api.install.HomeOperationsExt;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.OUIVersion;
import oracle.opatch.OneOffEntry;
import oracle.opatch.PatchObject;
import oracle.opatch.PatchObjectUtil;
import oracle.opatch.PrereqSession;
import oracle.opatch.conflicttextualinterpreter.IPatch;
import oracle.opatch.conflicttextualinterpreter.NPatchRelation;
import oracle.opatch.conflicttextualinterpreter.NPatchRelations;
import oracle.opatch.ipm.HomeInventoryHelper;
import oracle.opatch.ipm.IIPMRWServices;
import oracle.opatch.ipm.IIPMReadServices;
import oracle.opatch.ipm.IPM;
import oracle.opatch.opatchlogger.OLogger;

public class InactivePatchesUtil {
    private HashMap<IPatch, NPatchRelations> relationsMap = null;
    private List<TreeSet<IPatch>> ruChains = null;
    private HashMap<String, IPatch> allInactiveRus = null;
    private String OH = OPatchEnv.getOracleHome();
    private Path backupPath = null;
    private IIPMReadServices readServices = null;
    private IIPMRWServices rwServices = null;
    private Set<String> deletedPatches = null;
    private List<TreeSet<IPatch>> toDeleteList = null;
    private int keepIP = -1;
    private HashMap<IPatch, Collection<String>> allOverlays = null;

    public InactivePatchesUtil() {
        this.ruChains = new ArrayList<TreeSet<IPatch>>();
        this.allInactiveRus = new HashMap();
        this.deletedPatches = new HashSet<String>();
        this.toDeleteList = new ArrayList<TreeSet<IPatch>>();
        this.rwServices = IPM.INSTANCE.getRWServices();
        this.allOverlays = new HashMap();
    }

    private void getOrderedInactivePatches() throws RuntimeException {
        OLogger.debug("Entered InactivePatchesUtil:getOrderedInactivePatches() method...");
        if (this.ruChains.size() != 0) {
            return;
        }
        if (this.relationsMap == null) {
            if (this.readServices == null) {
                try {
                    this.readServices = PrereqSession.getReadServices(OPatchEnv.getOracleHome());
                }
                catch (Throwable e2) {
                    OLogger.log(OLogger.SEVERE, e2.getMessage());
                    OLogger.printStackTrace(e2);
                    throw new RuntimeException(e2.getMessage());
                }
            }
            this.relationsMap = this.readServices.getRelationsMap();
        }
        if (this.relationsMap == null) {
            throw new RuntimeException("Error: relation map is null.");
        }
        this.findOrderedInactivePatches(this.relationsMap);
        OLogger.debug("Finished InactivePatchesUtil:getOrderedInactivePatches() method");
    }

    private void findOrderedInactivePatches(HashMap<IPatch, NPatchRelations> relationsMap) throws RuntimeException {
        OLogger.debug("Entered InactivePatchesUtil:findOrderedInactivePatches() method...");
        try {
            for (Map.Entry<IPatch, NPatchRelations> entry : relationsMap.entrySet()) {
                IPatch key = entry.getKey();
                NPatchRelations value = entry.getValue();
                Collection<String> overlays = key.getOverlaysID();
                Collection<NPatchRelation> subsets = value.getSubsets();
                if (overlays != null && overlays.size() > 0 && subsets != null && subsets.size() > 0) {
                    this.allOverlays.put(key, overlays);
                    continue;
                }
                if (subsets != null && subsets.size() > 0) {
                    this.processInactiveRU(key, subsets);
                    continue;
                }
                OLogger.justlog(OLogger.INFO, "Found active RU/BP " + key.getPatchId());
            }
            this.updateOverlays();
        }
        catch (Throwable e2) {
            OLogger.justlog(OLogger.SEVERE, "Failed in findOrderedInactivePatches method");
            throw new RuntimeException(e2.getMessage());
        }
        OLogger.debug("Finished InactivePatchesUtil:findOrderedInactivePatches() method...");
        OLogger.justlog(OLogger.INFO, "Built sorted map of inactive patches in oracle home");
    }

    private TreeSet<IPatch> inChain(IPatch ru) {
        for (TreeSet<IPatch> ts : this.ruChains) {
            for (IPatch p2 : ts) {
                if (!p2.getPatchId().equals(ru.getPatchId())) continue;
                return ts;
            }
        }
        return null;
    }

    private List<IPatch> getSupersets(Collection<NPatchRelation> supersets) {
        ArrayList<IPatch> result = new ArrayList<IPatch>();
        for (NPatchRelation rel : supersets) {
            IPatch superset = rel.to();
            result.add(superset);
        }
        return result;
    }

    private void processInactiveRU(IPatch ru, Collection<NPatchRelation> supersets) {
        if (this.inChain(ru) == null) {
            ArrayList<IPatch> pendinglist = new ArrayList<IPatch>();
            pendinglist.add(ru);
            TreeSet<IPatch> foundChain = null;
            List<IPatch> supersetsList = this.getSupersets(supersets);
            for (IPatch p2 : supersetsList) {
                foundChain = this.inChain(p2);
                if (foundChain == null) {
                    pendinglist.add(p2);
                    continue;
                }
                foundChain.addAll(supersetsList);
                foundChain.add(ru);
                for (IPatch pp : supersetsList) {
                    this.allInactiveRus.put(pp.getPatchId(), pp);
                }
                this.allInactiveRus.put(ru.getPatchId(), ru);
            }
            if (foundChain == null) {
                TreeSet<IPatch> newchain = new TreeSet<IPatch>();
                newchain.addAll(pendinglist);
                this.ruChains.add(newchain);
                for (IPatch pp : pendinglist) {
                    this.allInactiveRus.put(pp.getPatchId(), pp);
                }
            }
        }
        OLogger.justlog(OLogger.INFO, "Found inactive RU/BP " + ru.getPatchId());
    }

    private void updateOverlays() {
        for (Map.Entry<IPatch, Collection<String>> entry : this.allOverlays.entrySet()) {
            IPatch key = entry.getKey();
            Collection<String> overlays = entry.getValue();
            for (String ov : overlays) {
                IPatch overlaying = this.allInactiveRus.get(ov);
                if (overlaying == null) continue;
                overlaying.addOverlay(key);
            }
        }
    }

    public void print() {
        this.getOrderedInactivePatches();
        OLogger.println("\nThe oracle home has the following inactive patch(es) and their respective overlay patches:");
        this.printChains(this.ruChains);
    }

    private void printChains(List<TreeSet<IPatch>> result) {
        if (result == null || result.size() == 0) {
            OLogger.println("\nNo Inactive RU/BP patches found in OH");
            return;
        }
        OLogger.println("\nThe number of RU chains is  " + result.size());
        int i2 = 1;
        for (TreeSet<IPatch> treeset : result) {
            int inactiveSize = treeset.size() - 1;
            OLogger.println("\n***** There are " + inactiveSize + " inactive RU patches in chain " + i2);
            for (IPatch p2 : treeset) {
                if (inactiveSize < 1) break;
                List<IPatch> overlays = p2.getOverlayList();
                OLogger.println("-Inactive RU/BP " + p2.getPatchId() + ":" + p2.getDescription() + ", installed on: " + p2.getAppliedDate().toString() + (overlays.size() > 0 ? ", with overlays: " + this.listToString(overlays) : ", with no overlays"));
                --inactiveSize;
            }
            ++i2;
            IPatch active = treeset.last();
            List<IPatch> ovs = active.getOverlayList();
            OLogger.println("-Active RU/BP " + active.getPatchId() + ":" + active.getDescription() + ", installed on: " + active.getAppliedDate().toString() + (ovs.size() > 0 ? ", with overlays: " + this.listToString(ovs) : ", with no overlays"));
        }
    }

    private void printToDeleteChains(List<TreeSet<IPatch>> result) {
        if (result == null || result.size() == 0) {
            OLogger.println("\nNo Inactive RU/BP patches eligible for delete.");
            return;
        }
        int i2 = 1;
        for (TreeSet<IPatch> treeset : result) {
            int inactiveSize = treeset.size() - 1;
            int deletesize = inactiveSize - this.keepIP;
            int keepsize = this.keepIP;
            OLogger.println("\n***** There are " + inactiveSize + " inactive RU patches in chain " + i2);
            OLogger.println("\n***** " + deletesize + " inactive patches will be deleted");
            for (IPatch p2 : treeset) {
                List<IPatch> overlays;
                if (deletesize > 0) {
                    overlays = p2.getOverlayList();
                    OLogger.println("-To be deleted inactive RU/BP " + p2.getPatchId() + ":" + p2.getDescription() + ", installed on: " + p2.getAppliedDate().toString() + (overlays.size() > 0 ? ", with overlays: " + this.listToString(overlays) : ", with no overlays"));
                    --deletesize;
                    continue;
                }
                if (keepsize <= 0) continue;
                overlays = p2.getOverlayList();
                OLogger.println("-To be retained inactive RU/BP " + p2.getPatchId() + ":" + p2.getDescription() + ", installed on: " + p2.getAppliedDate().toString() + (overlays.size() > 0 ? ", with overlays: " + this.listToString(overlays) : ", with no overlays"));
                --keepsize;
            }
            ++i2;
            IPatch active = treeset.last();
            List<IPatch> ovs = active.getOverlayList();
            OLogger.println("-Active RU/BP " + active.getPatchId() + ":" + active.getDescription() + ", installed on: " + active.getAppliedDate().toString() + (ovs.size() > 0 ? ", with overlays: " + this.listToString(ovs) : ", with no overlays"));
        }
    }

    private String listToString(List<IPatch> list) {
        int i2;
        StringBuffer result = new StringBuffer();
        for (IPatch p2 : list) {
            result.append(p2.getPatchId() + ", ");
        }
        if (result.length() > 0 && (i2 = result.lastIndexOf(",")) != -1) {
            result.deleteCharAt(i2);
        }
        return result.toString();
    }

    public void deletePatches(boolean report) {
        OLogger.debug("Entered InactivePatchesUtil:deletePatches() method...");
        int numberOfPatchesToDelete = this.preValidation();
        if (numberOfPatchesToDelete == 0) {
            return;
        }
        this.printToDeleteChains(this.toDeleteList);
        if (report) {
            OLogger.println("\nOPatch is in report mode. No actual deletion happened. Reporting is done.");
            return;
        }
        if (!OPatchEnv.proceedWithOperationDefaultYes(new StringBuffer())) {
            OLogger.println("\nOPatch does not delete any inactive patches on user's request.");
            return;
        }
        try {
            this.saveInventoryBeforeDeleteInactivePatches();
        }
        catch (Exception e2) {
            OLogger.justlog(OLogger.SEVERE, "Failed to save inventory before deleting inactive patches. Error: " + e2.getMessage());
            OLogger.printStackTrace(e2);
            return;
        }
        try {
            for (TreeSet<IPatch> ts : this.toDeleteList) {
                int tsSize = ts.size();
                int numberToDelete = tsSize - 1 - this.keepIP;
                ArrayList<IPatch> keepRUs = new ArrayList<IPatch>();
                Set<String> overlaysOfRetainingPatches = this.getOverlaysOfRetainingPatches(ts);
                ArrayList<IPatch> overlayToKeep = new ArrayList<IPatch>();
                for (IPatch patch : ts) {
                    if (numberToDelete < 1) {
                        keepRUs.add(patch);
                        continue;
                    }
                    List<IPatch> overlays = patch.getOverlayList();
                    for (IPatch overlay : overlays) {
                        String patchid = overlay.getPatchId();
                        if (this.deletedPatches.contains(patchid)) {
                            OLogger.justlog(OLogger.INFO, "Overlay patch: " + patchid + " was already deleted. ");
                            continue;
                        }
                        if (overlaysOfRetainingPatches.contains(patchid)) {
                            OLogger.justlog(OLogger.INFO, "Overlay patch: " + patchid + " will not be deleted because it overlays a retaining patch");
                            overlayToKeep.add(overlay);
                            continue;
                        }
                        this.deletePatch(patchid);
                        OLogger.println("Deleted overlay patch: " + patchid);
                    }
                    this.deletePatch(patch.getPatchId());
                    patch.getOverlayList().removeAll(overlayToKeep);
                    OLogger.println("Deleted RU/BP patch: " + patch.getPatchId());
                    --numberToDelete;
                }
                OLogger.justlog(OLogger.INFO, "Number of kept RUS, including active " + ts.last().getPatchId() + " is " + keepRUs.size());
                if (OPatchEnv.isCUPSupported() || OPatchEnv.isNextGenHome()) continue;
                for (IPatch p2 : keepRUs) {
                    this.deleteSubsetOUIRefs(p2);
                }
            }
            this.verifyAfter(this.toDeleteList);
        }
        catch (Throwable e3) {
            OLogger.justlog(OLogger.SEVERE, "Failed deleting inactive patches. Error: " + e3.getMessage());
            OLogger.printStackTrace(e3);
            OLogger.println("Restoring inventory to the state before deleting...");
            try {
                this.restoreInventoryAfterDeleteInactivePatchesFailed();
                OLogger.println("Inventory got restored to the state before deleting.");
            }
            catch (Exception e1) {
                OLogger.justlog(OLogger.SEVERE, "Failed to restore inventory to the state before deleting inactive patches. Error: " + e1.getMessage());
                OLogger.printStackTrace(e1);
            }
            return;
        }
        OLogger.debug("Finished InactivePatchesUtil:deletePatches() method...");
    }

    private Set<String> getOverlaysOfRetainingPatches(TreeSet<IPatch> chain) {
        HashSet<String> result = new HashSet<String>();
        int deletePatches = chain.size() - 1 - this.keepIP;
        int count = 1;
        for (IPatch patch : chain) {
            if (count <= deletePatches) {
                ++count;
                continue;
            }
            List<IPatch> overlays = patch.getOverlayList();
            for (IPatch p2 : overlays) {
                result.add(p2.getPatchId());
            }
        }
        return result;
    }

    private void deleteSubsetOUIRefs(IPatch patch) throws Exception {
        try {
            PatchObject po = PatchObjectUtil.loadPatch(this.OH, patch.getPatchId());
            po.setOneOffEntryObj(po.toOneOffEntry(this.OH));
            this.rwServices.remove(po);
            this.rwServices.add(po);
            this.rwServices.saveInstallInventory();
            OLogger.justlog(OLogger.INFO, "Cleaningup OUI references is completed from Inventory");
        }
        catch (Exception e2) {
            OLogger.justlog(OLogger.SEVERE, "Error while deleting the refs from active list ");
            throw e2;
        }
    }

    private void verifyAfter(List<TreeSet<IPatch>> toDeleteList) throws Exception {
        OLogger.justlog(OLogger.INFO, "Start verifying if inactive patches got deleted successfully..");
        this.relationsMap = null;
        this.ruChains = new ArrayList<TreeSet<IPatch>>();
        try {
            if (OPatchEnv.isCUPSupported()) {
                HomeOperationsExt homeOp = IPM.INSTANCE.getRWServices().getHomeOperations();
                boolean isNextGen = homeOp.getVersionInfo().isNextGen();
                if (isNextGen) {
                    this.verifyCupNextgen(toDeleteList);
                } else {
                    this.verifyCupDb(toDeleteList);
                }
            } else {
                this.verifyOldLegacy(toDeleteList);
            }
        }
        catch (Exception e2) {
            OLogger.println("The action to delete inactive patches was failed.");
            throw e2;
        }
        OLogger.justlog(OLogger.INFO, "Finished verifying. The inactive patches got deleted successfully..");
    }

    private void verifyCupNextgen(List<TreeSet<IPatch>> toDeleteList) throws Exception {
        OLogger.justlog(OLogger.INFO, "No verifying for nextgen FMW env for now.");
    }

    private void verifyCupDb(List<TreeSet<IPatch>> toDeleteList) throws Exception {
        try {
            this.readServices = IPM.INSTANCE.getReadServices();
            this.readServices.destroy();
            this.readServices = PrereqSession.getReadServices(OPatchEnv.getOracleHome());
        }
        catch (Throwable e2) {
            OLogger.log(OLogger.SEVERE, e2.getMessage());
            OLogger.printStackTrace(e2);
            throw new RuntimeException(e2.getMessage());
        }
        OneOffEntry[] inactivePatches = this.readServices.getInactivePatches();
        HashSet<String> inactiveSet = new HashSet<String>();
        StringBuffer b2 = new StringBuffer();
        for (OneOffEntry e3 : inactivePatches) {
            inactiveSet.add(e3.getPatchID());
            b2.append(e3.getPatchID() + ",");
        }
        OLogger.justlog(OLogger.INFO, "list of inactive patches after delete:" + b2.toString());
        block3: for (TreeSet treeSet : toDeleteList) {
            int tsSize = treeSet.size();
            int numberToDelete = tsSize - 1 - this.keepIP;
            for (IPatch p2 : treeSet) {
                if (numberToDelete < 1) continue block3;
                if (inactiveSet.contains(p2.getPatchId())) {
                    throw new Exception("Failed to verify that patch " + p2.getPatchId() + " really got deleted.");
                }
                List<IPatch> overlays = p2.getOverlayList();
                for (IPatch ov : overlays) {
                    if (!inactiveSet.contains(ov.getPatchId())) continue;
                    throw new Exception("Failed to verify that patch " + ov.getPatchId() + " really got deleted.");
                }
                --numberToDelete;
            }
        }
        OLogger.justlog(OLogger.INFO, "Verifying of delete inactive patches in DB CUP env was completed.");
    }

    private void verifyOldLegacy(List<TreeSet<IPatch>> toDeleteList) throws Exception {
        this.verifyCupDb(toDeleteList);
    }

    private int preValidation() {
        this.getOrderedInactivePatches();
        String ouiversion = OUIVersion.getOUIVersion();
        OLogger.justlog(OLogger.INFO, "OUI Version:" + ouiversion);
        if (ouiversion != null && (ouiversion.contains("11.2") || ouiversion.contains("12.1"))) {
            OLogger.println("This Delete Inactive patches feature is not supported for " + ouiversion + " OUI based homes");
            return 0;
        }
        if (!OPatchEnv.isCUPSupported() && OPatchEnv.isNextGenHome()) {
            OLogger.println("Delete inactive patches operation is not supported for old, non-cup nextgen home.");
            return 0;
        }
        try {
            this.keepIP = OPatchEnv.getInactivePatchesKeep();
        }
        catch (Exception e2) {
            OLogger.println("Error: failed to get the value of RETAIN_INACTIVE_PATCHES in config file. " + e2.toString());
            OLogger.println("The value of RETAIN_INACTIVE_PATCHES in config must be an integer greater than 0.");
            OLogger.printStackTrace(e2);
            return 0;
        }
        if (this.keepIP < 1) {
            OLogger.println("Warning: The value of parameter RETAIN_INACTIVE_PATCHES set to " + this.keepIP + " is not supported");
            OLogger.println("Please update the value of RETAIN_INACTIVE_PATCHES in OPatch config file OPatch/config/opatch.properties");
            OLogger.println("OPatch does not delete any inactive patches.");
            return 0;
        }
        for (TreeSet<IPatch> ts : this.ruChains) {
            int tsSize = ts.size();
            IPatch activePatch = ts.last();
            String actId = activePatch.getPatchId();
            String desc = activePatch.getDescription();
            if (tsSize < 3) {
                OLogger.justlog(OLogger.INFO, "The chain of active patch " + actId + ":" + desc + " has only " + (tsSize - 1) + " inactive patches. No inactive RU is eligible for delete.");
            }
            if (tsSize - this.keepIP < 2) {
                OLogger.justlog(OLogger.INFO, "The chain of active patch " + actId + ":" + desc + " has only " + (tsSize - 1) + " inactive patches, and number of RUs to keep is " + this.keepIP + ", therefore no inactive RU is eligible for delete.");
                continue;
            }
            int numberToDelete = tsSize - 1 - this.keepIP;
            OLogger.justlog(OLogger.INFO, "The chain of active patch " + actId + ":" + desc + " will have " + numberToDelete + " RUs to be deleted");
            this.toDeleteList.add(ts);
        }
        if (this.toDeleteList.size() < 1) {
            OLogger.println("Warning: No inactive RU is eligible for delete. See log file for more details");
        }
        return this.toDeleteList.size();
    }

    private void saveInventoryBeforeDeleteInactivePatches() throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
        String deleteSessionID = sdf.format(Calendar.getInstance().getTime());
        String backup = this.OH + File.separator + ".patch_storage" + File.separator + "backup_delete_inactive" + File.separator + deleteSessionID + File.separator + "inventory";
        this.backupPath = Paths.get(backup, new String[0]);
        Path p1 = Paths.get(this.OH, ".patch_storage", "backup_delete_inactive");
        if (!Files.exists(p1, new LinkOption[0])) {
            Files.createDirectory(p1, new FileAttribute[0]);
        }
        Path p2 = Paths.get(p1.toString(), deleteSessionID);
        Files.createDirectory(p2, new FileAttribute[0]);
        Files.createDirectory(this.backupPath, new FileAttribute[0]);
        Path contentsXMLPath = Paths.get(backup, "ContentsXML");
        Files.createDirectory(contentsXMLPath, new FileAttribute[0]);
        String source = this.OH + File.separator + "inventory";
        String compsxml = "ContentsXML" + File.separator + "comps.xml";
        Path s = Paths.get(source, compsxml);
        Path d2 = Paths.get(backup, compsxml);
        Files.copy(s, d2, new CopyOption[0]);
        OLogger.justlog(OLogger.INFO, "File " + s.toString() + " has been backed up.");
        String ouipatchxml = "ContentsXML" + File.separator + "oui-patch.xml";
        s = Paths.get(source, ouipatchxml);
        if (Files.exists(s, new LinkOption[0])) {
            d2 = Paths.get(backup, ouipatchxml);
            Files.copy(s, d2, new CopyOption[0]);
            OLogger.justlog(OLogger.INFO, "File " + s.toString() + " has been backed up.");
        }
        String registryxml = "registry.xml";
        s = Paths.get(source, registryxml);
        if (Files.exists(s, new LinkOption[0])) {
            d2 = Paths.get(backup, registryxml);
            Files.copy(s, d2, new CopyOption[0]);
            OLogger.justlog(OLogger.INFO, "File " + s.toString() + " has been backed up.");
        }
        String patches = "patches";
        s = Paths.get(source, patches);
        if (Files.exists(s, new LinkOption[0])) {
            d2 = Paths.get(backup, patches);
            this.copyDirResursive(s, d2);
            OLogger.justlog(OLogger.INFO, "Directory " + s.toString() + " has been backed up.");
        }
        String oneoffs = "oneoffs";
        s = Paths.get(source, oneoffs);
        d2 = Paths.get(backup, oneoffs);
        this.copyDirResursive(s, d2);
        OLogger.justlog(OLogger.INFO, "Directory " + s.toString() + " has been backed up.");
    }

    private void copyDirResursive(Path source, Path dest) throws Exception {
        if (!Files.exists(source, new LinkOption[0])) {
            throw new Exception("Oracle home is invalid. The inventory does not exist.");
        }
        if (!Files.exists(dest, new LinkOption[0])) {
            Files.createDirectory(dest, new FileAttribute[0]);
        }
        try {
            DirectoryStream<Path> stream = Files.newDirectoryStream(source);
            for (Path lfiles : stream) {
                if (Files.isDirectory(lfiles, new LinkOption[0])) {
                    Path newPath = Paths.get(dest.toString(), lfiles.getFileName().toString());
                    this.copyDirResursive(lfiles, newPath);
                    continue;
                }
                Path destPath = Paths.get(dest.toString(), lfiles.getFileName().toString());
                Files.copy(lfiles, destPath, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (Exception e2) {
            OLogger.justlog(OLogger.SEVERE, "Failed to copy from path " + source.toString() + " to path " + dest.toString());
            throw e2;
        }
    }

    private void restoreInventoryAfterDeleteInactivePatchesFailed() throws Exception {
        Path patchesDir;
        Path registryxml;
        if (this.backupPath == null || !Files.exists(this.backupPath, new LinkOption[0])) {
            throw new Exception("Failed to restore. Backup for restore does not exist.");
        }
        Path contentsXml = Paths.get(this.backupPath.toString(), "ContentsXML");
        if (!Files.exists(contentsXml, new LinkOption[0])) {
            throw new Exception("Failed to restore. Backup directory ContentsXML for restore does not exist.");
        }
        Path compsxml = Paths.get(contentsXml.toString(), "comps.xml");
        Path destCompsxml = Paths.get(this.OH, "inventory", "ContentsXML", "comps.xml");
        Files.copy(compsxml, destCompsxml, StandardCopyOption.REPLACE_EXISTING);
        OLogger.justlog(OLogger.INFO, "File " + destCompsxml.toString() + " has been restored.");
        Path ouipatchxml = Paths.get(contentsXml.toString(), "oui-patch.xml");
        if (Files.exists(ouipatchxml, new LinkOption[0])) {
            Path destOuipatchxml = Paths.get(this.OH, "inventory", "ContentsXML", "oui-patch.xml");
            Files.copy(ouipatchxml, destOuipatchxml, StandardCopyOption.REPLACE_EXISTING);
            OLogger.justlog(OLogger.INFO, "File " + destOuipatchxml.toString() + " has been restored.");
        }
        if (Files.exists(registryxml = Paths.get(this.backupPath.toString(), "registry.xml"), new LinkOption[0])) {
            Path destRegistryxml = Paths.get(this.OH, "inventory", "registry.xml");
            Files.copy(registryxml, destRegistryxml, StandardCopyOption.REPLACE_EXISTING);
            OLogger.justlog(OLogger.INFO, "File " + destRegistryxml.toString() + " has been restored.");
        }
        if (Files.exists(patchesDir = Paths.get(this.backupPath.toString(), "patches"), new LinkOption[0]) || Files.isDirectory(patchesDir, new LinkOption[0])) {
            Path destPatches = Paths.get(this.OH, "inventory", "patches");
            this.copyDirResursive(patchesDir, destPatches);
            OLogger.justlog(OLogger.INFO, "Directory " + destPatches.toString() + " has been restored.");
        }
        Path oneoffs = Paths.get(this.backupPath.toString(), "oneoffs");
        Path destOneoffs = Paths.get(this.OH, "inventory", "oneoffs");
        this.copyDirResursive(oneoffs, destOneoffs);
        OLogger.justlog(OLogger.INFO, "Directory " + destOneoffs.toString() + " has been restored.");
    }

    private void deletePatch(String patchid) throws Throwable {
        OLogger.debug("Entered InactivePatchesUtil:deletePatch() method...");
        if (this.deletedPatches.contains(patchid)) {
            OLogger.justlog(OLogger.INFO, "Patch: " + patchid + " was already deleted. ");
            return;
        }
        PatchObject patchObject = PatchObjectUtil.loadPatch(OPatchEnv.getOracleHome(), patchid);
        patchObject.setOneOffEntryObj(patchObject.toOneOffEntry(OPatchEnv.getOracleHome()));
        try {
            this.deleteInactivePatchFromInventory(patchObject);
            String patch_in_oneoffs = OPatchEnv.getPatchFilemapInfoLoc(OPatchEnv.getOracleHome(), patchid);
            try {
                OLogger.justlog(OLogger.INFO, "Deleting patch " + patch_in_oneoffs + " in inventory/oneoffs.");
                HomeInventoryHelper.removePatchDirectoryStructure(patch_in_oneoffs);
                OLogger.justlog(OLogger.INFO, "Deleting patch " + patch_in_oneoffs + " in inventory/oneoffs is done.");
            }
            catch (Exception e2) {
                if (!OPatchEnv.isWindows()) {
                    throw e2;
                }
                OLogger.justlog(OLogger.INFO, "Deleting patch " + patch_in_oneoffs + " in inventory/oneoffs failed in windows. This behavior is acceptable for now and it wont affect Opatch functionality.");
            }
            String cookedPatchId = patchObject.getCookedPatchID();
            String patch_loc = OPatchEnv.getPatchStorageDirectoryPath(OPatchEnv.getOracleHome(), cookedPatchId);
            OLogger.justlog(OLogger.INFO, "Deleting patch " + patch_loc + " in patch storage.");
            OPatchSessionHelper.deleteRecurse(patch_loc);
            OLogger.justlog(OLogger.INFO, "Deleting patch " + patch_loc + " in patch storage done.");
            this.deletedPatches.add(patchid);
        }
        catch (Throwable e3) {
            OLogger.println("Failed to delete inactive patch " + patchid);
            throw e3;
        }
        OLogger.debug("Finished InactivePatchesUtil:deletePatch() method...");
    }

    private void deleteInactivePatchFromInventory(PatchObject patchObject) throws Throwable {
        String patchid = patchObject.getPatchID();
        OLogger.justlog(OLogger.INFO, "Deleting patch " + patchid + " from inventory.");
        OPatchEnv.setDeleteInactivePatches(true);
        this.rwServices.remove(patchObject);
        this.rwServices.saveInstallInventory();
        this.rwServices.closeHomeOpResetLock();
        OLogger.justlog(OLogger.INFO, "Deleting patch " + patchid + " from inventory is done.");
    }

    private void deleteDirResursive(String dir) throws Exception {
        OLogger.debug("Entering deleteDirResursive method");
        if (dir == null || dir.length() == 0 || dir.equals("")) {
            OLogger.justlog(OLogger.INFO, "Directory " + dir + " is not valid. Ignored deleting");
            return;
        }
        Path dirPath = Paths.get(dir, new String[0]);
        if (!Files.exists(dirPath, new LinkOption[0])) {
            OLogger.justlog(OLogger.INFO, "Directory " + dir + " does not exist. Ignored deleting");
            return;
        }
        StringBuffer tmpSb = new StringBuffer();
        if (!Files.isDirectory(dirPath, new LinkOption[0])) {
            try {
                Files.deleteIfExists(dirPath);
                OLogger.justlog(OLogger.INFO, "File " + dir + " has been deleted");
            }
            catch (Exception e2) {
                OLogger.justlog(OLogger.SEVERE, "Failed to delete file " + dir + " , error " + e2.getMessage());
                throw e2;
            }
        }
        try {
            DirectoryStream<Path> stream = Files.newDirectoryStream(dirPath);
            for (Path lfiles : stream) {
                tmpSb = new StringBuffer(dir);
                tmpSb.append(File.separator);
                tmpSb.append(lfiles.getFileName().toString());
                this.deleteDirResursive(tmpSb.toString());
            }
            Files.deleteIfExists(dirPath);
            OLogger.justlog(OLogger.INFO, "Directory " + dir + " has been deleted");
        }
        catch (Exception e3) {
            OLogger.justlog(OLogger.SEVERE, "Failed to delete file " + dir + " , error " + e3.getMessage());
            throw e3;
        }
        OLogger.debug("Exited deleteDirResursive method");
    }
}

