/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchutil;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import oracle.opatch.MergedPatchObject;
import oracle.opatch.OPatchEnv;
import oracle.opatch.PatchObject;
import oracle.opatch.PatchObjectUtil;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.wrappers.WrapperFactory;

public class PatchList {
    static final int patchDir = 1;
    static final int patchFile = 2;
    static final int undefined = 0;
    private int code = 0;
    String patchLocation = "";

    public PatchList(String patchLocPtr) throws InstantiationException {
        Path loc = null;
        if (patchLocPtr != null) {
            loc = WrapperFactory.getNioServiceWrapper().getPath(patchLocPtr, new String[0]);
        }
        if (loc != null && Files.exists(loc, new LinkOption[0])) {
            if (Files.isDirectory(loc, new LinkOption[0])) {
                this.code = 1;
                this.patchLocation = patchLocPtr;
            } else if (Files.isRegularFile(loc, new LinkOption[0])) {
                this.code = 2;
                this.patchLocation = patchLocPtr;
            }
        }
        if (this.code == 0) {
            StringBuffer msg = new StringBuffer("Cannot initialize PatchList: argument given must be a file or directory: \"");
            msg.append(patchLocPtr);
            msg.append("\"");
            throw new InstantiationException(msg.toString());
        }
    }

    public PatchObject[] initPatchLocations(String oracleHomePath, String[] givenPatchIDs) throws InstantiationException {
        StringBuffer msg = new StringBuffer("initPatchLocations()");
        OLogger.debug(msg);
        String[] givenPatchAreas = new String[]{};
        if (givenPatchIDs == null) {
            InstantiationException e2 = new InstantiationException("Empty patch IDs specified.");
            throw e2;
        }
        givenPatchAreas = new String[givenPatchIDs.length];
        for (int i2 = 0; i2 < givenPatchIDs.length; ++i2) {
            String eachPatch = givenPatchIDs[i2];
            String path = OPatchEnv.getPatchFilemapInfoLoc(oracleHomePath, eachPatch);
            Path file = WrapperFactory.getNioServiceWrapper().getPath(path, new String[0]);
            if (!Files.exists(file, new LinkOption[0])) {
                msg = new StringBuffer("The given patch ID \"");
                msg.append(eachPatch);
                msg.append("\" does not have a valid patch area under \"");
                msg.append(path);
                msg.append("\"");
                InstantiationException e3 = new InstantiationException(msg.toString());
                throw e3;
            }
            givenPatchAreas[i2] = path;
        }
        try {
            PatchObject[] patchObjects = this.validatePatchAreas(oracleHomePath, givenPatchIDs);
            return patchObjects;
        }
        catch (RuntimeException e4) {
            msg = new StringBuffer("N-Rollback initPatchLocations(): cannot load patch. ");
            msg.append(e4.getMessage());
            InstantiationException ne = new InstantiationException(msg.toString());
            ne.setStackTrace(e4.getStackTrace());
            throw ne;
        }
    }

    public PatchObject[] initPatchLocations() throws InstantiationException {
        PatchObject[] patchObjects = null;
        String[] givenPatchAreas = new String[]{};
        if (this.code == 2) {
            try {
                givenPatchAreas = this.getFileEntry(this.patchLocation);
            }
            catch (IOException e2) {
                InstantiationException ne = new InstantiationException(e2.getMessage());
                ne.setStackTrace(e2.getStackTrace());
                throw ne;
            }
        }
        if (this.code == 1) {
            try {
                givenPatchAreas = this.getDirEntry(this.patchLocation);
            }
            catch (IOException e3) {
                InstantiationException ne = new InstantiationException(e3.getMessage());
                ne.setStackTrace(e3.getStackTrace());
                throw ne;
            }
        }
        try {
            patchObjects = this.validatePatchAreas(givenPatchAreas);
        }
        catch (RuntimeException e4) {
            StringBuffer msg = new StringBuffer("N-Apply initPatchLocations(): cannot load patch. ");
            msg.append(e4.getMessage());
            InstantiationException ne = new InstantiationException(msg.toString());
            ne.setStackTrace(e4.getStackTrace());
            throw ne;
        }
        return patchObjects;
    }

    public PatchObject[] validatePatchAreas(String oracleHomePath, String[] patchIDs) {
        ArrayList<PatchObject> patchList = new ArrayList<PatchObject>();
        for (int i2 = 0; i2 < patchIDs.length; ++i2) {
            String eachPatchArea = patchIDs[i2];
            try {
                PatchObject po = PatchObjectUtil.loadPatch(oracleHomePath, patchIDs[i2]);
                patchList.add(po);
                continue;
            }
            catch (RuntimeException e2) {
                StringBuffer msg = new StringBuffer("Patch area \"");
                msg.append(eachPatchArea);
                msg.append("\" is not valid and cannot be loaded as PatchObject: ");
                msg.append(e2.getMessage());
                RuntimeException ne = new RuntimeException(msg.toString());
                ne.setStackTrace(e2.getStackTrace());
                throw ne;
            }
        }
        int len = patchList.size();
        PatchObject[] patchObjects = new PatchObject[len];
        for (int i3 = 0; i3 < len; ++i3) {
            patchObjects[i3] = (PatchObject)patchList.get(i3);
        }
        return patchObjects;
    }

    public PatchObject[] validatePatchAreas(String[] givenPatchAreas) throws RuntimeException {
        ArrayList<PatchObject> patchList = new ArrayList<PatchObject>();
        for (int i2 = 0; i2 < givenPatchAreas.length; ++i2) {
            String eachPatchArea = givenPatchAreas[i2];
            try {
                PatchObject po = PatchObjectUtil.loadPatch(eachPatchArea);
                patchList.add(po);
                continue;
            }
            catch (RuntimeException e2) {
                StringBuffer msg = new StringBuffer("Patch area \"");
                msg.append(eachPatchArea);
                msg.append("\" is not valid and cannot be loaded as PatchObject: ");
                msg.append(e2.getMessage());
                RuntimeException ne = new RuntimeException(msg.toString());
                ne.setStackTrace(e2.getStackTrace());
                throw ne;
            }
        }
        int len = patchList.size();
        PatchObject[] patchObjects = new PatchObject[len];
        for (int i3 = 0; i3 < len; ++i3) {
            patchObjects[i3] = (PatchObject)patchList.get(i3);
        }
        return patchObjects;
    }

    public String[] getFileEntry(String file) throws IOException {
        String[] array = null;
        ArrayList<String> list = new ArrayList<String>();
        BufferedReader br = Files.newBufferedReader(WrapperFactory.getNioServiceWrapper().getPath(file, new String[0]), Charset.forName("UTF-8"));
        String line = "";
        line = br.readLine();
        while (line != null) {
            list.add(line);
            line = br.readLine();
        }
        int len = list.size();
        array = new String[len];
        for (int i2 = 0; i2 < len; ++i2) {
            array[i2] = (String)list.get(i2);
        }
        br.close();
        return array;
    }

    public String[] getDirEntry(String dir) throws IOException {
        Object[] array = new String[]{};
        ArrayList<Path> list = new ArrayList<Path>();
        StringBuffer tmp = new StringBuffer("getDirEntry()");
        OLogger.debug(tmp);
        Path file = WrapperFactory.getNioServiceWrapper().getPath(dir, new String[0]);
        if (Files.isDirectory(file, new LinkOption[0])) {
            try (DirectoryStream<Path> fileList = Files.newDirectoryStream(file);){
                for (Path child : fileList) {
                    if (child == null || !Files.exists(child, new LinkOption[0]) || !Files.isDirectory(child, new LinkOption[0])) continue;
                    list.add(child);
                }
            }
            catch (IOException e2) {
                OLogger.debug(e2.getMessage());
            }
        } else {
            StringBuffer msg = new StringBuffer("Given path is not a directory: \"");
            msg.append(dir);
            msg.append("\"");
            IOException e3 = new IOException(msg.toString());
            throw e3;
        }
        int len = list.size();
        array = new String[len];
        for (int i2 = 0; i2 < len; ++i2) {
            Path f2 = (Path)list.get(i2);
            array[i2] = f2.toAbsolutePath().toString();
        }
        if (array.length > 0) {
            Arrays.sort(array);
        }
        return array;
    }

    public static void dumpPatchObjects(PatchObject[] list) {
        for (int i2 = 0; i2 < list.length; ++i2) {
            String id = list[i2].getPatchID();
            String loc = list[i2].getPatchLocation();
            OLogger.println("Patch \"" + id + "\" at \"" + loc + "\"");
        }
    }

    public static void main(String[] args) {
        Properties prop = new Properties();
        prop.setProperty("OPatch.DEBUG", "TRUE");
        StringBuffer tmp = new StringBuffer("PatchList::main()");
        OLogger.debug(tmp);
        String patchLocPtr = "/scratch/phnguyen/OracleHome/10.2/home1/inventory/oneoffs";
        String oracleHomePath = "/scratch/phnguyen/OracleHome/10.2/home1";
        String[] patchIDs = new String[]{"1", "100", "20", "614"};
        tmp = new StringBuffer(" instantiating a PatchList object");
        OLogger.debug(tmp);
        try {
            MergedPatchObject mpo = new MergedPatchObject(OPatchEnv.getNApplySessionName());
            PatchObject p1 = PatchObjectUtil.loadPatch(patchLocPtr + File.separator + "1");
            PatchObject p20 = PatchObjectUtil.loadPatch(patchLocPtr + File.separator + "20");
            mpo.merge(oracleHomePath, p1, true);
            mpo.merge(oracleHomePath, p20, true);
            OLogger.println(mpo.toString());
            PatchList pl = new PatchList(patchLocPtr);
            OLogger.println("N-Apply the following patches using file ");
            OLogger.println("   " + patchLocPtr);
            PatchObject[] patchObjects = pl.initPatchLocations();
            PatchList.dumpPatchObjects(patchObjects);
            OLogger.println("N-Rollback the following patches ");
            for (int i2 = 0; i2 < patchIDs.length; ++i2) {
                OLogger.println("   " + patchIDs[i2]);
            }
            patchObjects = pl.initPatchLocations(oracleHomePath, patchIDs);
            PatchList.dumpPatchObjects(patchObjects);
        }
        catch (InstantiationException e2) {
            OLogger.println("main() fails:");
            e2.printStackTrace();
            return;
        }
    }
}

