/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchutil;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import oracle.opatch.ExitOPatchException;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchutil.UtilEnv;
import oracle.opatch.wrappers.WrapperFactory;

public class OUSessionHelper {
    static final String UTIL_TMP_FILE = "opatch_rac.tmp";
    public static final String REMOTE_NODES_MODIFIED = "Remote nodes have been modified.";
    public static final String REMOTE_NODES_NOT_MODIFIED = "Remote nodes have not been modified.";

    public static String[] readNodes() throws RuntimeException {
        String[] list = new String[]{};
        if (!OPatchEnv.isUserSuppliedRemoteNodes()) {
            throw new RuntimeException("-remote_nodes should be used to pass remote node names.");
        }
        list = OPatchEnv.getUserSuppliedRemoteNodes();
        return list;
    }

    public static void cleanupTmpFile(String tmpDir, String tmpFile) throws IOException {
        Path file = WrapperFactory.getNioServiceWrapper().getPath(tmpDir, new String[0]);
        if (!Files.exists(file, new LinkOption[0])) {
            OLogger.println("Can not find temp dir \"" + tmpDir + "\"");
            throw new IOException(tmpDir);
        }
        boolean ok = true;
        StringBuffer tmpListedFilesHolder = new StringBuffer(tmpDir);
        tmpListedFilesHolder.append(File.separator);
        tmpListedFilesHolder.append(tmpFile);
        String fileHolder = tmpListedFilesHolder.toString();
        Path tmpFileHolder = WrapperFactory.getNioServiceWrapper().getPath(fileHolder, new String[0]);
        if (Files.exists(tmpFileHolder, new LinkOption[0])) {
            try {
                Files.delete(tmpFileHolder);
                ok = true;
            }
            catch (Exception e2) {
                ok = false;
            }
        }
        if (!ok || Files.exists(tmpFileHolder, new LinkOption[0])) {
            OLogger.println("Cannot clean up file \"" + fileHolder + "\"");
            throw new IOException(fileHolder);
        }
        try {
            Files.createFile(tmpFileHolder, new FileAttribute[0]);
            ok = true;
        }
        catch (Exception e3) {
            ok = false;
        }
        if (!ok || !Files.exists(tmpFileHolder, new LinkOption[0])) {
            OLogger.println("Cannot create empty file \"" + fileHolder + "\"");
            throw new IOException(fileHolder);
        }
    }

    public static FilePrompt createListedFilesHolder(String tmpDir, String tmpFile, String pPath, boolean checkForExistence, boolean isDir) throws IOException {
        StringBuffer tmpListedFilesHolder = new StringBuffer(tmpDir);
        tmpListedFilesHolder.append(File.separator);
        tmpListedFilesHolder.append(tmpFile);
        String fileHolder = tmpListedFilesHolder.toString();
        Path tmpFileHolder = WrapperFactory.getNioServiceWrapper().getPath(fileHolder, new String[0]);
        if (checkForExistence) {
            Path pFile = WrapperFactory.getNioServiceWrapper().getPath(pPath, new String[0]);
            if (Files.exists(pFile, new LinkOption[0])) {
                if (isDir) {
                    if (!Files.isDirectory(pFile, new LinkOption[0])) {
                        throw new IOException("\"" + pPath + "\" is not a directory");
                    }
                } else if (Files.isDirectory(pFile, new LinkOption[0])) {
                    throw new IOException("\"" + pPath + "\" is a directory");
                }
                BufferedWriter bw = Files.newBufferedWriter(tmpFileHolder, Charset.forName("UTF-8"), new OpenOption[0]);
                bw.write(pPath);
                bw.write("\n");
                bw.close();
                String baseDir = pFile.getParent().toString();
                FilePrompt fp = new FilePrompt(fileHolder, baseDir);
                return fp;
            }
            OLogger.println("File or directory \"" + pPath + "\" does not exist");
            throw new IOException(pPath);
        }
        BufferedWriter bw = Files.newBufferedWriter(tmpFileHolder, Charset.forName("UTF-8"), new OpenOption[0]);
        bw.write(pPath);
        bw.write("\n");
        bw.close();
        Path pFile = WrapperFactory.getNioServiceWrapper().getPath(pPath, new String[0]);
        String baseDir = pFile.getParent().toString();
        FilePrompt fp = new FilePrompt(fileHolder, baseDir);
        return fp;
    }

    public static FilePrompt createTempFileHolder(String pPath, boolean checkForExistence, boolean isDir, String tmpDir, String tmpFile) throws IOException {
        OUSessionHelper.cleanupTmpFile(tmpDir, tmpFile);
        FilePrompt fp = OUSessionHelper.createListedFilesHolder(tmpDir, tmpFile, pPath, checkForExistence, isDir);
        return fp;
    }

    public static void loadSrvmLibPath(String oracleHomePath) {
        String jlibLoc = oracleHomePath + File.separator + (OPatchEnv.isNextGen() ? "modules" : "jlib");
        String srvm = jlibLoc + File.separator + "srvm.jar";
        String srvmasm = jlibLoc + File.separator + "srvmasm.jar";
        String srvmhas = jlibLoc + File.separator + "srvmhas.jar";
        try {
            OPatchSessionHelper.loadExternalLibFile(srvm);
            OPatchSessionHelper.loadExternalLibFile(srvmasm);
            OPatchSessionHelper.loadExternalLibFile(srvmhas);
            String classpath = System.getProperty("java.class.path");
            if (OPatchEnv.isWindows()) {
                classpath = classpath + ";" + srvm;
                classpath = classpath + ";" + srvmasm;
                classpath = classpath + ";" + srvmhas;
            } else {
                classpath = classpath + ":" + srvm;
                classpath = classpath + ":" + srvmasm;
                classpath = classpath + ":" + srvmhas;
            }
            System.setProperty("java.class.path", classpath);
        }
        catch (Exception e2) {
            OLogger.printStackTrace(e2);
        }
    }

    protected static String readTimeStampedPatchID(String oracleHomePath) throws IOException {
        StringBuffer buff = new StringBuffer();
        String patchStorage = OPatchEnv.getPatchStorageDirectoryPath(oracleHomePath);
        String timeStampedPatchID = null;
        if (!UtilEnv.isTimeStampedPatchID()) {
            throw new RuntimeException(" -ps option should be used to specify patchID with timestamp.");
        }
        timeStampedPatchID = UtilEnv.getTimeStampedPatchID();
        StringBuffer racDir = new StringBuffer(patchStorage);
        racDir.append(File.separator);
        racDir.append(timeStampedPatchID);
        OLogger.println("You entered: \"" + timeStampedPatchID + "\"");
        OLogger.println("OPatch will attempt to look for known files under ");
        OLogger.println(racDir.toString());
        Path racLoc = WrapperFactory.getNioServiceWrapper().getPath(racDir.toString(), new String[0]);
        if (!Files.exists(racLoc, new LinkOption[0])) {
            buff = new StringBuffer("\"");
            buff.append(racDir.toString());
            buff.append("\" does not exist.  Please try again.");
            throw new IOException(buff.toString());
        }
        if (!Files.isDirectory(racLoc, new LinkOption[0])) {
            buff = new StringBuffer("\"");
            buff.append(racDir.toString());
            buff.append("\" is not a directory.  Please try again.");
            throw new IOException(buff.toString());
        }
        buff = new StringBuffer(" \nLooking for known files under \"");
        buff.append(racDir.toString());
        buff.append("\"...\n");
        OLogger.debug(buff);
        return timeStampedPatchID;
    }

    protected static String readRacLocation(String oracleHomePath) throws IOException, ExitOPatchException {
        String rac = OPatchEnv.getRacSubdirName();
        String patchStorage = OPatchEnv.getPatchStorageDirectoryPath(oracleHomePath);
        String timeStampedPatchID = null;
        try {
            if (!UtilEnv.isTimeStampedPatchID()) {
                throw new RuntimeException(" -ps option should be used to specify patchID with timestamp.\n");
            }
            timeStampedPatchID = UtilEnv.getTimeStampedPatchID();
            StringBuffer racDir = new StringBuffer(patchStorage);
            racDir.append(File.separator);
            racDir.append(timeStampedPatchID);
            racDir.append(File.separator);
            racDir.append(OPatchEnv.getRacSubdirName());
            OLogger.println("You entered: \"" + timeStampedPatchID + "\"");
            OLogger.println("OPatch will attempt to look for known files under ");
            OLogger.println(racDir.toString());
            Path racLoc = WrapperFactory.getNioServiceWrapper().getPath(racDir.toString(), new String[0]);
            if (!Files.exists(racLoc, new LinkOption[0])) {
                StringBuffer buff = new StringBuffer("\"");
                buff.append(racDir.toString());
                buff.append("\" does not exist.  Please try again.");
                throw new IOException(buff.toString());
            }
            if (!Files.isDirectory(racLoc, new LinkOption[0])) {
                StringBuffer buff = new StringBuffer("\"");
                buff.append(racDir.toString());
                buff.append("\" is not a directory.  Please try again.");
                throw new IOException(buff.toString());
            }
            StringBuffer buff = new StringBuffer(" \nLooking for known files under \"");
            buff.append(racDir.toString());
            buff.append("\"...\n");
            OLogger.debug(buff);
            return racDir.toString();
        }
        catch (IOException e2) {
            throw e2;
        }
        catch (ExitOPatchException e3) {
            throw e3;
        }
    }

    public static String getXMLFileLocation() {
        String loc = "";
        if (!UtilEnv.isXML()) {
            throw new RuntimeException(" -xmlInput option should be used to specify xml file location.\n");
        }
        loc = UtilEnv.getXML();
        Path f2 = WrapperFactory.getNioServiceWrapper().getPath(loc, new String[0]);
        if (loc.isEmpty() || !Files.exists(f2, new LinkOption[0]) || !Files.isReadable(f2)) {
            StringBuffer buff = new StringBuffer("\"");
            buff.append(loc);
            buff.append("\" does not exist or not readable.");
            RuntimeException e2 = new RuntimeException(buff.toString());
            throw e2;
        }
        return loc;
    }

    public static class FilePrompt {
        String fileHolder;
        String baseDir;

        public FilePrompt(String fileHolder, String baseDir) {
            this.fileHolder = fileHolder;
            this.baseDir = baseDir;
        }

        public String getFileHolder() {
            return this.fileHolder;
        }

        public String getBaseDir() {
            return this.baseDir;
        }
    }
}

