/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchutil;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Vector;
import oracle.opatch.OPatchACL;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchFmwEnv;
import oracle.opatch.OPatchSDK;
import oracle.opatch.PatchObject;
import oracle.opatch.PrereqSession;
import oracle.opatch.Rules;
import oracle.opatch.ipm.IIPMReadServices;
import oracle.opatch.opatchfafmw.FmwHelper;
import oracle.opatch.opatchfafmw.checkApplicable;
import oracle.opatch.opatchfafmw.checkInstalledOneOffs;
import oracle.opatch.opatchfafmw.lsdomains;
import oracle.opatch.opatchfafmw.lshomes;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.wrappers.WrapperFactory;

public class OPatchFmwPointer {
    public static boolean isFmwUserOptionsError(int checkCode) {
        try {
            OPatchFmwPointer.checkFmwUserOptionsError(checkCode);
            return false;
        }
        catch (Exception e2) {
            return true;
        }
    }

    public static void checkFmwUserOptionsError(int checkCode) throws RuntimeException {
        String ohPath = null;
        String mwhPath = null;
        StringBuffer dbuff = null;
        StringBuffer finalMsg = new StringBuffer();
        int nChecks = 0;
        dbuff = new StringBuffer("  checkFmwUserOptionsError(").append(checkCode).append(")");
        OLogger.debug(dbuff);
        while (checkCode > 0) {
            if ((checkCode & 1) == 0) {
                ++nChecks;
                checkCode >>= 1;
                continue;
            }
            String msg = null;
            switch (1 << nChecks) {
                case 1: {
                    dbuff = new StringBuffer("Checking for WebLogic Home validity");
                    OLogger.debug(dbuff);
                    String wlHome = OPatchFmwEnv.getWlHome();
                    if (wlHome == null || wlHome.equals("")) {
                        msg = OLogger.getString("OUI-67710");
                        break;
                    }
                    Path wlHomeDir = WrapperFactory.getNioServiceWrapper().getPath(wlHome, new String[0]);
                    if (Files.exists(wlHomeDir, new LinkOption[0]) && Files.isDirectory(wlHomeDir, new LinkOption[0])) break;
                    msg = OLogger.getString("OUI-67711", new Object[]{wlHome});
                    break;
                }
                case 2: {
                    dbuff = new StringBuffer("Checking for Middleware Home validity");
                    OLogger.debug(dbuff);
                    mwhPath = OPatchFmwEnv.getUserSpecifiedMWH();
                    Path mwHomeDir = WrapperFactory.getNioServiceWrapper().getPath(mwhPath, new String[0]);
                    if (!Files.exists(mwHomeDir, new LinkOption[0]) || !Files.isDirectory(mwHomeDir, new LinkOption[0])) {
                        msg = OLogger.getString("OUI-67712", new Object[]{mwhPath});
                        break;
                    }
                    dbuff = new StringBuffer("Checking for Registry File in Middleware Home [" + mwHomeDir.toAbsolutePath().toString() + "]");
                    OLogger.debug(dbuff);
                    Path reg = WrapperFactory.getNioServiceWrapper().getPath(mwHomeDir.toAbsolutePath().toString(), "registry.dat");
                    if (OPatchEnv.isNextGen() || reg != null && Files.exists(reg, new LinkOption[0])) break;
                    msg = OLogger.getString("OUI-67712", new Object[]{mwhPath});
                    break;
                }
                case 4: {
                    dbuff = new StringBuffer("Checking for Middleware/Oracle Home consistency");
                    OLogger.debug(dbuff);
                    ohPath = OPatchFmwEnv.getUserSpecifiedOH();
                    if (ohPath == null || ohPath.equals("")) {
                        ohPath = OPatchFmwEnv.getOracleHome();
                    }
                    mwhPath = OPatchFmwEnv.getUserSpecifiedMWH();
                    String ohpCanPath = null;
                    String mwhCanPath = null;
                    Path fp_ohp = WrapperFactory.getNioServiceWrapper().getPath(ohPath, new String[0]).getParent();
                    Path fp_mwh = WrapperFactory.getNioServiceWrapper().getPath(mwhPath, new String[0]);
                    try {
                        ohpCanPath = fp_ohp.toRealPath(new LinkOption[0]).toString();
                        mwhCanPath = fp_mwh.toRealPath(new LinkOption[0]).toString();
                    }
                    catch (IOException e2) {
                        RuntimeException t = new RuntimeException(e2.getMessage());
                        t.setStackTrace(e2.getStackTrace());
                        throw t;
                    }
                    dbuff = new StringBuffer("User Specified MW_HOME full path is : " + mwhCanPath);
                    OLogger.debug(dbuff);
                    dbuff = new StringBuffer("Canonical Middleware Home full path is : " + ohpCanPath);
                    OLogger.debug(dbuff);
                    if (ohpCanPath.equals(mwhCanPath) || OPatchEnv.isNextGen()) break;
                    msg = OLogger.getString("OUI-67709", new Object[]{ohPath, mwhPath});
                    break;
                }
            }
            ++nChecks;
            checkCode >>= 1;
            if (msg == null) continue;
            finalMsg.append(msg).append("\n");
        }
        if (finalMsg.length() > 0) {
            throw new RuntimeException(finalMsg.toString());
        }
    }

    public static String verifyDomainNameSetting(String singleDomainName) {
        HashSet domainOHMap = FmwHelper.getDomainOracleHomeMap(null, null, OPatchFmwEnv.getOracleHome(), null);
        if (singleDomainName == null || singleDomainName.equals("")) {
            if (domainOHMap == null) {
                String msg = OLogger.getString("OUI-67831", new Object[]{OPatchFmwEnv.getOracleHome()});
                throw new RuntimeException(msg);
            }
            if (domainOHMap.size() > 1) {
                OLogger.println("Tho following domains are configured from this Oracle Home:\n");
                for (String theDomainInfo : domainOHMap) {
                    if (theDomainInfo == null || theDomainInfo.trim().length() <= 2) continue;
                    String[] s = theDomainInfo.split(";");
                    OLogger.println(" Domain Name = \"" + s[0] + "\" Path = \"" + s[1] + "\"");
                }
                String msg = OLogger.getString("OUI-67832", new Object[]{OPatchFmwEnv.getOracleHome()});
                throw new RuntimeException(msg);
            }
            String singleDomainInfo = (String)domainOHMap.iterator().next();
            if (singleDomainInfo == null || singleDomainInfo.trim().length() < 3) {
                String msg = OLogger.getString("OUI-67831", new Object[]{OPatchFmwEnv.getOracleHome()});
                throw new RuntimeException(msg);
            }
            singleDomainName = singleDomainInfo.split(";")[0];
        } else if (domainOHMap == null || domainOHMap.size() == 0) {
            // empty if block
        }
        return singleDomainName;
    }

    private static String getHomeGUID() {
        try {
            String home = System.getProperty("OPatch.COMMON_COMPONENTS_HOME");
            if (home == null) {
                throw new Exception("Common Components Home is not specified.");
            }
            String oh = OPatchFmwEnv.getOracleHome();
            IIPMReadServices readServices = PrereqSession.getReadServices(oh);
            if (!readServices.isInventoryLoaded()) {
                throw new Exception("Oracle Home [" + oh + "] is not registered with Central Inventory.");
            }
            String guid = readServices.getGUID(home);
            OLogger.printlnOnLog("[FMW] Home GUID for [" + home + "] [" + guid + "]");
            return guid;
        }
        catch (Throwable t) {
            OLogger.printlnOnLog(new StringBuffer("[FMW] [HomeGUID] ").append(t).toString());
            return "";
        }
    }

    public static boolean checkAutomatable(PatchObject po) {
        return Rules.isAutomatable(po);
    }

    public static void lsdomains() throws RuntimeException {
        OPatchFmwPointer.checkFmwUserOptionsError(1 | (OPatchFmwEnv.isUserSpecifiedMWH() && OPatchFmwEnv.isUserSpecifiedOH() ? 4 : 0));
        StringBuffer buff = new StringBuffer("OPatchFmwPointer::lsdomains()");
        OLogger.debug(buff);
        try {
            lsdomains.lsdomains(OPatchFmwEnv.isUserSpecifiedOH() ? OPatchFmwEnv.getUserSpecifiedOH() : null, OPatchFmwEnv.getMwHome());
        }
        catch (RuntimeException e2) {
            OLogger.printStackTrace(e2);
            throw e2;
        }
    }

    public static void lshomes() throws RuntimeException {
        OPatchFmwPointer.checkFmwUserOptionsError(1 | (OPatchFmwEnv.isUserSpecifiedMWH() ? 2 : 0));
        StringBuffer buff = new StringBuffer("OPatchFmwPointer::lshomes()");
        OLogger.debug(buff);
        try {
            boolean domainOptSpec;
            String domain = OPatchFmwEnv.getFmwDomainName();
            String domainDir = OPatchFmwEnv.getFmwDomainDir();
            boolean bl = domainOptSpec = domain != null && domain.trim().length() > 0 || domainDir != null && domainDir.trim().length() > 0;
            boolean allOption = OPatchFmwEnv.isUserSpecifiedMWH() ? false : domainOptSpec;
            String mwHome = OPatchFmwEnv.getMwHome();
            String[] homePaths = OPatchFmwPointer.getValidOracleHomesFromMwHome(OPatchFmwEnv.getOracleHome(), allOption, mwHome);
            lshomes.lshomes(null, homePaths, domain, domainDir, OPatchFmwEnv.isUserSpecifiedMWH() ? OPatchFmwEnv.getUserSpecifiedMWH() : null);
        }
        catch (RuntimeException e2) {
            OLogger.printStackTrace(e2);
            throw e2;
        }
    }

    public static void checkInstalledOneOffs(String oracleHomePath) throws RuntimeException {
        StringBuffer buff = new StringBuffer("OPatchFmwPointer::checkInstalledOneOffs()");
        OLogger.debug(buff);
        OPatchFmwPointer.checkFmwUserOptionsError(OPatchFmwEnv.isUserSpecifiedMWH() ? 2 : 0 | (OPatchFmwEnv.isUserSpecifiedMWH() && OPatchFmwEnv.isUserSpecifiedOH() ? 4 : 0));
        try {
            String domain = OPatchFmwEnv.getFmwDomainName();
            String[] patchIDs = OPatchFmwEnv.getPatchIDs();
            boolean userOH = OPatchFmwEnv.isUserSpecifiedOH();
            boolean userMWH = OPatchFmwEnv.isUserSpecifiedMWH();
            String mwHome = OPatchFmwEnv.getMwHome();
            boolean isAll = OPatchFmwEnv.isAll();
            String[] homePaths = new String[]{};
            if (userMWH || mwHome != null && !mwHome.equals("")) {
                if (userOH) {
                    homePaths = new String[]{oracleHomePath};
                } else {
                    homePaths = OPatchFmwPointer.getValidOracleHomesFromMwHome(oracleHomePath, isAll, mwHome);
                    if (homePaths == null || homePaths.length == 0) {
                        OLogger.printlnres("OUI-67714", new Object[]{mwHome});
                        return;
                    }
                }
            } else {
                homePaths = new String[]{oracleHomePath};
            }
            Vector<String> filteredHomePaths = new Vector<String>();
            try {
                if (domain != null && !domain.equals("")) {
                    if (mwHome == null || mwHome.equals("")) {
                        throw new RuntimeException("Fusion Middleware Home is not set. Please check and set MW_HOME environment variable or give the home by 'mw_home' option");
                    }
                    HashSet hs = FmwHelper.getDomainOracleHomeMap(domain, null, null, mwHome);
                    if (hs != null && homePaths != null) {
                        for (int i2 = 0; i2 < homePaths.length; ++i2) {
                            String eachOH = homePaths[i2];
                            if (eachOH == null || !hs.contains(eachOH)) continue;
                            filteredHomePaths.add(eachOH);
                        }
                    }
                    String[] domainBasedHomePaths = new String[filteredHomePaths.size()];
                    filteredHomePaths.toArray(domainBasedHomePaths);
                    homePaths = domainBasedHomePaths;
                }
            }
            catch (RuntimeException e2) {
                OLogger.printStackTrace(e2);
                throw new RuntimeException(e2.getMessage());
            }
            checkInstalledOneOffs.checkInstalledOneOffs(oracleHomePath, homePaths, patchIDs, mwHome, isAll);
        }
        catch (Throwable t) {
            RuntimeException e3 = new RuntimeException(t.getMessage());
            e3.setStackTrace(e3.getStackTrace());
            throw e3;
        }
    }

    public static void checkApplicable(String oracleHomePath) throws RuntimeException {
        StringBuffer buff = new StringBuffer("OPatchFmwPointer::checkApplicable()");
        OLogger.debug(buff);
        OPatchFmwPointer.checkFmwUserOptionsError(OPatchFmwEnv.isUserSpecifiedMWH() ? 2 : 0 | (OPatchFmwEnv.isUserSpecifiedMWH() && OPatchFmwEnv.isUserSpecifiedOH() ? 4 : 0));
        try {
            String patchLoc = OPatchFmwEnv.getFmwPatchLoc();
            boolean userOH = OPatchFmwEnv.isUserSpecifiedOH();
            boolean userMWH = OPatchFmwEnv.isUserSpecifiedMWH();
            String mwHome = OPatchFmwEnv.getMwHome();
            boolean isAll = OPatchFmwEnv.isAll();
            String[] homePaths = new String[]{};
            if (isAll) {
                homePaths = OPatchFmwPointer.getValidOracleHomesFromMwHome(oracleHomePath, isAll, mwHome);
            } else if (userMWH || mwHome != null && !mwHome.equals("")) {
                if (userOH) {
                    homePaths = new String[]{oracleHomePath};
                } else {
                    homePaths = OPatchFmwPointer.getValidOracleHomesFromMwHome(oracleHomePath, isAll, mwHome);
                    if (homePaths == null || homePaths.length == 0) {
                        OLogger.printlnres("OUI-67714", new Object[]{mwHome});
                        return;
                    }
                }
            } else {
                homePaths = new String[]{oracleHomePath};
            }
            checkApplicable.checkApplicable(oracleHomePath, homePaths, patchLoc, mwHome, isAll);
        }
        catch (Throwable t) {
            RuntimeException e2 = new RuntimeException(t.getMessage());
            e2.setStackTrace(e2.getStackTrace());
            throw e2;
        }
    }

    public static String[] getValidOracleHomesFromMwHome(String oracleHomePath, boolean isAll, String mwHome) throws RuntimeException {
        StringBuffer buff = new StringBuffer("getValidOracleHomesFromMwHome()");
        OLogger.debug(buff);
        OPatchSDK.OracleHome[] oracleHomes = new OPatchSDK.OracleHome[]{};
        String[] correctHomePaths = new String[]{};
        try {
            IIPMReadServices readServices = PrereqSession.getReadServices(oracleHomePath);
            if (!readServices.isInventoryLoaded()) {
                buff = new StringBuffer("checkValidOracleHomesFromMwHome():: Not able to load inventory.");
                throw new RuntimeException(buff.toString());
            }
            oracleHomes = OPatchACL.getOracleHomes(new OPatchFmwPointer(), readServices);
            String[] homePaths = new String[oracleHomes.length];
            for (int i2 = 0; i2 < homePaths.length; ++i2) {
                homePaths[i2] = oracleHomes[i2].getLocation();
            }
            Path mwDir = WrapperFactory.getNioServiceWrapper().getPath(mwHome, new String[0]);
            if (!(isAll || Files.exists(mwDir, new LinkOption[0]) && Files.isDirectory(mwDir, new LinkOption[0]))) {
                throw new RuntimeException("The given Middleware Home \"" + mwHome + "\" is not a valid directory.");
            }
            String mwCanPath = "";
            try {
                mwCanPath = mwDir.toRealPath(new LinkOption[0]).toString();
            }
            catch (IOException e2) {
                RuntimeException t = new RuntimeException(e2.getMessage());
                t.setStackTrace(e2.getStackTrace());
                throw t;
            }
            buff = new StringBuffer("MW_HOME path is : " + mwCanPath);
            OLogger.debug(buff);
            Vector<String> validHomePaths = new Vector<String>();
            for (int i3 = 0; i3 < homePaths.length; ++i3) {
                if (isAll) {
                    validHomePaths.add(homePaths[i3]);
                    continue;
                }
                buff = new StringBuffer("Checking Oracle Home \"" + homePaths[i3] + "\"...");
                OLogger.debug(buff);
                if (OPatchEnv.isNextGen()) {
                    if (!WrapperFactory.getNioServiceWrapper().getPath(homePaths[i3], new String[0]).equals(mwDir)) continue;
                    validHomePaths.add(homePaths[i3]);
                    continue;
                }
                Path fp = WrapperFactory.getNioServiceWrapper().getPath(homePaths[i3], new String[0]).getParent();
                String fpCanPath = "";
                try {
                    fpCanPath = fp.toRealPath(new LinkOption[0]).toString();
                }
                catch (IOException e3) {
                    RuntimeException t = new RuntimeException(e3.getMessage());
                    t.setStackTrace(e3.getStackTrace());
                    throw t;
                }
                buff = new StringBuffer("Current Oracle Home's parent is : " + fpCanPath);
                OLogger.debug(buff);
                if (!fpCanPath.equals(mwCanPath)) continue;
                buff = new StringBuffer("Adding valid Oracle home \"" + homePaths[i3] + "\" for further checks...");
                OLogger.debug(buff);
                validHomePaths.add(homePaths[i3]);
            }
            correctHomePaths = new String[validHomePaths.size()];
            validHomePaths.toArray(correctHomePaths);
        }
        catch (Throwable t) {
            RuntimeException e4 = new RuntimeException(t.getMessage());
            e4.setStackTrace(e4.getStackTrace());
            throw e4;
        }
        return correctHomePaths;
    }
}

