/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchutil;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import oracle.opatch.ApplySession;
import oracle.opatch.Bug;
import oracle.opatch.CompositePatchObject;
import oracle.opatch.CopyAction;
import oracle.opatch.CopyInventory;
import oracle.opatch.ExitOPatchException;
import oracle.opatch.MergedPatchObject;
import oracle.opatch.OCMException;
import oracle.opatch.OPatchACL;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchExternalFactory;
import oracle.opatch.OPatchOverCAS;
import oracle.opatch.OPatchOverCASUtil;
import oracle.opatch.OPatchSession;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.OPatchStateManagerFactory;
import oracle.opatch.OneOffEntry;
import oracle.opatch.OnlinePatchException;
import oracle.opatch.PatchObject;
import oracle.opatch.PatchValidationException;
import oracle.opatch.PatchingFlow;
import oracle.opatch.PatchingModel;
import oracle.opatch.PatchmdXml;
import oracle.opatch.PrereqFailedException;
import oracle.opatch.PrereqSession;
import oracle.opatch.Rac;
import oracle.opatch.RacFileCreator;
import oracle.opatch.RacProcessor;
import oracle.opatch.Rules;
import oracle.opatch.SymbolFailureException;
import oracle.opatch.cas.OPatchPatchKey;
import oracle.opatch.conflicttextualinterpreter.OracleHomeConflictMap;
import oracle.opatch.cup.CUPAdapter;
import oracle.opatch.cup.CUPPatchComponent;
import oracle.opatch.ipm.IIPMRWServices;
import oracle.opatch.ipm.IIPMReadServices;
import oracle.opatch.napplyhelper.BuildComposite;
import oracle.opatch.napplyhelper.CheckDuplicate;
import oracle.opatch.napplyhelper.CheckInterConflict;
import oracle.opatch.napplyhelper.CheckIntraConflict;
import oracle.opatch.napplyhelper.CheckMissingComps;
import oracle.opatch.napplyhelper.ConflictReporter;
import oracle.opatch.napplyhelper.CreateMergedPatch;
import oracle.opatch.napplyhelper.EnvValidation;
import oracle.opatch.napplyhelper.GetFinalList;
import oracle.opatch.napplyhelper.NApplyData;
import oracle.opatch.napplyhelper.NApplyDataSerializer;
import oracle.opatch.napplyhelper.PatchValidation;
import oracle.opatch.napplyhelper.PrintApplyReport;
import oracle.opatch.napplyhelper.ProcessLists;
import oracle.opatch.napplyhelper.RunConsolidatedScripts;
import oracle.opatch.napplyhelper.RunInit;
import oracle.opatch.opatchactions.DeleteAction;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchprereq.ConflictMatrixOutput;
import oracle.opatch.opatchprereq.PrereqAPI;
import oracle.opatch.opatchprereq.PrereqFilterDuplicatePatch;
import oracle.opatch.opatchprereq.PrereqResult;
import oracle.opatch.opatchprereq.PrereqSet;
import oracle.opatch.opatchprereq.ProcessFileVersions;
import oracle.opatch.opatchsdk.FailedPrereqException;
import oracle.opatch.opatchutil.NSession;
import oracle.opatch.opatchutil.OPatchUtilHelper;
import oracle.opatch.opatchutil.OUSession;
import oracle.opatch.ops.Feature;
import oracle.opatch.ops.OPS;
import oracle.opatch.twophase.ExitTwoPhaseException;
import oracle.opatch.twophase.TwoPhaseOperations;
import oracle.opatch.util.perfmonitor.MethodTracker;
import oracle.opatch.util.perfmonitor.MethodTrackerObj;
import oracle.opatch.util.perfmonitor.TrackerTags;
import oracle.opatch.wrappers.WrapperFactory;

public class NApply
extends NSession {
    private static final String sessionName = OPatchEnv.getNApplySessionName();

    private NApply() {
    }

    private static void checkEmptyPatchList(OneOffEntry[] patchesToApply) {
        if (patchesToApply == null || patchesToApply.length == 0) {
            StringBuffer buff = new StringBuffer(OLogger.getString("OUI-67306", new Object[]{"NApply", "apply"}));
            OLogger.debug(buff);
            throw new RuntimeException(buff.toString());
        }
    }

    private static String getNApplyCmdToRunAgain(String[] list) {
        String patchLoc = OUSession.getPatchBaseDir();
        StringBuffer tryAgainCmd = new StringBuffer("<ORACLE_HOME>/OPatch/opatch napply ");
        tryAgainCmd.append(patchLoc);
        tryAgainCmd.append(" -id ");
        for (int i2 = 0; i2 < list.length; ++i2) {
            String id = list[i2];
            if (i2 != 0) {
                tryAgainCmd.append(",");
            }
            tryAgainCmd.append(id);
        }
        String orgCmd = OPatchEnv.getOriginalCommand();
        StringTokenizer tk = new StringTokenizer(orgCmd);
        int i3 = 1;
        while (tk.hasMoreTokens()) {
            String token = tk.nextToken();
            if (i3 > 2) {
                if (token.equals("-id")) {
                    tk.nextToken();
                } else {
                    tryAgainCmd.append(" ").append(token);
                }
            }
            ++i3;
        }
        StringBuffer buff = new StringBuffer();
        buff.append("Conflict with patches in OracleHome detected. Please run OPatch again as\n");
        buff.append(tryAgainCmd.toString());
        buff.append("\n\nIf the command is too long, please paste the patch id list in a file and");
        buff.append("\ninvoke with 'idfile' option. Please refer 'opatch napply -help' for ");
        buff.append("\n'idfile' option.");
        return buff.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static void process(String oracleHomePath) throws RuntimeException, Error, FailedPrereqException {
        if (PatchingFlow.TWO_PHASE.equals((Object)OPatchEnv.getPatchingFlow()) && !OPatchEnv.isReport()) {
            OPatchEnv.setCASFlow(true);
            OLogger.printlnOnLog("NApply::CAS enabled, OPatch runs with two-phase patching.");
            try {
                if (OPatchEnv.isCASPhase1()) {
                    OLogger.printlnOnLog("NApply:: OPatch runs phase one.");
                    OPatchOverCAS.INSTANCE.prepareTwoPhasePatching(TwoPhaseOperations.NAPPLY);
                }
                if (!OPatchEnv.isCASPhase2()) return;
                OLogger.printlnOnLog("NApply:: OPatch runs phase two.");
                OPatchOverCAS.INSTANCE.commitTwoPhasePatching();
                OPatchOverCASUtil.cleanupCache(oracleHomePath);
                return;
            }
            catch (Exception e2) {
                if (e2 instanceof ExitTwoPhaseException) {
                    OLogger.printlnOnLog(e2.getMessage());
                    if (OPatchEnv.isOPatchSDKMode()) return;
                    NApply.legacy_process(oracleHomePath);
                    return;
                }
                RuntimeException re = new RuntimeException(e2.getMessage(), e2);
                re.setStackTrace(e2.getStackTrace());
                throw re;
            }
            finally {
                OPatchEnv.unsetCASPhase1();
                OPatchEnv.unsetCASPhase2();
                OPatchEnv.setCASFlow(false);
                if (OPatchEnv.isCASCleanupNeeded() || OPatchEnv.getCASInitCounter() > 0) {
                    OPatchOverCAS.INSTANCE.cleanupCAS();
                    OPatchEnv.decrementCASInitCounter();
                }
            }
        } else {
            OPatchEnv.setCASFlow(false);
            if (OPatchEnv.isReport()) {
                OLogger.printlnOnLog("NApply::Report mode, OPatch runs with legacy process.");
            } else {
                OLogger.printlnOnLog("NApply::no CAS enabled, OPatch runs with legacy process.");
            }
            OPatchEnv.setNapplyData(NApply.legacy_process(oracleHomePath));
        }
    }

    public static NApplyData legacy_process(String oracleHomePath) throws RuntimeException, Error, FailedPrereqException {
        if (OPatchEnv.isReport()) {
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] Napply session in report mode - Start");
        }
        NApplyData data = null;
        if (OPatchEnv.isOPatchSDKMode()) {
            List<PatchObject> pos = NApplyData.getPrereqPatchObject();
            PatchObject[] patchObjs = pos == null ? null : pos.toArray(new PatchObject[pos.size()]);
            data = NApply.legacy_process(oracleHomePath, patchObjs);
        } else {
            data = NApply.legacy_process(oracleHomePath, null);
        }
        if (OPatchEnv.isReport()) {
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] Napply session in report mode - End");
        }
        return data;
    }

    public static NApplyData legacy_process(String oracleHomePath, PatchObject[] piList) throws RuntimeException, Error, FailedPrereqException {
        Map<String, String> autoInActivePatches;
        RuntimeException re;
        StringBuffer dBuff;
        StringBuffer buff = new StringBuffer("NApply::process() on \"");
        buff.append(oracleHomePath);
        buff.append("\"");
        OLogger.debug(buff);
        if (OPatchEnv.isReport() && OPatchEnv.isCASFlow() && OPatchEnv.isOPatchSDKMode() && OUSession.isPhaseOneReport()) {
            NApply.runPreSKDApplyPrereqs(oracleHomePath, piList);
        }
        NApplyData data = new NApplyData();
        NApplyDataSerializer serializer = new NApplyDataSerializer();
        ProcessFileVersions proc = new ProcessFileVersions();
        OPatchEnv.setNApply(true);
        OneOffEntry[] patchesToApply = new OneOffEntry[]{};
        OneOffEntry[] OHOneOffs = new OneOffEntry[]{};
        PatchObject[] apPatchObjects = new PatchObject[]{};
        IIPMRWServices rwServices = null;
        RacProcessor.MinDowntimeNodeSelection selects = null;
        PrereqSet patchesToBeMerged = new PrereqSet();
        PrereqSet patchesNotNeeded = new PrereqSet();
        PrereqSet patchesThatCanGoNow = new PrereqSet();
        PrereqSet patchesToBeRolledBack = new PrereqSet();
        boolean isLocal = OPatchEnv.isLocal();
        OLogger.println(OLogger.getString("OUI-67910"));
        rwServices = OPatchSessionHelper.lockInventory(oracleHomePath);
        data.setModelCode(PatchingModel.returnModelCode(oracleHomePath));
        int modelCode = data.getModelCode();
        boolean fc = OPatchEnv.isForceConflict();
        if (fc) {
            try {
                OHOneOffs = PrereqAPI.getInstalledOneOff(oracleHomePath);
                data.setBeforePohs(OHOneOffs);
            }
            catch (Throwable e2) {
                OLogger.debug(new StringBuffer("Converting Throwable to RuntimeException"));
                RuntimeException re3 = new RuntimeException(e2.getMessage());
                re3.setStackTrace(e2.getStackTrace());
            }
        }
        MethodTrackerObj preReqTrackerObj = MethodTracker.getTracker(TrackerTags.PREREQ);
        preReqTrackerObj.start();
        OLogger.justlog(OLogger.INFO, "[OPSR-TIME] Running prerequisite checks");
        if (OPatchEnv.isSkipDuplicate() || OPatchEnv.isSkipSubset()) {
            OLogger.warn("OUI-67738");
        }
        EnvValidation.validate(oracleHomePath);
        try {
            dBuff = new StringBuffer("N-Apply: get a list of patches.");
            OLogger.debug(dBuff);
            if (piList == null) {
                patchesToApply = OPatchUtilHelper.getPatchesToApply(oracleHomePath, sessionName);
            } else {
                OneOffEntry[] inPatch = new OneOffEntry[piList.length];
                for (int i3 = 0; i3 < piList.length; ++i3) {
                    inPatch[i3] = piList[i3].toOneOffEntry(oracleHomePath);
                }
                patchesToApply = inPatch;
            }
            if (!OPatchEnv.isCUPSupported()) {
                for (OneOffEntry p2 : patchesToApply) {
                    String subType = p2.getSubType();
                    if (!subType.equalsIgnoreCase("upgrade") && !subType.equalsIgnoreCase("upgrade")) continue;
                    throw new RuntimeException("CUP feature not available, but incoming patches has CUP patches");
                }
            }
            data.setPatchesToApply(patchesToApply);
            if (OPS.INSTANCE.getSupportServices().isSupport(Feature.FA_TWO_PHASE)) {
                OPatchEnv.setFATwoPhase();
                if (proc.validateResult(oracleHomePath, OHOneOffs, patchesToApply)) {
                    OPatchEnv.setHashMatch();
                    OLogger.printlnOnLogAndVerbose("NApply SDK:Hash matches for FA snowball two-phase patching. Use pre-computed FVs.\n");
                }
            }
            PatchValidation pv = new PatchValidation(data);
            pv.validatePatch(data);
            BuildComposite bc = new BuildComposite(data);
            bc.checkComposite(data);
            if (data.isComposite()) {
                bc.buildCompositeArray(data);
                data.setCompositeIdenticalPatches(CompositePatchObject.GetIdenticalPatch(data.getCompositeSubArray(), oracleHomePath));
            }
        }
        catch (Exception e3) {
            if (e3 instanceof OnlinePatchException) {
                throw (OnlinePatchException)e3;
            }
            if (e3 instanceof SymbolFailureException) {
                throw (SymbolFailureException)e3;
            }
            if (e3 instanceof PatchValidationException) {
                throw (PatchValidationException)e3;
            }
            RuntimeException re4 = new RuntimeException(e3.getMessage(), e3);
            re4.setStackTrace(e3.getStackTrace());
            OPatchStateManagerFactory.getInstance().setErrorCode(215);
            throw re4;
        }
        if (data.isComposite() && modelCode == 2) {
            String errorBuff = OLogger.getString("OUI-67927");
            throw new RuntimeException(errorBuff);
        }
        HashSet[] filteredPatchActions = null;
        filteredPatchActions = new HashSet[patchesToApply.length];
        for (int i4 = 0; i4 < patchesToApply.length; ++i4) {
            filteredPatchActions[i4] = new HashSet();
        }
        data.setPatchActions(filteredPatchActions);
        try {
            PatchObject[] initialApplyPatchObjects = OPatchUtilHelper.getPatchesToApply(oracleHomePath, patchesToApply, sessionName);
            OPatchSessionHelper.checkIfSidAddition(oracleHomePath, initialApplyPatchObjects);
            OPatchSessionHelper.getWlsPatchProfile(initialApplyPatchObjects);
            patchesToApply = PrereqFilterDuplicatePatch.filterDupPi(patchesToApply);
            data.setPatchesToApply(patchesToApply);
        }
        catch (Exception e4) {
            RuntimeException re5 = new RuntimeException(e4.getMessage(), e4);
            re5.setStackTrace(e4.getStackTrace());
            throw re5;
        }
        CheckMissingComps checkMc = new CheckMissingComps(data);
        boolean b2 = checkMc.doMcCheck(oracleHomePath, data);
        if (b2) {
            OPatchSessionHelper.releaseInventory(rwServices);
            return data;
        }
        patchesToApply = data.getPatchesToApply();
        if (!OPatchEnv.isSnowBall()) {
            CheckIntraConflict intra = new CheckIntraConflict(data);
            intra.doIntraCheck(oracleHomePath, data);
        }
        CheckInterConflict inter = new CheckInterConflict(data);
        boolean sc = OPatchEnv.isIgnoreConflict();
        boolean checkAgain = true;
        boolean showCanGo = false;
        OPatchEnv.setForceConflict(false);
        inter.getAllRes(oracleHomePath, data);
        ConflictMatrixOutput interOutput = data.getInterOutput();
        ArrayList<OneOffEntry> patchesCanGoForDup = null;
        ArrayList<String> worsePatchesForDup = null;
        patchesToBeMerged = new PrereqSet(interOutput.getListOfPatchesToBeMerged());
        patchesCanGoForDup = new ArrayList<OneOffEntry>(Arrays.asList(interOutput.getListOfPatchesThatCanGoNow()));
        worsePatchesForDup = new ArrayList<String>(interOutput.getListOfWorsePatches());
        ArrayList<OneOffEntry> patchesToApplyForDup = new ArrayList<OneOffEntry>();
        for (OneOffEntry patchToApply : patchesToApply) {
            if (!patchToApply.getIsComposite() && patchesCanGoForDup.contains(patchToApply) && worsePatchesForDup.contains(patchToApply.getID())) continue;
            patchesToApplyForDup.add(patchToApply);
        }
        OneOffEntry[] patchesToApplyForDupArr = new OneOffEntry[patchesToApplyForDup.size()];
        patchesToApplyForDup.toArray(patchesToApplyForDupArr);
        NApplyData dataToCheckDup = new NApplyData();
        dataToCheckDup.setModelCode(data.getModelCode());
        dataToCheckDup.setPatchesToApply(patchesToApplyForDupArr);
        try {
            BuildComposite bcDup = new BuildComposite(dataToCheckDup);
            bcDup.checkComposite(dataToCheckDup);
            if (dataToCheckDup.isComposite()) {
                bcDup.buildCompositeArray(dataToCheckDup);
                dataToCheckDup.setCompositeIdenticalPatches(CompositePatchObject.GetIdenticalPatch(dataToCheckDup.getCompositeSubArray(), oracleHomePath));
            }
        }
        catch (Exception e5) {
            RuntimeException re6 = new RuntimeException(e5.getMessage(), e5);
            re6.setStackTrace(e5.getStackTrace());
            OPatchStateManagerFactory.getInstance().setErrorCode(215);
            throw re6;
        }
        CheckDuplicate dup = new CheckDuplicate(dataToCheckDup);
        if (dup.check(oracleHomePath, dataToCheckDup) && patchesToApplyForDupArr.length == patchesToApply.length) {
            OPatchSessionHelper.releaseInventory(rwServices);
            return data;
        }
        if (interOutput.getResult().equals(PrereqResult.ExecuteStatus.FAILED) && !fc) {
            ConflictReporter.processFailUI(data);
            ConflictReporter.processFailMessage(data);
        } else if (interOutput.getResult().equals(PrereqResult.ExecuteStatus.PASSED)) {
            checkAgain = false;
        }
        if (checkAgain) {
            ConflictReporter.processFailUI(data);
            if (!OPatchEnv.proceedWithOperationDefaultYes(new StringBuffer())) {
                buff = new StringBuffer("NApply stops on user's request.");
                throw new PrereqFailedException(buff.toString());
            }
            OPatchEnv.setForceConflict(fc);
            boolean passed = inter.doInterCheck(oracleHomePath, data);
            if (!passed) {
                ConflictReporter.processFailMessage(data);
            }
        }
        if (!checkAgain) {
            ConflictReporter.processSucceedUI(data, checkAgain);
        }
        if (!data.getCanGoFlag()) {
            OPatchSessionHelper.releaseInventory(rwServices);
            return data;
        }
        boolean needMergeRequest = data.getMergedFlag();
        boolean hasNotNeededPatch = data.getNotNeedFlag();
        boolean hasPatchToApply = data.getCanGoFlag();
        boolean hasAutoRollback = data.getRollbackFlag();
        if (OPatchEnv.isFATwoPhase()) {
            try {
                OLogger.printlnOnLog("NApply: Parsed cached FVs for copying files in ApplySession...\n");
                CopyAction.setHashMapEnv(new HashMap<String, String>(serializer.deserializeFileVersion(OPatchEnv.getPrereqResultFileLoc(oracleHomePath) + File.separator + "fv_delta.txt")));
                DeleteAction.setEnvDeleteActVer(new HashMap<String, List<String>>(serializer.deserializeFileVersionList(OPatchEnv.getPrereqResultFileLoc(oracleHomePath) + File.separator + "fv_delta_delete.txt")));
                HashMap<String, String> fvOhMap = new HashMap<String, String>(serializer.deserializeFileVersion(OPatchEnv.getPrereqResultFileLoc(oracleHomePath) + File.separator + "fv_oh.txt"));
                CopyAction.setHashMap(fvOhMap);
                CopyAction.setIHashMap(new HashMap<String, String>(serializer.deserializeFileVersion(OPatchEnv.getPrereqResultFileLoc(oracleHomePath) + File.separator + "fv_pi_merge.txt")));
                DeleteAction.setiDeleteActVer(new HashMap<String, List<String>>(serializer.deserializeFileVersionList(OPatchEnv.getPrereqResultFileLoc(oracleHomePath) + File.separator + "fv_pi_delete.txt")));
                DeleteAction.setCopyFileVer(fvOhMap);
            }
            catch (Exception e6) {
                OLogger.printlnOnLog("NApply: Unable to read file/versions data from cached files, unset two-phase patching mode");
                OPatchEnv.unsetFATwoPhase();
            }
        }
        OPatchSessionHelper.validateOCMOption(oracleHomePath, rwServices);
        if (!OPatchEnv.isCASFlow()) {
            RunInit init = new RunInit(data);
            init.runInit(oracleHomePath, data);
        }
        ProcessLists pl = new ProcessLists(data);
        pl.processRollback(oracleHomePath, data);
        pl.processCanGo(data);
        if (hasPatchToApply) {
            dBuff = new StringBuffer("These patches can be applied:");
            dBuff.append(data.getProceedList());
            OLogger.debug(dBuff);
        }
        if (hasAutoRollback) {
            dBuff = new StringBuffer("If OPatch proceeds, these patches ");
            dBuff.append("will be rolled back:").append(data.getHasAutoRollbackMsg());
            OLogger.debug(dBuff);
        }
        dBuff = new StringBuffer("N-Apply: get the PatchObjects");
        OLogger.debug(dBuff);
        GetFinalList gf = new GetFinalList(data);
        gf.getFinal(oracleHomePath, data);
        try {
            PatchObject[] filteredPatchObjects = data.getApPatchObjects();
            String[] filteredPatchLocs = OPatchUtilHelper.getPatchLocs(filteredPatchObjects);
            patchesToApply = data.getPatchesToApply();
            buff = new StringBuffer("Run all the prereqs related to apply.");
            OLogger.debug(buff);
            OPatchSessionHelper.runApplyPrereqs(oracleHomePath, patchesToApply, filteredPatchObjects, filteredPatchLocs);
        }
        catch (FailedPrereqException fpe) {
            throw fpe;
        }
        catch (Exception e7) {
            RuntimeException re7 = new RuntimeException(e7.getMessage(), e7);
            re7.setStackTrace(e7.getStackTrace());
            throw re7;
        }
        if (hasPatchToApply) {
            OUSession.addNApplyPatchesToReport(data.getApPatchObjects());
            OLogger.println("OPatch continues with these patches: " + data.getFinalList());
        }
        if (OPatchSessionHelper.hasNonHotPatch(data.getCanGoPatches()) && OPatchSessionHelper.hasHotPatch(data.getRollbackPatches())) {
            String msg = OLogger.getString("OUI-67279", new Object[]{OPatchSessionHelper.getHotPatchIDs(data.getRollbackPatches()), OPatchSessionHelper.getPatchIDs(data.getCanGoPatches())});
            PrereqFailedException re8 = new PrereqFailedException(msg);
            throw re8;
        }
        if (!OPatchEnv.proceedWithOperationDefaultYes(new StringBuffer())) {
            buff = new StringBuffer("NApply stops on user's request.");
            throw new ExitOPatchException(buff.toString());
        }
        CreateMergedPatch cmp = new CreateMergedPatch(data);
        cmp.merge(oracleHomePath, data);
        MergedPatchObject mPo = data.getMpo();
        PatchObject[] arbPatchObjects = data.getArbPatchObjects();
        ArrayList patchesMerged = data.getPatchesMerged();
        buff = new StringBuffer("\n");
        buff.append(sessionName);
        buff.append(": backed-up files are under \"");
        String loc = OPatchEnv.getPatchStorageDirectoryPath(oracleHomePath, data.getMpo().getCookedPatchID());
        buff.append(loc);
        buff.append("\"\n");
        OLogger.log(OLogger.FINE, buff.toString());
        if (!OPatchEnv.isCASFlow()) {
            RunConsolidatedScripts rcs = new RunConsolidatedScripts(data);
            rcs.runScripts(oracleHomePath, data);
        }
        dBuff = new StringBuffer("N-Apply: step 7, do remaining Prereqs except ");
        dBuff.append("component checking.");
        OLogger.debug(dBuff);
        OneOffEntry[] autorbOneOffs = OPatchUtilHelper.getAutoRollbackOneOffs();
        if (autorbOneOffs != null && autorbOneOffs.length > 0) {
            buff = new StringBuffer("Run all the prereqs related to autorollback");
            OLogger.debug(buff);
            OPatchSessionHelper.runAutoRollbackPrereqs(oracleHomePath, OPatchUtilHelper.getAutoRollbackOneOffs(), OPatchUtilHelper.getAutoRollbackPatchObjects(oracleHomePath), data.getApOneOffs());
        }
        OLogger.printlnOnConsole(OLogger.getString("OUI-67911"));
        OLogger.justlog(OLogger.INFO, "[OPSR-TIME] " + OLogger.getString("OUI-67911"));
        preReqTrackerObj.end();
        try {
            OPatchSessionHelper.processOCM(rwServices, oracleHomePath);
        }
        catch (OCMException excep) {
            throw excep;
        }
        catch (Exception e8) {
            // empty catch block
        }
        dBuff = new StringBuffer("N-Apply: step 8, prompt for shutdown ");
        OLogger.debug(dBuff);
        try {
            selects = mPo.promptForShutdown(oracleHomePath, rwServices);
        }
        catch (ExitOPatchException e9) {
            buff = new StringBuffer("UtilSession: NApply exits on user's request.");
            OLogger.println(buff.toString());
            throw e9;
        }
        catch (RuntimeException e10) {
            throw e10;
        }
        String cookedPatchID = mPo.getCookedPatchID();
        String invBackupLoc = OPatchUtilHelper.getBackupLoc(oracleHomePath, cookedPatchID);
        OLogger.justlog(OLogger.INFO, "Backing up complete OH/inventory directory to :" + invBackupLoc);
        try {
            Files.createDirectories(Paths.get(invBackupLoc, new String[0]), new FileAttribute[0]);
            CopyInventory cpInv = new CopyInventory();
            Path srcInv = WrapperFactory.getNioServiceWrapper().getPath(oracleHomePath, "inventory");
            Path destInv = WrapperFactory.getNioServiceWrapper().getPath(invBackupLoc, "inventory");
            cpInv.copyDir(srcInv.toFile(), destInv.toFile());
            OLogger.justlog(OLogger.INFO, "Copied \n from -> " + srcInv + "\n to -> " + destInv);
        }
        catch (IOException e11) {
            e11.printStackTrace();
        }
        OLogger.println(OLogger.getString("OUI-67912"));
        OPatchUtilHelper.createUtilSessionPatchStorageLocation(oracleHomePath, cookedPatchID);
        ArrayList<String> patchListToApply = new ArrayList<String>();
        ArrayList<String> patchListToRollback = new ArrayList<String>();
        for (OneOffEntry oneOffEntry : data.getCanGoPatches().getAllElements()) {
            patchListToApply.add(oneOffEntry.getTripletID());
        }
        for (OneOffEntry oneOffEntry : data.getRollbackPatches().getAllElements()) {
            patchListToRollback.add(oneOffEntry.getTripletID());
        }
        if (!OPatchEnv.isCASFlow()) {
            mPo.backupForRestore(oracleHomePath, rwServices, patchListToApply.toArray(new String[0]), patchListToRollback.toArray(new String[0]));
        }
        if (!OPatchEnv.isCASFlow()) {
            for (PatchObject po : data.getApPatchObjects()) {
                CUPAdapter cupAdapter = new CUPAdapter(po);
                for (CUPPatchComponent cupComponent : cupAdapter.getCUPPatchComponentList()) {
                    cupComponent.backupForRestore();
                }
            }
        }
        OPatchUtilHelper.setupRLibBackupDir(oracleHomePath, cookedPatchID);
        apPatchObjects = data.getApPatchObjects();
        if (Rules.SystemWrite_continue() || Rules.OUIWrite_continue()) {
            String[] patchIDs = new String[apPatchObjects.length];
            for (int i5 = 0; i5 < apPatchObjects.length; ++i5) {
                patchIDs[i5] = apPatchObjects[i5].getPatchID();
            }
            String[] triggeredPatchIDs = new String[arbPatchObjects.length];
            for (int j2 = 0; j2 < arbPatchObjects.length; ++j2) {
                triggeredPatchIDs[j2] = arbPatchObjects[j2].getPatchID();
            }
            OPatchSessionHelper.createSessionProperties(oracleHomePath, sessionName, mPo.getCookedPatchID(), patchIDs, triggeredPatchIDs);
        }
        try {
            OPatchACL.setLocal(new NApply(), true);
        }
        catch (IllegalAccessException e12) {
            // empty catch block
        }
        String psLoc = OPatchUtilHelper.getUtilSessionPatchStorageLocation(oracleHomePath, mPo.getCookedPatchID());
        buff = new StringBuffer("\nNApply: begins applying each patch...");
        OLogger.debug(buff);
        boolean doRestore = false;
        dBuff = new StringBuffer("N-Apply: Step 10) Create interim_inventory.txt ");
        OLogger.debug(dBuff);
        String sInterim = OPatchEnv.getInterimInventoryFileLoc(oracleHomePath);
        String rInterim = OPatchEnv.getRecordInventoryFileLoc(oracleHomePath);
        Path fInterim = null;
        fInterim = WrapperFactory.getNioServiceWrapper().getPath(sInterim, new String[0]);
        if (Files.exists(fInterim, new LinkOption[0])) {
            try {
                Files.delete(fInterim);
            }
            catch (Exception exception) {
                OLogger.debug(exception.getMessage());
            }
        }
        Object var54_100 = null;
        Path path = WrapperFactory.getNioServiceWrapper().getPath(rInterim, new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            try {
                Files.delete(path);
            }
            catch (Exception e14) {
                OLogger.debug(e14.getMessage());
            }
        }
        BufferedWriter interimWrite = null;
        try {
            String bID;
            Bug[] bugs;
            String id;
            PatchObject po;
            StringBuffer line;
            OPatchSessionHelper.writeRecordedEntries(fInterim, "napply", rwServices);
            OPatchSessionHelper.writeRecordedEntries(path, "napply", rwServices);
            interimWrite = Files.newBufferedWriter(fInterim, Charset.forName("UTF-8"), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
            String comment = "# napply: list of patches to be applied.\n";
            interimWrite.write(comment);
            for (int i6 = 0; i6 < apPatchObjects.length; ++i6) {
                line = new StringBuffer();
                po = apPatchObjects[i6];
                id = po.getPatchID();
                line.append(id).append(":apply:");
                bugs = po.getBugsToFix();
                for (int j3 = 0; j3 < bugs.length; ++j3) {
                    bID = bugs[j3].getBugID();
                    line.append(bID);
                    if (j3 >= bugs.length - 1) continue;
                    line.append(",");
                }
                line.append("\n");
                interimWrite.write(line.toString());
                interimWrite.flush();
            }
            comment = "# napply: list of patches to be auto-rolled back.\n";
            interimWrite.write(comment);
            for (int i2 = 0; i2 < arbPatchObjects.length; ++i2) {
                line = new StringBuffer();
                po = arbPatchObjects[i2];
                id = po.getPatchID();
                line.append(id).append(":rollback:");
                bugs = po.getBugsToFix();
                for (int j2 = 0; j2 < bugs.length; ++j2) {
                    bID = bugs[j2].getBugID();
                    line.append(bID);
                    if (j2 >= bugs.length - 1) continue;
                    line.append(",");
                }
                line.append("\n");
                interimWrite.write(line.toString());
                interimWrite.flush();
            }
            interimWrite.close();
        }
        catch (Exception e15) {
            // empty catch block
        }
        dBuff = new StringBuffer("N-Apply: Step 11, apply each patch ");
        OLogger.debug(dBuff);
        if (PatchingFlow.CAS_REPO.equals((Object)OPatchEnv.getPatchingFlow())) {
            OPatchPatchKey opKey = new OPatchPatchKey(apPatchObjects[0], "napply");
            OPatchEnv.PATCH_MEMENTO_WRAPPER.setPatchMementoName(opKey.toString());
        }
        for (int i7 = 0; i7 < apPatchObjects.length; ++i7) {
            String msg;
            if (i7 > 0) {
                doRestore = true;
            }
            PatchObject po = apPatchObjects[i7];
            String patchID = po.getPatchID();
            String patchLoc = po.getPatchLocation();
            po.disableFuserCheck();
            po.disablePromptForShutdown();
            po.disablePromptForStartup();
            po.disableRestoreFileCreation();
            po.disableSystemCommandCheck();
            buff = new StringBuffer("\nUser specify system property APPLY_MAKE, ");
            buff.append("OPatch won't disableMakeAction or disableRenerateLibrary ");
            buff.append("for NApply.\n");
            OLogger.debug(buff);
            if (!OPatchEnv.isApplyMake()) {
                po.disableMakeAction();
                po.disableRegenerateLibrary();
            }
            if (OPatchEnv.isCASFlow()) {
                po.disablePrePostInit();
                buff = new StringBuffer("N-Apply: Disable all pre/post/init of patch if CAS is enabled. ");
                OLogger.debug(buff);
            }
            buff = new StringBuffer("\nApplying patch ");
            buff.append(patchID);
            buff.append("...\n");
            OLogger.justlog(OLogger.INFO, buff.toString());
            Bug[] bugsToFix = po.getBugsToFix();
            if (bugsToFix.length == 0) {
                dBuff = new StringBuffer("N-Apply: patch ").append(patchID);
                dBuff.append(" has no basebug info.");
                OLogger.debug(dBuff);
                msg = OLogger.getString("OUI-67132");
                RuntimeException re9 = new RuntimeException(msg);
                throw re9;
            }
            StringBuffer tBuf = new StringBuffer();
            for (int nBugs = 0; nBugs < bugsToFix.length; ++nBugs) {
                Bug b3 = bugsToFix[nBugs];
                tBuf.append("   ");
                tBuf.append(b3.getBugID());
                tBuf.append(": ");
                tBuf.append(b3.getDesc());
                tBuf.append("\n");
            }
            msg = OLogger.getString("OUI-67216", new Object[]{po.getPatchID(), tBuf.toString()});
            OLogger.verbose(OPatchSession.UTIL, new StringBuffer(msg));
            buff = new StringBuffer("calling ApplySession::process() ");
            buff.append(" with a PatchObject.");
            OLogger.debug(buff);
            try {
                OPatchUtilHelper.createAndUpdatePatchList(oracleHomePath, mPo.getCookedPatchID(), po, sessionName);
            }
            catch (Exception e16) {
                // empty catch block
            }
            ApplySession applySession = OPatchSession.APPLY;
            try {
                OPatchACL.processApply(new NApply(), applySession, patchLoc, oracleHomePath, po, new HashSet());
                continue;
            }
            catch (IllegalAccessException e17) {
                buff = new StringBuffer("NApply doesn't have permission to invoke ApplySession::process(). ");
                buff.append(e17.getMessage());
                RuntimeException re2 = new RuntimeException(buff.toString(), e17);
                re2.setStackTrace(e17.getStackTrace());
                throw re2;
            }
            catch (RuntimeException e18) {
                OLogger.warn("OUI-67124", new Object[]{e18.getMessage()});
                if (doRestore) {
                    buff = new StringBuffer("Some patches have been processed --> treat as Error.");
                    OLogger.debug(buff);
                    boolean ok = mPo.restoreOH(oracleHomePath, data.getCanGoPatches().getAllElements());
                    OPatchUtilHelper.warnRestoreMessage(sessionName, psLoc, ok);
                    if (!ok) {
                        Error err = new Error(e18.getMessage(), e18);
                        err.setStackTrace(e18.getStackTrace());
                        throw err;
                    }
                    throw e18;
                }
                throw e18;
            }
            catch (Error e19) {
                OLogger.warn("OUI-67124", new Object[]{e19.getMessage()});
                boolean ok = mPo.restoreOH(oracleHomePath, data.getCanGoPatches().getAllElements());
                OPatchUtilHelper.warnRestoreMessage(sessionName, psLoc, ok);
                if (!ok) {
                    throw e19;
                }
                RuntimeException re10 = new RuntimeException(e19.getMessage(), e19);
                re10.setStackTrace(e19.getStackTrace());
                throw re10;
            }
            finally {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e20) {}
            }
        }
        boolean cont = Rules.OUIWrite_continue();
        if (cont) {
            try {
                rwServices.processPatches(apPatchObjects, false);
                rwServices.savePatchesToInventory();
            }
            catch (Exception e21) {
                OLogger.justlog(OLogger.SEVERE, e21.getMessage());
                throw new RuntimeException(e21.getMessage(), e21);
            }
        }
        OLogger.log(OLogger.FINE, "\nDone applying all patches.\n");
        if (!OPS.INSTANCE.getSupportServices().isSupport(Feature.CAS)) {
            ApplySession applySession = OPatchSession.APPLY;
            try {
                OPatchACL.verifyApply(new NApply(), applySession, rwServices, oracleHomePath, apPatchObjects);
            }
            catch (IllegalAccessException e22) {
                buff = new StringBuffer("NApply doesn't have permission to invoke ApplySession::process(). ");
                buff.append(e22.getMessage());
                re = new RuntimeException(buff.toString(), e22);
                re.setStackTrace(e22.getStackTrace());
                throw re;
            }
            catch (RuntimeException e23) {
                OLogger.warn("OUI-67124", new Object[]{e23.getMessage()});
                throw e23;
            }
            catch (Error e24) {
                OLogger.warn("OUI-67124", new Object[]{e24.getMessage()});
                boolean ok = mPo.restoreOH(oracleHomePath, data.getCanGoPatches().getAllElements());
                OPatchUtilHelper.warnRestoreMessage(sessionName, psLoc, ok);
                if (!ok) {
                    throw e24;
                }
                RuntimeException re11 = new RuntimeException(e24.getMessage(), e24);
                re11.setStackTrace(e24.getStackTrace());
                throw re11;
            }
        }
        if (!OPatchEnv.isApplyMake() && !OPatchEnv.isCASFlow()) {
            dBuff = new StringBuffer("N-Apply: Step 12, ");
            dBuff.append(" run all consolidated makes.");
            dBuff.append(" OPatch run this step only when user doesn't specify 'APPLY_MAKE' ");
            OLogger.debug(dBuff);
            try {
                PatchObject[] patchesTouched = new PatchObject[patchesMerged.size()];
                patchesMerged.toArray(patchesTouched);
                mPo.invokeConsolidatedMake(oracleHomePath, apPatchObjects);
            }
            catch (Throwable e25) {
                boolean ok = mPo.restoreOH(oracleHomePath);
                OPatchUtilHelper.warnRestoreMessage(sessionName, psLoc, ok);
                if (!ok) {
                    Error err = new Error(e25.getMessage(), e25);
                    err.setStackTrace(e25.getStackTrace());
                    throw err;
                }
                re = new RuntimeException(e25.getMessage(), e25);
                re.setStackTrace(e25.getStackTrace());
                throw re;
            }
        }
        dBuff = new StringBuffer("N-Apply: Step 12.5, ");
        dBuff.append(" run all consolidated library regenerations.");
        dBuff.append(" OPatch run this step only when user doesn't specify 'APPLY_MAKE' ");
        OLogger.debug(dBuff);
        mPo.invokeConsolidatedRLib(oracleHomePath, apPatchObjects);
        for (int i2 = 0; i2 < arbPatchObjects.length && OPatchEnv.isRunSql(); ++i2) {
            String originalPatchLoc = OPatchEnv.getPatchBackupDirectoryPath(oracleHomePath, arbPatchObjects[i2].getCookedPatchID());
            PatchmdXml rollbackSql = new PatchmdXml(oracleHomePath, originalPatchLoc, false, arbPatchObjects[i2].getAllIncludedCopyActions(), arbPatchObjects[i2].getPatchID());
            String rollbackSqlPath = rollbackSql.getSqlPath();
            if (rollbackSqlPath == null || rollbackSqlPath.equals("")) continue;
            try {
                OLogger.println(OLogger.getString("OUI-67272", new Object[]{"auto-rollback", rollbackSqlPath, arbPatchObjects[i2].getPatchID()}));
                OPatchSessionHelper.runSqlScript(rollbackSqlPath, arbPatchObjects[i2].getPatchInventory().isSqlMigrate());
                continue;
            }
            catch (RuntimeException e26) {
                OLogger.printStackTrace(e26);
                OLogger.printlnOnLog(OLogger.INFO, e26.getMessage());
                OLogger.warn(OLogger.getString("OUI-67273", new Object[]{"auto-rollback", rollbackSqlPath, arbPatchObjects[i2].getPatchID()}));
            }
        }
        for (int i3 = 0; i3 < apPatchObjects.length && OPatchEnv.isRunSql(); ++i3) {
            String pLoc = apPatchObjects[i3].getPatchLocation();
            PatchmdXml applySql = new PatchmdXml(oracleHomePath, pLoc, true, apPatchObjects[i3].getAllIncludedCopyActions(), apPatchObjects[i3].getPatchID());
            String applySqlPath = applySql.getSqlPath();
            if (applySqlPath == null || applySqlPath.equals("")) continue;
            try {
                OLogger.println(OLogger.getString("OUI-67272", new Object[]{"apply", applySqlPath, apPatchObjects[i3].getPatchID()}));
                OPatchSessionHelper.runSqlScript(applySqlPath, apPatchObjects[i3].getPatchInventory().isSqlMigrate());
                continue;
            }
            catch (RuntimeException e27) {
                OLogger.printStackTrace(e27);
                OLogger.printlnOnLog(OLogger.INFO, e27.getMessage());
                OLogger.warn(OLogger.getString("OUI-67273", new Object[]{"apply", applySqlPath, apPatchObjects[i3].getPatchID()}));
            }
        }
        try {
            OPatchSession.runCustomScript();
        }
        catch (RuntimeException e28) {
            OLogger.printStackTrace(e28);
            OLogger.printlnOnLog(OLogger.INFO, e28.getMessage());
            OLogger.warn("OUI-67266", new Object[]{OPatchEnv.getSqlScriptFilePath()});
        }
        if (OPatchEnv.isRunSql()) {
            for (int i8 = 0; i8 < arbPatchObjects.length; ++i8) {
                if (!arbPatchObjects[i8].isSqlRelatedActions()) continue;
                OPatchSessionHelper.removeSidFromSqlPropertyFile(oracleHomePath, arbPatchObjects[i8].getCookedPatchID());
            }
        }
        String[] sidArray = OPatchEnv.getDBSIDs();
        String[] dbNodes = OPatchEnv.getDBNodes();
        String lNode = OPatchEnv.getLocalNode();
        StringBuffer sidValue = new StringBuffer("");
        for (int sidCount = 0; sidArray != null && sidCount < sidArray.length; ++sidCount) {
            if (!dbNodes[sidCount].equals(lNode) && !dbNodes[sidCount].equals("")) continue;
            sidValue.append(sidArray[sidCount]);
            if (sidCount == sidArray.length - 1) continue;
            sidValue.append(",");
        }
        if (sidValue.toString().endsWith(",")) {
            String temp = sidValue.toString().substring(0, sidValue.toString().length() - 1);
            sidValue = new StringBuffer(temp);
        }
        for (int i9 = 0; i9 < apPatchObjects.length; ++i9) {
            Properties prop = new Properties();
            if (OPatchEnv.isRunSql() && apPatchObjects[i9].isSqlRelatedActions()) {
                prop.setProperty("RUNSQL", "true");
                prop.setProperty("SID", sidValue.toString());
            } else {
                prop.setProperty("RUNSQL", "unknown");
            }
            OPatchSessionHelper.setSqlPropertyToFile(prop, oracleHomePath, apPatchObjects[i9].getCookedPatchID());
        }
        Properties onlineProp = OPatchSessionHelper.getOnlinePropertyFromFile(oracleHomePath);
        OPatchSessionHelper.removeOnlineRollbackSids(onlineProp, arbPatchObjects, OPatchEnv.getLocalNode(), oracleHomePath);
        for (int i10 = 0; i10 < apPatchObjects.length; ++i10) {
            if (!apPatchObjects[i10].isOnlinePatch()) continue;
            OPatchSessionHelper.setOnlinePropertyToFile(oracleHomePath, OPatchEnv.getLocalNode(), apPatchObjects[i10].getPatchID());
        }
        if (Rules.SystemWrite_continue() && data.isComposite()) {
            try {
                CompositePatchObject.updateActiveXMLField(data.getCompositeIdenticalPatches(), oracleHomePath, data.getActivePatch());
            }
            catch (RuntimeException e29) {
                buff = new StringBuffer("Some patches have been processed --> treat as Error.");
                OLogger.debug(buff);
                boolean ok = mPo.restoreOH(oracleHomePath, data.getCanGoPatches().getAllElements());
                OPatchUtilHelper.warnRestoreMessage(sessionName, psLoc, ok);
                if (!ok) {
                    Error err = new Error(e29.getMessage(), e29);
                    err.setStackTrace(e29.getStackTrace());
                    throw err;
                }
                throw e29;
            }
        }
        dBuff = new StringBuffer("N-Apply: Step 14, prompt for start-up");
        OLogger.debug(dBuff);
        mPo.promptForStartup(oracleHomePath, rwServices);
        try {
            OPatchACL.setLocal(new NApply(), isLocal);
        }
        catch (IllegalAccessException e30) {
            // empty catch block
        }
        dBuff = new StringBuffer("N-Apply: calling processRemote()");
        OLogger.debug(dBuff);
        NApply.processRemote(oracleHomePath, selects, apPatchObjects, arbPatchObjects, mPo);
        OPatchSessionHelper.cleanup(oracleHomePath);
        OPatchSessionHelper.releaseInventory(rwServices);
        dBuff = new StringBuffer("N-Apply: process() done.");
        OLogger.debug(dBuff);
        if (fc) {
            try {
                OHOneOffs = PrereqAPI.getInstalledOneOff(oracleHomePath);
                data.setAfterPohs(OHOneOffs);
            }
            catch (Throwable e31) {
                OLogger.debug(new StringBuffer("Converting Throwable to RuntimeException"));
                RuntimeException re2 = new RuntimeException(e31.getMessage());
                re2.setStackTrace(e31.getStackTrace());
            }
        }
        PrintApplyReport pa = new PrintApplyReport(data);
        pa.printAppliedPatches(data);
        if (fc && !OPatchEnv.isReport()) {
            pa.printBugsReport(data);
        }
        OracleHomeConflictMap.printToInActivePatchMessage();
        if (!(OPatchEnv.isReport() || OPatchEnv.isCASFlow() && OPatchEnv.isCASPhase1() || (autoInActivePatches = OracleHomeConflictMap.getInstance().getToInActivePatchMap()) == null)) {
            for (String patchId : autoInActivePatches.keySet()) {
                OPatchSession.runPatchgen(oracleHomePath, patchId, false, false);
            }
        }
        if (OPatchEnv.isFATwoPhase()) {
            if (!OPatchEnv.isReport()) {
                proc.updateCachedFiles(oracleHomePath);
                proc.cleanCachedFiles(oracleHomePath);
            }
            OPatchEnv.unsetHashMatch();
            OPatchEnv.unsetFATwoPhase();
        }
        data.setBeforePohs(new OneOffEntry[0]);
        data.setAfterPohs(new OneOffEntry[0]);
        return data;
    }

    public static NApplyData legacy_process_binary(String oracleHomePath, PatchObject[] piList) throws RuntimeException, Error {
        Map<String, String> autoInActivePatches;
        int i2;
        StringBuffer buff = new StringBuffer("NApply::processBinary() on \"");
        buff.append(oracleHomePath);
        buff.append("\"");
        OLogger.debug(buff);
        ProcessFileVersions proc = new ProcessFileVersions();
        OPatchEnv.setNApply(true);
        OPatchEnv.setNRollback(false);
        boolean isLocal = OPatchEnv.isLocal();
        IIPMRWServices rwServices = OPatchSessionHelper.lockInventory(oracleHomePath);
        OPatchSessionHelper.validateOCMOption(oracleHomePath, rwServices);
        try {
            OPatchSessionHelper.processOCM(rwServices, oracleHomePath);
        }
        catch (OCMException excep) {
            throw excep;
        }
        catch (Exception e2) {
            // empty catch block
        }
        NApplyData data = OPatchEnv.getNapplyData();
        if (data == null) {
            data = OPatchUtilHelper.prepareNApplyData(piList);
        }
        OneOffEntry[] patchesToApply = new OneOffEntry[]{};
        StringBuffer dBuff = new StringBuffer("N-Apply: get a list of patches.");
        OLogger.debug(dBuff);
        OneOffEntry[] inPatch = new OneOffEntry[piList.length];
        for (int i3 = 0; i3 < piList.length; ++i3) {
            inPatch[i3] = piList[i3].toOneOffEntry(oracleHomePath);
        }
        patchesToApply = inPatch;
        data.setPatchesToApply(patchesToApply);
        boolean fc = OPatchEnv.isForceConflict();
        if (fc) {
            try {
                OneOffEntry[] OHOneOffs = PrereqAPI.getInstalledOneOff(oracleHomePath);
                data.setBeforePohs(OHOneOffs);
            }
            catch (Throwable e3) {
                OLogger.debug(new StringBuffer("Converting Throwable to RuntimeException"));
                RuntimeException re = new RuntimeException(e3.getMessage());
                re.setStackTrace(e3.getStackTrace());
            }
        }
        RacProcessor.MinDowntimeNodeSelection selects = null;
        MergedPatchObject mPo = data.getMpo();
        dBuff = new StringBuffer("N-Apply: step 8, prompt for shutdown ");
        OLogger.debug(dBuff);
        try {
            selects = mPo.promptForShutdown(oracleHomePath, rwServices);
        }
        catch (ExitOPatchException e4) {
            buff = new StringBuffer("UtilSession: NApply exits on user's request.");
            OLogger.println(buff.toString());
            throw e4;
        }
        catch (RuntimeException e5) {
            throw e5;
        }
        OLogger.println(OLogger.getString("OUI-67912"));
        try {
            OPatchACL.setLocal(new NApply(), true);
        }
        catch (IllegalAccessException e6) {
            // empty catch block
        }
        String psLoc = OPatchUtilHelper.getUtilSessionPatchStorageLocation(oracleHomePath, data.getMpo().getCookedPatchID());
        buff = new StringBuffer("\nNApply: begins applying each patch...");
        OLogger.debug(buff);
        boolean doRestore = false;
        PatchObject[] apPatchObjects_total = data.getApPatchObjects();
        ArrayList<PatchObject> applyPatchList_total = new ArrayList<PatchObject>(Arrays.asList(apPatchObjects_total));
        ArrayList<PatchObject> applyPatchList = new ArrayList<PatchObject>(Arrays.asList(piList));
        applyPatchList.retainAll(applyPatchList_total);
        PatchObject[] apPatchObjects = applyPatchList.toArray(new PatchObject[applyPatchList.size()]);
        if (apPatchObjects.length == 0) {
            OPatchSessionHelper.releaseInventory(rwServices);
            return data;
        }
        String msg = "";
        dBuff = new StringBuffer("N-Apply: Step 11, apply each patch ");
        OLogger.debug(dBuff);
        for (int i4 = 0; i4 < apPatchObjects.length; ++i4) {
            if (i4 > 0) {
                doRestore = true;
            }
            PatchObject po = apPatchObjects[i4];
            String patchID = po.getPatchID();
            String patchLoc = po.getPatchLocation();
            po.disableFuserCheck();
            po.disablePromptForShutdown();
            po.disablePromptForStartup();
            po.disableRestoreFileCreation();
            po.disableSystemCommandCheck();
            buff = new StringBuffer("\nUser specify system property APPLY_MAKE, ");
            buff.append("OPatch won't disableMakeAction or disableRenerateLibrary ");
            buff.append("for NApply.\n");
            OLogger.debug(buff);
            if (!OPatchEnv.isApplyMake()) {
                po.disableMakeAction();
                po.disableRegenerateLibrary();
            }
            if (OPatchEnv.isCASFlow()) {
                po.disablePrePostInit();
                buff = new StringBuffer("N-Apply: Disable all pre/post/init of patch if CAS is enabled. ");
                OLogger.debug(buff);
            }
            buff = new StringBuffer("\nApplying patch ");
            buff.append(patchID);
            buff.append("...\n");
            OLogger.justlog(OLogger.INFO, buff.toString());
            Bug[] bugsToFix = po.getBugsToFix();
            if (bugsToFix.length == 0) {
                dBuff = new StringBuffer("N-Apply: patch ").append(patchID);
                dBuff.append(" has no basebug info.");
                OLogger.debug(dBuff);
                msg = OLogger.getString("OUI-67132");
                RuntimeException re = new RuntimeException(msg);
                throw re;
            }
            StringBuffer tBuf = new StringBuffer();
            for (int nBugs = 0; nBugs < bugsToFix.length; ++nBugs) {
                Bug b2 = bugsToFix[nBugs];
                tBuf.append("   ");
                tBuf.append(b2.getBugID());
                tBuf.append(": ");
                tBuf.append(b2.getDesc());
                tBuf.append("\n");
            }
            msg = OLogger.getString("OUI-67216", new Object[]{po.getPatchID(), tBuf.toString()});
            OLogger.verbose(OPatchSession.UTIL, new StringBuffer(msg));
            buff = new StringBuffer("calling ApplySession::process() ");
            buff.append(" with a PatchObject.");
            OLogger.debug(buff);
            try {
                OPatchUtilHelper.createAndUpdatePatchList(oracleHomePath, mPo.getCookedPatchID(), po, sessionName);
            }
            catch (Exception e7) {
                // empty catch block
            }
            ApplySession applySession = OPatchSession.APPLY;
            try {
                OPatchACL.processApply(new NApply(), applySession, patchLoc, oracleHomePath, po, new HashSet());
                continue;
            }
            catch (IllegalAccessException e8) {
                buff = new StringBuffer("NApply doesn't have permission to invoke ApplySession::process(). ");
                buff.append(e8.getMessage());
                RuntimeException re = new RuntimeException(buff.toString(), e8);
                re.setStackTrace(e8.getStackTrace());
                throw re;
            }
            catch (RuntimeException e9) {
                OLogger.warn("OUI-67124", new Object[]{e9.getMessage()});
                if (doRestore) {
                    buff = new StringBuffer("Some patches have been processed --> treat as Error.");
                    OLogger.debug(buff);
                    boolean ok = mPo.restoreOH(oracleHomePath, data.getCanGoPatches().getAllElements());
                    OPatchUtilHelper.warnRestoreMessage(sessionName, psLoc, ok);
                    if (!ok) {
                        Error err = new Error(e9.getMessage(), e9);
                        err.setStackTrace(e9.getStackTrace());
                        throw err;
                    }
                    throw e9;
                }
                throw e9;
            }
            catch (Error e10) {
                OLogger.warn("OUI-67124", new Object[]{e10.getMessage()});
                boolean ok = mPo.restoreOH(oracleHomePath, data.getCanGoPatches().getAllElements());
                OPatchUtilHelper.warnRestoreMessage(sessionName, psLoc, ok);
                if (!ok) {
                    throw e10;
                }
                RuntimeException re = new RuntimeException(e10.getMessage(), e10);
                re.setStackTrace(e10.getStackTrace());
                throw re;
            }
            finally {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e11) {}
            }
        }
        boolean cont = Rules.OUIWrite_continue();
        if (cont) {
            try {
                rwServices.processPatches(apPatchObjects, false);
                rwServices.savePatchesToInventory();
            }
            catch (Exception e12) {
                OLogger.justlog(OLogger.SEVERE, e12.getMessage());
                throw new RuntimeException(e12.getMessage(), e12);
            }
        }
        OLogger.log(OLogger.FINE, "\nDone applying all patches.\n");
        ApplySession applySession = OPatchSession.APPLY;
        try {
            OPatchACL.verifyApply(new NApply(), applySession, rwServices, oracleHomePath, apPatchObjects);
        }
        catch (IllegalAccessException e13) {
            buff = new StringBuffer("NApply doesn't have permission to invoke ApplySession::process(). ");
            buff.append(e13.getMessage());
            RuntimeException re = new RuntimeException(buff.toString(), e13);
            re.setStackTrace(e13.getStackTrace());
            throw re;
        }
        catch (RuntimeException e14) {
            OLogger.warn("OUI-67124", new Object[]{e14.getMessage()});
            throw e14;
        }
        catch (Error e15) {
            OLogger.warn("OUI-67124", new Object[]{e15.getMessage()});
            boolean ok = mPo.restoreOH(oracleHomePath, data.getCanGoPatches().getAllElements());
            OPatchUtilHelper.warnRestoreMessage(sessionName, psLoc, ok);
            if (!ok) {
                throw e15;
            }
            RuntimeException re = new RuntimeException(e15.getMessage(), e15);
            re.setStackTrace(e15.getStackTrace());
            throw re;
        }
        dBuff = new StringBuffer("N-Apply: Step 12.5, ");
        dBuff.append(" run all consolidated library regenerations.");
        dBuff.append(" OPatch run this step only when user doesn't specify 'APPLY_MAKE' ");
        OLogger.debug(dBuff);
        mPo.invokeConsolidatedRLib(oracleHomePath, apPatchObjects);
        PatchObject[] arbPatchObjects = data.getArbPatchObjects();
        for (i2 = 0; i2 < arbPatchObjects.length && OPatchEnv.isRunSql(); ++i2) {
            String originalPatchLoc = OPatchEnv.getPatchBackupDirectoryPath(oracleHomePath, arbPatchObjects[i2].getCookedPatchID());
            PatchmdXml rollbackSql = new PatchmdXml(oracleHomePath, originalPatchLoc, false, arbPatchObjects[i2].getAllIncludedCopyActions(), arbPatchObjects[i2].getPatchID());
            String rollbackSqlPath = rollbackSql.getSqlPath();
            if (rollbackSqlPath == null || rollbackSqlPath.equals("")) continue;
            try {
                OLogger.println(OLogger.getString("OUI-67272", new Object[]{"auto-rollback", rollbackSqlPath, arbPatchObjects[i2].getPatchID()}));
                OPatchSessionHelper.runSqlScript(rollbackSqlPath, arbPatchObjects[i2].getPatchInventory().isSqlMigrate());
                continue;
            }
            catch (RuntimeException e16) {
                OLogger.printStackTrace(e16);
                OLogger.printlnOnLog(OLogger.INFO, e16.getMessage());
                OLogger.warn(OLogger.getString("OUI-67273", new Object[]{"auto-rollback", rollbackSqlPath, arbPatchObjects[i2].getPatchID()}));
            }
        }
        for (i2 = 0; i2 < apPatchObjects.length && OPatchEnv.isRunSql(); ++i2) {
            String pLoc = apPatchObjects[i2].getPatchLocation();
            PatchmdXml applySql = new PatchmdXml(oracleHomePath, pLoc, true, apPatchObjects[i2].getAllIncludedCopyActions(), apPatchObjects[i2].getPatchID());
            String applySqlPath = applySql.getSqlPath();
            if (applySqlPath == null || applySqlPath.equals("")) continue;
            try {
                OLogger.println(OLogger.getString("OUI-67272", new Object[]{"apply", applySqlPath, apPatchObjects[i2].getPatchID()}));
                OPatchSessionHelper.runSqlScript(applySqlPath, apPatchObjects[i2].getPatchInventory().isSqlMigrate());
                continue;
            }
            catch (RuntimeException e17) {
                OLogger.printStackTrace(e17);
                OLogger.printlnOnLog(OLogger.INFO, e17.getMessage());
                OLogger.warn(OLogger.getString("OUI-67273", new Object[]{"apply", applySqlPath, apPatchObjects[i2].getPatchID()}));
            }
        }
        try {
            OPatchSession.runCustomScript();
        }
        catch (RuntimeException e18) {
            OLogger.printStackTrace(e18);
            OLogger.printlnOnLog(OLogger.INFO, e18.getMessage());
            OLogger.warn("OUI-67266", new Object[]{OPatchEnv.getSqlScriptFilePath()});
        }
        if (OPatchEnv.isRunSql()) {
            for (int i5 = 0; i5 < arbPatchObjects.length; ++i5) {
                if (!arbPatchObjects[i5].isSqlRelatedActions()) continue;
                OPatchSessionHelper.removeSidFromSqlPropertyFile(oracleHomePath, arbPatchObjects[i5].getCookedPatchID());
            }
        }
        String[] sidArray = OPatchEnv.getDBSIDs();
        String[] dbNodes = OPatchEnv.getDBNodes();
        String lNode = OPatchEnv.getLocalNode();
        StringBuffer sidValue = new StringBuffer("");
        for (int sidCount = 0; sidArray != null && sidCount < sidArray.length; ++sidCount) {
            if (!dbNodes[sidCount].equals(lNode) && !dbNodes[sidCount].equals("")) continue;
            sidValue.append(sidArray[sidCount]);
            if (sidCount == sidArray.length - 1) continue;
            sidValue.append(",");
        }
        if (sidValue.toString().endsWith(",")) {
            String temp = sidValue.toString().substring(0, sidValue.toString().length() - 1);
            sidValue = new StringBuffer(temp);
        }
        for (int i6 = 0; i6 < apPatchObjects.length; ++i6) {
            Properties prop = new Properties();
            if (OPatchEnv.isRunSql() && apPatchObjects[i6].isSqlRelatedActions()) {
                prop.setProperty("RUNSQL", "true");
                prop.setProperty("SID", sidValue.toString());
            } else {
                prop.setProperty("RUNSQL", "unknown");
            }
            OPatchSessionHelper.setSqlPropertyToFile(prop, oracleHomePath, apPatchObjects[i6].getCookedPatchID());
        }
        Properties onlineProp = OPatchSessionHelper.getOnlinePropertyFromFile(oracleHomePath);
        OPatchSessionHelper.removeOnlineRollbackSids(onlineProp, arbPatchObjects, OPatchEnv.getLocalNode(), oracleHomePath);
        for (int i7 = 0; i7 < apPatchObjects.length; ++i7) {
            if (!apPatchObjects[i7].isOnlinePatch()) continue;
            OPatchSessionHelper.setOnlinePropertyToFile(oracleHomePath, OPatchEnv.getLocalNode(), apPatchObjects[i7].getPatchID());
        }
        if (Rules.SystemWrite_continue() && data.isComposite()) {
            try {
                CompositePatchObject.updateActiveXMLField(data.getCompositeIdenticalPatches(), oracleHomePath, data.getActivePatch());
            }
            catch (RuntimeException e19) {
                buff = new StringBuffer("Some patches have been processed --> treat as Error.");
                OLogger.debug(buff);
                boolean ok = mPo.restoreOH(oracleHomePath, data.getCanGoPatches().getAllElements());
                OPatchUtilHelper.warnRestoreMessage(sessionName, psLoc, ok);
                if (!ok) {
                    Error err = new Error(e19.getMessage(), e19);
                    err.setStackTrace(e19.getStackTrace());
                    throw err;
                }
                throw e19;
            }
        }
        dBuff = new StringBuffer("N-Apply: Step 14, prompt for start-up");
        OLogger.debug(dBuff);
        mPo.promptForStartup(oracleHomePath, rwServices);
        try {
            OPatchACL.setLocal(new NApply(), isLocal);
        }
        catch (IllegalAccessException e20) {
            // empty catch block
        }
        dBuff = new StringBuffer("N-Apply: calling processRemote()");
        OLogger.debug(dBuff);
        NApply.processRemote(oracleHomePath, selects, apPatchObjects, arbPatchObjects, mPo);
        OPatchSessionHelper.cleanup(oracleHomePath);
        OPatchSessionHelper.releaseInventory(rwServices);
        dBuff = new StringBuffer("N-Apply: process() done.");
        OLogger.debug(dBuff);
        if (fc) {
            try {
                OneOffEntry[] OHOneOffs = PrereqAPI.getInstalledOneOff(oracleHomePath);
                data.setAfterPohs(OHOneOffs);
            }
            catch (Throwable e21) {
                OLogger.debug(new StringBuffer("Converting Throwable to RuntimeException"));
                RuntimeException re = new RuntimeException(e21.getMessage());
                re.setStackTrace(e21.getStackTrace());
            }
        }
        OneOffEntry[] apOneOffsTotal = data.getApOneOffs();
        ArrayList<OneOffEntry> apOneOffsTotalList = new ArrayList<OneOffEntry>(Arrays.asList(apOneOffsTotal));
        ArrayList<OneOffEntry> incomingOneOffList = new ArrayList<OneOffEntry>(piList.length);
        for (int piIndex = 0; piIndex < piList.length; ++piIndex) {
            incomingOneOffList.add(piList[piIndex].toOneOffEntry(oracleHomePath));
        }
        incomingOneOffList.retainAll(apOneOffsTotalList);
        data.setApOneOffs(incomingOneOffList.toArray(new OneOffEntry[incomingOneOffList.size()]));
        PrintApplyReport pa = new PrintApplyReport(data);
        pa.printAppliedPatches(data);
        if (fc && !OPatchEnv.isReport()) {
            pa.printBugsReport(data);
        }
        OracleHomeConflictMap.printToInActivePatchMessage();
        if (!(OPatchEnv.isReport() || OPatchEnv.isCASFlow() && OPatchEnv.isCASPhase1() || (autoInActivePatches = OracleHomeConflictMap.getInstance().getToInActivePatchMap()) == null)) {
            for (String patchId : autoInActivePatches.keySet()) {
                OPatchSession.runPatchgen(oracleHomePath, patchId, false, false);
            }
        }
        data.setApOneOffs(apOneOffsTotal);
        if (OPatchEnv.isFATwoPhase()) {
            if (!OPatchEnv.isReport()) {
                proc.updateCachedFiles(oracleHomePath);
                proc.cleanCachedFiles(oracleHomePath);
            }
            OPatchEnv.unsetHashMatch();
            OPatchEnv.unsetFATwoPhase();
        }
        return data;
    }

    protected static void processRemote(String oracleHomePath, RacProcessor.MinDowntimeNodeSelection selects, PatchObject[] applyPatchObjects, PatchObject[] autoRolledBackPatchObjects, MergedPatchObject mPo) throws RuntimeException {
        block24: {
            StringBuffer buff = new StringBuffer("NApply::processRemote()");
            OLogger.debug(buff);
            OPatchSessionHelper.loadRACRelatedLibFile();
            Rac.RacType racType = null;
            boolean autoRollBack = OPatchUtilHelper.isAutoRollbackNeeded();
            String cookedPatchID = mPo.getCookedPatchID();
            IIPMReadServices readServices = null;
            try {
                readServices = PrereqSession.getReadServices(oracleHomePath);
                Rac rac = OPatchExternalFactory.getRac(oracleHomePath);
                if (!readServices.isInventoryLoaded()) {
                    buff.append(" needs a non-null Inventory and patchObject");
                    OLogger.debug(buff);
                    throw new RuntimeException(buff.toString());
                }
                racType = Rules.OUIRead_continue() ? rac.getInstance(readServices, true) : rac.getInstance(null);
                if (!rac.shouldPropagate(racType) && !rac.shouldRemoteRun(racType)) {
                    buff = new StringBuffer(" not a RAC system, no-op for NApply::processRemote()");
                    OLogger.debug(buff);
                    break block24;
                }
                buff = new StringBuffer("NApply::processRemote() will apply the patch on the following nodes: ");
                String localNode = racType.getLocalNode();
                String[] remoteNodes = racType.getRemoteNodes();
                try {
                    OPatchUtilHelper.generateRacFiles(oracleHomePath, applyPatchObjects, cookedPatchID, sessionName);
                }
                catch (IOException e2) {
                    RuntimeException re = new RuntimeException(e2.getMessage(), e2);
                    re.setStackTrace(e2.getStackTrace());
                    throw re;
                }
                if (remoteNodes != null) {
                    for (int i2 = 0; i2 < remoteNodes.length; ++i2) {
                        String node = remoteNodes[i2];
                        buff.append(" (node ");
                        buff.append(node);
                        buff.append(")");
                    }
                }
                buff.append(".  RAC mode is: ");
                buff.append(racType.getDetail());
                boolean local = OPatchEnv.isLocal();
                boolean minDT = OPatchEnv.isMinDowntime();
                boolean allNode = OPatchEnv.isAllNode();
                boolean rolling = mPo.isRolling();
                boolean shutdown = mPo.isShutdown();
                boolean silent = OPatchEnv.isSilent();
                try {
                    if (mPo.forceAllNodeMode() && !allNode && (rolling || minDT)) {
                        allNode = true;
                        OPatchACL.setAllNode(new NApply(), true);
                        OLogger.info("OUI-67250");
                    }
                }
                catch (IllegalAccessException e3) {
                    // empty catch block
                }
                Rules.RacPatchOrder order = Rules.getRacPatchOrder(racType, local, rolling, minDT, allNode, silent);
                buff.append(".  Applying order is: ");
                buff.append(order.toString());
                OLogger.debug(buff);
                try {
                    String FP = null;
                    String DP = null;
                    String FR = null;
                    String DR = null;
                    String MP = null;
                    String RC = null;
                    String patchStorageRac = "";
                    try {
                        patchStorageRac = OPatchEnv.getPatchStorageRacDirectoryPath(oracleHomePath, cookedPatchID);
                        boolean createRacFile = OPatchEnv.isCreateRacFile();
                        Path f2 = WrapperFactory.getNioServiceWrapper().getPath(patchStorageRac, new String[0]);
                        if (!createRacFile && !Files.exists(f2, new LinkOption[0])) {
                            buff = new StringBuffer("NApply::processRemote() was not able to locate the ");
                            buff.append("directory containing listed files/dirs to be propagated/removed on remote nodes.  ");
                            buff.append("Moreover, since users request that no RAC listed files be generated, ");
                            buff.append("OPatch cannot go on patching remote nodes.  ");
                            OLogger.println(buff.toString());
                            return;
                        }
                        RacFileCreator.checkPsRac(patchStorageRac);
                        FP = RacFileCreator.getFPFinalName(patchStorageRac);
                        DP = RacFileCreator.getDPFinalName(patchStorageRac);
                        RC = RacFileCreator.getRCFinalName(patchStorageRac);
                        if (autoRollBack) {
                            FR = RacFileCreator.getFRFinalName(patchStorageRac);
                            DR = RacFileCreator.getDRFinalName(patchStorageRac);
                        }
                        MP = RacFileCreator.getMPFinalName(patchStorageRac);
                    }
                    catch (IOException e4) {
                        RuntimeException re = new RuntimeException(e4.getMessage(), e4);
                        re.setStackTrace(e4.getStackTrace());
                        throw re;
                    }
                    StringBuffer report = new StringBuffer("OPatch will use the following files to patch remote nodes:\n");
                    if (FP != null) {
                        report.append("   \"");
                        report.append(FP);
                        report.append("\"\n");
                    }
                    if (RC != null) {
                        report.append("   \"");
                        report.append(RC);
                        report.append("\"\n");
                    }
                    if (DP != null) {
                        report.append("   \"");
                        report.append(DP);
                        report.append("\"\n");
                    }
                    if (FR != null) {
                        report.append("   \"");
                        report.append(FR);
                        report.append("\"\n");
                    }
                    if (DR != null) {
                        report.append("   \"");
                        report.append(DR);
                        report.append("\"\n");
                    }
                    if (MP != null) {
                        report.append("   \"");
                        report.append(MP);
                        report.append("\"\n");
                    }
                    OLogger.log(OLogger.FINE, report.toString());
                    boolean apply = true;
                    boolean rollback = false;
                    RacProcessor.patchRemoteNodes(oracleHomePath, remoteNodes, order, FP, DP, FR, DR, MP, RC, shutdown, sessionName, selects, apply, rollback, autoRollBack, patchStorageRac, mPo.getShutdownMsg(), applyPatchObjects, autoRolledBackPatchObjects, localNode, rac.shouldPropagate(racType), rac.shouldRemoteRun(racType));
                }
                catch (RuntimeException e5) {
                    throw e5;
                }
                catch (Error e6) {
                    throw e6;
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                RuntimeException e7 = new RuntimeException(t.getMessage(), t);
                e7.setStackTrace(e7.getStackTrace());
                throw e7;
            }
        }
    }

    private static void runPrereqs(String oracleHomePath, OneOffEntry[] apOneOffs, PatchObject[] apPatchObjects, String[] apPatchLocs) throws PrereqFailedException {
        String patchID;
        PatchObject po;
        StringBuffer buff = new StringBuffer();
        boolean runPrereq = true;
        boolean bl = runPrereq = Rules.SystemWrite_continue() || OPatchEnv.isReport();
        if (runPrereq) {
            PrereqResult sysSpaceRes = PrereqAPI.checkSystemSpace(oracleHomePath, apOneOffs, apPatchLocs);
            if (sysSpaceRes.getResult() == PrereqResult.ExecuteStatus.NOT_EXECUTED || sysSpaceRes.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                buff = new StringBuffer("\nPre-requiste \"CheckSystemSpace\" failed.");
                buff.append(sysSpaceRes.toString());
                OLogger.println(buff.toString());
                PrereqFailedException pe = new PrereqFailedException("Prereq checkSystemSpace failed.");
                throw pe;
            }
            OLogger.log(OLogger.FINE, "Enough system space is available.");
        }
        boolean bl2 = runPrereq = Rules.OUIRead_continue() || OPatchEnv.isReport();
        if (runPrereq) {
            PrereqResult platRes = PrereqAPI.checkPatchApplicableOnCurrentPlatform(oracleHomePath, apPatchObjects);
            if (platRes.getResult() == PrereqResult.ExecuteStatus.NOT_EXECUTED || platRes.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                buff = new StringBuffer("\nPre-requiste \"CheckPatchApplicableOnCurrentPlatform\" failed.");
                buff.append(platRes.toString());
                OLogger.println(buff.toString());
                PrereqFailedException pe = new PrereqFailedException("Prereq checkPatchApplicableOnCurrentPlatform failed.");
                throw pe;
            }
            OLogger.log(OLogger.FINE, "All the given patches are applicable on the current platform.");
        }
        boolean bl3 = runPrereq = Rules.SystemWrite_continue() || OPatchEnv.isReport();
        if (runPrereq) {
            for (int i2 = 0; i2 < apOneOffs.length; ++i2) {
                po = apPatchObjects[i2];
                patchID = po.getPatchID();
                buff = new StringBuffer("checkSystemCommandAvailable for patch ");
                buff.append(patchID);
                OLogger.debug(buff);
                String[] executables = po.getExecutables(oracleHomePath);
                PrereqResult sysCmdRes = PrereqAPI.checkSystemCommandAvailable(oracleHomePath, apOneOffs[i2], executables);
                if (sysCmdRes.getResult() == PrereqResult.ExecuteStatus.NOT_EXECUTED || sysCmdRes.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                    buff = new StringBuffer("\nPre-requiste \"CheckSystemCommandAvailable\" failed ");
                    buff.append(" on patch ").append(patchID);
                    buff.append(sysCmdRes.toString());
                    OLogger.println(buff.toString());
                    PrereqFailedException pe = new PrereqFailedException("Prereq checkSystemCommandAvailable failed.");
                    throw pe;
                }
                OLogger.log(OLogger.FINE, "All the required system commands are present.");
            }
        }
        boolean bl4 = runPrereq = Rules.SystemWrite_continue() || OPatchEnv.isReport();
        if (runPrereq) {
            for (int i3 = 0; i3 < apPatchObjects.length; ++i3) {
                po = apPatchObjects[i3];
                patchID = po.getPatchID();
                buff = new StringBuffer("checkActiveFilesAndExecutables for patch ");
                buff.append(patchID);
                OLogger.debug(buff);
                PrereqResult activeFilesRes = PrereqAPI.checkActiveFilesAndExecutables(oracleHomePath, po);
                if (activeFilesRes.getResult() == PrereqResult.ExecuteStatus.NOT_EXECUTED || activeFilesRes.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                    buff = new StringBuffer("\nPre-requiste \"CheckActiveFilesAndExecutables\" failed ");
                    buff.append("on patch ").append(patchID).append(", ");
                    buff.append(activeFilesRes.toString());
                    OLogger.println(buff.toString());
                    PrereqFailedException pe = new PrereqFailedException("Prereq checkActiveFilesAndExecutables failed.");
                    throw pe;
                }
                OLogger.log(OLogger.FINE, "None of the executables are active.");
            }
        }
        boolean bl5 = runPrereq = Rules.OUIRead_continue() && Rules.SystemWrite_continue() || OPatchEnv.isReport();
        if (runPrereq) {
            PrereqResult applicableRes = PrereqAPI.checkApplicableIgnoreMisingOptionalComp(oracleHomePath, apPatchObjects);
            if (applicableRes.getResult() == PrereqResult.ExecuteStatus.NOT_EXECUTED || applicableRes.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                buff = new StringBuffer("\nPre-requiste \"CheckApplicable\" failed.");
                buff.append(applicableRes.toString());
                OLogger.println(buff.toString());
                PrereqFailedException pe = new PrereqFailedException("Prereq checkApplicable failed.");
                throw pe;
            }
            OLogger.log(OLogger.FINE, "All the actions of the given patches are applicable.");
        }
    }

    protected static boolean shouldConsiderNoBugSuperSet(OneOffEntry[] notNeededOneOffs, OneOffEntry[] autoRollbackOneOffs) {
        for (int i2 = 0; i2 < autoRollbackOneOffs.length; ++i2) {
            String autoRollbackID = autoRollbackOneOffs[i2].getID();
            for (int j2 = 0; j2 < notNeededOneOffs.length; ++j2) {
                if (!autoRollbackID.equals(notNeededOneOffs[j2].getID())) continue;
                return true;
            }
        }
        return false;
    }

    private static ArrayList intersect(ArrayList tmp, ArrayList current) {
        current.retainAll(tmp);
        return current;
    }

    protected static String getMsgForNoBugSuperSet(String oracleHomePath, ConflictMatrixOutput cOutput, OneOffEntry[] samePatchSuperset) {
        int i2;
        OneOffEntry[] notNeededOneOffs = cOutput.getListOfPatchesNotNeeded();
        OneOffEntry[] autoRollbackOneOffs = cOutput.getListOfPatchesThatNeedToBeRollback();
        ArrayList<String> ohOneOffs = new ArrayList<String>();
        for (int i3 = 0; autoRollbackOneOffs != null && i3 < autoRollbackOneOffs.length; ++i3) {
            String autoRollbackID = autoRollbackOneOffs[i3].getID();
            for (int j2 = 0; notNeededOneOffs != null && j2 < notNeededOneOffs.length; ++j2) {
                if (!autoRollbackID.equals(notNeededOneOffs[j2].getID())) continue;
                ohOneOffs.add(autoRollbackID);
            }
        }
        int rowLength = cOutput.getRowLength();
        int colLength = cOutput.getColumnLength();
        StringBuffer tmpS = new StringBuffer();
        for (i2 = 0; i2 < rowLength; ++i2) {
            String superSetID = cOutput.getRowPatchID(i2, 0);
            boolean success = false;
            if (ohOneOffs.contains(superSetID)) continue;
            StringBuffer buff = new StringBuffer();
            for (int j3 = 0; j3 < colLength; ++j3) {
                String subSetID = cOutput.getColumnPatchID(i2, j3);
                if (cOutput.getConflictType(i2, j3) != ConflictMatrixOutput.ConflictType.BUG_SUPERSET || !ohOneOffs.contains(subSetID)) continue;
                success = true;
                buff.append(subSetID);
                buff.append(" ");
            }
            if (!success) continue;
            tmpS.append(OLogger.getString("OUI-67078", new Object[]{superSetID, buff.toString(), oracleHomePath}));
            tmpS.append("\n");
        }
        for (i2 = 0; samePatchSuperset != null && i2 < samePatchSuperset.length; ++i2) {
            String patchID = samePatchSuperset[i2].getID();
            tmpS.append(OLogger.getString("OUI-67078", new Object[]{patchID, patchID, oracleHomePath}));
            tmpS.append("\n");
        }
        return tmpS.toString();
    }

    /*
     * Exception decompiling
     */
    private static void runPreSKDApplyPrereqs(String oracleHomePath, PatchObject[] pos) throws FailedPrereqException, RuntimeException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [23[CATCHBLOCK]], but top level block is 8[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void runPreSKDApplyPrereqs(String oracleHomePath) throws FailedPrereqException, RuntimeException {
        NApply.runPreSKDApplyPrereqs(oracleHomePath, null);
    }
}

