/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchutil;

import java.io.IOException;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchExternalFactory;
import oracle.opatch.RacFileCreator;
import oracle.opatch.RacProcessor;
import oracle.opatch.RacSrvm;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchutil.OUSessionHelper;
import oracle.opatch.opatchutil.UtilEnv;

public class CopyToNodes {
    protected static void copyDir(String oracleHomePath) throws RuntimeException {
    }

    protected static void copyListedFilesTest(String oracleHomePath) throws RuntimeException {
        try {
            String listedFileHolder = "";
            String baseDir = "";
            OLogger.println("This option will propagate a given file to a given set of nodes.");
            String[] nodes = OUSessionHelper.readNodes();
            String fileToPropagate = "";
            RacSrvm racSrvm = OPatchExternalFactory.getRacSrvm(oracleHomePath);
            if (nodes == null || nodes.length == 0) {
                StringBuffer buff = new StringBuffer("There are no nodes to update.  ");
                buff.append("Remote nodes have not been modified.");
                throw new RuntimeException(buff.toString());
            }
            if (!UtilEnv.isFP()) {
                throw new RuntimeException("-fp argument is required to copy file to remote nodes.");
            }
            fileToPropagate = UtilEnv.getFilesToPropagate();
            OUSessionHelper.FilePrompt filePrompt = OUSessionHelper.createTempFileHolder(fileToPropagate, true, false, OPatchEnv.getTmpDir(), "opatch_rac.tmp");
            listedFileHolder = filePrompt.getFileHolder();
            String finalFile = RacFileCreator.getInstantiatedFile(listedFileHolder);
            baseDir = filePrompt.getBaseDir();
            OLogger.println("The file \"" + fileToPropagate + "\" will be copied to remote node(s).");
            racSrvm.propagateListedFilesToNodes(baseDir, nodes, listedFileHolder, finalFile);
        }
        catch (IOException e2) {
            RuntimeException re = new RuntimeException(e2.getMessage());
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
    }

    protected static void copyListedFiles(String oracleHomePath) throws RuntimeException {
        OLogger.println("This option will propagate listed files to a given set of nodes.");
        String[] nodes = OUSessionHelper.readNodes();
        RacSrvm racSrvm = OPatchExternalFactory.getRacSrvm(oracleHomePath);
        if (nodes == null || nodes.length == 0) {
            StringBuffer buff = new StringBuffer("There are no nodes to update.  ");
            buff.append("Remote nodes have not been modified.");
            throw new RuntimeException(buff.toString());
        }
        try {
            String nodesStr = RacProcessor.getNodesString(nodes);
            String fpFile = RacFileCreator.getFPFinalName();
            String listedFileHolder = "";
            if (!UtilEnv.isFP()) {
                throw new RuntimeException("-fp argument is required to copy files to remote nodes.");
            }
            listedFileHolder = UtilEnv.getFilesToPropagate();
            String finalFile = RacFileCreator.getInstantiatedFile(listedFileHolder);
            OLogger.println("The files listed in \"" + listedFileHolder + "\" will be copied to remote node(s).");
            racSrvm.propagateListedFilesToNodes(oracleHomePath, nodes, listedFileHolder, finalFile);
        }
        catch (IOException e2) {
            RuntimeException re = new RuntimeException(e2.getMessage());
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
    }

    protected static void copyListedDirs(String oracleHomePath) throws RuntimeException {
        String listedFileHolder = "";
        try {
            OLogger.println("This option will propagate listed directories to a given set of nodes.");
            String[] nodes = OUSessionHelper.readNodes();
            RacSrvm racSrvm = OPatchExternalFactory.getRacSrvm(oracleHomePath);
            if (nodes == null || nodes.length == 0) {
                StringBuffer buff = new StringBuffer("There are no nodes to update.  ");
                buff.append("Remote nodes have not been modified.");
                throw new RuntimeException(buff.toString());
            }
            String dpFile = RacFileCreator.getDPFinalName();
            if (!UtilEnv.isDP()) {
                throw new RuntimeException("-dp argument is required to copy directories to remote nodes.");
            }
            listedFileHolder = UtilEnv.getDirectoriesToPropagate();
            String finalFile = RacFileCreator.getInstantiatedFile(listedFileHolder);
            OLogger.println("The directories listed in \"" + listedFileHolder + "\" will be copied to remote node(s).");
            racSrvm.propagateListedDirsToNodes(oracleHomePath, nodes, listedFileHolder, finalFile);
        }
        catch (IOException e2) {
            RuntimeException re = new RuntimeException(e2.getMessage());
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
    }

    protected static void copyListedDirsTest(String oracleHomePath) throws RuntimeException {
        String listedFileHolder = "";
        try {
            OLogger.println("This option will propagate listed directories to a given set of nodes.");
            String[] nodes = OUSessionHelper.readNodes();
            String dirToPropagate = "";
            RacSrvm racSrvm = OPatchExternalFactory.getRacSrvm(oracleHomePath);
            if (nodes == null || nodes.length == 0) {
                StringBuffer buff = new StringBuffer("There are no nodes to update.  ");
                buff.append("Remote nodes have not been modified.");
                throw new RuntimeException(buff.toString());
            }
            if (!UtilEnv.isDP()) {
                throw new RuntimeException("-dp argument is required to copy directory to remote nodes.");
            }
            dirToPropagate = UtilEnv.getDirectoriesToPropagate();
            OUSessionHelper.FilePrompt filePrompt = OUSessionHelper.createTempFileHolder(dirToPropagate, true, true, OPatchEnv.getTmpDir(), "opatch_rac.tmp");
            listedFileHolder = filePrompt.getFileHolder();
            String finalFile = RacFileCreator.getInstantiatedFile(listedFileHolder);
            String baseDir = filePrompt.getBaseDir();
            OLogger.println("The directory \"" + dirToPropagate + "\" will be copied to remote node(s).");
            racSrvm.propagateListedDirsToNodes(baseDir, nodes, listedFileHolder, finalFile);
        }
        catch (IOException e2) {
            RuntimeException re = new RuntimeException(e2.getMessage());
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
    }
}

