/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchutil;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import oracle.opatch.OPatchEnv;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.wrappers.WrapperFactory;

public class CacheProcessor {
    public static void clearcachedfiles(String oracleHomePath) {
        boolean found = false;
        String cachedLoc = OPatchEnv.getPrereqResultFileLoc(oracleHomePath);
        OLogger.println("Cached files are located at: " + cachedLoc);
        Path cachedDir = WrapperFactory.getNioServiceWrapper().getPath(cachedLoc, new String[0]);
        DirectoryStream<Path> listOfFiles = null;
        try {
            listOfFiles = Files.newDirectoryStream(cachedDir);
        }
        catch (IOException e2) {
            OLogger.debug(e2.getMessage());
        }
        for (Path listOfFile : listOfFiles) {
            Path fv = listOfFile;
            if (!Files.isRegularFile(fv, new LinkOption[0]) || Files.isDirectory(fv, new LinkOption[0]) || !fv.getFileName().toString().endsWith(".txt") && !fv.getFileName().toString().startsWith("phaseone_status_CLI") && !fv.getFileName().toString().startsWith("phaseone_status_SDK")) continue;
            OLogger.println("Deleting file " + fv.getFileName().toString() + "...");
            try {
                Files.delete(fv);
            }
            catch (IOException e3) {
                OLogger.debug(e3.getMessage());
            }
            found = true;
        }
        if (found) {
            OLogger.println(OLogger.getString("OUI-67329", new Object[]{"UtilSession"}));
        } else {
            OLogger.println(OLogger.getString("OUI-67330", new Object[]{"UtilSession"}));
        }
    }
}

