/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchfafmw;

import oracle.opatch.opatchfafmw.FMWContext;
import oracle.opatch.opatchfafmw.Logger;
import oracle.opatch.opatchfafmw.OPatchStepAdapter;
import oracle.opatch.opatchfafmw.Operation;
import oracle.opatch.opatchfafmw.SOAComposite;
import oracle.opatch.opatchfafmw.SOACompositeManager;
import oracle.opatch.opatchsdk.OPatchFAStep;

final class UndeploySOAComposite
implements Operation {
    UndeploySOAComposite() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(FMWContext c2) {
        SOACompositeManager scm = c2.getDomain().getSOACompositeManager();
        SOAComposite sc = c2.getSOAComposite();
        String name = sc.getName();
        String[] compRevs = c2.getCompRevisionToUndeploy();
        String prevDefaultRevision = compRevs[0];
        String revision = compRevs[1];
        String defaultRevAfterUndeploy = "";
        String compositeDN = "default/" + name + '!' + revision;
        String errorMsg = "";
        boolean success = true;
        sc.setDefaultRevisionBeforeUndeploy(revision);
        Logger.logi("Composite Revision that will be used to Undeploy [" + revision + "]");
        try {
            Logger.logi("[SOA COMPOSITE] Disable EDN Events");
            OPatchStepAdapter disableEdnEventsStep = new OPatchStepAdapter(OPatchFAStep.SOA_DISABLE_EDN_EVENTS);
            disableEdnEventsStep.setStepDescription("Disable Edn Events Delivery");
            try {
                scm.disableEDNEvents();
                disableEdnEventsStep.setSuccess(true);
                c2.getContextBuilder().addExecutionStep(disableEdnEventsStep);
            }
            catch (Throwable t) {
                errorMsg = "Error in Disable EDN Events Delivery.";
                disableEdnEventsStep.setSuccess(false);
                disableEdnEventsStep.setErrorMessage(errorMsg);
                RuntimeException re = new RuntimeException(t);
                disableEdnEventsStep.setExceptionObject(re);
                c2.getContextBuilder().addExecutionStep(disableEdnEventsStep);
                Logger.loge(errorMsg);
                Logger.loge(re);
                success = false;
                throw re;
            }
            Logger.logi("[SOA COMPOSITE] Undeploy SOA Composite [" + compositeDN + "]");
            OPatchStepAdapter undeployStep = new OPatchStepAdapter(OPatchFAStep.SOA_UNDEPLOY_COMPOSITE);
            undeployStep.setStepDescription("Undeploy SOA Composite");
            try {
                scm.undeployComposite(compositeDN);
                undeployStep.setSuccess(true);
                c2.getContextBuilder().addExecutionStep(undeployStep);
            }
            catch (Throwable t) {
                errorMsg = "Error in undeploying Composite [" + compositeDN + "]";
                undeployStep.setSuccess(false);
                undeployStep.setErrorMessage(errorMsg);
                RuntimeException re = new RuntimeException(t);
                undeployStep.setExceptionObject(re);
                c2.getContextBuilder().addExecutionStep(undeployStep);
                Logger.loge(errorMsg);
                Logger.loge(re);
                success = false;
                throw re;
            }
            String prevCompositeDN = "default/" + name + '!' + prevDefaultRevision;
            Logger.logi("[SOA COMPOSITE] Activate the previously deployed composite [" + prevCompositeDN + "]");
            OPatchStepAdapter activateStep = new OPatchStepAdapter(OPatchFAStep.SOA_MAKE_RIGHT_COMPOSITE_ACTIVE);
            activateStep.setStepDescription("Activate the previously deployed composite");
            try {
                scm.activateComposite(prevCompositeDN);
                activateStep.setSuccess(true);
                c2.getContextBuilder().addExecutionStep(activateStep);
            }
            catch (Throwable t) {
                errorMsg = "Error in activating previously deployed SOA Composite [" + prevCompositeDN + "]";
                activateStep.setSuccess(false);
                activateStep.setErrorMessage(errorMsg);
                RuntimeException re = new RuntimeException(t);
                activateStep.setExceptionObject(re);
                c2.getContextBuilder().addExecutionStep(activateStep);
                success = false;
                Logger.loge(errorMsg);
                Logger.loge(re);
                throw re;
            }
            Logger.logi("[SOA COMPOSITE] Assign default to the previously deployed composite [" + prevCompositeDN + "]");
            OPatchStepAdapter assignDefaultStep = new OPatchStepAdapter(OPatchFAStep.SOA_ASSIGN_DEFAULT_COMPOSITE);
            assignDefaultStep.setStepDescription("Assign default to previously deployed composite");
            try {
                scm.assignDefaultComposite(prevCompositeDN);
                assignDefaultStep.setSuccess(true);
                c2.getContextBuilder().addExecutionStep(assignDefaultStep);
            }
            catch (Throwable t) {
                errorMsg = "Error in assigning 'default' to the SOA Composite [" + prevCompositeDN + "]";
                assignDefaultStep.setSuccess(false);
                assignDefaultStep.setErrorMessage(errorMsg);
                RuntimeException re = new RuntimeException(t);
                assignDefaultStep.setExceptionObject(re);
                c2.getContextBuilder().addExecutionStep(assignDefaultStep);
                success = false;
                Logger.loge(errorMsg);
                Logger.loge(re);
                throw re;
            }
        }
        finally {
            Logger.logi("[SOA COMPOSITE] Enable EDN Events Delivery.");
            OPatchStepAdapter enableEdnStep = new OPatchStepAdapter(OPatchFAStep.SOA_ENABLE_EDN_EVENTS);
            enableEdnStep.setStepDescription("Enable EDN Events Delivery");
            try {
                scm.enableEDNEvents();
                enableEdnStep.setSuccess(true);
                if (success) {
                    c2.getContextBuilder().addExecutionStep(enableEdnStep);
                } else {
                    c2.getContextBuilder().addRecoveryStep(enableEdnStep);
                }
            }
            catch (Throwable t) {
                errorMsg = "Error in executing enableEDNEvents API";
                enableEdnStep.setSuccess(false);
                enableEdnStep.setErrorMessage(errorMsg);
                RuntimeException exObj = new RuntimeException(t);
                enableEdnStep.setExceptionObject(exObj);
                if (success) {
                    c2.getContextBuilder().addExecutionStep(enableEdnStep);
                } else {
                    c2.getContextBuilder().addRecoveryStep(enableEdnStep);
                }
                Logger.loge(errorMsg);
                Logger.loge(exObj);
                throw exObj;
            }
            OPatchStepAdapter defaultRevStep = new OPatchStepAdapter(OPatchFAStep.SOA_GET_DEFAULT_REVISION);
            defaultRevStep.setStepDescription("Get default revision after undeployment");
            try {
                defaultRevAfterUndeploy = scm.getDefaultRevision(name);
                defaultRevStep.setSuccess(true);
                if (success) {
                    c2.getContextBuilder().addExecutionStep(defaultRevStep);
                } else {
                    c2.getContextBuilder().addRecoveryStep(defaultRevStep);
                }
                sc.setDefaultRevisionAfterUndeploy(defaultRevAfterUndeploy);
            }
            catch (Throwable t) {
                errorMsg = "Error in getting default revision after undeployment";
                defaultRevStep.setSuccess(false);
                defaultRevStep.setErrorMessage(errorMsg);
                RuntimeException re = new RuntimeException(t);
                defaultRevStep.setExceptionObject(re);
                if (success) {
                    c2.getContextBuilder().addExecutionStep(enableEdnStep);
                } else {
                    c2.getContextBuilder().addRecoveryStep(enableEdnStep);
                }
                Logger.loge(errorMsg);
                Logger.loge(re);
                throw re;
            }
            Logger.logi("[SOA COMPOSITE] Default Revision after undeploy composite  [" + defaultRevAfterUndeploy + "]");
        }
    }
}

