/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchfafmw;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.opatch.fmwclient.FMWClient;
import oracle.opatch.opatchfafmw.Logger;
import oracle.opatch.opatchfafmw.OPatchStepAdapter;
import oracle.opatch.opatchfafmw.rb.RB;
import oracle.opatch.opatchlogger.OLogger;
import weblogic.management.runtime.ServerLifeCycleRuntimeMBean;
import weblogic.management.runtime.ServerLifeCycleTaskRuntimeMBean;

class PostTimeoutThread
extends Thread {
    List clients;
    private boolean start;

    PostTimeoutThread(List list, boolean start) {
        this.clients = list;
        this.start = start;
    }

    @Override
    public void run() {
        this.executeTimeout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeTimeout() {
        ArrayList<String> eList = null;
        OPatchStepAdapter executionStep = null;
        for (int i2 = 0; i2 < this.clients.size(); ++i2) {
            eList = null;
            FMWClient client = (FMWClient)this.clients.get(i2);
            try {
                OLogger.reInitJavaLogger(client.getLogFile(), "OFF", "INFO", false);
                Map<String, ServerLifeCycleRuntimeMBean> lMap1 = client.getServerLifeCycleRuntimeMBeanMap();
                Map<String, ServerLifeCycleTaskRuntimeMBean> tMap1 = client.getServerLifeCycleTaskRuntimeMBeanMap();
                executionStep = client.getExecutionStep();
                if (lMap1 == null | tMap1 == null) continue;
                for (String server : tMap1.keySet()) {
                    if (tMap1.get(server).isRunning()) {
                        Logger.loge("Life Cycle Operation on Server [" + server + "] is still going on. Timed out.");
                        continue;
                    }
                    if ("TASK COMPLETED".equals(tMap1.get(server).getStatus())) {
                        if (!Logger.debug) continue;
                        Logger.debug("Life Cycle Operation on Server [" + server + "] completed succesfully.");
                        continue;
                    }
                    Exception e2 = tMap1.get(server).getError();
                    if (e2 == null) continue;
                    executionStep.setSuccess(false);
                    executionStep.setErrorMessage(e2.getMessage());
                    executionStep.setExceptionObject(new RuntimeException(e2));
                    Logger.loge("Exception while doing Life Cycle Operation on Server [" + server + "].");
                    Logger.loge(e2);
                }
                for (String server : lMap1.keySet()) {
                    String state = lMap1.get(server).getState();
                    if (this.checkStateAfterOperation(state)) continue;
                    Logger.logi("Server \"" + server + "\" is not in desirable state \"" + state + "\" after operation.");
                    if (eList == null) {
                        eList = new ArrayList<String>(3);
                    }
                    eList.add(server + "[Not-desired state: " + state + "]");
                }
                if (eList == null || eList.isEmpty()) continue;
                if (executionStep.isSuccess()) {
                    executionStep.setSuccess(false);
                    executionStep.setErrorMessage(Logger.getString(RB.Entry.ERROR_IN_LIFE_CYCLE_OPERATION, ((Object)eList).toString()));
                }
                Logger.error(RB.Entry.ERROR_IN_LIFE_CYCLE_OPERATION, ((Object)eList).toString());
                continue;
            }
            catch (Throwable t) {
                RuntimeException re = new RuntimeException(t);
                Logger.loge(re);
                continue;
            }
            finally {
                Logger.close();
            }
        }
    }

    private boolean checkStateAfterOperation(String state) {
        if (this.start && "RUNNING".equals(state)) {
            return true;
        }
        return !this.start && "SHUTDOWN".equals(state);
    }
}

